<?php
require_once 'EbatNs_ComplexType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class SellerShippingProfileType extends EbatNs_ComplexType
{
	/**
	 * @var long
	 */
	protected $ShippingProfileID;
	/**
	 * @var string
	 */
	protected $ShippingProfileName;

	/**
	 * @return long
	 */
	function getShippingProfileID()
	{
		return $this->ShippingProfileID;
	}
	/**
	 * @param long
	 */
	function setShippingProfileID($value)
	{
		$this->ShippingProfileID = $value;
	}

	/**
	 * @return string
	 */
	function getShippingProfileName()
	{
		return $this->ShippingProfileName;
	}
	/**
	 * @param long
	 */
	function setShippingProfileName($value)
	{
		$this->ShippingProfileName = $value;
	}



	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('SellerShippingProfileType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
					array(
						'ShippingProfileID' =>
						array(
							'required' => false,
							'type' => 'long',
							'nsURI' => 'http://www.w3.org/2001/XMLSchema',
							'array' => false,
							'cardinality' => '0..1'
						)
					),array(
						'ShippingProfileName' =>
						array(
							'required' => false,
							'type' => 'string',
							'nsURI' => 'http://www.w3.org/2001/XMLSchema',
							'array' => false,
							'cardinality' => '0..1'
						)
					)
				);
		
	}
}

