<?php
$target_file = main::get_secure_path().'Versand-Amazon.txt';
if(is_file($target_file)){
	unlink($target_file) or die('Cant delete '.$target_file);
}
$basics = new basics;
define('AMAZON_VERSANDMELDUNG_XSLX_CARRIER_CODES',[
	"4PX", 
	"Asendia", 
	"AT POST", 
	"China Post", 
	"Chrono Express", 
	"Chronopost", 
	"City Link", 
	"Correos", 
	"DB Schenker", 
	"Deutsche Post", 
	"DHL", 
	"DHL eCommerce", 
	"DHL Freight", 
	"DHL Home Delivery", 
	"DPD", 
	"DSV", 
	"Endopack", 
	"Fastway", 
	"FedEx", 
	"GEL Express", 
	"Geodis Calberson", 
	"GLS", 
	"GO!", 
	"Hermes Einrichtungsservice", 
	"Hermes Logistik Gruppe", 
	"Hongkong Post", 
	"IDS Netzwerk", 
	"India Post", 
	"JCEX", 
	"Kuehne+Nagel", 
	"La Poste", 
	"MRW", 
	"Nacex", 
	"Parcelforce", 
	"Parcelnet", 
	"Post NL", 
	"Poste Italiane", 
	"Raben Group", 
	"Rhenus", 
	"Rieck", 
	"Royal Mail", 
	"SDA", 
	"Seur", 
	"SF Express", 
	"SFC", 
	"Smartmail", 
	"Target", 
	"TNT", 
	"Tourline", 
	"UPS", 
	"VIR", 
	"WanbExpress", 
	"WINIT", 
	"YANWEN", 
	"Yodel", 
	"Yun Express", 
	"Other"
]);
define('AMAZON_VERSANDMELDUNG_XSLX_HEADER_COLS',[
	'order-id',
	'order-item-id',
	'quantity',
	'ship-date', // JJJJ-MM-TT
	'carrier-code',
	'carrier-name', // max 50 zeichen
	'tracking-number', // max 50 zeichen
	'ship-method', // max 50 Zeichen, zb Warenpost
	'transparency_code', // Der Transparency-Code für das Produkt, wenn dieses für das Transparency-Programm registriert ist. 
	'ship_from_address_name', // 50
	'ship_from_address_line1', // 60
	'ship_from_address_line2', // 60
	'ship_from_address_line3', // 60
	'ship_from_address_city', // 50
	'ship_from_address_county', // 50
	'ship_from_address_state_or_region',// 50
	'ship_from_address_postalcode', // 50
	'ship_from_address_countrycode' // 2
]);
define('AMAZON_VERSANDMELDUNG_XSLX_COLUMN_VALUES','ABCDEFGHIJKLMNOPQRSTUVWXYZ');
$data = [];
if(!isset($_POST['amazon_order_item_code']) or !is_countable($_POST['amazon_order_item_code']) or !sizeOf($_POST['amazon_order_item_code'])){
    $messageStack->add_session('Keine Trackingdaten &uuml;bermittelt.','error');
    xtc_redirect(xtc_href_link('amazon.php'));
}
foreach($_POST['amazon_order_item_code'] as $aoicode){
    $query = xtc_db_query(sprintf(
            "SELECT aop.carrier_code,aop.carrier_name, aop.shipping_method,ao.orig_amazon_orders_id,aop.quantity FROM amazon_orders ao LEFT JOIN amazon_orders_products aop USING(amazon_orders_id) WHERE aop.amazon_order_item_code='%s'",
            $aoicode
    ));
    $record = xtc_db_fetch_array($query);
    if(isset($_POST['shipper_tracking_number'][$aoicode])){
        $tn = explode('+',$_POST['shipper_tracking_number'][$aoicode]);
    }else{
        $tn = [''];
    }
    foreach($tn as $tracking_nr){
        $transparency_code = '';
        $data[] = [
            $record['orig_amazon_orders_id'],
            $aoicode,
            $record['quantity'],
            date('Y-m-d'),
            $record['carrier_code'],
            $record['carrier_name'],
            trim($tracking_nr),
            $record['shipping_method'],
            $transparency_code,
            AMAZON_FULFILLMENT_ADDRESS_DATA_NAME,
            AMAZON_FULFILLMENT_ADDRESS_DATA_LINE1,
            AMAZON_FULFILLMENT_ADDRESS_DATA_LINE2,
            AMAZON_FULFILLMENT_ADDRESS_DATA_LINE3,
            AMAZON_FULFILLMENT_ADDRESS_DATA_CITY,
            AMAZON_FULFILLMENT_ADDRESS_DATA_COUNTY,
            AMAZON_FULFILLMENT_ADDRESS_DATA_STATE_OR_REGION,
            AMAZON_FULFILLMENT_ADDRESS_DATA_POSTALCODE,
            AMAZON_FULFILLMENT_ADDRESS_DATA_COUNTRYCODE,
        ];
    }
}


if(sizeOf($data)){
    $csv_arr = [implode("\t", AMAZON_VERSANDMELDUNG_XSLX_HEADER_COLS)];
    foreach($data as $data_row){
        $csv_arr[] = implode("\t",$data_row);
    }
    $csv = implode("\n",$csv_arr);
    $basics = new \basics;
    $basics->create_file($target_file, $csv);
    
    
    foreach($_POST['amazon_order_item_code'] as $aoicode){
        if(isset($_POST['shipper_tracking_number'][$aoicode])){
            $tn = $_POST['shipper_tracking_number'][$aoicode];
        }else{
            $tn = '';
        }
        $query = xtc_db_query(sprintf(
            "SELECT aop.shippings_id FROM amazon_orders_products aop WHERE aop.amazon_order_item_code='%s'",
            $aoicode
        ));
        $record = xtc_db_fetch_array($query);
        $shipping = new yes_shipping($record['shippings_id']);
        
        $order = new order( $shipping->getOrders_id());
        $tn_hist = (!empty($tn)) ? '(Trackingnummer: '.$tn.')' : '';
        $order->add_history($order->info['orders_status'], false, 'Versandmeldung an Amazon gemeldet.'.$tn_hist);
        $update_sql_array = [
            'order_fulfillment_send'=>1,
            'order_fulfillment_send_date'=>'now()',
            'shipper_tracking_number'=>$tn,
        ];
        xtc_db_perform('amazon_orders_products',$update_sql_array,'update',"amazon_order_item_code='".$aoicode."'");
    }
    $messageStack->add_session('Amazon Trackingnummern Exportdatei erzeugt. <a href="amazon.php?action=fulfillment_dl">[DOWNLOAD]</a>','success');
    xtc_redirect(xtc_href_link('amazon.php'));
}

