<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
include('includes/cron_application_top.php');
include('includes/classes/amz_Helper.php');
include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_SubmitFeed.php');
require_once('includes/classes/product.php');
require_once('includes/classes/class.storagequantity.php');
require_once('includes/classes/class.basics.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}

$basics = new basics;
$exportdata_path = \main::get_exportdata_path();
define('AMAZON_SAVE_PATH',$exportdata_path.'amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',1);
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);
$ReportType = '_GET_FLAT_FILE_OPEN_LISTINGS_DATA_';
$A = new amazon_helper;
$AS = new amazon_service();
$service = $AS->get_service();


// BOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER
$auth_user_array = $A->get_auth_user_array();
if(sizeOf($auth_user_array) > 1){
	$toggle_merchant_file = \main::get_exportdata_path().'CRON_AMAZON_SYNC_PRODUCTS.TOGGLE';
	if(!is_file($toggle_merchant_file)){
		file_put_contents($toggle_merchant_file,'0');
	}
	$merchant_nr = (int)file_get_contents($toggle_merchant_file);
	$mercID = $auth_user_array[$merchant_nr];
	$new_merchant_nr = (($merchant_nr+1) >= sizeOf($auth_user_array)) ? 0 : $merchant_nr+1;
	file_put_contents($toggle_merchant_file,$new_merchant_nr);
}else{
	$mercID = $auth_user_array[0];
}
// EOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER


$auth_params = $A->get_auth_data_array($mercID);
$parameters = array (
    'Marketplace' => $auth_params['marketplace_id'],
    'Merchant' => $auth_params['merchant_id'],
    'AvailableToDate' => new DateTime('now'),
    'AvailableFromDate' => new DateTime('-1 Days'),
    'ReportTypeList'=>array ('Type' => array ($ReportType)),
    'MaxCount' => AMAZON_REPORTLIST_MAX_COUNT,
    'Acknowledged' => false
);
if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
}
$service = $AS->get_service();
$RL = new ReportList;
$request = new MarketplaceWebService_Model_GetReportListRequest($parameters);
$items = $RL->invokeGetReportList($service, $request);
if(!sizeOf($items)){
    $request = new MarketplaceWebService_Model_RequestReportRequest();
    $request->setMarketplace($auth_params['marketplace_id']);
    $request->setMerchant($auth_params['merchant_id']);
    $request->setReportType($ReportType);
    if(!empty($auth_params['mwsauthtoken'])){
	    $request->setMWSAuthToken($auth_params['mwsauthtoken']);
    }
    //$request->setEndDate(new DateTime('now'));
    //$request->setStartDate(new DateTime('-3 hours'));
    $service->requestReport($request);
    
    // BOF - LOCK NEW REPORT
    define('LOCK_DURATION_TIME',60*5);
    $action_key = 'cron_amazon_sync_products'; // der key fuer table_lock
    $lock = yes_table_lock_get_status($action_key);
    if($lock['status'] == 'locked'){
	    if(!yes_table_lock_is_locked($lock['last_lock'],LOCK_DURATION_TIME)){
		    yes_table_lock_set_last_lock($action_key);
	    }else{
		$recipients_array = main::get_notice_recipients('amazon');
		$subject = 'Cronjob: Amazon Artikel Sync';
		$message = sprintf('Der cronjob zum Synchronisieren der Amazon Artikel konnte um %s nicht ausgefuehrt werden. Report zu schnell angefordert oder kein Report vorhanden.',date('d.m.Y H:i:s'));
		$sender = 0;
		yes_write_notice($subject,$message,$sender,$recipients_array);
		die('Locked: noch '.yes_strftime("%M:%S",( (LOCK_DURATION_TIME)-(time()-strtotime( $lock['last_lock'] ) ) ) ) .' Min. (last: '.$lock['last_lock'].')'."\r\n");
	    }
    }else{
	if(!yes_table_lock_exists($action_key)){
	    yes_table_lock_add($action_key);
	}else{
	    yes_table_lock_set_status($action_key,'locked');
	}
        die('Neuer Report '.$ReportType.' angefordert.');
    }
    // EOF - LOCK NEW REPORT
}
yes_table_lock_set_status($action_key,'open');

foreach($items as $item){
    printf("\r\nReport %s: %s\r\n",$ReportType,$item['ID']);
    $parameters = array (
	'Marketplace' => $auth_params['marketplace_id'],
	'Merchant' => $auth_params['merchant_id'],
	'Report' => @fopen('php://memory', 'rw+'),
	'ReportId' => $item['ID']
    );
    if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
    }

    $service = $AS->get_service();
    $R = new Report;
    $R->setReportType($ReportType);
    $request = new MarketplaceWebService_Model_GetReportRequest($parameters);
    $reports = $R->invokeGetReport($service, $request);
    if(sizeOf($reports)){
	    foreach($reports as $report ){
		$update_sql_array = array(
		    'price'=>$report['price'],
		    /*'quantity'=>$report['qty'],
		    'last_quantity_feed'=>'now()',*/
		    'last_price_feed'=>'now()'
		);
		xtc_db_perform('amazon_products',$update_sql_array,'update','products_id='.$report['products_id']." and merchant_id='".$auth_params['merchant_id']."'");
	    }
    }
    $parameters = array (
	'Marketplace' => $auth_params['marketplace_id'],
	'Merchant' => $auth_params['merchant_id'],
	'ReportIdList' => array ('Id' => $item['ID']),
	'Acknowledged' => true,
    );
    if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
    }
    $request = new MarketplaceWebService_Model_UpdateReportAcknowledgementsRequest($parameters);
    $response = $service->updateReportAcknowledgements($request);
    if ($response->isSetUpdateReportAcknowledgementsResult()) {
	printf("\r\nReportAcknowlegdement (true) fuer Report %s gesendet.\r\n",$item['ID']);
    }
    printf("\r\nEs wurden %s Amazonartikel synchronisiert.\r\n",sizeOf($reports));
}
die("\r\nScript beendet (".date('d.m.y H:i:s').")\r\n");
