<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
require_once('includes/cron_application_top.php');
// wir brauchen den namen
$_SESSION['language'] = 'german';
$_SESSION['languages_id'] = 2;
require(DIR_FS_LANGUAGES.$_SESSION['language'].'/modules/order_total/ot_subtotal_no_tax.php');
require(DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/orders.php');
require_once(DIR_FS_INC . 'xtc_is_shipping_before_payment.inc.php');
require_once(DIR_FS_INC . 'xtc_get_payment_method_title.inc.php');
require(DIR_FS_INC.'xtc_get_customers_status_export_note.inc.php');			
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ebay_seller_data.inc.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_serials.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
require_once(DIR_FS_INC . 'changedataout.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid_status.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_get_short_description.inc.php');
require (DIR_FS_CATALOG.'includes/classes/shipping.php');
require (DIR_FS_CATALOG.'inc/xtc_count_shipping_modules.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC . 'yes_get_shop_content.inc.php');
require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
if(!function_exists('yes_get_sha1_from_string')){
    require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
}

if( !defined('USE_DOMPDF') or USE_DOMPDF != 'True'){
    require_once("includes/classes/class.html2pdf.php");
}
if(BARCODE_PACKINGSLIP_ACTIVE == 'True'){
	require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');
}
require_once(DIR_FS_INC . 'xtc_get_order_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'xtc_get_packingslip_html_for_pdf.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_data_from_name.inc.php');
require(DIR_WS_CLASSES . 'currencies.php');
include('includes/classes/class.ebaymail.php');
require(DIR_WS_CLASSES . 'order.php');

// initiate template engine for mail
$smarty = new yesSmarty;

$config_file_name = basename(__FILE__).'.conf';
$config_hint = "Die Konfigurationsdatei muss die einzelnen orders_id enthalten, von denen jeweils eine Kopie erzeugt werden soll. Pro Zeile eine Auftragsnummer gefolgt von einem Doppelpunkt und dem Tag des Monats (also zb 1234:10).\r\n\r\n";
/*
 * ES SOLL IN EINEM PFAD UNTERHALB DES WEBROOTS GESPEICHERT WERDEN
 * $secure_path ist dann der Pfad vor /yes/
 */
$secure_path = main::get_secure_path();
if(!is_file($secure_path.$config_file_name) ){
    die("\r\nMissing config File ".$secure_path.$config_file_name."\r\n".$config_hint);
}
$contents = explode("\n",file_get_contents($secure_path.$config_file_name));
$order_src = array();
foreach($contents as $order_param){
    $parts = explode(':',$order_param);
    if(sizeOf($parts) < 2){
        continue;
    }
    $orders_id = $parts[0];
    $day = $parts[1];
    if(strlen($orders_id)<1 or !is_numeric($orders_id)){
        continue;
    }
    if(strlen($day)<1 or !is_numeric($day)){
        continue;
    }
    $order_src[ $day ] = (int)$orders_id;
}
if(!sizeOf($order_src)){
    die("\r\n\r\nNo valid orders_id:dayofmonth in config File ".$secure_path.$config_file_name."\r\n\r\n");
}
setlocale (LC_TIME, 'de_DE@euro', 'de_DE', 'de', 'ge');
foreach($order_src as $day => $src_oID){
    $abrechnungszeitraum = ($day == 1) ? yes_strftime('%B %Y',strtotime('-1 Month')) : $day.'.'.yes_strftime('%m.%Y',strtotime('-1 Month')).' - '.yes_strftime('%d.%m.%Y');
    echo $abrechnungszeitraum."\r\n";
    if($day != date('j')){
        printf("\tAuftrag %s erst verarbeiten am %s. des Monats\r\n",$src_oID,$day);
        continue;
    }
    
    $src_order = new order($src_oID);
// rein  nehmen
    $oID = $src_order->copy();
    $update_sql_array = array(
        'comments_visible'=>$abrechnungszeitraum
    );
    xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$oID."'");
    $order = new order($oID);
    
    
    $cID = $order->customer['ID'];
    $email_address = $order->customer['email_address'];
    if(strpos($email_address, ',') !== false){
        $email_addresses = explode(',',$email_address);
        foreach($email_addresses as $_eak=>$_ea){
            $email_addresses[$_eak] = trim($_ea);
        }
    }else{
        $email_addresses = array( trim($email_address) );
    }

    $payi = $order->get_paymentinstructions();
    if(sizeOf($order->get_paymentinstructions())){
        $smarty->assign('PAYMENTINSTRUCTIONS',current($payi));
    }

    $smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
    $smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br>'));
    $smarty->assign('address_label_payment',xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br>'));
    $smarty->assign('csID',$order->customer['csID']);
    $smarty->assign('vatID',$order->customer['vat_id']);
    $smarty->assign('ABRECHNUNGSZEITRAUM',$abrechnungszeitraum);

    $conditions = '';
    $conditions_txt = '';
    $shop_content_data = yes_get_shop_content(3, $_SESSION['languages_id'],false);
    if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
            $conditions = $shop_content_data['content_text'];
            $conditions_txt = yes_get_shop_content_html_stripped($conditions);
    }

    // WIDERRUF
    $widerruf = '';
    $widerruf_txt = '';
    $shop_content_data = yes_get_shop_content(9, $_SESSION['languages_id'],false);
    if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
            $widerruf = $shop_content_data['content_text'];
            $widerruf_txt = yes_get_shop_content_html_stripped($widerruf);
    }

    $smarty->assign(array(
            'cID'=>$order->customer['ID'],
            'cgroup'=>  xtc_get_customers_status_name($order->info['status']),
            'conditions'=>$conditions,
            'widerruf'=>$widerruf,
            'conditions_txt'=>$conditions_txt,
            'widerruf_txt'=>$widerruf_txt
    ));

    $ebay_seller = xtc_get_orders_ebay_seller((int)$_GET['oID']);
    if($ebay_seller != ''){
            $smarty->assign('EBAY_SELLER_DATA',xtc_get_ebay_seller_data($ebay_seller));
            $smarty->assign('EBAY_ID',$order->info['ebay_id']);
    }

    if( $order->info['orders_status'] == ORDERS_STATUS_STORNIERT) {
            $smarty->assign('IS_STORNO','1');
    }

    // get products data
    if( $order->info['is_parent'] == 'n') {
            $order_query=xtc_db_query("SELECT
                                    products_id,
                                    orders_products_id,
                                    products_model,
                                    products_name,
                                    allow_tax,
                                    products_tax,
                                    final_price,
                                    products_quantity
                                    FROM ".TABLE_ORDERS_PRODUCTS."
                                    WHERE orders_id='".(int)$_GET['oID']."'");
    }else{
            $order_query=xtc_db_query("SELECT
                                    op.products_id,
                                    op.orders_products_id,
                                    op.products_model,
                                    op.products_name,
                                    op.allow_tax,
                                    op.products_tax,
                                    op.final_price,
                                    op.products_quantity
                                    FROM ".TABLE_ORDERS_PRODUCTS." op, orders o 
                                    WHERE o.parent_orders_id='".(int)$_GET['oID']."' && op.orders_id=o.orders_id");
    }
    $order_data=array();
    $xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
    $sum_netto = 0;
    while ($order_data_values = xtc_db_fetch_array($order_query)) {
            // EAN AUSLESEN
            $ean = '';
            $vpe = '';
            $ean_query = yes_db_query(sprintf("SELECT products_ean,products_vpe,products_vpe_status,products_vpe_value FROM products WHERE products_id='%s'",$order_data_values['products_id']),true);
            if($ean_query){
                    $result = current($ean_query);
                    $ean = $result['products_ean'];
                    if ($result['products_vpe_status'] == 1 && $result['products_vpe_value'] != 0.0){
                            $vpe = $xtPrice->xtcFormat($order_data_values['final_price']  * (1 / $result['products_vpe_value']), true).TXT_PER.xtc_get_vpe_name($result['products_vpe']);
                    }
            }
            $order_data[]=array(
                    'PRODUCTS_SHORT_DESCRIPTION' => xtc_get_short_description($order_data_values['products_id'],$_SESSION['languages_id']),
                    'PRODUCTS_MODEL' => $order_data_values['products_model'],
                    'PRODUCTS_EAN' => $ean,
                    'PRODUCTS_VPE'=>$vpe,
                    'PRODUCTS_NAME' => $order_data_values['products_name'],
                'ABRECHNUNGSZEITRAUM' => $abrechnungszeitraum,
                    'PRODUCTS_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price'], true),
                    'PRODUCTS_SINGLE_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price']/$order_data_values['products_quantity'], true),
                    'PRODUCTS_TAX' => $tax,
                    'PRODUCTS_QTY' => $order_data_values['products_quantity'],
                    'PRODUCTS_WEIGHT'=>  xtc_get_ext_products_weight($order_data_values['products_id'])*$order_data_values['products_quantity']
            );

            if($order_data_values['allow_tax'] == '1' and $order_data_values['products_tax'] > 0){
                    $sum_netto += format_price($order_data_values['final_price'], 0, $order->info['currency'], $order_data_values['allow_tax'], $order_data_values['products_tax']);
            }
    }

    // ZEIGE ZWISCHENSUMME NETTOSUMME WENN INCL STEUER
    if($sum_netto > 0){
            $smarty->assign('NETTOSUM',number_format(xtc_round($sum_netto,PRICE_PRECISION),2,',','').' '.$order->info['currency']);
    }

    // get order_total data
    $oder_total_query=xtc_db_query("SELECT
                    title,
                    text,
                    class,
                    value,
                    sort_order
                                    FROM ".TABLE_ORDERS_TOTAL."
                                    WHERE orders_id='".$_GET['oID']."'
                                    ORDER BY sort_order ASC");

    $order_total=array();

    $notax = 0;
    while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {

            $order_total[]=array(
                    'TITLE' => $oder_total_values['title'],
                    'CLASS'=> $oder_total_values['class'],
                    'VALUE'=> $oder_total_values['value'],
                    'TEXT' => $oder_total_values['text']);

            if ($oder_total_values['class']=='ot_total'){
                    $total=$oder_total_values['value'];
            }
            if($oder_total_values['class']=='ot_subtotal_no_tax'){
                    $notax = 1; // RE OHNE MWST
            }
    }
    // das muss kundengruppenabh. sein
    $export_note = xtc_get_customers_status_export_note($order->info['status'],$_SESSION['languages_id']);
    if($export_note != '')
            $smarty->assign('export_note',$export_note);

    // assign language to template for caching
    $smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
    $smarty->assign('STORE_WRAP', STORE_WRAP);
    $smarty->assign('COMMENTS_VISIBLE', $order->info['comments_visible']);
    $smarty->assign('BANK', MODULE_PAYMENT_MONEYORDER_PAYTO);

    $smarty->assign('language', $_SESSION['language']);
    $smarty->assign('logo_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/img/');

    $o_ebayid = '';
    $in_auction_array = array();
    if($order->info['is_parent'] == 'y'){
            $all_ebay_query = xtc_db_query("SELECT ebay_id FROM orders WHERE parent_orders_id='".$_GET['oID']."'");
            while($all_ebay = xtc_db_fetch_array($all_ebay_query)){
                    $o_ebayid .= $all_ebay['ebay_id'].', ';
                    $in_auction_array[] = $all_ebay['ebay_id'];
            }
            $o_ebayid = substr($o_ebayid,0,(strlen($o_ebayid)-2));
    }else{
            $o_ebayid .= $order->info['ebay_id'];
            $in_auction_array[] = $order->info['ebay_id'];
    }
    if($o_ebayid!=''){
            $o_ebayid = '<p><b>'.EBAY_ID.':</b> '.$o_ebayid.'</p>';
    }
    $smarty->assign('ORDERS_ID',(int)xtc_db_input($_GET['oID']));
    if(sizeOf($in_auction_array)){
        $smarty->assign(array(
            'EBAY_ID_ARRAY'=>$in_auction_array,
            'EBAY_PLUS'=>$order->info['ebay_plus']
        ));
    }
    $smarty->assign('oID',(int)xtc_db_input($_GET['oID']).$o_ebayid);

    $smarty->assign('PAYMENT_METHOD',xtc_get_payment_method_title($order->info['payment_method']));
    $smarty->assign('DATE',xtc_date_long($order->info['date_purchased']));
    if($order->info['date_shipping'] > 0)
            $smarty->assign('DATE_SHIPPING',xtc_date_long($order->info['date_shipping']));
    $smarty->assign('order_data', $order_data);
    $smarty->assign('order_total', $order_total);
    $smarty->assign('skonto_values', $order->get_skonto());
    $delivery_conditions = xtc_get_customers_status_delivery_conditions($order->info['status'],$_SESSION['languages_id']);
    if(xtc_not_null($delivery_conditions)){
            $smarty->assign('DELIVERY_CONDITIONS',$delivery_conditions);
    }
    $smarty->assign('skonto_values',$order->get_skonto());

    // FIBUNUMBER ADDON
    $fibu_number = $order->get_fibunumber();
    if($fibu_number > 0){
            $smarty->assign('FIBU_NUMBER',$fibu_number);
    }
    $smarty->assign('ORDER_TYPE',$order->get_title($fibu_number));
    if($_GET['oc']){
            $smarty->assign('ORDER_TYPE',TEXT_ORDER_CONFIRMATION);
    }

    $smarty->assign('YESORDER',$order->get_order_positions());
    $smarty->assign('tpl_path',HTTP_SERVER.'templates/'.CURRENT_TEMPLATE.'/');
    if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
            $fibu_date_query = yes_db_query(sprintf(
                    "SELECT date_added FROM orders_fibunumbers WHERE orders_id='%s'",
                    $order->info['id']
            ));
            if(yes_db_num_rows($fibu_date_query)){
                    $date = current($fibu_date_query);
                    $smarty->assign('fibu_date',$date['date_added']);
            }
    }
    if($order->info['source_editor_id'] > 0){
        $editor_data_query = xtc_db_query(sprintf(
                "SELECT customers_firstname, customers_lastname,customers_telephone,customers_fax,mobile,customers_email_address FROM customers c WHERE customers_id='%s'",
                $order->info['source_editor_id']
        ));
        $smarty->assign('EDITOR_DATA',xtc_db_fetch_array($editor_data_query));
    }


    $html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_order.html');
    // **** EMAILCLIENT - ADDON *****
    $dbMail = new DBmail('0');
    $subject = (isset($_REQUEST['subject'])) ? xtc_db_prepare_input(yes_encode_string($_REQUEST['subject'])) : TEXT_ORDER_EMAIL_SUBJECT.$order->info['id'].(($order->info['ebay_id']!='') ? ' ('.$order->info['ebay_id'].')':'');
    foreach($email_addresses as $ea){
        $dbMail->save_mail($subject,$ea,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$html_mail,date('Y-m-d H:i:s'), $order->info['ebay_id'],$cID,$oID);
        $comments = sprintf(HISTORY_ORDER_EMAIL,$ea);
        $order->add_history($order->info['orders_status'], true, $comments);
    }


    $pdf_name = '';
    if(PDF_EMAILS == 'True'){
            // GENERIERE RECHNUNG-PDF
            $pdf_smarty = new yesSmarty;
            $pdf_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
            $pdf_name=\main::get_exportdata_path().sprintf(ORDER_PDF_NAME,$order->info['id']);
            if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
                $pdf = new yes_pdf();
                if(DOMPDF_ORDER_LANDSCAPE == 'True'){
                    $pdf->set_landscape();
                }
                $pdf->set_html($pdf_html);
                $pdf->save($pdf_name);
            }else{
                $pdf=new HTML2FPDF();
                $pdf->AddPage();
                $pdf->WriteHTML($pdf_html);
                $pdf->Output($pdf_name,$dest='F'); //Read the FPDF.org manual to know the other options
            }

    }
    $teaser_pdf_name = '';
    $attachments_array = array();
    if($pdf_name != ''){
        $attachments_array[] = $pdf_name;
    }
    if($teaser_pdf_name != ''){
        $attachments_array[] = $teaser_pdf_name;
    }
    for($i=0;$i<sizeOf($email_addresses);$i++){
        $email_address = $email_addresses[$i];
        xtc_php_mail(EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $email_address, $email_address, 'b.agri@yes4trade.de', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $attachments_array, '', $subject, $html_mail,'');
    }

    if(PDF_EMAILS == 'True'){
            unlink($pdf_name);
    }
    if(PDF_TEASER_IN_ORDERS == 'true' and $teaser_pdf_name != ''){
            unlink($teaser_pdf_name);
    }
    printf("\r\nAuftrag %s wurde erzeugt\r\n",$oID);
}
