<?php
/* --------------------------------------------------------------
   $Id: customers_status.php,v 1.31 2018/06/04 09:23:48 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce( based on original files from OSCommerce CVS 2.2 2002/08/28 02:14:35); www.oscommerce.com
   (c) 2003	 nextcommerce (customers_status.php,v 1.28 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   based on Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   --------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC.'xtc_get_customers_status_export_note.inc.php');
require_once(DIR_FS_INC.'yes_get_customers_status_description.inc.php');
foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
    if(strpos($cd->getKey(),'customers_status')>-1){
        $InstanceCache->deleteItem($cd->getKey()); // customers_status
    }
}

// initiate template engine for mail
$smarty = new yesSmarty;
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch ($action) {
    case 'short_view':
        $csID = intval($_GET['csID']??0);
        $customers_status = \YES4Trade\Model\customers_status::get_by_customers_status_id($csID);
        if($customers_status === false){
            die('Invalid customers status');
        }
        $smarty->assign([
            'language_path'=>DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
            'CS'=>$customers_status->toArray(),
            'TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE'=>TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE,
            'TEXT_INFO_CUSTOMERS_STATUS_PUBLIC'=>TEXT_INFO_CUSTOMERS_STATUS_PUBLIC_INTRO,
            'TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_OT_XMEMBER_INTRO'=>TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_OT_XMEMBER_INTRO,
            'TEXT_INFO_CUSTOMERS_STATUS_OT_DISCOUNT_PRICE'=>TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE,
            'TEXT_INFO_CUSTOMERS_STATUS_GRADUATED_PRICES'=>TEXT_INFO_CUSTOMERS_STATUS_GRADUATED_PRICES_INTRO,
            'TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE'=>TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE_INTRO,
            'TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE_TAX'=>ENTRY_CUSTOMERS_STATUS_SHOW_PRICE_TAX,
            'TEXT_INFO_CUSTOMERS_STATUS_ADD_TAX_OT'=>ENTRY_CUSTOMERS_STATUS_ADD_TAX,
            'TABLE_HEADING_CUSTOMERS_STATUS'=>TABLE_HEADING_CUSTOMERS_STATUS
        ]);
        $smarty->display('customers_status.short_view.html');
        exit;
        break;
    case 'insert':
    case 'save':
        $customers_status_id = $_GET['cID']??null;
	    if($customers_status_id == 0 and $action != 'insert' and $_SESSION['customer_id'] != 1){
	        $messageStack->add_session('Forbidden Customers Status','error');
	        xtc_redirect(xtc_href_link(basename(__FILE__)));
	    }

        $languages = xtc_get_languages();
        for ($i=0; $i<sizeof($languages); $i++) {
            $customers_status_name_array = $_POST['customers_status_name'];
            $customers_status_show_price = $_POST['customers_status_show_price'];
            $customers_status_show_price_tax = $_POST['customers_status_show_price_tax'];
            $customers_status_public = $_POST['customers_status_public'];
            $customers_status_discount = $_POST['customers_status_discount'];
            $customers_status_ot_discount_flag = $_POST['customers_status_ot_discount_flag'];
            $customers_status_ot_discount = $_POST['customers_status_ot_discount'];
            $customers_status_graduated_prices = $_POST['customers_status_graduated_prices'];
            $customers_status_discount_attributes = $_POST['customers_status_discount_attributes'];
            $customers_status_add_tax_ot = $_POST['customers_status_add_tax_ot'];
            $customers_status_payment_unallowed = $_POST['customers_status_payment_unallowed'];
            $customers_status_shipping_unallowed = $_POST['customers_status_shipping_unallowed'];
            $customers_status_payment_target = $_POST['customers_status_payment_target'];
            $customers_status_skonto = $_POST['customers_status_skonto'];
            $export_note = (int)$_POST['export_note'];
            $export_note_text_array = $_POST['export_note_text'];

            $customers_fsk18 = $_POST['customers_fsk18'];
            $customers_fsk18_display = $_POST['customers_fsk18_display'];

            $account_value_alert_status = $_POST['account_value_alert_status'];
            $account_value_alert_limit = $_POST['account_value_alert_limit'];

            $language_id = $languages[$i]['id'];

            $sql_data_array = array(
                'customers_status_name' => xtc_db_prepare_input($customers_status_name_array[$language_id]),
                'customers_status_public' => xtc_db_prepare_input($customers_status_public),
                'customers_status_show_price' => xtc_db_prepare_input($customers_status_show_price),
                'customers_status_show_price_tax' => xtc_db_prepare_input($customers_status_show_price_tax),
                'customers_status_discount' => xtc_db_prepare_input($customers_status_discount),
                'customers_status_ot_discount_flag' => xtc_db_prepare_input($customers_status_ot_discount_flag),
                'customers_status_ot_discount' => xtc_db_prepare_input($customers_status_ot_discount),
                'customers_status_graduated_prices' => xtc_db_prepare_input($customers_status_graduated_prices),
                'customers_status_add_tax_ot' => xtc_db_prepare_input($customers_status_add_tax_ot),
                'customers_status_payment_unallowed' => xtc_db_prepare_input($customers_status_payment_unallowed),
                'customers_status_shipping_unallowed' => xtc_db_prepare_input($customers_status_shipping_unallowed),
                'customers_status_payment_target' => (int)xtc_db_prepare_input($customers_status_payment_target),
                'customers_status_skonto' => xtc_db_prepare_input($customers_status_skonto),
                'customers_status_default_admin_paymentmethod' => xtc_db_prepare_input($_POST['customers_status_default_admin_paymentmethod']),
                'customers_status_delivery_conditions' => xtc_db_prepare_input($_POST['customers_status_delivery_conditions'][$language_id]),
                'export_note_text'=>(($export_note == 1)?xtc_db_prepare_input($export_note_text_array[$language_id]):''),
                'export_note'=>$export_note,
                'customers_fsk18' => xtc_db_prepare_input($customers_fsk18),
                'customers_fsk18_display' => xtc_db_prepare_input($customers_fsk18_display),
                'customers_status_discount_attributes' => xtc_db_prepare_input($customers_status_discount_attributes),
                'account_value_alert_status'=>$account_value_alert_status,
                'account_value_alert_limit'=>$account_value_alert_limit,
                'sort_order'=>(int)$_POST['sort_order'],
                'customers_status_description'=>xtc_db_prepare_input($_POST['customers_status_description']['l'.$language_id]),
            );
            if ($_GET['action'] == 'insert') {
                if (!xtc_not_null($customers_status_id)) {
                    $customers_status_id = \YES4Trade\Model\customers_status::get_next_id();
                    \YES4Trade\Model\group_prices::create_table($customers_status_id);
                }
                $insert_sql_data = array(
                    'customers_status_id' => $customers_status_id??null, 
                    'language_id' => xtc_db_prepare_input($language_id)
                );
                $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
                xtc_db_perform(TABLE_CUSTOMERS_STATUS, $sql_data_array);
            } elseif ($_GET['action'] == 'save') {
                xtc_db_perform(TABLE_CUSTOMERS_STATUS, $sql_data_array, 'update', 
                    "customers_status_id = '" . xtc_db_input($customers_status_id) . "' and language_id = '" . $language_id . "'"
                );
            }
            if($_SESSION['languages_id'] == $language_id){
                $history_string = TEXT_CUSTOMERS_STATUS_CONFIGURATION.$customers_status_name_array[$language_id].':<br />';
                foreach($sql_data_array as $sqlk=>$sqlv){
                    $history_string .= $sqlk.' = '.$sqlv.'<br />';
                }
                $history_sql_array = array(
                    'date_added'=>'now()',
                    'comments'=>$history_string,
                    'editor_id'=>$_SESSION['customer_id']
                );
                xtc_db_perform('history',$history_sql_array);
            }
        }
        $allow_upload = false;
        if(isset($_FILES['customers_status_image'])){
            $mime_type = yes_get_mime_type($_FILES['customers_status_image']['tmp_name']);
            switch($mime_type){
                  case 'image/gif':
                      $allow_upload = true;
                      break;
                  default:
                      break;
            }
            if($allow_upload){
                if ($customers_status_image = &xtc_try_upload('customers_status_image', DIR_WS_ICONS)) {
                    xtc_db_query("update " . TABLE_CUSTOMERS_STATUS . " set customers_status_image = '" . $customers_status_image->filename . "' where customers_status_id = '" . xtc_db_input($customers_status_id) . "'");
                }
            }else{
                $messageStack->add_session(sprintf(MSG_ERROR_INVALID_STATUS_IMAGE,$mime_type),'error');
            }
        }

        if ($_POST['default'] == 'on') {
            main::update_configuration_value('DEFAULT_CUSTOMERS_STATUS_ID', xtc_db_input($customers_status_id));
        }

        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&cID=' . $customers_status_id));
        break;
    case 'deleteconfirm':
	$cID = (int)xtc_db_input($_GET['cID']);
	if($cID == '0' and $_SESSION['customer_id'] != 1){
	    $messageStack->add_session('Forbidden Customers Status','error');
	    xtc_redirect(xtc_href_link(basename(__FILE__)));
	}
        
        $dcsID = main::get_configuration_value('DEFAULT_CUSTOMERS_STATUS_ID');
        if ($dcsID == $cID) {
            main::update_configuration_value('DEFAULT_CUSTOMERS_STATUS_ID', '');
        }

	$status_name = xtc_get_customers_status_name($cID);
        $comments = sprintf(HISTORY_CUSTOMERS_STATUS_DELETED,$status_name,$cID);
        $history_sql_array = array(
                'date_added'=>'now()',
                'comments'=>$comments,
                'editor_id'=>$_SESSION['customer_id']
        );
        xtc_db_perform('history',$history_sql_array);

        xtc_db_query("delete from " . TABLE_CUSTOMERS_STATUS . " where customers_status_id = '" . xtc_db_input($cID) . "'");

        // We want to drop the existing corresponding personal_offers table
        \YES4Trade\Model\group_prices::drop_table((int)xtc_db_input($cID));
        xtc_redirect(xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page']));
        break;
    case 'delete':
      $cID = xtc_db_prepare_input($_GET['cID']);
	if(intval($cID) == 0 and $_SESSION['customer_id'] != 1){
	    $messageStack->add_session('Forbidden Customers Status','error');
	    xtc_redirect(xtc_href_link(basename(__FILE__)));
	}

        $status_query = xtc_db_query("select count(*) as count from " . TABLE_CUSTOMERS . " where customers_status = '" . xtc_db_input($cID) . "'");
        $status = xtc_db_fetch_array($status_query);

        $remove_status = true;
        if (intval($cID) == intval(constant('DEFAULT_CUSTOMERS_STATUS_ID')) or intval($cID) == intval(constant('DEFAULT_CUSTOMERS_STATUS_ID_GUEST'))) {
            $remove_status = false;
            $messageStack->add(ERROR_REMOVE_DEFAULT_CUSTOMERS_STATUS, 'error');
        } elseif ($status['count'] > 0) {
            $remove_status = false;
            $messageStack->add(ERROR_STATUS_USED_IN_CUSTOMERS, 'error');
        } else {
            $history_query = xtc_db_query("select count(*) as count from " . TABLE_CUSTOMERS_STATUS_HISTORY . " where '" . xtc_db_input($cID) . "' in (new_value, old_value)");
            $history = xtc_db_fetch_array($history_query);
            if ($history['count'] > 0) {
                // delete from history
                xtc_db_query("DELETE FROM " . TABLE_CUSTOMERS_STATUS_HISTORY . " where '" . xtc_db_input($cID) . "' in (new_value, old_value)");
                $remove_status = true;
                // $messageStack->add(ERROR_STATUS_USED_IN_HISTORY, 'error');
            }
        }
        break;
}
$customers_status_ot_discount_flag_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_graduated_prices_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_public_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_show_price_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_show_price_tax_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_discount_attributes_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_add_tax_ot_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_fsk18_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_fsk18_display_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));
$customers_status_query_raw = "select * from " . TABLE_CUSTOMERS_STATUS . " where language_id = '" . $_SESSION['languages_id'] . "' order by sort_order,customers_status_id";
$account_value_alert_status_array = array(array('id' => '0', 'text' => ENTRY_NO), array('id' => '1', 'text' => ENTRY_YES));

$customers_status_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $customers_status_query_raw, $customers_status_query_numrows);

yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript">
<!--
$().ready(function(){
   $('table#customers_status_table tbody tr').each(function(){
        $(this).click(function(){
            if($(this).attr('id') == default_csid){
            var chref = '<?php echo xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&action=edit'); ?>&cID='+$(this).attr('id');
            }else{
            var chref = '<?php echo xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page']); ?>&cID='+$(this).attr('id');
            }
            window.location.href = chref;
        });
        if($(this).attr('id') == default_csid){
            $(this).attr('class','ui-state-active');
        }
        $(this).css('cursor','pointer');
   });
});
//-->
</script>
<?php
$menus = array();
if (substr($action, 0, 3) != 'new') {
    $menus[] = array('text'=>TEXT_INFO_HEADING_NEW_CUSTOMERS_STATUS,
	    'link'=>xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&action=new'),
	    'lbOn'=>false,
	    'auth'=>true
    );	
}
$items = array();
$customers_status_query = xtc_db_query($customers_status_query_raw);
while ($customers_status = xtc_db_fetch_array($customers_status_query)) {
    if (((!isset($_GET['cID'])) || ($_GET['cID'] == $customers_status['customers_status_id'])) && (!isset($cInfo)) && (!isset($_GET['action']) or substr($_GET['action'], 0, 3) != 'new')) {
      $cInfo = new objectInfo($customers_status);
    }
    $status = '';
    if ($customers_status['customers_status_id'] == DEFAULT_CUSTOMERS_STATUS_ID ) {
      $status .= '<b>' . $customers_status['customers_status_name'];
      $status .= ' (' . TEXT_DEFAULT . ')';
    } else {
      $status .= $customers_status['customers_status_name'];
    }
    if ($customers_status['customers_status_public'] == '1') {
      $status .= ' ,public ';
    }
    
    $tax = '&nbsp;';
    if ($customers_status['customers_status_show_price'] == '1') {
	if ($customers_status['customers_status_show_price_tax'] == '1') {
	    $tax = TAX_YES;
	} else {
	    $tax = TAX_NO;
	}
    }
    $items[] = array(
	'id'=>$customers_status['customers_status_id'],
	'icon'=>($customers_status['customers_status_image'] != '') ? xtc_image(DIR_WS_ICONS . $customers_status['customers_status_image'] , IMAGE_ICON_INFO,'','','style="max-width: 100px;max-height: 100px;"') : '&nbsp;',
	'user'=>xtc_get_status_users($customers_status['customers_status_id']),
	'status'=>$status,
	'tax'=>$tax,
	'discount'=>$customers_status['customers_status_discount'] . ' %',
	'ot_discount'=>$customers_status['customers_status_ot_discount'].' %',
	'graduated'=>($customers_status['customers_status_graduated_prices'] == 0) ? NO : YES,
	'payment_unallowed'=>$customers_status['customers_status_payment_unallowed'],
	'shipping_unallowed'=>$customers_status['customers_status_shipping_unallowed'],
        'sort_order'=>$customers_status['sort_order'],
    );
}
$heading = array();
$contents = array();
switch ($action) {
    case 'new':
	$cInfo = new objectInfo(array(
	    'customers_status_public'=>'',
	    'customers_status_show_price'=>'',
	    'customers_status_show_price_tax'=>'',
	    'customers_status_add_tax_ot'=>'',
	    'customers_status_discount'=>'',
	    'customers_status_ot_discount'=>'',
	    'customers_status_ot_discount_flag'=>'',
	    'customers_status_graduated_prices'=>'',
	    'customers_status_discount_attributes'=>'',
	    'customers_status_payment_unallowed'=>'',
	    'customers_status_payment_target'=>'',
	    'customers_status_skonto'=>'',
	    'customers_fsk18'=>'',
	    'customers_fsk18_display'=>'',
	    'customers_status_shipping_unallowed'=>'',
	    'account_value_alert_status'=>0,
	    'account_value_alert_limit'=>0,
            'sort_order'=>0,
            'customers_status_description'=>'',
	));
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_NEW_CUSTOMERS_STATUS . '</b>');
      $contents = array('form' => xtc_draw_form('status', FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&action=insert', 'post', 'enctype="multipart/form-data"'));
      $contents[] = array('text' => TEXT_INFO_INSERT_INTRO);
      $customers_status_inputs_string = '';
      $languages = xtc_get_languages();
      for ($i=0; $i<sizeof($languages); $i++) {
        $customers_status_inputs_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'.$languages[$i]['directory'].'/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('customers_status_name[' . $languages[$i]['id'] . ']');
      }
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_NAME . $customers_status_inputs_string);
      $contents[] = array('text' => '<br /><b>' . TEXT_INFO_CUSTOMERS_STATUS_IMAGE . '</b><br />' . xtc_draw_file_field('customers_status_image'));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PUBLIC_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PUBLIC . ' ' . xtc_draw_pull_down_menu('customers_status_public', $customers_status_public_array, $cInfo->customers_status_public ));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE_INTRO     . '<br />' . ENTRY_CUSTOMERS_STATUS_SHOW_PRICE . ' ' . xtc_draw_pull_down_menu('customers_status_show_price', $customers_status_show_price_array, $cInfo->customers_status_show_price ));
      $contents[] = array('text' => '<br /><b>' . TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE_TAX_INTRO . '</b><br />' . ENTRY_CUSTOMERS_STATUS_SHOW_PRICE_TAX . ' ' . xtc_draw_pull_down_menu('customers_status_show_price_tax', $customers_status_show_price_tax_array, $cInfo->customers_status_show_price_tax ));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_ADD_TAX_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_ADD_TAX . ' ' . xtc_draw_pull_down_menu('customers_status_add_tax_ot', $customers_status_add_tax_ot_array, $cInfo->customers_status_add_tax_ot));
      $contents[] = array('text' => '<br /><b>' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE_INTRO . '</b><br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE . '<br />' . xtc_draw_input_field('customers_status_discount', $cInfo->customers_status_discount));
//      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES_INTRO     . '<br />' . ENTRY_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES . ' ' . xtc_draw_pull_down_menu('customers_status_discount_attributes', $customers_status_discount_attributes_array, $cInfo->customers_status_discount_attributes ));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_OT_XMEMBER_INTRO . '<br /> ' . ENTRY_OT_XMEMBER . ' ' . xtc_draw_pull_down_menu('customers_status_ot_discount_flag', $customers_status_ot_discount_flag_array, $cInfo->customers_status_ot_discount_flag ). '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE . '<br />' . xtc_draw_input_field('customers_status_ot_discount', $cInfo->customers_status_ot_discount));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_GRADUATED_PRICES_INTRO . '<br />' . ENTRY_GRADUATED_PRICES . ' ' . xtc_draw_pull_down_menu('customers_status_graduated_prices', $customers_status_graduated_prices_array, $cInfo->customers_status_graduated_prices ));
      //$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES . ' ' . xtc_draw_pull_down_menu('customers_status_discount_attributes', $customers_status_discount_attributes_array, $cInfo->customers_status_discount_attributes ));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PAYMENT_UNALLOWED_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PAYMENT_UNALLOWED . '<br />' . xtc_draw_input_field('customers_status_payment_unallowed', $cInfo->customers_status_payment_unallowed ));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SHIPPING_UNALLOWED_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_SHIPPING_UNALLOWED . '<br />' . xtc_draw_input_field('customers_status_shipping_unallowed', $cInfo->customers_status_shipping_unallowed ));
      
      // YES: payment target
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PAYMENT_TARGET_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PAYMENT_TARGET . ' ' . xtc_draw_input_field('customers_status_payment_target', ''.(int)$cInfo->customers_status_payment_target ));

      // YES: SKONTO
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SKONTO_INTRO . '<br />' .
		  xtc_draw_input_field('customers_status_skonto', ''.$cInfo->customers_status_skonto ));
      
    $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DEFAULT_ADMIN_PAYMENTMETHOD_INTRO . '<br />' .
                xtc_draw_input_field('customers_status_default_admin_paymentmethod', ''.$cInfo->customers_status_default_admin_paymentmethod ));

    $delivery_conditions_string = '';
    $export_note_string = '';
    for ($i=0; $i<sizeof($languages); $i++) {
              $export_note_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'.$languages[$i]['directory'].'/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('export_note_text[' . $languages[$i]['id'] . ']', '','maxlength="255"');
              $delivery_conditions_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'.$languages[$i]['directory'].'/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('customers_status_delivery_conditions[' . $languages[$i]['id'] . ']', '','maxlength="255"');
    }
    $contents[] = array('text' => '<br /><b>' . TEXT_EXPORT_NOTE_ACTIVE . '</b>'.xtc_draw_checkbox_field('export_note',1,false));
    $contents[] = array('text' => TEXT_EXPORT_NOTE . $export_note_string);
    $contents[] = array('text' => TEXT_INFO_CUSTOMERS_STATUS_DELIVERY_CONDITIONS_INTRO . $delivery_conditions_string);

      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_FSK18_INTRO . '<br />' . ENTRY_CUSTOMERS_FSK18 . ' ' . xtc_draw_pull_down_menu('customers_fsk18', $customers_fsk18_array, $cInfo->customers_fsk18));
      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_FSK18_DISPLAY_INTRO . '<br />' . ENTRY_CUSTOMERS_FSK18_DISPLAY . ' ' . xtc_draw_pull_down_menu('customers_fsk18_display', $customers_fsk18_display_array, $cInfo->customers_fsk18_display));
      
      // BOF account_value_alert
      $contents[] = array('text' => '<b>' . TEXT_ACCOUNT_VALUE_ALERT_STATUS . '</b><br />' . xtc_draw_pull_down_menu('account_value_alert_status',$account_value_alert_status_array,$account_value_alert_status));
      $contents[] = array('text' => '<b>' . TEXT_ACCOUNT_VALUE_ALERT_LIMIT . '</b><br />' . xtc_draw_input_field('account_value_alert_limit',$account_value_alert_limit,'size="10" maxlength="12"'));
      // EOF account_value_alert
      
      $contents[] = array('text' => '<br />' . xtc_draw_checkbox_field('default') . ' ' . TEXT_SET_DEFAULT);
      $contents[] = array('text' => '<b>' . TABLE_HEADING_SORT_ORDER . '</b><br />' . xtc_draw_input_field('sort_order',0,'size="4" maxlength="3"'));
      for ($i=0; $i<sizeof($languages); $i++) {
        $contents[] = ['text' => '<b>' . TABLE_HEADING_CUSTOMERS_STATUS_DESCRIPTION . ' '.$languages[$i]['name'].'</b><br />' . 
          xtc_draw_textarea_field("customers_status_description[l".$languages[$i]['id']."]", 'virtual', 40, 5,'')
        ];
      }
      $contents[] = array('align' => 'center', 'text' => '<br />' .
		  yes_draw_href_button(IMAGE_INSERT,'','width:120px','submit').
		  '&nbsp;'.
		  yes_draw_href_button(IMAGE_CANCEL,
			  xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page']),
			  'width:120px;')
	  );
      break;

    case 'edit':
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_EDIT_CUSTOMERS_STATUS . '</b>');
      if($cInfo->customers_status_id == '0' and $_SESSION['customer_id'] != 1){
	    $contents[] = array('align' => 'center', 'text' => TEXT_ERROR_ONLY_ADMIN_CAN_CHANGE );
      }else{
	$contents = array('form' => xtc_draw_form('status', FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&cID=' . $cInfo->customers_status_id  .'&action=save', 'post', 'enctype="multipart/form-data"'));
	$contents[] = array('text' => TEXT_INFO_EDIT_INTRO);
	$customers_status_inputs_string = '';
	$languages = xtc_get_languages();
	for ($i=0; $i<sizeof($languages); $i++) {
	  $customers_status_inputs_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'.$languages[$i]['directory'].'/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('customers_status_name[' . $languages[$i]['id'] . ']', xtc_get_customers_status_name($cInfo->customers_status_id, $languages[$i]['id']));
	}

	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_NAME . $customers_status_inputs_string);
	$contents[] = array('text' => '<br />' . xtc_image(DIR_WS_ICONS . $cInfo->customers_status_image, $cInfo->customers_status_name) . '<br />' . DIR_WS_ICONS . '<br /><b>' . $cInfo->customers_status_image . '</b>');
	$contents[] = array('text' => '<br /><b>' . TEXT_INFO_CUSTOMERS_STATUS_IMAGE . '</b><br />' . xtc_draw_file_field('customers_status_image', $cInfo->customers_status_image));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PUBLIC_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PUBLIC . ' ' . xtc_draw_pull_down_menu('customers_status_public', $customers_status_public_array, $cInfo->customers_status_public ));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE_INTRO     . '<br />' . ENTRY_CUSTOMERS_STATUS_SHOW_PRICE . ' ' . xtc_draw_pull_down_menu('customers_status_show_price', $customers_status_show_price_array, $cInfo->customers_status_show_price ));
	$contents[] = array('text' => '<br /><b>' . TEXT_INFO_CUSTOMERS_STATUS_SHOW_PRICE_TAX_INTRO . '</b><br />' . ENTRY_CUSTOMERS_STATUS_SHOW_PRICE_TAX . ' ' . xtc_draw_pull_down_menu('customers_status_show_price_tax', $customers_status_show_price_tax_array, $cInfo->customers_status_show_price_tax ));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_ADD_TAX_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_ADD_TAX . ' ' . xtc_draw_pull_down_menu('customers_status_add_tax_ot', $customers_status_add_tax_ot_array, $cInfo->customers_status_add_tax_ot));
	$contents[] = array('text' => '<br /><b>' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE_INTRO . '</b><br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE . ' ' . xtc_draw_input_field('customers_status_discount', $cInfo->customers_status_discount));
  //      $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES . ' ' . xtc_draw_pull_down_menu('customers_status_discount_attributes', $customers_status_discount_attributes_array, $cInfo->customers_status_discount_attributes ));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_OT_XMEMBER_INTRO . '<br /> ' . ENTRY_OT_XMEMBER . ' ' . xtc_draw_pull_down_menu('customers_status_ot_discount_flag', $customers_status_ot_discount_flag_array, $cInfo->customers_status_ot_discount_flag). '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE . ' ' . xtc_draw_input_field('customers_status_ot_discount', $cInfo->customers_status_ot_discount));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_GRADUATED_PRICES_INTRO . '<br />' . ENTRY_GRADUATED_PRICES . ' ' . xtc_draw_pull_down_menu('customers_status_graduated_prices', $customers_status_graduated_prices_array, $cInfo->customers_status_graduated_prices));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PAYMENT_UNALLOWED_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PAYMENT_UNALLOWED . '<br />' . xtc_draw_input_field('customers_status_payment_unallowed', $cInfo->customers_status_payment_unallowed ));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SHIPPING_UNALLOWED_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_SHIPPING_UNALLOWED . '<br />' . xtc_draw_input_field('customers_status_shipping_unallowed', $cInfo->customers_status_shipping_unallowed ));

	// YES: payment target
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PAYMENT_TARGET_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PAYMENT_TARGET . ' ' . xtc_draw_input_field('customers_status_payment_target', ''.(int)$cInfo->customers_status_payment_target ));
	// YES: SKONTO
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SKONTO_INTRO . '<br />' .
		    xtc_draw_input_field('customers_status_skonto', ''.$cInfo->customers_status_skonto ));
	    // YES: Lieferbedingungen
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DEFAULT_ADMIN_PAYMENTMETHOD_INTRO . '<br />' .
		    xtc_draw_input_field('customers_status_default_admin_paymentmethod', ''.$cInfo->customers_status_default_admin_paymentmethod ));

	$delivery_conditions_string = '';
	$export_note_string = '';
	for ($i=0; $i<sizeof($languages); $i++) {
		  $export_note_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'.$languages[$i]['directory'].'/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('export_note_text[' . $languages[$i]['id'] . ']', xtc_get_customers_status_export_note($cInfo->customers_status_id, $languages[$i]['id']),'maxlength="255"');
		  $delivery_conditions_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'.$languages[$i]['directory'].'/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_draw_input_field('customers_status_delivery_conditions[' . $languages[$i]['id'] . ']', xtc_get_customers_status_delivery_conditions($cInfo->customers_status_id, $languages[$i]['id']),'maxlength="255"');
	}
	$contents[] = array('text' => '<br /><b>' . TEXT_EXPORT_NOTE_ACTIVE . '</b>'.xtc_draw_checkbox_field('export_note',1,(($cInfo->export_note == 1)?true:false)	));
	$contents[] = array('text' => TEXT_EXPORT_NOTE . $export_note_string);
	$contents[] = array('text' => TEXT_INFO_CUSTOMERS_STATUS_DELIVERY_CONDITIONS_INTRO . $delivery_conditions_string);

	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_FSK18_INTRO . '<br />' . ENTRY_CUSTOMERS_FSK18 . ' ' . xtc_draw_pull_down_menu('customers_fsk18', $customers_fsk18_array, $cInfo->customers_fsk18 ));
	$contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_FSK18_DISPLAY_INTRO . '<br />' . ENTRY_CUSTOMERS_FSK18_DISPLAY . ' ' . xtc_draw_pull_down_menu('customers_fsk18_display', $customers_fsk18_display_array, $cInfo->customers_fsk18_display));

	// BOF account_value_alert
	$contents[] = array('text' => '<b>' . TEXT_ACCOUNT_VALUE_ALERT_STATUS . '</b><br />' . xtc_draw_pull_down_menu('account_value_alert_status',$account_value_alert_status_array,$cInfo->account_value_alert_status));
	$contents[] = array('text' => '<b>' . TEXT_ACCOUNT_VALUE_ALERT_LIMIT . '</b><br />' . xtc_draw_input_field('account_value_alert_limit',$cInfo->account_value_alert_limit,'size="10" maxlength="12"'));
	// EOF account_value_alert
        
	$contents[] = array('text' => '<b>' . TABLE_HEADING_SORT_ORDER . '</b><br />' . xtc_draw_input_field('sort_order',$cInfo->sort_order,'size="4" maxlength="3"'));
        for ($i=0; $i<sizeof($languages); $i++) {
            $contents[] = ['text' => '<b>' . TABLE_HEADING_CUSTOMERS_STATUS_DESCRIPTION . ' '.$languages[$i]['name'].'</b><br />' . 
                xtc_draw_textarea_field("customers_status_description[l".$languages[$i]['id']."]", 'virtual', 40, 5,yes_get_customers_status_description($cInfo->customers_status_id,$languages[$i]['id'] ))
            ];
        }

	if (DEFAULT_CUSTOMERS_STATUS_ID != $cInfo->customers_status_id) {
            $contents[] = array('text' => '<br />' . xtc_draw_checkbox_field('default') . ' ' . TEXT_SET_DEFAULT);
        }
	$contents[] = array('align' => 'center', 'text' => '<br />' .
		    yes_draw_href_button(IMAGE_UPDATE,'','width:120px','submit').
		    '&nbsp;'.
		    yes_draw_href_button(IMAGE_CANCEL,
			    xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&cID=' . $cInfo->customers_status_id),
			    'width:120px;')
	    );
      }
      break;

    case 'delete':
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_CUSTOMERS_STATUS . '</b>');

      $contents = array('form' => xtc_draw_form('status', FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&cID=' . $cInfo->customers_status_id  . '&action=deleteconfirm'));
      $contents[] = array('text' => TEXT_INFO_DELETE_INTRO);
      $contents[] = array('text' => '<br /><b>' . $cInfo->customers_status_name . '</b>');

      if ($remove_status) {
        $contents[] = array(
            'align' => 'center', 
            'text' => yes_draw_href_button(IMAGE_DELETE,'','width: 200px;','submit','ui-state-button ui-corner-all ui-state-error') 
                .'<br />'
                . yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_CUSTOMERS_STATUS, 
                    xtc_get_all_get_params(['action','cID']).'&cID=' . $cInfo->customers_status_id),
                    'width:200px;','button'
                )
        );
      }
      break;

    default:
      if (is_object($cInfo)) {
        $heading[] = array('text' => $cInfo->customers_status_name);
	    if($cInfo->customers_status_id == '0' and $_SESSION['customer_id'] != 1){
	        $contents[] = array('align' => 'center', 'text' => TEXT_ERROR_ONLY_ADMIN_CAN_CHANGE );
	    }else{
            $num_customers_query = xtc_db_query(sprintf(
                    "SELECT COUNT(customers_id) AS anz FROM %s WHERE customers_status='%d'",
                    TABLE_CUSTOMERS,$cInfo->customers_status_id
            ));
            $num_customers = xtc_db_fetch_array($num_customers_query);
    	    $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
                IMAGE_EDIT,
                xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&cID=' . $cInfo->customers_status_id . '&action=edit'),
                'width:120px;','button')
            );
            $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
                sprintf(SHOW_CUSTOMERS_GROUP_CUSTOMERS,$num_customers['anz']),
                xtc_href_link(FILENAME_CUSTOMERS, 'status=' . $cInfo->customers_status_id),
                'width:120px;')
	    );
            $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
                IMAGE_DELETE,
                xtc_href_link(FILENAME_CUSTOMERS_STATUS, 'page=' . $_GET['page'] . '&cID=' . $cInfo->customers_status_id . '&action=delete'),
                'width:120px;')
	    );
	    
      }
        $customers_status_inputs_string = '';
        $languages = xtc_get_languages();
        for ($i=0; $i<sizeof($languages); $i++) {
          $customers_status_inputs_string .= '<br />' . xtc_image(DIR_WS_CATALOG.'lang/'. $languages[$i]['directory'] . '/admin/images/' . $languages[$i]['image'], $languages[$i]['name']) . '&nbsp;' . xtc_get_customers_status_name($cInfo->customers_status_id, $languages[$i]['id']);
        }
        $contents[] = array('text' => $customers_status_inputs_string);
        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE_INTRO . '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_PRICE . ' ' . $cInfo->customers_status_discount . '%');
        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_OT_XMEMBER_INTRO . '<br />' . ENTRY_OT_XMEMBER . ' ' . $customers_status_ot_discount_flag_array[$cInfo->customers_status_ot_discount_flag]['text'] . ' (' . $cInfo->customers_status_ot_discount_flag . ')' . ' - ' . $cInfo->customers_status_ot_discount . '%');
        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_GRADUATED_PRICES_INTRO . '<br />' . ENTRY_GRADUATED_PRICES . ' ' . $customers_status_graduated_prices_array[$cInfo->customers_status_graduated_prices]['text'] . ' (' . $cInfo->customers_status_graduated_prices . ')' );
//        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_DISCOUNT_ATTRIBUTES . ' ' . $customers_status_discount_attributes_array[$cInfo->customers_status_discount_attributes]['text'] . ' (' . $cInfo->customers_status_discount_attributes . ')' );
        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PAYMENT_UNALLOWED_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PAYMENT_UNALLOWED . ':<b> ' . $cInfo->customers_status_payment_unallowed.'</b>');
        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_SHIPPING_UNALLOWED_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_SHIPPING_UNALLOWED . ':<b> ' . $cInfo->customers_status_shipping_unallowed.'</b>');
        $contents[] = array('text' => '<br />' . TEXT_INFO_CUSTOMERS_STATUS_PAYMENT_TARGET_INTRO . '<br />' . ENTRY_CUSTOMERS_STATUS_PAYMENT_TARGET . ':<b> ' . (int)$cInfo->customers_status_payment_target.'</b>');
        $contents[] = array('text'=>'<br /><b>'.TABLE_HEADING_SORT_ORDER.':</b> '.$cInfo->sort_order);
      }
      break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    $box = new box;
    $smarty->assign('BOX',$box->infoBox($heading, $contents));
}


$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$menus,
    'TABLE_HEADING_CUSTOMERS_STATUS'=>TABLE_HEADING_CUSTOMERS_STATUS,
    'TABLE_HEADING_TAX_PRICE'=>TABLE_HEADING_TAX_PRICE,
    'TABLE_HEADING_DISCOUNT'=>TABLE_HEADING_DISCOUNT,
    'TABLE_HEADING_CUSTOMERS_GRADUATED'=>TABLE_HEADING_CUSTOMERS_GRADUATED,
    'TABLE_HEADING_CUSTOMERS_UNALLOW'=>TABLE_HEADING_CUSTOMERS_UNALLOW,
    'TABLE_HEADING_CUSTOMERS_UNALLOW_SHIPPING'=>TABLE_HEADING_CUSTOMERS_UNALLOW_SHIPPING,
    'TABLE_HEADING_ACTION'=>TABLE_HEADING_ACTION,
    'SPLIT1'=>$customers_status_split->display_count($customers_status_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_CUSTOMERS_STATUS),
    'SPLIT2'=>$customers_status_split->display_links($customers_status_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page']),
    'items'=>$items,
    'TABLE_HEADING_SORT_ORDER'=>TABLE_HEADING_SORT_ORDER
));
$smarty->display('customers_status.html');
?>
<script type="text/javascript">
<!--
var default_csid = '<?php echo (isset($cInfo) and is_object($cInfo) and isset($cInfo->customers_status_id)) ? $cInfo->customers_status_id : 0; ?>';
//-->
</script>

<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
