<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require('includes/classes/distributor_invoice.php');
require(DIR_FS_INC.'xtc_get_distributor_invoice_status_name.inc.php');

$admin_access = main::get_admin_access();

$smarty = new yesSmarty;
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'new':
    case 'edit':
        echo '<div class="main">';
        if($action == 'edit'){
            $dirID = (int)xtc_db_input($_GET['dirID']);
            $item = \YES4Trade\Model\distributor_invoices_reasons::get_by_distributor_invoices_reasons_id($dirID);
            printf('<b>%s: %d</b><br />',DIR_ID,$_GET['dirID']);
        }else{
            $item = null;
        }
        if($item !== null){
            $title = $item->title;
            $konto = $item->konto;
        }else{
            $title = '';
            $konto = '';
        }
        if($action == 'edit'){
            echo xtc_draw_form('dir_edit_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=save','POST');
        }else{
            echo xtc_draw_form('dir_insert_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=insert','POST');
        }
        printf('<label for="title">%s<br /></label>%s<br />',
                DIR_TITLE,
                xtc_draw_input_field('title',$title,'id="title"')
        );
        printf('<label for="konto">%s<br /></label>%s<br />',
                DIR_KONTO,
                xtc_draw_input_field('konto',$konto,'id="konto"')
        );
        printf('<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" /></form></div>', IMAGE_SAVE);
        exit;
        break;
    case 'insert':
    case 'save':
        if(isset($_GET['dirID'])){
            $dirID = (int)xtc_db_prepare_input( $_GET['dirID'] );
        }else{
            $dirID = null;
        }
        if ($_GET['action'] == 'insert') {
            $new = new \YES4Trade\Model\distributor_invoices_reasons([
                'title'=>xtc_db_input($_POST['title']),
                'konto'=>xtc_db_input($_POST['konto']),
            ]);
            $new->create();
        } elseif ($_GET['action'] == 'save') {
            $update = new \YES4Trade\Model\distributor_invoices_reasons([
                'distributor_invoices_reasons_id'=>$dirID,
                'title'=>xtc_db_input($_POST['title']),
                'konto'=>xtc_db_input($_POST['konto']),
            ]);
            $update->update();
        }
        $messageStack->add_session(MSG_SUCCESS_DIR_SAVED,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'delete':
        $dirID = (int)xtc_db_prepare_input($_GET['dirID']);
        \YES4Trade\Model\distributor_invoices_reasons::delete($dirID);
        $messageStack->add_session(MSG_SUCCESS_DIR_DELETED,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();
$buttons[] = array('text'=>IMAGE_INSERT,
    'link'=>xtc_href_link(basename(__FILE__), 'action=new'),
    'lbOn'=>true,
    'auth'=>true
);

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$contents = [[
    ['text'=>DIR_ID,'th'=>true],
    ['text'=>DIR_TITLE,'th'=>true],
    ['text'=>DIR_KONTO,'th'=>true],
    ['text'=>'&nbsp;','th'=>true],
]];
$items = \YES4Trade\Model\distributor_invoices_reasons::get_all();
foreach($items as $it){
    $links = [
        sprintf('<a title="%s" class="dir_edit" href="javascript:;" data-distributorinvoicesreasonsid="%d">%s</a>',
            IMAGE_EDIT,
            $it->distributor_invoices_reasons_id,
            smarty_function_icon(['type'=>'edit','title'=>IMAGE_EDIT], $smarty)
        ),
        sprintf('<a title="%s" class="dir_delete" href="javascript:;" data-distributorinvoicesreasonsid="%d">%s</a>',
            IMAGE_DELETE,
            $it->distributor_invoices_reasons_id,
            smarty_function_icon(['type'=>'delete','title'=>IMAGE_DELETE], $smarty)
        ),
    ];
    $contents[] = [
        ['text'=>$it->distributor_invoices_reasons_id],
        ['text'=>$it->title],
        ['text'=>$it->konto],
        ['text'=>implode('&nbsp;',$links)],
    ];
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TABLE'=>$table->tableBlock_draw($contents),
    'REALLY_DELETE_DIR'=>REALLY_DELETE_DIR,
));
$smarty->display('distributor_invoices_reasons.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
