<?php
// ITEMS = REAL KATALOG
// PRODUCTS = ZUGEWIESENE ITEMS ZU EINEM SELLER (MIT PREIS ETC)
include('includes/application_top.php');

define('KAUFLAND_PUSH_EVENTS',[
    'order_new' => 'This event is triggered once each time a customer places an order which includes one or more of your products. If a customer buys 5 products from you in a single order, only 1 order_new event notification will be sent.',
    'order_unit_new' => 'This event is triggered each time one of your units is ordered. If a customer buys 5 products from you in a single order, 5 separate order_unit_new notifications will be sent.',
    'order_unit_status_changed' => 'This event is triggered each time when the status of one of your units has been changed.',
    'item_changed' => 'This event is triggered each time when a product has changed.',
    'category_changed' => 'This event is triggered each time a category has changed.',
    'return_new' => 'This event is triggered each time a customer starts a return process.',
    'return_status_changed' => 'This event is triggered each time when the status of a customer return has been changed.',
    'return_unit_status_changed' => 'This event is triggered each time when the status of a customer return unit has been changed.',
    'item_unit_new' => 'This event is triggered each time when a new unit for a given Product has been created. Information about the unit will be sent in the field payload.',
    'item_unit_changed' => 'This event is triggered each time when one of the adjustable properties of a unit has been changed. Information about the unit will be sent in the field payload.',
    'item_unit_deleted' => 'This event is triggered each time when a has been deleted and cannot be sold anymore. Information about the unit will be sent in the field payload.',
    'item_unit_out_of_stock' => 'This event is triggered each time when a unit is out of stock (amount = 0). Information about the unit will be sent in the field payload.',
    'item_unit_not_available' => 'This event is triggered each time when a unit is set from available to onhold, which prevents it from being sold until it is set to available again. Information about the unit will be sent in the field payload.',
    'item_unit_available' => 'This event is triggered each time when a unit is set from onhold to available, so it can be sold again. Information about the unit will be sent in the field payload.'
]);

require_once(DIR_WS_CLASSES.'yes_hitmeister.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once('includes/classes/class.ebaymail.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_CATALOG.'includes/classes/xtcPrice.php');
require_once(DIR_WS_CLASSES.'split_page_results_array.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_oe_customer_infos.inc.php');
require_once(DIR_FS_INC.'yes_end_auction_add.inc.php');
// HISTORY_ORDER_EMAIL, TEXT_ORDER_EMAIL_SUBJECT
require_once(DIR_FS_CATALOG.'lang/german/admin/orders.php');
require_once(DIR_FS_INC.'xtc_get_orders_ebay_seller.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_generate_packingslip_barcode.inc.php');

// NUR BEI CRONJOBS
//require_once(DIR_FS_CATALOG.'lang/german/admin/german.php');
require_once(DIR_FS_INC.'xtc_get_order_html_for_pdf.inc.php');

define('MODULE_OTHER_YES_HITMEISTER_HANDLING_TIME',3);



$YH = new yes_hitmeister();
$client = $YH->client;
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');


define('HITMEISTER_ATTRIBUTES_TEXTAREA_ROWS',3);
define('HITMEISTER_ATTRIBUTES_TEXTAREA_COLS',40);
define('HITMEISTER_ATTRIBUTES_SHORTTEXT_MAXLENGTH',512);
define('HITMEISTER_ATTRIBUTES_SMALLTEXT_MAXLENGTH',1024);
define('HITMEISTER_ATTRIBUTES_PICTURE_INPUT_SIZE', 60);
define('HITMEISTER_ATTRIBUTES_TINYTEXT_SIZE',40);
define('HITMEISTER_ATTRIBUTES_TINYTEXT_MAXLENGTH',255);
define('HITMEISTER_ATTRIBUTES_SI_SIZE',16);
define('HITMEISTER_ATTRIBUTES_SI_MAXLENGTH',16);
// DEFAULT
define('HITMEISTER_ATTRIBUTES_TEXT_INPUT_SIZE',16);
define('HITMEISTER_ATTRIBUTES_TEXT_INPUT_MAXLENGTH',16);

/**
    GENERAL ATTRIBUTES::

    ean The EAN(s) of the item. Generally there is only one EAN per item, but some have multiples.
    title The title or name of the item.
    description A detailed description of the item. This field can contain HTML.
    short_description A short description of the item. This field should not contain HTML.
    picture One or more pictures.
    list_price The manufacturer's suggested retail price (MSRP) of the item.
    category The name of the category the item is in.
    mpn The manufacturer part number of the item.

*/

/**
item = IM KATALOG VON REAL
unit = EINEM SELLER ZUGEWIESEN
*/
$action = $_GET['action']??'';

if(isset($_GET['term']) and $_GET['term'] != ''){
	$term = trim($_GET['term']);
	if(strlen($term)<3){
		die(json_encode(array(
			'ERROR'=>HITMEISTER_SEARCH_MIN_LENGTH
		)));
	}
        $json_decode = false;
	if(isset($_GET['ean'])){
		//$items = array($client->items()->findByEan($_GET['term']));
                $res = json_decode($YH->items_find_by_ean($_GET['term']));
                if(isset($res->data->main_picture)){
                    $items = [$res->data];
                }else{
                    $items = $res->data;
                }
	}else{
		$res = json_decode($YH->items_find($_GET['term']));
                $items = $res->data;
	}
	$res = array();
	foreach($items as $item){
		$res[] = array(
			'id'=>$item->id_product,
			'text'=>$item->title,
			'eans'=>$item->eans,
			'image'=>$item->main_picture,
			'manufacturer'=>$item->manufacturer,
			//'real_mgb_article_number'=>$item->real_mgb_article_number
		);
	}
	die(json_encode(array(
		'ERROR'=>'',
		'res'=>$res
	)));
}

function crawl_seller_units($start = 0, &$units = []){
    global $YH;
    $limit = 1;
    $res = json_decode($YH->get_seller_units($start,$limit));
    $seller_units = $res->data;
    foreach($seller_units as $item){
        $units[] = array(
            'id_unit'=>"".$item->id_unit,
            'id_product'=>"".$item->id_product,
            'amount'=>0+$item->amount,
            'id_offer'=>"".$item->id_offer, // pid
        );
    }
    $total = $res->pagination->total;
    if($start+$limit < $total){
        crawl_seller_units($start+$limit, $units);
    }
}

switch($action){
    case 'unallocate_product':
        $default_value = '';
        if(isset($_GET['unallocate_products_id']) and (int)$_GET['unallocate_products_id'] > 0){
            $default_value = $_GET['unallocate_products_id'];
        }
        if(isset($_GET['process']) and $_GET['process'] == 1){
            if(!yes_hitmeister::is_hitmeister_product($default_value)){
                die(json_encode([
                    'MSG'=>PRODUCT_IS_NOT_ALLOCATED,
                    'SUCCESS'=>false
                ]));
            }
            xtc_db_query(sprintf(
                    "DELETE FROM hitmeister_products WHERE products_id='%d'",
                    $default_value
            ));
            xtc_db_perform('products_history',[
                'products_id'=>$default_value,
                'editor_id'=>$_SESSION['customer_id'],
                'date_saved'=>'now()',
                'comments'=>PRODUCTS_HISTORY_UNALLOCATE
            ]);
            die(json_encode([
                'MSG'=>sprintf(MSG_SUCCESS_PRODUCT_ALLOCATION_DELETED, $default_value),
                'SUCCESS'=>true
            ]));
        }
        printf('<div class="main"><p>%s</p>pID %s<input type="button" name="unallocate_products_submit" onclick="hitmeister_unallocate_product(\'unallocate_products_id\')" value="%s" class="ui-button-ui-corner-all ui-state-default" style="padding: 4px; " />',
                HITMEISTER_UNALLOCATE_PRODUCT_INTRO,
                xtc_draw_input_field('unallocate_products_id', $default_value,'size="5" maxlength="7"'),
                IMAGE_DELETE
        );
        exit;
    case 'update_subscriptions':
        $str = '';
        $params = explode(';',$_GET['params']);
        $res = json_decode($YH->get_subscriptions());
        foreach($params as $p){
            $keyval = explode(':',$p);
            $exist = false;
            $event_id = '';
            foreach($res->data as $s){
                if( $s->event_name == $keyval[0] ){
                    $exist = true;
                    $event_id = $s->id_subscription;
                }
            }
            if( $keyval[1] == 1){
                $res = $YH->subscribe( $keyval[0] );
            }else{
                if( $exist ) {
                    $res = $YH->unsubscribe( $event_id );
                }
            }
        }
        die(json_encode([
            'MSG'=>print_r($res,true)
        ]));
        break;
    case 'subscriptions':
        // PUSH CONFIG
        // GET https://sellerapi.kaufland.com/v2/subscriptions 
        $res = json_decode($YH->get_subscriptions());
        echo TEXT_HITMEISTER_SUBSCRIPTIONS;
        echo '<ul id="subscriptions">';
        foreach(KAUFLAND_PUSH_EVENTS as $kev=>$desc){
            $checked = false;
            foreach($res->data as $s){
                if($s->event_name == $kev){
                    $checked = $s->is_active == 1;
                }
            }
            echo '<li title="'.$desc.'"><input type="checkbox" name="subscriptions[]" value="'.$kev.'" '.(($checked)?' checked="checked"' : '').'/>'.$kev.'</li>';
        }
        echo '</ul>';
        echo '<button class="ui-button ui-state-default" onclick="hitmeister_update_subscriptions()">'.IMAGE_UPDATE.'</button>';
        exit;
        break;
    case 'delete_order_invoice':
        $id_order = $_GET['id_order'];
        $id_invoice = $_GET['id_invoice'];
        try{
            $res = json_decode( $YH->delete_order_invoice($id_order, $id_invoice));
        }catch( Exception $e ){
            die(json_encode(array(
                'MSG'=>sprintf('Fehler delete invoice: '.$e->getMessage())
            )));
        }
        xtc_db_query(sprintf(
                "UPDATE hitmeister_orders SET invoice_upload='0' WHERE hitmeister_id_order='%s'",
                $id_order
        ));
        $oID = yes_hitmeister::hitmeister_get_yes_orders_id_from_id_order($id_order);
        $comments = sprintf(DELETE_ORDER_INVOICE_HISTORY_ORDER, $id_order, $id_invoice);
        $order = new order( $oID );
        $order->add_history($order->info['orders_status'], false, $comments);
        
        die(json_encode(array(
            'MSG'=>sprintf(MSG_DELETE_ORDER_INVOICE_SUCCESS,$id_order, $id_invoice)
        )));
        break;
    case 'order_invoices':
        $id_order = $_GET['id_order'];
        $res = json_decode( $YH->get_order_invoices($id_order) );
        if($res->pagination->total < 1){
            die('<p>'.ORDER_INVOICE_NO_DATA.'</p>');
        }
        $html = '<ul class="uploaded-order-invoices">';
        $treffer = 0;
        for($i=0;$i<$res->pagination->total;$i++){
            if( $res->data->data[$i]->id_order != $id_order ){
                continue;
            }
            $treffer++;
            $html .= sprintf('<li title="%s" id="%s"><a target="_blank" href="%s">%s</a> #%s vom %s <a href="javascript:;" onclick="delete_order_invoice(\'%s\',\'%s\')"><img src="images/basicons/delete82.png" width="20" alt="Delete" title="Delete" /></a></li>',
                    TEXT_SHOW_UPLOADED_INVOICES.' ('.$res->data->data[$i]->mime_type.')',
                    $res->data->data[$i]->id_invoice,
                    $res->data->data[$i]->url,
                    $res->data->data[$i]->original_name,
                    $res->data->data[$i]->id_invoice,
                    xtc_date_short($res->data->data[$i]->ts_created_iso),
                    $id_order,
                    $res->data->data[$i]->id_invoice
            );
        }
        $html .= '</ul>';
        if($treffer > 0){
            echo $html;
        }else{
            die('<p>'.ORDER_INVOICE_NO_DATA.'</p>');
        }
        exit;
        break;
    case 'activate_unit':
        $id_unit = $_GET['id_unit'];
        $unit_data = [
            'status' => 'AVAILABLE',
            'amount' => 1,
        ];
        $res = json_decode( $YH->units_update( $id_unit, $unit_data ));
        $pID = yes_hitmeister::get_products_id_from_id_unit($id_unit);
        yes_hitmeister::update_local_quantity(
            $pID,
            1
        );
        $com = "Kaufland - Status manually set to AVAILABLE with amount 1";
        product::add_history_static(intval($pID), $com);
        $messageStack->add_session(MSG_SUCCESS_ACTIVATE_UNIT,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__),'tab=hitmeister-products-menu'));
        break;
    case 'set_send':
		$oID = (int)xtc_db_input($_GET['orders_id']);
		$order = new order($oID);
		$query = xtc_db_query(sprintf(
		        "SELECT hitmeister_orders_id FROM hitmeister_orders WHERE orders_id='%d'",
		        $oID
		));
		$hou_num = xtc_db_num_rows($query);
		if($hou_num == 1){
		    $record = xtc_db_fetch_array($query);
		    xtc_db_query(sprintf(
		            "UPDATE hitmeister_orders_units SET fulfillment_sent=1 WHERE hitmeister_orders_id='%d'",
		            $record['hitmeister_orders_id']
		    ));
		}else{
		    $messageStack->add_session('Zur orders_id '.$orders_id.' gibt es '.$hou_num.' Eintraege','error');
		}
		/** WIRD IN hitmeister_orders_units GESETZT - 07/2022
		xtc_db_query(sprintf(
		        "UPDATE hitmeister_orders SET fulfillment_sent=1 WHERE orders_id='%d'",
		        $orders_id
		));
                 * 
                 */
		$order->add_history($order->info['orders_status'], false, "Lokaler Kaufland Versandstatus manuell auf versendet gesetzt.");
		
		xtc_redirect(xtc_href_link(basename(__FILE__),'action=fulfillment'));
		break;
    case 'fulfillment':
    case 'fulfillment_process':
            require_once('hitmeister.fulfillment.php');
            break;
    case 'view_order_import_logfile':
        $import_order_logfile = main::get_secure_path().yes_hitmeister::ORDER_IMPORT_STATUS_LOGFILE_NAME;
        printf("<b>Import Logfile %s</b><p><pre>%s</pre></p>",
                date('d.m.Y H:i:s',filemtime($import_order_logfile)),
                file_get_contents($import_order_logfile)
        );
        exit;
        break;
    case 'edit_local_quantity':
        $qty = (int)$_GET['qty'];
        $id_item = $_GET['id_item'];
        $pID = yes_hitmeister::get_products_id_from_id_item($id_item);
        $id_unit = yes_hitmeister::get_id_unit_from_products_id($pID);
        echo '<div class="main">';
        if($pID > 0){
            $SQ = new products_quantity($pID);
            $p = new product($pID);
            printf('<b>pID %d</b><br />&raquo;%s&laquo;<br />',
                    $pID,$p->info['products_name']
            );
            printf('<div style="margin-bottom: 5px; padding: 3px;" class="ui-widget-content">AV1: %d / AV2: %d</div>',
                    $SQ->get_available1_qty(),
                    $SQ->get_available2_qty()
            );
        }
        echo xtc_draw_input_field('qty',$qty,'size="5" maxlength="7" id="hitmeister_product_qty_update"');
        printf('<input type="button" onclick="update_hitmeister_product_qty(\'%s\')" value="%s" class="ui-button ui-corner-all ui-state-default" />',
                /* FALSCH $id_item*/
                $id_unit, IMAGE_UPDATE
        );
        echo '</div>';
        exit;
        break;
    case 'sync_quantity_confirm':
        printf('<p>%s</p>%s&nbsp;%s',TEXT_SYNC_QUANTITY_INTRO,
            yes_draw_href_button(IMAGE_UPDATE, xtc_href_link(basename(__FILE__),'action=sync_quantity'), 'width: 150px;','button','ui-state-default'),
            yes_draw_href_button(IMAGE_CANCEL, 'javascript: $(\'#modal_window\').dialog(\'destroy\')', 'width: 150px;','button','ui-state-error')
        );
        exit;
        break;
    case 'sync_quantity':
        $units = [];
        crawl_seller_units(0, $units);
        $synced = 0;
        foreach($units as $unit){
            $products_id = yes_hitmeister::get_products_id_from_id_item($unit['id_product']);
            if($products_id < 1){
                continue;
            }
            yes_hitmeister::update_local_quantity($products_id, $unit['amount']);
            $synced++;
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_HITMEISTER_QUANTITY_SYNC, $synced),'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        exit;
        break;
    case 'download_import_file':
        $file = yes_hitmeister::SAVE_DIR.DIRECTORY_SEPARATOR.$_GET['file'];
        if(!is_file($file)){
            $messageStack->add_session('No valid file','error');
            xtc_redirect(xtc_href_link(basename(__FILE__)).'#hitmeister-products-menu');
        }
        header('Content-Description: File Transfer');
        header('Content-Type: application/force-download');
        header('Content-Disposition: attachment; filename='.basename($file));
        echo file_get_contents($file);
        exit;
        break;
    case 'import_order':
            $orders_id = $YH->import_order($_GET['id']);
            die(json_encode(array(
                'MSG'=>'',
                'orders_id'=>$orders_id
            )));
            break;
    case 'allocate':
            $pID = (int)xtc_db_input($_GET['pID']);
            
            $id_item = xtc_db_input($_GET['id_item']);
            $id_unit = xtc_db_input($_GET['id_unit']);
            $allocation_exists = false;
            if($pID < 1 or $id_item == '' or $id_unit == ''){
                die(json_encode(array(
                    'MSG'=>HITMEISTER_ALLOCATION_ERROR_MISSING_PARAMS
                )));
            }
            // DA WIR DIE QUANTITY BRAUCHEN, STARTEN WIR EINEN CALL UM DEN
            // AKTUELLEN BESTAND ZU KRIEGEN
            $res = json_decode($YH->get_unit($id_unit));
            $unit = $res->data;
            if(strtoupper(gettype($unit)) == 'NULL'){
                die(json_encode(array(
                    'MSG'=>HITMEISTER_ALLOCATION_ERROR_INVALID_ITEM_ID
                )));
            }
            $quantity = $unit->amount;
            $yes_products_id = yes_hitmeister::get_products_id_from_id_item($id_item);
            if($yes_products_id > 0){
                if($yes_products_id == $pID){
                    die(json_encode(array(
                        'MSG'=>HITMEISTER_ALLOCATION_ERROR_NO_CHANGE_NECCESSARY
                    )));
                }
                $allocation_exists = true;
            }
            $query = xtc_db_query(sprintf(
                    "SELECT products_id FROM %s WHERE products_id='%d'",
                    TABLE_PRODUCTS, $pID
            ));
            if(!xtc_db_num_rows($query)){
                die(json_encode(array(
                    'MSG'=>HITMEISTER_ALLOCATION_ERROR_INVALID_PRODUCTS_ID
                )));
            }
            $query = xtc_db_query(sprintf(
                    "SELECT hitmeister_products_id FROM hitmeister_products WHERE products_id='%d'",
                    $pID
            ));
            if(xtc_db_num_rows($query)){
                die(json_encode(array(
                    'MSG'=>HITMEISTER_ALLOCATION_ERROR_ALLOCATION_EXISTS
                )));
            }
            if($allocation_exists){
                $update_sql_array = array(
                    'products_id'=>$pID,
                    'quantity'=>$quantity
                );
                xtc_db_perform('hitmeister_products',$update_sql_array,'update',"hitmeister_id_item='".$id_item."'");
            }else{
                $insert_sql_array = array(
                    'quantity'=>$quantity,
                    'products_id'=>$pID,
                    'hitmeister_id_item'=>$id_item,
                    'id_unit'=>$id_unit
                );
                xtc_db_perform('hitmeister_products',$insert_sql_array);
            }
            $product = new product($pID);
            $product->add_history(sprintf(HITMEISTER_ITEM_ALLOCATION,$id_item));
            die(json_encode(array(
                'MSG'=>''
            )));
            break;
        case 'update_pid_allocation':
            $id_item = $_GET['id_item'];
            $id_unit = $_GET['id_unit'];
            $product_exists = false;
            if($id_item != ''){
                
                $query = xtc_db_query(sprintf(
                        "SELECT products_id FROM hitmeister_products WHERE hitmeister_id_item='%s'",
                        $id_item
                ));
                if(xtc_db_num_rows($query)){
                    $record = xtc_db_fetch_array($query);
                    $query = xtc_db_query(sprintf(
                            "SELECT products_id FROM %s WHERE products_id='%s'",
                            TABLE_PRODUCTS, $record['products_id']
                    ));
                    $product_exists = xtc_db_num_rows($query);
                }
            }
            $res = json_decode($YH->get_unit($id_unit,array('products')));
            $unit = $res->data;
            $smarty->assign(array(
                'PRODUCTS_ID'=>smarty_function_hitmeister_allocated_products_id(array('id'=>$unit->id_product), $smarty),
               'ACTION'=>$action,
                'EXISTS'=>$product_exists,
                'HITMEISTER_INFO'=>$unit,
                'ID_ITEM'=>$id_item,
                'ID_UNIT'=>$id_unit,
                'FORM'=>xtc_draw_form('allocate_search',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=allocate_products_id'),
                'FORM_END'=>'</form>',
            ));
            $smarty->display('hitmeister.tpl');
            exit;
            break;
        case 'close_ticket':
            $id = $_GET['id'];
            try{
                $messageStack->add_session('Ticket '.$id.' closed','success');
                $res = $YH->ticket_close($id);
            }catch(Exception $e){
                $messageStack->add_session($e->getMessage(),'error');
            }
            xtc_redirect(xtc_href_link(basename(__FILE__)));
            break;
        case 'ticket_reply':
            $message = $_GET['message'];
            $id = $_GET['id'];
            $msg = '';
            try{
                $res = $YH->ticket_post($id, $message);
            }catch(Exception $e){
                $msg = $e->getMessage()."\r\nID: ".$id."\r\nMessage: ".$message;
            }
            die(json_encode(array(
                'MSG'=>$msg
            )));
            break;
        case 'get_ticket_details':
            $id = $_GET['id'];
            $res = json_decode($YH->get_tickets($id));
            $ticket = $res->data;
            $smarty->assign(array(
                'TICKET'=>$ticket,
                'ACTION'=>'ticket_details'
            ));
            $smarty->display('hitmeister.tpl');
            exit;
            break;
	case 'invoice_upload':
		$id_order = $_GET['id_order'];
		$orders_id = $_GET['orders_id'];
		if(empty($id_order) or empty($orders_id)){
			die(json_encode(array(
				'ERROR'=>'Missing params',
				'MSG'=>''
			)));
		}

		$order = new order($orders_id);
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
		$pdf_smarty = new yesSmarty;
		$pdf_order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
		// FUEGE ORDER AN GESAMTPDF AN
		$pdf_file = \main::get_exportdata_path().'HITMEISTER_INVOICE_ORDER_'.$InvoiceNumber.'.pdf';
		if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
		    $headerandfooter=(strstr(HTTP_SERVER,'localhost')) ? true : false;
		    $pdf = new yes_pdf($headerandfooter);
		    if(DOMPDF_ORDER_LANDSCAPE == 'True'){
			$pdf->set_landscape();
		    }
		    $pdf->set_html($pdf_order_html);
		    $pdf->save($pdf_file);
		}else{
		    $order_pdf=new HTML2FPDF();
		    $order_pdf->AddPage();
		    $order_pdf->WriteHTML($pdf_order_html);
		    $order_pdf->Output($pdf_file,'F'); //Read the FPDF.org manual to know the other options
		}
		$PDF_BIN = file_get_contents($pdf_file);
		unlink($pdf_file);
		$basics = new basics;
		$parts = parse_url(HTTP_SERVER);
		$fn = $basics->get_valid_filename_from_string($parts['host'].'_'.TEXT_ORDER.'_'.$orders_id).'.pdf';
                $response = json_decode($YH->order_invoice_upload($id_order,$fn,base64_encode($PDF_BIN)));
                $msg = 'Error, cant upload PDF';
		if(isset($response->data->id_invoice)){
			$update_sql_array = array(
				'invoice_upload'=>1
			);
			xtc_db_perform('hitmeister_orders',$update_sql_array,'update',"orders_id='".$orders_id."' and hitmeister_id_order='".$id_order."'");
                        $msg = 'Order Invoice '.$response->data->id_invoice.' created.';
		}
		die(json_encode(array(
			'ERROR'=>'',
			'MSG'=>$msg
		)));
		break;
	case 'delete_unit':
            $msg = '';
            if(!isset($_GET['id']) or empty($_GET['id'])){
                die(json_encode(array(
                        'MSG'=>'Error: Cant delete unit - missing parameter'
                )));
            }
            try{
                $res = json_decode($YH->get_unit($_GET['id']));
                $info = $res->data;
                if(isset($info->id_product)){
                    $res = json_decode( $YH->delete_unit($_GET['id']));
                    yes_hitmeister::delete_hitmeister_product_allocation($info->id_product);
                }
            }catch(Exception $ex){
                $msg = 'Error: '.$ex->getMessage();
            }
            die(json_encode(array(
                    'MSG'=>$msg
            )));
            break;
	case 'unit_update_process':
		$part = $_GET['part'];
		$id_unit = $_GET['id_unit'];
                $res = json_decode($YH->get_unit( $id_unit ));
                $unit = $res->data;
		if($unit === false){
			die(json_encode(array(
				'MSG'=>'Unkown Unit',
				'PART'=>$part,
				'ID_UNIT'=>$id_unit,
				'VALUE'=>0
			)));
		}
		$unit_data = array(
			'listing_price'=>$unit->price,
			"amount"=> $unit->amount,
/*			"note"=> $unit->note,
			"location"=> $unit->location,
			"delivery_time"=> $unit->delivery_time,
			"warehouse"=> $unit->warehouse,
			"shipping_group"=> $unit->shipping_group // FREI DEFINIERBAR
*/
		);
		if(isset($unit->minimum_price) and $unit->minimum_price <> $unit->price){
			$unit_data["minimum_price"] = $unit->minimum_price;
		}
		$return_json_val = $_GET[$part];
		switch($part){
			case 'listing_price':
			case 'minimum_price':
			case 'shipping_rate':
				$value = (float)str_replace(',','.',$_GET[$part]);
				$value = (int)($value * 100);
				break;
			case 'amount':
				$value = (int)$_GET[$part];
				break;
			case 'location':
			case 'note':
				$value = $_GET[$part];
				break;
			case 'delivery_time':
				$value = $_GET[$part];
				foreach(yes_hitmeister::hitmeister_delivery_times() as $dt){
					if($dt['id'] == $value){
						$return_json_val = $dt['text'];
					}
				}
				break;
		}
		$unit_data[$part] = $value;
		try{
                        $res = json_decode($YH->units_update( $id_unit, $unit_data));
                        $update = $res->data;
			$msg = (isset($update->status)) ? '' : 'Update fehlgeschlagen';
                        if($msg == '' and $part == 'amount'){
                            yes_hitmeister::update_local_quantity(
                                yes_hitmeister::get_products_id_from_id_item($update->id_product),
                                $value
                            );
                        }
		}catch(Exception $e){
			$msg = $e->getMessage();
		}
		die(json_encode(array(
			'MSG'=>$msg,
			'PART'=>$part,
			'ID_UNIT'=>$id_unit,
			'VALUE'=>$return_json_val
		)));
		break;
	case 'unit_update':
		$part = $_GET['part'];
		$id_unit = $_GET['id_unit'];
                $res = json_decode($YH->get_unit( $id_unit ));
                $unit = $res->data;
		switch($part){
			case 'condition':
				$prm = array(
					'type'=>'select',
					'name'=>$part,
					'original_value'=>$unit->$part,
					'title'=>HITMEISTER_CONDITION,
					'options'=>yes_hitmeister::hitmeister_conditions()
				);
				break;
			case 'delivery_time':
				$prm = array(
					'type'=>'select',
					'name'=>$part,
					'original_value'=>$unit->$part,
					'title'=>HITMEISTER_OFFER_SHIPPINGTIME,
					'options'=>yes_hitmeister::hitmeister_delivery_times()
				);
				break;
			case 'location':
				$prm = array(
					'type'=>'text',
					'name'=>$part,
					'original_value'=>$unit->$part,
					'title'=>HITMEISTER_LOCATION,
					'size'=>2,
					'maxlength'=>2
				);
				break;
			case 'amount':
				$prm = array(
					'type'=>'text',
					'name'=>$part,
					'original_value'=>$unit->$part,
					'title'=>HITMEISTER_OFFER_QUANTITY
				);
				break;
			case 'shipping_rate':
				$prm = array(
					'type'=>'text',
					'name'=>$part,
					'original_value'=>number_format(($unit->$part/100),2,',',''),
					'title'=>HITMEISTER_OFFER_SHIPPING_PRICE
				);
				break;
			case 'listing_price':
				$prm = array(
					'type'=>'text',
					'name'=>$part,
					'original_value'=>number_format(($unit->price/100),2,',',''),
					'title'=>HITMEISTER_PRICE
				);
				break;
			case 'minimum_price':
				$prc = (isset($unit->$part)) ? $unit->$part : $unit->price;
				$prm = array(
					'type'=>'text',
					'name'=>$part,
					'original_value'=>number_format(($prc/100),2,',',''),
					'title'=>HITMEISTER_MINIMUM_PRICE
				);
				break;
			case 'note':
				$prm = array(
					'type'=>'textarea',
					'name'=>$part,
					'original_value'=>$unit->$part,
					'title'=>HITMEISTER_OFFER_NOTE
				);
				break;
		}
		switch($prm['type']){
			case 'text':
				$prm['input'] = '<input type="text" name="'.$part.'" value="'.$prm['original_value'].'"';
				if(isset($prm['size'])){
					$prm['input']  .= ' size="'.$prm['size'].'"';
				}
				if(isset($prm['maxlength'])){
					$prm['input'] .= ' maxlength="'.$prm['maxlength'].'"';
				}
				$prm['input'] .= ' />';
				break;
			case 'textarea':
				$prm['input'] = '<textarea name="'.$part.'" cols="35" rows="3">'.$prm['original_value'].'</textarea>';
				break;
			case 'select':
				$prm['input'] = '<select name="'.$part.'">';
				foreach($prm['options'] as $opt){
					$prm['input'] .= sprintf('<option value="%s" %s>%s</option>',
						$opt['id'],
						($opt['id'] == $prm['original_value']) ? 'selected="selected"' : '',
						$opt['text']
					);
				}
				$prm['input'] .= '</select>';
				break;
		}
		$smarty->assign(array(
			'INPUT_ID_UNIT'=>sprintf('<input type="hidden" name="id_unit" value="%s" />',$id_unit),
			'INPUT_ACTION'=>sprintf('<input type="hidden" name="action" value="%s" />','unit_update_process'),
			'INPUT_PART'=>sprintf('<input type="hidden" name="part" value="%s" />',$part),
			'ACTION'=>$action,
			'DATA'=>$prm,
		));
		$smarty->display('hitmeister.tpl');
		exit;
		break;
	// post() return ID: 382576320670
	// Pool Tester pH Chlor Brom Tester inkl. 2x20 Tabletten
	// real.de ID: 312936612
	// real.de Kategorie: Poolzubehör
	// Hersteller: Zawa
	// EAN: 4011821131664


	// WIR UEBERNEHMEN EINEN ARTIKEL AUS DEM REAL.DE SORTIMENT ALS ANGEBOT EINES SELLERS
	case 'allocate_hitmeister_catalog_product_process':
            $pID = yes_hitmeister::get_products_id_from_id_item($_POST['id']);
            if($pID > 0){
                die(json_encode(array(
                    'ERROR'=>'Kaufland item is always allocated to seller in YES products_id '.$pID,
                    'MSG'=>''
                )));
            }
            if(yes_hitmeister::get_id_item_from_products_id($pID) != ''){
                die(json_encode(array(
                    'ERROR'=>'YES products_id is in use for an Kaufland item',
                    'MSG'=>''
                )));
            }
            $lp = (float)str_replace(',','.',$_POST['listing_price']);
            $mp = (float)str_replace(',','.',$_POST['minimum_price']);
            $unit = array(
                    "amount"=> $_POST['amount'],
                    "handling_time"=> MODULE_OTHER_YES_HITMEISTER_HANDLING_TIME,
                    'listing_price'=>(int)($lp * 100),
                    "minimum_price"=>($mp>0) ? (int)($mp*100) : 1,
                    //"id_warehouse"=> $_POST['warehouse'],
                    "ean"=>$_POST['ean'],
                    "id_product"=>$_POST['id'],
                    "id_offer"=> $_POST['products_id'], // pID
                    'note'=>$_POST['note'],
            );
            if($mp<=0){
                   unset($unit["minimum_price"]);
            }
            try{
                    $res = json_decode($YH->post_unit($unit));
                    if(isset($res->data->status)){
                        $YH->allocate_hitmeister_product($_POST['id'], $_POST['products_id'], (int)$_POST['amount']);
                        die(json_encode(array(
                            'ERROR'=>'',
                            'MSG'=>''
                        )));
                    }else{
                        die(json_encode([
                            'ERROR'=>'Cant send allocation to kaufland API',
                            'MSG'=>print_r($res, true)
                        ]));
                    }
            }catch(Exception $e){
                    die(json_encode(array(
                        'MSG'=>'',
                        'ERROR'=>$e->getMessage()
                    )));
            }
            break;
	// WIR HOLEN ZU EINER PID DEN BESTAND UND DEN PREIS
	case 'get_yes_product_data':
		if(!isset($_GET['products_id']) or empty($_GET['products_id'])){
			die(json_encode(array(
				'ERROR'=>'Missing parameter'
			)));
		}
                $products_id = (int)xtc_db_input($_GET['products_id']);
                if(!product::isProduct($products_id)){
                    die(json_encode(array(
                        'ERROR'=>'Invalid products_id'
                    )));
                }
                if(isset($_GET['check_allocation'])){
                    if(yes_hitmeister::get_id_item_from_products_id($products_id) > 0){
                        die(json_encode(array(
                            'ERROR'=>HITMEISTER_ALLOCATION_ERROR_NO_CHANGE_NECCESSARY
                        )));
                    }
                }
                $xtPrice = new xtcPrice(DEFAULT_CURRENCY, MODULE_OTHER_YES_HITMEISTER_API_CUSTOMERS_STATUS);
                $product = new product($products_id, $_SESSION['languages_id'],true);
                $SQ = new products_quantity($products_id);
                $price = $xtPrice->xtcFormat($product->info['products_price'], false, $product->info['products_tax_class_id']);
		die(json_encode(array(
                    'ERROR'=>'',
                    'listing_price'=>number_format($price,2,',',''),
                    'minimum_price'=>number_format($price,2,',',''),
                    'amount'=>$SQ->get_available2_qty(),
		)));
		break;
	// WIR UEBERNEHMEN EINEN ARTIKEL AUS DEM REAL.DE SORTIMENT FUER EINEN SELLER
	// DAZU DEFINIEREN WIR PREISE USW UND WEISEN DEM ARTIKEL EINEN YES ARTIKEL ZU
	case 'allocate_hitmeister_catalog_product':
		if(!isset($_GET['id']) or empty($_GET['id'])){
			die(json_encode(array(
				'ERROR'=>'Missing parameter'
			)));
		}
		//$info = $client->items()->get($_GET['id'],array('units','category'));
                
                $res = json_decode($YH->get_products( $_GET['id'],array('units','category') ));
                $info = $res->data;
		$conditions = yes_hitmeister::hitmeister_conditions();
		$delivery_times = yes_hitmeister::hitmeister_delivery_times();
		$unit = array(
			"id_item"=>$_GET['id'],
			"ean"=>$_GET['ean'],
			'values_condition'=>$conditions,
			'condition'=>$conditions[1]['id'],
			'listing_price'=>'0,00',
			"minimum_price"=>'0,00',
			"amount"=> 0,
			"note"=> "", //Spezielle Hinweise
			"location"=> "DE",
			'delivery_times'=>$delivery_times,
			"delivery_time"=> $delivery_times[1]['id'],
			"warehouse"=> "",
			"shipping_group"=> "paket" // FREI DEFINIERBAR
		);
		$smarty->assign(array(
                    'PRODUCTS_ID'=>(isset($_GET['products_id'])) ? $_GET['products_id'] : '',
                    'UNIT'=>$unit,
                    'ACTION'=>$action,
                    'HITMEISTER_INVALID_PRODUCTS_ID'=>HITMEISTER_INVALID_PRODUCTS_ID,
                    'HITMEISTER_ALLOCATE_YES_PRODUCT_INTRO'=>HITMEISTER_ALLOCATE_YES_PRODUCT_INTRO,
                    'HITMEISTER_ALLOCATE'=>HITMEISTER_ALLOCATE,
                    'HITMEISTER_CONDITION'=>HITMEISTER_CONDITION,
                    'HITMEISTER_ALLOCATE_YES_PRODUCT_INTRO_STEP_2'=>HITMEISTER_ALLOCATE_YES_PRODUCT_INTRO_STEP_2,
                    'HITMEISTER_PRICE'=>HITMEISTER_PRICE,
                    'HITMEISTER_MINIMUM_PRICE'=>HITMEISTER_MINIMUM_PRICE,
                    'HITMEISTER_MINIMUM_PRICE_INTRO'=>HITMEISTER_MINIMUM_PRICE_INTRO,
                    'HITMEISTER_OFFER_QUANTITY'=>HITMEISTER_OFFER_QUANTITY,
                    'HITMEISTER_OFFER_NOTE'=>HITMEISTER_OFFER_NOTE,
                    'HITMEISTER_LOCATION'=>HITMEISTER_LOCATION,
                    'HITMEISTER_OFFER_SHIPPINGTIME'=>HITMEISTER_OFFER_SHIPPINGTIME,
                    'HITMEISTER_WAREHOUSE'=>HITMEISTER_WAREHOUSE,
                    'HITMEISTER_SAVE'=>HITMEISTER_SAVE,
                    'HITMEISTER_OFFER_SHIPPING_PRICE'=>HITMEISTER_OFFER_SHIPPING_PRICE,
                    'SELLER'=>MODULE_OTHER_YES_HITMEISTER_API_ALIAS,
                    'CHECK_ALLOCATION'=>(isset($_GET['check_allocation'])) ? 1 : 0,
                    'REFERRER'=>(isset($_GET['referrer']))? $_GET['referrer'] : '',
                    'BASELINK'=>xtc_href_link(basename(__FILE__)),
		));
		$smarty->display('hitmeister.tpl');
		exit;
		break;
	case 'import_yes_product_get_data_from_pid':
		$file = basename($_GET['file']);
                $products_id = (int)xtc_db_input($_GET['pID']);
                $file_path = sprintf('%s/%s',yes_hitmeister::SAVE_DIR, $file);
		if(substr($file,-5) != '.json' or !is_file($file_path)){
			die(json_encode(array(
				'ERROR'=>'Invalid File "'.$file.'"'
			)));
		}
		$items = array();
                if(!product::isProduct($products_id)){
                    die(json_encode(array(
                            'ERROR'=>'Invalid Product #"'.$products_id.'"'
                    )));
                }
                $product = new product($products_id, $_SESSION['languages_id']);
                $categoryID = str_replace( array('hitmeister_category_attributes_','.json'),'',$file);
                $res = json_decode($YH->get_categories( $categoryID ));
                $sugg = $res->data;
                //$sugg = $client->categories()->get($categoryID);
                
                $products_data = $product->info;
		$scheme = json_decode(file_get_contents($file_path),true);
		foreach($scheme as $field){
			switch($field['name']){
                                case 'category':
                                    $items[ $field['name'] ] = $sugg->title_plural;
                                    break;
				case 'ean':
					$items[ $field['name'] ] = $products_data['products_ean'];
					break;
				case 'title':
					$items[ $field['name'] ] = $products_data['products_name'];
					break;
				case 'description':
					$items[ $field['name'] ] = $products_data['products_description'];
					break;
				case 'description':
					$items[ $field['name'] ] = $products_data['products_description'];
					break;
				case 'picture':
                                    if($products_data['products_image'] != ''){
					$items[ $field['name'] ] = array(sprintf('%s/images/product_images/original_images/%s',
                                                HTTP_SERVER,
                                                $products_data['products_image']
                                        ));
                                        foreach($product->get_mo_images() as $mo){
                                            $items[ $field['name'] ][] = sprintf('%s/images/product_images/original_images/%s',
                                                    HTTP_SERVER,
                                                    $mo['image_name']
                                            );
                                        }
                                    }
                                    break;
				case 'manufacturer':
					$items[ $field['name'] ] = yes_get_manufacturers_name($products_data['manufacturers_id']);
					break;
				case 'short_description':
					$items[ $field['name'] ] = $products_data['products_short_description'];
					break;
			}
		}
		die(json_encode(array(
			'ITEMS'=>$items,
			'ERROR'=>''
		)));
		exit;
		break;
	case 'import_yes_product':
            if(!isset($_GET['file'])){
                if(isset($_GET['products_id'])){
                    // KATEGORIE VORSCHLAG
                    $pID = (int)xtc_db_input($_GET['products_id']);
                    if(!product::isProduct($pID)){
                        die('Invalid parameter');
                    }
                    $product = new product($pID,$_SESSION['languages_id']);
                    if($product->info['products_ean'] != ''){
                        try{
                            $res = json_decode($YH->items_find_by_ean($product->info['products_ean']));
                            $info = $res->data;
                            //$info = $client->items()->findByEan($product->info['products_ean']);
                        }catch(Exception $e){
                            $info = Null;
                        }
                        if($info !== Null){
                            $smarty->assign(array(
                                'PRODUCTS_ID'=>$pID,
                                'ID_ITEM'=>$info->id_product,
                                'EAN'=>$product->info['products_ean'],
                                'HITMEISTER_ALLOCATE_UNIT'=>HITMEISTER_ALLOCATE_UNIT,
                                'EXISTING_EAN_INFO'=>$info,
                                'HITMEISTER_EXISTING_EAN_INFO'=>sprintf(
                                        HITMEISTER_EXISTING_EAN_INFO,
                                        $product->info['products_ean']
                                )
                            ));
                        }
                    }
                    $xtPrice = new xtcPrice(DEFAULT_CURRENCY, MODULE_OTHER_YES_HITMEISTER_API_CUSTOMERS_STATUS);
                    $price = $xtPrice->xtcFormat($product->info['products_price'], false, $product->info['products_tax_class_id']);
                    if($price <= 0){
                        die(HITMEISTER_ERROR_PRODUCT_HAS_NO_PRICE);
                    }
                    $data = array(
                        "item"=>array(
                            "title"=>$product->info['products_name'],
                            "description"=>$product->info['products_description']
                        ),
                        'price'=>(int)((float)$price)*100
                    );
                    if($product->info['manufacturers_id'] > 0){
                        $data['item']['manufacturer'] = yes_get_manufacturers_name($product->info['manufacturers_id']);
                    }
                    $res = json_decode($YH->get_categories_decide($data));
                    $decide = $res->data;
                    //$decide = $client->categories()->decide($data);
                    $smarty->assign('DECIDES', $decide);
                }
                
                $files = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),$YH->get_category_config_files());
		$smarty->assign(array(
                    'INPUT_CATEGORY_FILE'=>xtc_draw_pull_down_menu('file',$files),
                    'ACTION'=>$action.'_select_file',
                    'LINK_CONTINUE'=> xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('file'))),
                    'HITMEISTER_DECIDE_INTRO'=>HITMEISTER_DECIDE_INTRO,
                    'REFERRER'=>urlencode($_GET['referrer'])
                ));
            }else{
		$file = basename($_GET['file']);
                $file_path = sprintf('%s/%s',yes_hitmeister::SAVE_DIR, $file);
		if(substr($file,-5) != '.json' or !is_file($file_path)){
			die('Invalid File');
		}
		$input = array();
		$scheme = json_decode(file_get_contents($file_path));
		foreach($scheme as $field){
			$input[] = yes_hitmeister::hitmeister_get_attribute_input( (array) $field);
		}
		$smarty->assign(array(
			'FILE'=>$file,
			'INPUT'=>$input,
			'ACTION'=>$action,
			'HITMEISTER_PRODUCTS_ID'=>HITMEISTER_PRODUCTS_ID,
			'HITMEISTER_IMPORT_YES_PRODUCT_UPDATE_PRODUCTS_DATA'=>HITMEISTER_IMPORT_YES_PRODUCT_UPDATE_PRODUCTS_DATA,
			'HITMEISTER_IMPORT_YES_PRODUCTS_INTRO'=>HITMEISTER_IMPORT_YES_PRODUCTS_INTRO,
			'HITMEISTER_BUTTON_IMPORT'=>HITMEISTER_BUTTON_IMPORT,
                    'INITIAL_PRODUCTS_ID'=>(isset($_GET['products_id'])) ? (int)xtc_db_input($_GET['products_id']) : 0,
                    'HITMEISTER_DECIDE_INTRO'=>HITMEISTER_DECIDE_INTRO,
		));
            }
            $smarty->display('hitmeister.tpl');
            exit;
            break;
	case 'get_export_config_file':
		$file = basename($_GET['file']);
                try{
                    yes_hitmeister::download_export_config_csv($file);
                }catch(Exception $ex){
                    $messageStack->add_session($ex->getMessage(),'error');
                }
                xtc_redirect(xtc_href_link(basename(__FILE__).'#hitmeister-categories-menu'));
		break;
	case 'chk_import':
            $res = json_decode($YH->get_importFiles($_GET['id_file']));
            $if = $res->data;
            //    $if = $client->importFiles()->get($_GET['id_file']);
                $file = yes_hitmeister::SAVE_DIR.'/'.basename($if->uri);
		if(substr($file,-4) == '.csv' && is_file($file)){
			$content = explode("\r\n",file_get_contents($file));
			foreach($content as $zn=>$row){
				if($zn == 0) continue;
				$cols = explode(yes_hitmeister::PRODUCT_IMPORT_DELIMITER,$row);
				$ean = $cols[0];
				printf('<li class="not_chk" id="%s">EAN %s</li>', $ean, $ean);
			}
		}else{
                    die(sprintf('<i>Invalid File %s</i>',
                            basename($file)
                    ));
                }
		exit;
		break;
	case 'item_info':
            // ALT
            // $info = $client->items()->get($_GET['id'],array('units','category'));
            $res = json_decode($YH->get_products($_GET['id'], ['units','category']));
            $info = $res->data;
            
		$smarty->assign(array(
			'INFO'=>$info,
			'HITMEISTER_CATEGORY'=>HITMEISTER_CATEGORY,
			'TEXT_MANUFACTURER'=>TEXT_MANUFACTURER,
			'HITMEISTER_SHOW_OFFERS'=>HITMEISTER_SHOW_OFFERS,
			'HITMEISTER_TOGGLE_SHOW_HIDE'=>HITMEISTER_TOGGLE_SHOW_HIDE,
			'HITMEISTER_OFFER_PRICE'=>HITMEISTER_OFFER_PRICE,
			'HITMEISTER_OFFER_SHIPPING_PRICE'=>HITMEISTER_OFFER_SHIPPING_PRICE,
			'HITMEISTER_OFFER_FROM_DATE'=>HITMEISTER_OFFER_FROM_DATE,
			'HITMEISTER_OFFER_LAST_UPDATE'=>HITMEISTER_OFFER_LAST_UPDATE,
			'HITMEISTER_ALLOCATE_UNIT'=>HITMEISTER_ALLOCATE_UNIT,
			'SELLER'=>MODULE_OTHER_YES_HITMEISTER_API_ALIAS
		));
		$smarty->display('hitmeister_item_info.tpl');
		exit;
		break;
	case 'get_hitmeister_categories_select':
?>
<!DOCTYPE html>
<html  xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"><head>
<meta charset="UTF-8" /><head>
 <link rel="stylesheet" href="<?php echo yes_get_cdn_link('jquery-ui-css'); ?>">
<script src="<?php echo yes_get_cdn_link('jquery'); ?>"></script>
<script src="<?php echo yes_get_cdn_link('jquery-ui'); ?>"></script>
  <script>
    $(function(){
        $( "ul#hitmeister_cat_menu" ).menu({
                select: function(event, ui){
                        if($(ui.item).hasClass('clickable')){
                            parent.performCategorySelect($(ui.item).attr('id'),$(ui.item).text());
                        }
                },
                create: function(event, ui){
                    parent.$('#hitmeister_loads').hide('slow');
                }
        });
    });
    </script>        
  <style>
  .ui-menu {
    width: 300px;
  }
  </style></head>
<body>
<?php
		if(is_file(yes_hitmeister::CATEGORIES_HTML_FILE)){
			echo '<ul id="hitmeister_cat_menu">';
			echo gzuncompress(file_get_contents(yes_hitmeister::CATEGORIES_HTML_FILE));
			echo '</ul>';
		}
?>
</body>
</html>
<?php
		exit;
		break;
        case 'delete_import_item':
            $ean_array = explode(',',$_GET['ean']);
            $msg = array();
            foreach($ean_array as $ean){
                $res = $YH->delete_product( $ean );
                // ALT
                // $status = $client->productData()->delete($ean);
                //if($status != 1){
                //    $msg[] = 'Error EAN '.$ean;
                //}
            }
            die(json_encode(array(
                'MSG'=>implode("\r\n",$msg)
            )));
            break;
        // ARTIKEL WURDEN IM REAL KATALOG AUFGENOMMEN
        // HIER WERDEN SIE NUN IMPORTIERT
        case 'process_import_file':
            $if = $client->importFiles()->get($_GET['id']);
            switch($if->product_feed_async_done){
                case '1':
                    break;
                default:
                    $messageStack->add_session(sprintf(
                            'Import File %s has Status %s and Process is %s',
                            basename($if->uri),
                            $if->status,
                            $if->product_feed_async_done
                    ),'error');
                    xtc_redirect(xtc_href_link(basename(__FILE__)));
                    break;
            }
            $products = yes_hitmeister::get_import_file_content($if->uri);
            $csv_header = array();
            $csv = array();
            $hitmeister_categories = array();
            foreach($products as $row=>$product){
                $ean = $product[0];
                try{
                    $data = $client->productData()->get($ean);
                }catch(Exception $ex){
                    die($row.') productData()->get('.$ean.')'.$ex->getMessage());
                }
                if($data === Null){
                    continue;
                }
                $add_info = $client->items()->findByEan($ean);
                $id_item = '';
                if($add_info !== Null){
                    $id_item = $add_info->id_item;
                }
                if(!sizeOf($csv_header)){
                    $csv_header[] = 'products_id';
                    $csv_header[] = 'allocated_in_yes';
                    $csv_header[] = 'id_item';
                    foreach(current((array) $data) as $col=>$val){
                        $csv_header[] = $col;
                    }
                }
                foreach($csv_header as $ch){
                    $csv[$row][$ch] = '';
                }
                foreach(current((array) $data) as $col=>$val){
                    $ean = current($data->ean);
                    $csv[$row]['products_id'] = product::get_products_id_array_from_ean($ean);
                    $allocated = yes_hitmeister::get_products_id_from_id_item($id_item);
                    $csv[$row]['allocated_in_yes'] = $allocated;
                    $csv[$row]['id_item'] = $id_item;
                    $csv[$row][$col] = current($val);
                    if($col == 'category'){
                        if(!isset($hitmeister_categories[current($val)])){
                             $cat = $client->categories()->get(current($val));
                             $hitmeister_categories[current($val)] = $cat->title_plural;
                        }
                    }
                }
            }
            $smarty->assign(array(
                'HITMEISTER_ALLOCATE_UNIT'=>HITMEISTER_ALLOCATE_UNIT,
                'ACTION'=>$action,
                'ITEMS'=>array_merge(array($csv_header),$csv),
                'IMPORT_FILE'=>basename($if->uri),
                'TEXT_SELECT'=>TEXT_SELECT,
                'IMAGE_BACK'=>IMAGE_BACK,
                'HITMEISTER_CATEGORIES'=>$hitmeister_categories,
                'REFERRER'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params()),
            ));
            yes_draw_pre_header();
            yes_draw_header(TITLE);
            $smarty->display('hitmeister.tpl');
            require(DIR_WS_INCLUDES . 'footer.php');
            require(DIR_WS_INCLUDES . 'application_bottom.php');
            exit;
            break;
	/**
	STATUS DER HOCHGELADENEN ARTIKEL BEI REAL
	MANUELLE PRUEFUNG KANN JA TAGE/WOCHEN DAUERN
	*/
	case 'product_data_status':
            try{
                /** Vorbereitung V2
                $statuses = ['NEW', 'DOWNLOADING', 'DOWNLOADED', 'DOWNLOADING_FAILED', 
                    'PREPARING', 'PREPARED', 'PREPARING_FAILED', 'CHECKING', 
                    'CHECKED', 'CHECKING_FAILED', 'PREPROCESSING', 'PREPROCESSED', 
                    'PREPROCESSING_FAILED', 'IMPORTING', 'IMPORTED', 
                    'IMPORTING_FAILED', 'IMPORTING_STOPPED', 'ERROR', 'ABORTED', 'DONE'
                ];
                $req_status = 'DONE';
                $types = [];
                $objDateTime1 = new DateTime('-3 Years');
                $created_from = $objDateTime1->format('c'); 
                $updated_from = $created_from;
                $sort = 'ts_created:asc';
                $limit = 100;
                $offset = 0;
                $status = $YH->get_import_files_from_hitmeister($req_status, 
                    Null, 
                    Null,
                    $sort, 
                    $limit,
                    $offset
                );
                yes_debug($status);
                exit;*/
                    yes_mail_debug('Kaufland V1 Aufruf product_data_status');
			$status = $client->ProductDataStatus()->get($_GET['ean']);
			$msg = sprintf(HITMEISTER_PRODUCT_IMPORT_STATUS_DETAIL,
				$status->update_status,
				(($status->item_ready < 1) ? HITMEISTER_NO : HITMEISTER_YES),
				(($status->item_not_ready_reason != '')?'<span class="ui-icon ui-icon-info" title="'.$status->item_not_ready_reason.'"></span>' : '')
			);
			die(json_encode(array(
				'ERROR'=>'',
				'MSG'=>$msg
			)));
		}catch(Exception $e){
			die(json_encode(array(
				'ERROR'=>$e->getMessage()
			)));
		}
		exit;
		break;
	case 'import_product_data_status':
            $statii = array("ABORTED","CHECKED","CHECKING","CHECKING_FAILED","DONE","DOWNLOADED","DOWNLOADING","DOWNLOADING_FAILED","IMPORTED","IMPORTING","IMPORTING_FAILED","IMPORTING_STOPPED","NEW","PREPARED","PREPARING","PREPARING_FAILED","PREPROCESSED","PREPROCESSING","PREPROCESSING_FAILED","WAITING");
            $types = array('PRODUCT_FEED');
            $createdFrom = date('Y-m-d', (time()-(60*60*24*7*4)) );
            $updatedFrom = date('Y-m-d', (time()-(60*60*24*7*4)) );
            $sort = 'ts_created:desc';
            $limit = 30;
            $offset = 0;
            yes_mail_debug('Kaufland V1 Aufruf import_product_data_status');
            $res = json_decode($YH->get_import_files_from_hitmeister($statii, $types, $createdFrom, $updatedFrom, $sort, $limit, $offset));
            $status = $res->data;
            /*
		$status = $client->ImportFiles()->find(
			$statii,
			$types,
			$createdFrom,
                        $updatedFrom,
			$sort,
			$limit,
			$offset
		);
             * 
             */
                $smarty->assign(array(
                    'ACTION' => $action,
                    'STATUS' => $status,
                    'HITMEISTER_NO_IMPORT_STATUS_RESULTS'=>HITMEISTER_NO_IMPORT_STATUS_RESULTS,
                    'HITMEISTER_VOM'=>HITMEISTER_VOM,
                ));
                $smarty->display('hitmeister.tpl');
		exit;
		break;
	/**
	ARTIKEL BEI REAL KATALOG EINSTELLEN PER CSV DATEN
	*/
	case 'import_product_data':
            //9780201379709
            $referrer_filename = (!isset($_POST['referrer_filename']) or empty($_POST['referrer_filename'])) ? basename(__FILE__) : $_POST['referrer_filename'];
            $categoryID = str_replace(array('hitmeister_category_attributes_','.json'),'',$_POST['file']);
            $product_csv_file = yes_hitmeister::SAVE_DIR.'/'.'hitmeister_csv_import_'.$categoryID.'.csv';
            $redir = (isset($_POST['referrer_filename'])) ? $_POST['referrer_filename'] : basename(__FILE__).'#hitmeister-products-menu';
            $ref_params = '';
            switch($referrer_filename){
                case FILENAME_CATEGORIES:
                    $ref_params = 'action=new_product&pID='.$_POST['products_id'];
                    break;
            }
            
            if(yes_hitmeister::is_product_saved_in_csv_import_file($_POST['products_id'],$product_csv_file)){
                $messageStack->add_session(sprintf(
                        MSG_ERROR_PRODUCTS_ID_EXISTS_IN_HITMEISTER_EXPORT,
                        basename($product_csv_file)
                ),'error');
                xtc_redirect(xtc_href_link($redir,$ref_params));
            }
            $eannr = (int)current($_POST['ean']);
            $ean = current($_POST['ean']);
            /*
            $nomatch=true;
            while($nomatch){
                try{
                    $ean_result = $client->items()->findByEan($eannr);
                    if($ean_result === Null){
                        echo '<li><b>Hurray, '.$eannr.'</b>';
                        $nomatch = false;
                    }else{
                        echo '<li>existing'.$eannr;
                    }
                }catch(Exception $ex){
                    echo '<li>'.$ex->getMessage();
                }
                $eannr++;
            }
            die('VALID:'.$eannr);
            exit;
             * 
             */
            try{
                $res = json_decode($YH->items_find_by_ean($ean));
                $ean_result = $res->data;
            }catch(Exception $ex){
                $ean_result = Null;
                $messageStack->add_session($ex->getMessage(),'error');
                xtc_redirect(xtc_href_link($redir,$ref_params));
            }
            if($ean_result !== Null){
                $info_str = sprintf(
                        '&nbsp;ID %s: %s',
                        $ean_result->id_item,
                        $ean_result->title
                );
                $messageStack->add_session(sprintf(HITMEISTER_EXISTING_EAN_INFO,current($_POST['ean'])).$info_str,'error');
                xtc_redirect(xtc_href_link($redir,$ref_params));
            }
            if(yes_hitmeister::is_hitmeister_product($_POST['products_id'])){
                $messageStack->add_session(HITMEISTER_ALLOCATION_ERROR_ALLOCATION_EXISTS,'error');
                xtc_redirect(xtc_href_link($redir, $ref_params));
            }
            $file = yes_hitmeister::add_line_to_export(
                    $_POST['file'],
                    $_POST['products_id']
            );
            $messageStack->add_session(sprintf(
                    MSG_SUCCESS_ADD_LINE_TO_EXPORT,
                    basename($file)
            ),'success');
            xtc_redirect(xtc_href_link($redir,$ref_params));
            
            break;
	case 'save_import_product_data_scheme':
		$categoryID = $_GET['categoryID'];
                $res = json_decode($YH->get_categories( $categoryID,['optional_attributes','required_attributes'] ));
                $category = $res->data;
		$json_scheme = array();
		$optional_attributes = array();
		foreach($category->optional_attributes as $oa){
			$optional_attributes[] = array(
				'id_attribute'=>$oa->id,
				'name' => $oa->name,
				'title'=> $oa->title,
				'is_multiple_allowed' => $oa->is_multiple,
				'type'=>$oa->type
			);
		}
		$mandatory_attributes = array();
		foreach($category->required_attributes as $oa){
			$mandatory_attributes[] = array(
				'id_attribute'=>$oa->id,
				'name' => $oa->name,
				'title'=> $oa->title,
				'is_multiple_allowed' => $oa->is_multiple,
				'type'=>$oa->type
			);
		}
		$sort = 0;
		foreach($_POST as $k=>$v){
			foreach($mandatory_attributes as $att){
				if($att['name'] == $k){
					$json_scheme[$sort] = $att;
					$sort++;
				}
			}
			foreach($optional_attributes as $att){
				if($att['name'] == $k){
					$json_scheme[$sort] = $att;
					$sort++;
				}
			}
		}
                if(yes_hitmeister::save_attribute_json_file($categoryID,$json_scheme)){
                        $messageStack->add_session(sprintf(MSG_SUCCESS_HITMEISTER_SAVE_IMPORT_PRODUCT_SCHEME,
                                basename($category_attributes_json_file)
                        ),'success');
		}else{
                    $messageStack->add_session(MSG_ERROR_HITMEISTER_SAVE_IMPORT_PRODUCT_SCHEME_NO_DATA,'error');
                }
		xtc_redirect(xtc_href_link(basename(__FILE__)).'#hitmeister-categories-menu');
		exit;
		break;
	case 'configure_import_product_data_scheme':
		$categoryID = (isset($_GET['categoryID'])) ? $_GET['categoryID'] : '39751'; // spaeter dann per _GET
            
                $res = json_decode($YH->get_categories($categoryID,array('optional_attributes','required_attributes')));
                $category = $res->data;
		$optional_attributes = array();
		foreach($category->optional_attributes as $oa){
			$optional_attributes[] = array(
				'id_attribute'=>$oa->id,
				'name' => $oa->name,
				'title'=> $oa->title,
				'is_multiple_allowed' => $oa->is_multiple,
				'type'=>$oa->type
			);
		}
		$mandatory_attributes = array();
		foreach($category->required_attributes as $oa){
			$mandatory_attributes[] = array(
				'id_attribute'=>$oa->id,
				'name' => $oa->name,
				'title'=> $oa->title,
				'is_multiple_allowed' => $oa->is_multiple,
				'type'=>$oa->type
			);
		}
		$mandatorys = array();
		if(sizeOf($mandatory_attributes)){
			foreach($mandatory_attributes as $opt){
				$dat = yes_hitmeister::hitmeister_get_attribute_input($opt);
				$mandatorys[] = array(
					'INPUT'=>sprintf('<input checked="checked" type="checkbox" name="%s" value="1">',
						$opt['name']),
					'TEXT'=>$dat['title']
				);
			}
		}
		$optionals = array();
		if(sizeOf($optional_attributes)){
			foreach($optional_attributes as $opt){
				$dat = yes_hitmeister::hitmeister_get_attribute_input($opt);
				$optionals[] = array(
					'INPUT'=>sprintf('<input type="checkbox" name="%s" value="1">',$opt['name']),
					'TEXT'=>$dat['title']
				);
			}
		}
		$smarty->assign(array(
			'FORM'=>'<form action="hitmeister.php?action=save_import_product_data_scheme&categoryID='.$categoryID.'#hitmeister-categories-menu" method="post">',
			'TEXT_MANDATORY_ATTRIBUTES'=>HITMEISTER_MANDATORY_ATTRIBUTES,
			'TEXT_OPTIONAL_ATTRIBUTES'=>HITMEISTER_OPTIONAL_ATTRIBUTES,
			'ACTION'=>$action,
			'MANDATORYS'=>$mandatorys,
			'OPTIONALS'=>$optionals,
			'HITMEISTER_SAVE'=>HITMEISTER_SAVE
		));
		$smarty->display('hitmeister.tpl');
		exit;
		break;
	/**
	WENN DIE ARTIKEL BEREITS BEI REAL GELISTET SIND
	*/
	case 'import_item_csv': 
		if(is_file($csv_file)){
			die(json_encode(array(
				'ERROR'=>'',
				'MSG'=>$csv_file.' exists'
			)));
		}else{
			$header = array(
				"ean","condition","price","comment","offer_id","warehouse","count","delivery_time","minimum_price","price_cs","minimum_price_cs","shipping_group"
			);
			$delimiter = ';';
			// BEISPIELDATEN
			$csv = array(
				$header
			,array(
				'118866134422',
				'new', // hitmeister_conditions()
				'500', // Preis in Cent
				'Hinweis an den Kaeufer',
				'EINE_EIGENE_TRACKINGID', // wofuer auch immer
				'', // warehouse
				'30', // av quantity
				'b', // hitmeister_delivery_times()
				'minimum_price'=>'500', // Tiefstpreisautomatik
				'', // price_cs in EUR ... nur wenn price nicht gesetzt - glaube nur anderes format
				'', // minimum_price_cs ... selbe wie price_cs
				'paket' // shipping_group - muss angelegt werden
			),array(
				'118866134413',
				'new', // hitmeister_conditions()
				'600', // Preis in Cent
				'Hinweis an den Kaeufer (2)',
				'EINE_EIGENE_TRACKINGID', // wofuer auch immer
				'', // warehouse
				'60', // av quantity
				'b', // hitmeister_delivery_times()
				'minimum_price'=>'600', // Tiefstpreisautomatik
				'', // price_cs in EUR ... nur wenn price nicht gesetzt - glaube nur anderes format
				'', // minimum_price_cs ... selbe wie price_cs
				'paket' // shipping_group - muss angelegt werden
			),array(
				'118866134431',
				'new', // hitmeister_conditions()
				'700', // Preis in Cent
				'Hinweis an den Kaeufer (3)',
				'EINE_EIGENE_TRACKINGID', // wofuer auch immer
				'', // warehouse
				'70', // av quantity
				'b', // hitmeister_delivery_times()
				'minimum_price'=>'700', // Tiefstpreisautomatik
				'', // price_cs in EUR ... nur wenn price nicht gesetzt - glaube nur anderes format
				'', // minimum_price_cs ... selbe wie price_cs
				'paket' // shipping_group - muss angelegt werden
			));
			$csv_string = '';
			foreach($csv as $row){
				foreach($row as $k=>$v){
					$row[$k] = sprintf('"%s"',$v);
				}
				$csv_string .= implode($delimiter, $row)."\r\n";
			}
			file_put_contents($csv_file, $csv_string);
			die(json_encode(array(
				'ERROR'=>'',
				'MSG'=>$csv_file.' created'
			)));
		}
		break;
	case 'save_cats':
            try{
                $done = $YH->save_category_tree_as_html();
            }catch(Exception $ex){
                die(json_encode(array(
                    'ERROR'=>$ex->getMessage(),
                    'DONE'=>0
                )));
            }
            die(json_encode(array(
                'ERROR'=>'',
                'DONE'=>$done,
                'FILE'=>yes_hitmeister::CATEGORIES_HTML_FILE
            )));
            break;
}

$export_config_files = $YH->get_category_config_files();

//
// FUER ALLE PAGE RESULTS
//
$limit= (main::isDev(true))?30:100; // limit
//
// -----------------------
//

$PAGER_UNITS = '';
$seller_units_offset = $seller_units_page = (isset($_GET['page_seller_units'])) ? (int)$_GET['page_seller_units'] : 0;

// eigenes handling, ich komm durcheinander
$su_pager_offset = (isset($_GET['page_seller_units'])) ? (int)$_GET['page_seller_units'] : 0;

$data_array = array(); // nur fuer splitpage results array
$su_apiOffset = ($seller_units_offset <= 1)?1 : $seller_units_offset;
$su_apiOffset = ($su_apiOffset - 1) * $limit;

$units_array = array();
if((isset($_GET['id_item']) and $_GET['id_item'] != '') or (isset($_GET['id_item_products_id']) and $_GET['id_item_products_id'] != '' )) {
//    $seller_units = $client->units()->seller($limit, $su_apiOffset,(int)$_GET['id_item']);
    if(isset($_GET['id_item']) and $_GET['id_item'] != ''){
        $id_item = $_GET['id_item'];
        $pID = yes_hitmeister::get_products_id_from_id_item($id_item);
        $id_unit = yes_hitmeister::get_id_unit_from_products_id($pID);
    }else{
        $id_unit = yes_hitmeister::get_id_unit_from_products_id((int)xtc_db_input($_GET['id_item_products_id']));
    }
    $res = json_decode($YH->get_seller_units($su_apiOffset, $limit,trim("$id_unit")));
    $seller_units = $res;
    $seller_units_total = $res->pagination->total;
}else{
    //$seller_units = $client->units()->seller($limit, $su_pager_offset*$limit);
    
    $res = json_decode($YH->get_seller_units($su_apiOffset, $limit));
    $seller_units = $res->data;
    $seller_units_total = $res->pagination->total;
}
$data_array = $seller_units->data ?? [];
if(!is_array($data_array)){
	$data_array = [$data_array];
}

foreach($data_array as $su){
    $data_array[] = $su->id_offer;
    $su->id_offer = smarty_function_hitmeister_allocated_products_id(array('id'=>$su->id_product), $smarty);
    $units_array[] = $su;
}
if(isset($_GET['action']) and $_GET['action'] == 'allocate_unknown_by_ean'){
	if($seller_units_offset == 0){
		echo "<div id=\"allocate_unknown_by_ean_div\">";
	}
	$allocateds = 0;
	foreach($units_array as $unit){
		if(!sizeOf( $unit->product->eans ) or !isset($unit->product->eans) ){
			printf('Kaufland Artikel %s hat keine EAN<br />',$unit->id_item);
			continue;
		}
		if(sizeOf( $unit->product->eans ) > 1 ){
			printf('Kaufland Artikel %s hat %d EAN<br />',$unit->id_product,sizeOf( $unit->product->eans ));
			continue;
		}
		if( yes_hitmeister::get_products_id_from_id_item($unit->id_product) < 0){
			$q = xtc_db_query(sprintf(
				"SELECT products_id FROM %s WHERE products_ean='%s'",
				TABLE_PRODUCTS,current($unit->product->eans)
			));
			$matches_num = xtc_db_num_rows($q);
			if($matches_num){
				$r = xtc_db_fetch_array($q);
				$YH->allocate_hitmeister_product($unit->id_product, $r['products_id'],$unit->amount);
				$allocateds++;
			}else{
				printf('Zum Kaufland Artikel %s konnten keine passenden EAN in YES gefunden werden.<br />',$unit->id_product);
			}
		}
	}
	printf("<p>%s neue Zuweisungen gespeichert</p>",$allocateds);
	$next_su_apiOffset = ($su_pager_offset <= 1) ? 2 : $su_pager_offset+1;
	if($seller_units_total > ($limit * $next_su_apiOffset)){
		printf("<a href=\"javascript:automatic_ean_allocation_pager(%d);\">%s</a>&nbsp;",
			$next_su_apiOffset,
			HITMEISTER_AUTOMATIC_EAN_ALLOCATION_CONTINUE
		);
		printf(HITMEISTER_AUTOMATIC_EAN_ALLOCATION_PAGER_INFO,
			$limit*$next_su_apiOffset,$limit*$next_su_apiOffset+$limit,
			$seller_units_total
		);
	}
	if($seller_units_offset == 0){
		echo "</div>";
	}
	exit;
}

$su_num_rows = 0;
$split = new splitPageResultsArray($seller_units_offset, $limit, $data_array, $su_num_rows);
$PAGER_UNITS = $split->display_count($seller_units_total, $limit, (($seller_units_page == 0)?1:$seller_units_page), TEXT_DISPLAY_NUMBER_OF_ITEMS).
        '<br />'.
    $split->display_links($seller_units_total, $limit,20,$seller_units_page,xtc_get_all_get_params(array('page_seller_units')),'page_seller_units');


$PAGER_ORDERS = '';
$hitmeister_orders_statuses = array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),yes_hitmeister::hitmeister_orders_statuses());
$id_order = (isset($_GET['id_order'])) ? $_GET['id_order'] : '';
if($id_order != ''){
    // ALT
    // $seller_order = $client->orders()->get($id_order,array('seller_units'));
    $res = json_decode($YH->get_order($id_order));
    $seller_order = $res->data;
    $oID = yes_hitmeister::hitmeister_get_yes_orders_id_from_id_order($seller_order->id_order);
    $smarty->assign([
        'ACTION'=>'order',
        'ORDER'=>$seller_order,
        'OID'=>$oID,
    ]);
    yes_draw_pre_header();
    yes_draw_header(TITLE);
    $smarty->display('hitmeister.tpl');
    require(DIR_WS_INCLUDES . 'footer.php');
    require(DIR_WS_INCLUDES . 'application_bottom.php');
    exit;
}else{
    $offset = $page = (isset($_GET['page'])) ? (int)$_GET['page'] : 0;
    
    $data_array = array(); // nur fuer splitpage results array
    $apiOffset = ($offset <= 1)?1 : $offset;
    $apiOffset = ($apiOffset - 1) * $limit;
    
    $hitmeister_order_status = (isset($_GET['hitmeister_order_status'])) ? $_GET['hitmeister_order_status'] : '';
    $idOffer = null;
    $createdFrom = date('Y-m-d',time()-(60*60*24*7));
    $updatedFrom = '';
    $sort = 'ts_created:desc';
    $res = json_decode($YH->get_orderUnits($hitmeister_order_status,$idOffer,$createdFrom,$updatedFrom,$sort,$limit, $apiOffset));
    $seller_orders = $res->data;
    //$seller_orders = $client->orderUnits()->find($hitmeister_order_status,$idOffer,$createdFrom,$updatedFrom,$sort,$limit, $apiOffset);
    $nr = 0;
    foreach($seller_orders as $so){
        $data_array[] = $so->id_order;
        $query = xtc_db_query(sprintf(
                "SELECT invoice_upload FROM hitmeister_orders WHERE hitmeister_id_order='%s'",
                $so->id_order
        ));
        $record = xtc_db_fetch_array($query);
        $seller_orders[ $nr ]->invoice_upload = $record[ 'invoice_upload'];
        $nr++;
    }
    $products_query_num_rows = 0;
    $split = new splitPageResultsArray($offset, $limit, $data_array, $products_query_num_rows);
    $PAGER_ORDERS = $split->display_count($res->pagination->total, $limit, (($page==0)?1:$page), TEXT_DISPLAY_NUMBER_OF_ITEMS).
            '<br />'.
        $split->display_links($res->pagination->total, $limit,20,(($page==0)?1:$page),xtc_get_all_get_params(array('page')));
}

$res = json_decode($YH->get_tickets(Null,'opened'));
$tickets = $res->data;
$tickets_array = array();
foreach($tickets as $t){
    $res = json_decode($YH->get_tickets( $t->id_ticket ));
    $ticket = $res->data;
    $tickets_array[] = $ticket;
}

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
if(is_file(yes_hitmeister::CATEGORIES_HTML_FILE)){
	$smarty->assign(array(
		'CATEGORY_FILE_INFO'=> sprintf(HITMEISTER_CATEGORY_FILE_INFO,date('d.m.y H:i:s',filemtime(yes_hitmeister::CATEGORIES_HTML_FILE))),
	));
}
$import_files = array();
$d = dir(yes_hitmeister::SAVE_DIR);
while (false !== ($entry = $d->read())) {
   if(strstr($entry,'.csv') and strstr($entry,'hitmeister_csv_import_')){
       $lines = count(file(yes_hitmeister::SAVE_DIR.'/'.$entry))-1;
       $catId = str_replace(array('.csv','hitmeister_csv_import_'),'',$entry);
       $import_files[] = array(
           'file'=>$entry,
           'category'=>$YH->get_hitmeister_category_name_from_id($catId),
           'lines'=>$lines
       );
   }
}
$d->close();

$buttons = [
    array('text'=>BUTTON_SYNC_QUANTITY,
        'link'=>xtc_href_link(basename(__FILE__),'action=sync_quantity_confirm'),
        'lbOn'=>true,
        'auth'=>true
    ),
    array('text'=>BUTTON_HITMEISTER_SUBSCRIPTIONS,
        'link'=>xtc_href_link(basename(__FILE__),'action=subscriptions'),
        'lbOn'=>true,
        'auth'=>true
    ),
];
$import_order_logfile = main::get_secure_path().yes_hitmeister::ORDER_IMPORT_STATUS_LOGFILE_NAME;
if(is_file($import_order_logfile)){
    $buttons[] =  array('text'=>'Order Import Log',
        'link'=>xtc_href_link(basename(__FILE__),'action=view_order_import_logfile'),
        'lbOn'=>true,
        'auth'=>true
    );
}

$smarty->assign(array(
        'PAGER_ORDERS'=>$PAGER_ORDERS,
	'HITMEISTER_UPDATE_CATEGORIES'=>HITMEISTER_UPDATE_CATEGORIES,
	'HITMEISTER_SELECT_CATEGORY'=>HITMEISTER_SELECT_CATEGORY,
	'HITMEISTER_PRODUCT_IMPORT_STATUS'=>HITMEISTER_PRODUCT_IMPORT_STATUS,
	'HITMEISTER_CATEGORY_ID'=>HITMEISTER_CATEGORY_ID,
	'HITMEISTER_PRODUCT_INFO'=>HITMEISTER_PRODUCT_INFO,
	'HITMEISTER_CATEGORY_UPDATE_STARTED'=>HITMEISTER_CATEGORY_UPDATE_STARTED,
	'HITMEISTER_CATEGORY_EXPORT_CONFIG'=>HITMEISTER_CATEGORY_EXPORT_CONFIG,
	'HITMEISTER_NO_SEARCH_RESULT'=>HITMEISTER_NO_SEARCH_RESULT,
	'TEXT_MANUFACTURER'=>TEXT_MANUFACTURER,
	'HITMEISTER_MGB_ART_NR'=>HITMEISTER_MGB_ART_NR,
	'HITMEISTER_CATEGORIES'=>HITMEISTER_CATEGORIES,
	'HITMEISTER_CATEGORY_UPDATE_FAILED'=>HITMEISTER_CATEGORY_UPDATE_FAILED,
	'HITMEISTER_CATEGORY_UPDATE_FINISHED'=>HITMEISTER_CATEGORY_UPDATE_FINISHED,
	'HITMEISTER_CATEGORY_UPDATE_STATE_PRE'=>HITMEISTER_CATEGORY_UPDATE_STATE_PRE,
	'HITMEISTER_CATEGORY_UPDATE_STATE_AFTER'=>HITMEISTER_CATEGORY_UPDATE_STATE_AFTER,
	'HITMEISTER_CATEGORY_UPDATE_UNKNOWN'=>HITMEISTER_CATEGORY_UPDATE_UNKNOWN,
	'HITMEISTER_EXPORT_CONFIG_TEXT_SELECT'=>HITMEISTER_EXPORT_CONFIG_TEXT_SELECT,
	'EXPORT_CONFIG_FILES'=>$export_config_files,
	'HITMEISTER_PRODUCTS'=>HITMEISTER_PRODUCTS,
	'HITMEISTER_ADD_PRODUCT'=>HITMEISTER_ADD_PRODUCT,
	'HITMEISTER_IMPORT_CONFIG_TEXT_SELECT'=>HITMEISTER_IMPORT_CONFIG_TEXT_SELECT,
	'HITMEISTER_SELLER_UNITS'=>$units_array,
	'HITMEISTER_PRICE'=>HITMEISTER_PRICE,
	'HITMEISTER_OFFER_QUANTITY'=>HITMEISTER_OFFER_QUANTITY,
	'HITMEISTER_CONDITION'=>HITMEISTER_CONDITION,
	'HITMEISTER_MINIMUM_PRICE'=>HITMEISTER_MINIMUM_PRICE,
	'HITMEISTER_OFFER_NOTE'=>HITMEISTER_OFFER_NOTE,
	'HITMEISTER_LOCATION'=>HITMEISTER_LOCATION,
	'HITMEISTER_OFFER_SHIPPINGTIME'=>HITMEISTER_OFFER_SHIPPINGTIME,
	'HITMEISTER_OFFER_SHIPPING_PRICE'=>HITMEISTER_OFFER_SHIPPING_PRICE,
	'HITMEISTER_WAREHOUSE'=>HITMEISTER_WAREHOUSE,
	'HITMEISTER_OFFER_FROM_DATE'=>HITMEISTER_OFFER_FROM_DATE,
	'HITMEISTER_OFFER_LAST_UPDATE'=>HITMEISTER_OFFER_LAST_UPDATE,
	'HITMEISTER_UNIT_UPDATE'=>HITMEISTER_UNIT_UPDATE,
	'HITMEISTER_REALLY_DELETE_UNIT'=>HITMEISTER_REALLY_DELETE_UNIT,
	'HITMEISTER_PRODUCT_BASE_URL'=>'https://www.kaufland.de/product/',
	'HITMEISTER_SELLER_TIEFPREIS_AUTOMATIC'=>MODULE_OTHER_YES_HITMEISTER_API_SELLER_TIEFPREIS_AUTOMATIC,
	'HITMEISTER_PRELOADER_IMAGE'=>'http://i.stack.imgur.com/FhHRx.gif',
	'HITMEISTER_ORDERS'=>HITMEISTER_ORDERS,
	'SELLER_ORDERS'=>$seller_orders,
	'HITMEISTER_ORDER_FROM_DATE'=>HITMEISTER_ORDER_FROM_DATE,
	'HITMEISTER_ORDER_QUANTITY'=>HITMEISTER_ORDER_QUANTITY,
	'HITMEISTER_YES'=>HITMEISTER_YES,
	'HITMEISTER_NO'=>HITMEISTER_NO,
	'HITMEISTER_PROCESS_SELECTED_ORDER_UNITS'=>HITMEISTER_PROCESS_SELECTED_ORDER_UNITS,
	'HITMEISTER_PLEASE_SELECT'=>HITMEISTER_PLEASE_SELECT,
	'HITMEISTER_ORDER_UNIT_ACTION_SENT'=>HITMEISTER_ORDER_UNIT_ACTION_SENT,
	'HITMEISTER_ORDER_UNIT_ACTION_FULFILL'=>HITMEISTER_ORDER_UNIT_ACTION_FULFILL,
	'HITMEISTER_ORDER_UNIT_ACTION_CANCEL'=>HITMEISTER_ORDER_UNIT_ACTION_CANCEL,
	'HITMEISTER_ORDER_UNIT_ACTION_REFUND'=>HITMEISTER_ORDER_UNIT_ACTION_REFUND,
        'HEADING_TITLE'=>HITMEISTER_HEADING_TITLE,
        'HITMEISTER_NO_EXPORT_CONFIG'=>HITMEISTER_NO_EXPORT_CONFIG,
        'HITMEISTER_CATEGORY_STRUCT_UPDATE'=>HITMEISTER_CATEGORY_STRUCT_UPDATE,
    'TICKETS'=>$tickets,
    'INPUT_ID_ORDER'=>xtc_draw_input_field('id_order',$id_order,'size="8" maxlength="16"'),
    'TICKETS_ARRAY'=>$tickets_array,
    'HITMEISTER_TICKETS'=>HITMEISTER_TICKETS,
    'PAGER_UNITS'=>$PAGER_UNITS,
    'INPUT_HITMEISTER_ORDERS_STATUSES'=>xtc_draw_pull_down_menu('hitmeister_order_status',$hitmeister_orders_statuses,$hitmeister_order_status),
    'HITMEISTER_IMPORT_YES_PRODUCTS_INTRO'=>HITMEISTER_IMPORT_YES_PRODUCTS_INTRO,
    'ID_ITEM'=>(isset($_GET['id_item'])) ? $_GET['id_item'] : '',
    'IMPORT_CSV_FILES'=>$import_files,
    'REALLY_IMPORT_CSV_FILE_LINK'=>REALLY_IMPORT_CSV_FILE_LINK,
    'HITMEISTER_PRODUCTS_IMPORT_INTRO'=>HITMEISTER_PRODUCTS_IMPORT_INTRO,
    'TEXT_SYNC_QUANTITY_INTRO'=>TEXT_SYNC_QUANTITY_INTRO,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'LINK_ALLOCATE_UNKNOWN_BY_EAN'=>xtc_href_link(basename(__FILE__),'action=allocate_unknown_by_ean'),
    'TAB'=>(isset($_GET['tab'])) ? $_GET['tab'] : '',
    'TEXT_DELETE_ORDER_INVOICE'=>TEXT_DELETE_ORDER_INVOICE,
    'TEXT_UPLOADED_INVOICES'=>TEXT_UPLOADED_INVOICES,
    'HITMEISTER_UNALLOCATE_PRODUCT'=>HITMEISTER_UNALLOCATE_PRODUCT,
    'HITMEISTER_UNALLOCATE_PRODUCT_INTRO'=>HITMEISTER_UNALLOCATE_PRODUCT_INTRO,
    'NOT_A_VALID_PRODUCTS_ID'=>NOT_A_VALID_PRODUCTS_ID,
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('hitmeister.tpl');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
