<?php
namespace YES4Trade\Model;

/**
 * Description of category
 *
 * @author mario
 */
class categories_description  extends \YES4Trade\Model\BaseType {
    const TABLE_NAME = 'categories_description';
    
    private static $propertyTypes = [
        'categories_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_id'
        ],
        'language_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'language_id'
        ],
        'categories_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_name'
        ],
        'categories_heading_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_heading_title'
        ],
        'categories_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_description'
        ],
        'categories_meta_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_meta_title'
        ],
        'categories_meta_description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_meta_description'
        ],
        'categories_meta_keywords' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'categories_meta_keywords'
        ],
        'google_product_feed_category' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'google_product_feed_category'
        ],
        'amazon_flatfile' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_flatfile'
        ],
        'amazon_browse_node_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_browse_node_id'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }
    
    private static function cache_delete(){
        global $InstanceCache;
        \yescache_helper::cache_bump_generation($InstanceCache, 'categories');        
    }
    
    public function create(){
        $data = self::convert_values( $this->toArray(),self::$propertyTypes );
        yes_db_perform(self::TABLE_NAME, $data);
        self::cache_delete();
        return xtc_db_insert_id();
    }
    
    
    public function update(){
        $data = self::convert_values( $this->toArray(),self::$propertyTypes );
        if(!isset($this->categories_id) or $this->categories_id < 1){
            throw new Exception('Need categories_id to update categories_description');
        }
        if(!isset($this->language_id) or $this->language_id < 1){
            throw new Exception('Need language_id to update categories_description');
        }
        yes_db_perform(self::TABLE_NAME, $data,'update',[
            'categories_id' => $this->categories_id,
            'language_id' => $this->language_id,
        ]);
        self::cache_delete();
    }
    
    public static function delete( int $category_id, int $language_id = -1){
        $parameters = [
            'cat_id'=>$category_id,
        ];
        if($language_id <= 0){
            $query_raw = sprintf(
                "delete from %s where categories_id =:cat_id",
                self::TABLE_NAME
            );
        }else{
            $parameters['language_id'] = $language_id;
            $query_raw = sprintf("delete from %s where categories_id =:cat_id AND language_id=:language_id",
                self::TABLE_NAME
            );
        }
        yes_query($query_raw, $parameters);
        self::cache_delete();
    }
    
    public static function get_by_categories_id_and_language_id( int $categories_id, int $language_id, array $select_fields = [] ){
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE categories_id=:id AND language_id=:language_id",
                $select_field_string,self::TABLE_NAME
            ),['id'=>$categories_id,'language_id'=>$language_id]
        );
        if(sizeOf($query)){
            $record = current($query);
            $data = self::convert_values( $record,self::$propertyTypes );
            return new self($data);
        }
        return null;
    }
    
    /**
     * Array aller categories_description Eintraege zur catID
     * Es werden anhand der categories_id alle Eintraege zurueckgegeben
     * die dem categories_id Parameter entsprechen
     * 
     * @param int $categories_id
     * @param array $select_fields
     * @return array
     */
    public static function get_by_categories_id( int $categories_id, array $select_fields = [] ):array{
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE categories_id=:id",
                $select_field_string,self::TABLE_NAME
            ),['id'=>$categories_id]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values( $record,self::$propertyTypes ));
        }
        return $items;
    }
    
    /**
     * Alle Eintraege einer Sprache loeschen
     * Wird verwendet in languages.php beim loeschen von sprachen
     * @param int $language_id
     */
    public static function delete_by_language_id( int $language_id ){
        yes_query(sprintf(
            "DELETE FROM %s WHERE language_id=:language_id",
                self::TABLE_NAME
            ),['language_id'=>$language_id]
        );
        self::cache_delete();
    }
    
    public static function get_retoure_categories_id():int{
        global $InstanceCache;
        $cache_key = 'categories.RETOURE_ID';
        $cache_group = 'categories';
        $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);
        $CachedString = $InstanceCache->getItem($key); // cache group
        if (!$CachedString->isHit()) {
            $query = yes_query(sprintf(
                "SELECT categories_id FROM %s WHERE categories_name='RETOURE'",
                self::TABLE_NAME
            ));
            $categories_id = 0;
            if(sizeOf($query)){
                $record = current($query);
                $categories_id = intval($record['categories_id']);
            }
            $CachedString->set($categories_id)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $categories_id = intval($CachedString->get());
        }
        return $categories_id;
    }
}
