<?php

namespace YES4Trade\Model;

class ebay_emails extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_emails';
    const TABLE_INDEX = 'id';
    const READ_STATUS1 = '1';
    const READ_STATUS0 = '0';
    const REPLY_STATUS1 = '1';
    const REPLY_STATUS0 = '0';
    const OWNMAIL1 = '1';
    const OWNMAIL0 = '0';
    const DELETED1 = '1';
    const DELETED0 = '0';
    const SAVED1 = 1;
    const SAVED0 = 0;
    const ALLOCATION_STATUS1 = '1';
    const ALLOCATION_STATUS0 = '0';


    private static $propertyTypes = [
        'id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'id'
        ],
        'subject' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'subject'
        ],
        'mailto' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'mailto'
        ],
        'from_name' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'from_name'
        ],
        'from_email' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'from_email'
        ],
        'messageid' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'messageid'
        ],
        'date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date'
        ],
        'ebay_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_id'
        ],
        'customers_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'customers_id'
        ],
        'orders_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'orders_id'
        ],
        'read_status' => [
            'type' => 'string', // '0' oder '1'
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'read_status'
        ],
        'reply_status' => [
            'type' => 'string', // '0' oder '1'
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'reply_status'
        ],
        'allocation_status' => [
            'type' => 'string',  // '0' oder '1'
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'allocation_status'
        ],
        'saved' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'saved'
        ],
        'deleted' => [
            'type' => 'string', // '0' oder '1'
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'deleted'
        ],
        'ownmail' => [
            'type' => 'string', // '0' oder '1'
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ownmail'
        ],
        'reply_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'reply_id'
        ],
        'editor' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'editor'
        ],
        'ebay_user' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_user'
        ],
        'format' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'format'
        ],
        'body' => [ // nicht in verwendung
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'body'
        ],
        'email_body_id' => [ // nicht in verwendung
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'email_body_id'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create():int{
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
        \YES4Trade\Model\ebay_email_bodys::delete($index);
        \YES4Trade\Model\ebay_email_attachments::delete_by_email_id($index);
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_id(int $id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

    /**
     * wrapper function for create entry
     * @param mixed $data
     * 
     * @return int insert_id
     */
    public static function create_ebay_emails(array $data, string $body = ''):int{
        $new = new self($data);
        $insert_id = $new->create();
        if(!empty($body)){
            \YES4Trade\Model\ebay_email_bodys::create_ebay_email_bodys([
                'email_body'=>$body,
                'email_id'=>intval($insert_id)
            ]);
        }
        return $insert_id;
    }

    public static function filter(array $filter = [], array $select_fields = [], int $limit = 0){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $filter_sql = '';
        $parameters = [];
        if(sizeOf($filter)){
            $filter_values = [];
            foreach($filter as $field=>$value){
                $filter_values[] = $field.'=:'.$field;
                $parameters[$field] = $value;
            }
            $filter_sql = 'WHERE '.implode(' AND ',$filter_values);
        }

        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee %s ORDER BY ee.date DESC %s",
				$select_field_string,self::TABLE_NAME, $filter_sql,$limit_sql
            ),$parameters
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function get_abonded(\DateTime $abonded_date, array $select_fields = [], int $start = -1, int $limit = -1){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        $parameters = [
            'abonded_date'=>$abonded_date->format('Y-m-d H:i:s')
        ];
        if($start > -1 and $limit > -1){
            $limit_sql = " LIMIT :start, :limit";
            $parameters['start'] = $start;
            $parameters['limit'] = $limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE ee.date<:abonded_date ORDER BY ee.date %s",
				$select_field_string,self::TABLE_NAME, $limit_sql
            ),$parameters
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function change_customers_id(int $original_customers_id, int $new_customers_id){
        yes_query(sprintf(
            "UPDATE %s SET customers_id=:new_customers_id WHERE customers_id=:original_customers_id",
                self::TABLE_NAME
            ),[
                'new_customers_id'=>$new_customers_id,
                'original_customers_id'=>$original_customers_id
            ]
        );
    }

    public static function change_mailto(string $original_mailto, string $new_mailto){
        yes_query(sprintf(
            "UPDATE %s SET mailto=:new_mailto WHERE mailto=:original_mailto",
                self::TABLE_NAME
            ),[
                'new_mailto'=>$new_mailto,
                'original_mailto'=>$original_mailto
            ]
        );
    }

    public static function change_from_email(string $original_from_email, string $new_from_email){
        yes_query(sprintf(
            "UPDATE %s SET from_email=:new_from_email WHERE from_email=:original_from_email",
                self::TABLE_NAME
            ),[
                'new_from_email'=>$new_from_email,
                'original_from_email'=>$original_from_email
            ]
        );
    }

    public static function update_by_from_email(array $data ){
        $from_email = $data['from_email'];
		$data = self::convert_values( $data,self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
        unset($data['from_email']);
		yes_db_perform(self::TABLE_NAME, $data,'update',['from_email'=>$from_email]);
    }

    /**
     * wrapper function for update item
     * @param array $data
     * 
     * @return none
     */
    public static function update_ebay_email(array $data){
        $upd = new self($data);
        $upd->update();
    }

    public static function auto_allocate_addresses(array $addresses){
        // fuegt einfache ' um die Array Values
        // so dass 'email@example.com','email2@example.com' usw herauskommt
        $addresses_string = array_map(fn($value) => "'$value'", $addresses);
        yes_query(sprintf(
            "UPDATE %s SET allocation_status='1',saved=1 WHERE from_email IN (:addresses_string) AND allocation_status='0'",
            self::TABLE_NAME
            ),['addresses_string'=>implode(',',$addresses_string)]
        );
    }

    /**
     * liefert ein array der objekte zu einer customers_id - ausser einer bestimmten id
     * also alle emails des users ausser der angegebenen id
     * 
     * @param int $customers_id
     * @param int $id exclude id
     * @param array $select_fields
     * @param int $limit
     * @param array $order_by
     * 
     * @return array of objects
     */
    public static function get_by_customers_id_excluding_id(int $customers_id,int $id, array $select_fields = [], int $limit = 0, array $order_by = []){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }

        $order_by_sql = 'ORDER BY ee.date DESC';
        if(sizeOf($order_by)){
            $order_by_sql = 'ORDER BY '.implode(',',$order_by);
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE ee.customers_id=:customers_id AND ee.id != :id %s %s",
				$select_field_string,self::TABLE_NAME, $order_by_sql,$limit_sql
            ),[
                'customers_id'=>$customers_id,
                'id'=>$id
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function get_by_ebay_id_excluding_id(string $ebay_id, int $id, array $select_fields = [], int $limit = 0, array $order_by = []){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}

        $order_by_sql = ' ORDER BY ee.date DESC';
        if(sizeOf($order_by)){
            $order_by_sql = ' ORDER BY '.implode(',',$order_by);
        }
        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE ee.ebay_id=:ebay_id AND ee.id != :id %s %s",
				$select_field_string,self::TABLE_NAME, $order_by_sql, $limit_sql
            ),[
                'ebay_id'=>$ebay_id,
                'id'=>$id
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function get_by_email_address_excluding_id(string $from_email, int $id, array $select_fields = [], int $limit = 0){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        if($limit > 0){
            $limit_sql .= ' LIMIT '.$limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE (from_email=:email or mailto=:email) AND ee.id != :id ORDER BY ee.date DESC %s",
				$select_field_string,self::TABLE_NAME, $limit_sql
            ),[
                'email'=>$from_email,
                'id'=>$id
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function get_by_from_email(string $from_email, array $select_fields = [], int $limit = 0){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE from_email=:email or from_email=:email_in_klammern ORDER BY ee.date DESC %s",
				$select_field_string,self::TABLE_NAME, $limit_sql
            ),[
                'email'=>$from_email,
                'email_in_klammern'=>sprintf('<%s>',$from_email),
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function get_by_mailto(string $from_email, array $select_fields = [], int $limit = 0){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE mailto=:email or mailto=:email_in_klammern ORDER BY ee.date DESC %s",
				$select_field_string,self::TABLE_NAME, $limit_sql
            ),[
                'email'=>$from_email,
                'email_in_klammern'=>sprintf('<%s>',$from_email),
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }				

    public static function get_by_from_email_or_customers_id(string $email_address, int $customers_id, array $select_fields = [], int $limit = 0){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }
        $params = [];
        $sql_addon = '';
        if(!empty($email_address)){
            $sql_addon .= ' from_email LIKE :email ';
            $params['email'] = '%'.$email_address.'%';
        }
        if($customers_id > 0){
            if(!empty($sql_addon)){
                $sql_addon .= ' OR ';
            }
            $sql_addon .= ' customers_id=:id ';
            $params['id'] = $customers_id;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE %s ORDER BY customers_id DESC,UNIX_TIMESTAMP(date) desc %s",
				$select_field_string,
                self::TABLE_NAME, 
                $sql_addon,
                $limit_sql
            ),$params
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function get_by_orders_id(int $orders_id,array $select_fields = [], int $limit = 0){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
        $limit_sql = '';
        if($limit > 0){
            $limit_sql = ' LIMIT '.$limit;
        }
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE orders_id = :id ORDER BY customers_id DESC,UNIX_TIMESTAMP(date) desc %s",
				$select_field_string,self::TABLE_NAME, $limit_sql
            ),[
                'id'=>$orders_id,
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function count_own_unread_by_date(\DateTime $date){
        $query = yes_query(sprintf(
            "SELECT count(id) AS anz FROM %s ee WHERE ee.date > :ee_date AND ownmail=:ownmail AND read_status=:read_status",
                self::TABLE_NAME
            ),[
                'ee_date'=>$date->format('Y-m-d H:i:s'),
                'ownmail'=>self::OWNMAIL0,
                'read_status'=>self::READ_STATUS0
            ],true
        );
        return intval($query['anz']);
    }

    public static function get_undeleted_by_customers_id_or_from_email_addresses(int $customers_id,array $email_addresses, array $select_fields = []){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s ee WHERE (customers_id=:id or from_email IN(:emails)) and deleted=:deleted ORDER BY ee.date",
				$select_field_string,self::TABLE_NAME
            ),[
                'emails'=>implode(',',$email_addresses),
                'id'=>$customers_id,
                'deleted'=>self::DELETED0
            ]
		);
		foreach($query as $record){
		    $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
}
