<?php
/**
 * AdjustmentEvent
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Finances
 *
 * The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.
 *
 * The version of the OpenAPI document: v0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\FinancesV0;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * AdjustmentEvent Class Doc Comment
 *
 * @category Class
 * @description An adjustment to the seller's account.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class AdjustmentEvent extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AdjustmentEvent';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'adjustment_type' => 'string',
        'posted_date' => 'string',
        'adjustment_amount' => '\SellingPartnerApi\Model\FinancesV0\Currency',
        'adjustment_item_list' => '\SellingPartnerApi\Model\FinancesV0\AdjustmentItem[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'adjustment_type' => null,
        'posted_date' => null,
        'adjustment_amount' => null,
        'adjustment_item_list' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'adjustment_type' => 'AdjustmentType',
        'posted_date' => 'PostedDate',
        'adjustment_amount' => 'AdjustmentAmount',
        'adjustment_item_list' => 'AdjustmentItemList'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'adjustment_type' => 'setAdjustmentType',
        'posted_date' => 'setPostedDate',
        'adjustment_amount' => 'setAdjustmentAmount',
        'adjustment_item_list' => 'setAdjustmentItemList'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'adjustment_type' => 'getAdjustmentType',
        'posted_date' => 'getPostedDate',
        'adjustment_amount' => 'getAdjustmentAmount',
        'adjustment_item_list' => 'getAdjustmentItemList'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['adjustment_type'] = $data['adjustment_type'] ?? null;
        $this->container['posted_date'] = $data['posted_date'] ?? null;
        $this->container['adjustment_amount'] = $data['adjustment_amount'] ?? null;
        $this->container['adjustment_item_list'] = $data['adjustment_item_list'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets adjustment_type
     *
     * @return string|null
     */
    public function getAdjustmentType()
    {
        return $this->container['adjustment_type'];
    }

    /**
     * Sets adjustment_type
     *
     * @param string|null $adjustment_type The type of adjustment.
     *   Possible values:
     *   * FBAInventoryReimbursement - An FBA inventory reimbursement to a seller's account. This occurs if a seller's inventory is damaged.
     *   * ReserveEvent - A reserve event that is generated at the time of a settlement period closing. This occurs when some money from a seller's account is held back.
     *   * PostageBilling - The amount paid by a seller for shipping labels.
     *   * PostageRefund - The reimbursement of shipping labels purchased for orders that were canceled or refunded.
     *   * LostOrDamagedReimbursement - An Amazon Easy Ship reimbursement to a seller's account for a package that we lost or damaged.
     *   * CanceledButPickedUpReimbursement - An Amazon Easy Ship reimbursement to a seller's account. This occurs when a package is picked up and the order is subsequently canceled. This value is used only in the India marketplace.
     *   * ReimbursementClawback - An Amazon Easy Ship reimbursement clawback from a seller's account. This occurs when a prior reimbursement is reversed. This value is used only in the India marketplace.
     *   * SellerRewards - An award credited to a seller's account for their participation in an offer in the Seller Rewards program. Applies only to the India marketplace.
     *
     * @return self
     */
    public function setAdjustmentType($adjustment_type)
    {
        $this->container['adjustment_type'] = $adjustment_type;

        return $this;
    }
    /**
     * Gets posted_date
     *
     * @return string|null
     */
    public function getPostedDate()
    {
        return $this->container['posted_date'];
    }

    /**
     * Sets posted_date
     *
     * @param string|null $posted_date A date string in ISO 8601 format.
     *
     * @return self
     */
    public function setPostedDate($posted_date)
    {
        $this->container['posted_date'] = $posted_date;

        return $this;
    }
    /**
     * Gets adjustment_amount
     *
     * @return \SellingPartnerApi\Model\FinancesV0\Currency|null
     */
    public function getAdjustmentAmount()
    {
        return $this->container['adjustment_amount'];
    }

    /**
     * Sets adjustment_amount
     *
     * @param \SellingPartnerApi\Model\FinancesV0\Currency|null $adjustment_amount adjustment_amount
     *
     * @return self
     */
    public function setAdjustmentAmount($adjustment_amount)
    {
        $this->container['adjustment_amount'] = $adjustment_amount;

        return $this;
    }
    /**
     * Gets adjustment_item_list
     *
     * @return \SellingPartnerApi\Model\FinancesV0\AdjustmentItem[]|null
     */
    public function getAdjustmentItemList()
    {
        return $this->container['adjustment_item_list'];
    }

    /**
     * Sets adjustment_item_list
     *
     * @param \SellingPartnerApi\Model\FinancesV0\AdjustmentItem[]|null $adjustment_item_list A list of information about items in an adjustment to the seller's account.
     *
     * @return self
     */
    public function setAdjustmentItemList($adjustment_item_list)
    {
        $this->container['adjustment_item_list'] = $adjustment_item_list;

        return $this;
    }
}


