<?php
class amazon_export
{
    var $flatfiles_path,$language;
    public function __construct($language){
	$this->language = $language;
	$this->flatfiles_path = DIR_FS_ADMIN.'includes/amazon_flatfiles/'.$this->language;
    }
    
    public function get_amazon_flatfiles(){
	$path = $this->flatfiles_path;
	$dirs = array();
	if(!is_dir($path)) return $dirs;
	if ($handle = opendir($path)) {
	    while (false !== ($entry = readdir($handle))) {
		if($entry != '.' and $entry != '..' and $entry != 'CVS'){
		    $flatfile = '';
		    $btgfile = '';
		    if ($handle2 = opendir($path.'/'.$entry)) {
			while (false !== ($file = readdir($handle2))) {
			    if($file != '.' and $file != '..'){
				if(substr($file,0,4) == 'Flat'){
				    $flatfile = $file;
				}
				if(substr($file,strlen($file)-9,strlen($file)) == '_TTH_.csv'){
				    $btgfile = $file;
				}
			    }
			}
			closedir($handle2);
		    }
		    $dirs[] = array('id'=>$flatfile,'text'=>$entry,'btgfile'=>$btgfile);
		}
	    }
	    closedir($handle);
	}
	return $dirs;
    }

    public function get_amazon_browse_node_title($flat_file,$browse_node_id){
	$path = $this->flatfiles_path;
	$name = '';
	if(!is_dir($path)) return $name;
	if ($handle = opendir($path)) {
	    while (false !== ($entry = readdir($handle))) {
		if($entry == '.' or $entry == '..') continue;
		if ($handle2 = opendir($path.'/'.$entry)) {
		    while (false !== ($file = readdir($handle2))) {
			if(substr($file,strlen($file)-9,strlen($file)) != '_TTH_.csv') continue;
			$content = file_get_contents($path.'/'.$entry.'/'.$file);
			$rows = explode(PHP_EOL,$content);
			foreach($rows as $row){
			    $cols = explode(',',$row);
			    if($cols[0] == $browse_node_id)
				$name = $cols[1];
			}
		    }
		    closedir($handle2);
		}
	    }
	    closedir($handle);
	}
	return $name;
    }

    public function get_amazon_template_location($template){
	$path = $this->flatfiles_path;
	$return_path = '';
	if(!is_dir($path)) return $dirs;
	if ($handle = opendir($path)) {
	    while (false !== ($entry = readdir($handle))) {
		if($entry != '.' and $entry != '..'){
		    if ($handle2 = opendir($path.'/'.$entry)) {
			while (false !== ($file = readdir($handle2))) {
			    if($file == $template){
				$return_path = $path.'/'.$entry;
			    }
			}
			closedir($handle2);
		    }
		}
	    }
	    closedir($handle);
	}
	return $return_path;
    }
    
    public function get_flatfile_config($template,$config_name){
	$config_file = $this->get_amazon_template_location($template).'/VALUES-'.$template;
	if(!is_file($config_file)){
	    return array();
	}
	$content = file_get_contents($config_file);
	$lines = explode(PHP_EOL,$content);
	$configs = explode(",",$lines[1]);
	foreach($configs as $nr => $config){
	    if($config == $config_name){
		$config_key = $nr;
	    }
	}
	if(!isset($config_key)) return array();
	$entries = array();
	foreach($lines as $nr => $line){
	    if($nr > 1)
		$_entries = explode(',',$line);
		if(isset($_entries[$config_key]) and $_entries[$config_key] != '')
		    $entries[] = $_entries[$config_key];
	}
	return $entries;
    }
}