<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of amz_Feedhandler
 *
 * @author mario
 */
require('includes/classes/amz_FeedhandlerItem.php');
class amz_Feedhandler {
	var $feedId;
	var $feed_processing_status;
	var $amazon_feeds_id;
	var $processed;
	var $items = array();
	var $ErrorMsg = array();
	var $feed_info;
	var $service;
	var $helper;
	var $feedType;
	var $selling_partner_id;

	function __construct($id){
		if(!$id){
			$this->setErrorMsg("Kein Feed angegeben");
			return '-1';
		}
		$this->setFeedId($id);
                $af = \YES4Trade\Model\amazon_feeds::get_by_feed_submission_id($id);
		if($af === null){
                    $this->setErrorMsg(sprintf(MSG_ERROR_FEED_UNKNOWN,$id));
                    $this->setProcessed(true);
                    return '-1';
		}
		$this->setProcessed($af->processed);
		$this->setFeed_processing_status($af->feed_processing_status);
		$this->setAmazon_feeds_id($af->amazon_feeds_id);
		$this->setFeedType($af->feed_type);
                $this->selling_partner_id = $af->selling_partner_id;
		$items = array();
		switch($af->feed_type){
			case '_POST_PRODUCT_PRICING_DATA_': // veraltet
			case 'POST_PRODUCT_PRICING_DATA': // veraltet
                        case 'JSON_LISTINGS_FEED.price':
                            $amazon_feeds_price_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_amazon_feeds_id(
                                intval($af->amazon_feeds_id)
                            );
                            foreach($amazon_feeds_price_items as $record){
                                $pID = yes_get_products_id_from_amazon_sku($record->sku,$this->selling_partner_id);
                                $items[] = new amz_FeedhandlerItem(array(
                                        'sku'=>$record->sku,
                                        'price'=>(float)$record->price,
                                        'processed'=>(int)$record->processed,
                                        'products_id'=>(int)$pID,
                                        'selling_partner_id'=>$this->selling_partner_id
                                ));
                            }
                            break;
                        case 'JSON_LISTINGS_FEED.quantity':
			case '_POST_INVENTORY_AVAILABILITY_DATA_': // veraltet
			case 'POST_INVENTORY_AVAILABILITY_DATA': // veraltet
				$query = xtc_db_query(sprintf(
					"SELECT sku,qty,processed FROM amazon_feeds_quantity_items afqi WHERE afqi.amazon_feeds_id=%s",
					$record['amazon_feeds_id']
				));
				while($record = xtc_db_fetch_array($query)){
					$pID = yes_get_products_id_from_amazon_sku($record['sku'],$this->merchant_id);
					$items[] = new amz_FeedhandlerItem(array(
						'sku'=>$record['sku'],
						'qty'=>$record['qty'],
						'processed'=>$record['processed'],
						'products_id'=>$pID,
						'merchant_id'=>$this->merchant_id
					));
				}
				break;
			case 'POST_ORDER_FULFILLMENT_DATA':
			case '_POST_ORDER_FULFILLMENT_DATA_':
				$query = xtc_db_query(sprintf(
					"SELECT amazon_order_item_code,processed FROM amazon_feeds_order_fulfillments afof WHERE afof.amazon_feeds_id=%s",
					$record['amazon_feeds_id']
				));
				while($record = xtc_db_fetch_array($query)){
					$items[] = new amz_FeedhandlerItem(array(
						'amazon_order_item_code'=>$record['amazon_order_item_code'],
						'processed'=>$record['processed'],
						'shipper_tracking_number'=>$record['shipper_tracking_number']
					));
				}
				break;
		}
		$this->setItems($items);
	}
	public function getFeedId() {
		return $this->feedId;
	}

	public function setFeedId($feedId) {
		$this->feedId = $feedId;
	}

	public function getFeed_processing_status() {
		return $this->feed_processing_status;
	}

	public function setFeed_processing_status($feed_processing_status) {
		$this->feed_processing_status = $feed_processing_status;
	}

	public function getItems() {
		return $this->items;
	}

	public function setItems($items,$id = -1) {
            if($id > 0){
                $this->items[$id] = $items;
            }else{
                $this->items = $items;
            }
	}

	public function getAmazon_feeds_id() {
		return $this->amazon_feeds_id;
	}

	public function setAmazon_feeds_id($amazon_feeds_id) {
		$this->amazon_feeds_id = $amazon_feeds_id;
	}

	public function getErrorMsg() {
		return $this->ErrorMsg;
	}

	public function getProcessed() {
		return $this->processed;
	}

	public function setProcessed($processed) {
		$this->processed = $processed;
	}


	public function setErrorMsg($ErrorMsg,$id = -1) {
		if($id > 0)
			$this->ErrorMsg[$id] = $ErrorMsg;
		else
			$this->ErrorMsg[] = $ErrorMsg;
	}

	public function getFeed_info() {
		return $this->feed_info;
	}

	public function setFeed_info($feed_info) {
		$this->feed_info = $feed_info;
	}

	public function getService() {
		return $this->service;
	}

	public function setService($service) {
		$this->service = $service;
	}

	public function getFeedType() {
		return $this->feedType;
	}

	public function setFeedType($feedType) {
		$this->feedType = $feedType;
	}

	private function update_yes_qty(){
		$items = $this->getItems();
		if(!sizeOf($items)){
			$this->setErrorMsg(sprintf(
				MSG_ERROR_FEED_UNKNOWN_SKU,
				$this->getFeedId(), $item->getSku()
			));
			return false;
		}
		$processed = 0;
		foreach($items as $k=>$item){
			switch($item->getProcessed()){
				case 1:
					$processed++;
					break;
				case 0:
					if($item->getProducts_id() < 1){
						$this->setErrorMsg(sprintf(
							MSG_ERROR_FEED_UNKNOWN_PRODUCTS_ID,
							$this->getFeedId(), $item->getSku()
						));
					}else{
						$item->update_qty_db($this->getAmazon_feeds_id());
					}
					$processed++;
					break;
			}
		}
		if($processed == sizeOf($items)){
			$this->setProcessed(1);
			$this->delete_feed_info_db();
			return true;
		}
		return false;
	}

	private function update_yes_price(){
		$items = $this->getItems();
		if(!sizeOf($items)){
			$this->setErrorMsg(sprintf(
				MSG_ERROR_FEED_UNKNOWN_SKU,
				$this->getFeedId(), $item->getSku()
			));
			return false;
		}
		$processed = 0;
		foreach($items as $k=>$item){
			switch($item->getProcessed()){
				case 1:
					$processed++;
					break;
				case 0:
					if($item->getProducts_id() < 1){
						$this->setErrorMsg(sprintf(
							MSG_ERROR_FEED_UNKNOWN_PRODUCTS_ID,
							$this->getFeedId(), $item->getSku()
						));
					}else{
						$item->update_price_db($this->getAmazon_feeds_id());
					}
					$processed++;
					break;
			}
		}
		if($processed == sizeOf($items)){
			$this->setProcessed(1);
			$this->delete_feed_info_db();
			return true;
		}
		return false;
	}

	private function update_order_fulfillment(){
		$items = $this->getItems();
		if(!sizeOf($items)){
			$this->setErrorMsg(sprintf(
				MSG_ERROR_FEED_UNKNOWN_AMAZON_ORDER_ITEM_CODE,
				$this->getFeedId(), $item->getSku()
			));
			return false;
		}
		$processed = 0;
		foreach($items as $k=>$item){
			switch($item->getProcessed()){
				case 1:
					$processed++;
					break;
				case 0:
					if( !empty($item->getAmazon_order_item_code()) ){
						$item->update_order_fulfillment(
							$this->getAmazon_feeds_id()
						);
					}
					$processed++;
					break;
			}
		}
		if($processed == sizeOf($items)){
			$this->setProcessed(1);
			$this->delete_feed_info_db();
			return true;
		}
		return false;
	}

	/**
	 * - LIEFERT INFORMATIONEN ZU EINEM AMAZON FEED ANHAND DER FEEDSUBMISSIONID
	 *
	 * @param object $service
	 * @return object
	 */
	public function getFeedInfo(){
		$service = $this->getService();
		$A = $this->getHelper();
		if($this->getFeedId() == ''){
			throw new Exception('Feed ID Param not set');
			return false;
		}
		$auth_params = $A->get_auth_data_array($this->merchant_id);
		$parameters = array (
			'Marketplace' => $auth_params['marketplace_id'],
			'Merchant' => $auth_params['merchant_id'],
			'MaxCount' => 1,
			'FeedSubmissionIdList' => array('Id'=>array($this->getFeedId()))
		);
		if(!empty($auth_params['mwsauthtoken'])){
			$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
		}
		$request = new MarketplaceWebService_Model_GetFeedSubmissionListRequest($parameters);
		try{
				$response = $service->getFeedSubmissionList($request);
		} catch (MarketplaceWebService_Exception $ex) {
			if(!empty($ex->getStatusCode())){
				$this->setErrorMsg( "Response Status Code: " . $ex->getStatusCode());
			}
			if(!empty($ex->getErrorCode())){
				$this->setErrorMsg( "Error Code: " . $ex->getErrorCode());
			}
			if(!empty($ex->getErrorType())){
				$this->setErrorMsg( "Error Type: " . $ex->getErrorType());
			}
			if(!empty($ex->getRequestId())){
				$this->setErrorMsg( "Request ID: " . $ex->getRequestId());
			}
			if(!empty($ex->getXML())){
				$this->setErrorMsg( "XML: " . $ex->getXML());
			}
			throw new Exception($ex->getMessage()."<br /><i>".implode("<br />",$this->getErrorMsg())."</i>");
		}
		$getFeedSubmissionListResult = $response->getGetFeedSubmissionListResult();
		$feedSubmissionInfoList = $getFeedSubmissionListResult->getFeedSubmissionInfoList();
		return current($feedSubmissionInfoList);
	}

	/**
	 * AKTUALISIERT DEN feed_processing_status IN DER TABELLE amazon_feeds
	 *
	 * @param object $info
	 */
	public function update_feed_info_db(){
		$info = $this->getFeed_info();
                $upd = new \YES4Trade\Model\amazon_feeds([
                    'amazon_feeds_id'=>$this->getAmazon_feeds_id(),
                    'feed_processing_status'=>$info->getProcessingStatus()
                ]);
                $upd->update();
		$this->setFeed_processing_status($info->getProcessingStatus());
	}

	public function delete_feed_info_db(){
            \YES4Trade\Model\amazon_feeds::delete(intval($this->getAmazon_feeds_id()));
            $this->items = array();
	}

	/**
	 * VERSUCHE DEN FEED ABZUARBEITEN
	 *
	 * @return bool
	 */
	public function process_feed(){
                $fInfo = $this->getFeed_info();
		if(!is_object($fInfo) or $fInfo->getProcessingStatus() != 'DONE'){
			return false;
		}
		if($this->getProcessed() == 1){
			return true;
		}
		switch($this->getFeedType()){
                        case 'JSON_LISTINGS_FEED.quantity':
			case '_POST_INVENTORY_AVAILABILITY_DATA_': // veraltet
			case 'POST_INVENTORY_AVAILABILITY_DATA': // veraltet
				if($this->update_yes_qty()){
					return true;
				}
				break;
                        case 'JSON_LISTINGS_FEED.price':
			case '_POST_PRODUCT_PRICING_DATA_': // veraltet
			case 'POST_PRODUCT_PRICING_DATA': // veraltet
				if($this->update_yes_price()){
					return true;
				}
				break;
			case '_POST_ORDER_FULFILLMENT_DATA_':
			case 'POST_ORDER_FULFILLMENT_DATA':
				if($this->update_order_fulfillment()){
					return true;
				}
				break;
		}
		return false;
	}

	public function set_feed_info_from_api( $feedApiInstance ){
            try{
                $info = $feedApiInstance->getFeed($this->getFeedId());
                $this->setFeed_info($info);
                return true;
            }catch(Exception $e){
                    $this->setErrorMsg($e->getMessage());
                    return false;
            }
	}
	
	public function getHelper() {
	    return $this->helper;
	}

	public function setHelper($helper) {
	    $this->helper = $helper;
	}

	
}

