<?php
/**
 * Funktionen um Feeds an Amazon zu senden
 *
 * @author mario
 */
class SubmitFeed {

	/**
	 * Liefert den XML Feed um den Bestand eines Artikels bei Amazon zu aendern
	 *
	 * @param String $sku
	 * @param Integer $qty
	 * @return String
	 */
	public function get_update_qty_feed($sku,$qty,$fulfillment_latency){
		$xml = $this->get_base_xml();
		$feed = new SimpleXMLElement($xml);
		$feed->addChild('MessageType','Inventory');
		$Message = $feed->addChild('Message');
		$Message->addChild('MessageID',1);
		$Message->addChild('OperationType','Update');
		$Inventory = $Message->addChild('Inventory');
		$Inventory->addChild('SKU',$sku);
		$Inventory->addChild('Quantity',$qty);
		$Inventory->addChild('FulfillmentLatency',(int)$fulfillment_latency);
		return $feed;
	}

	/**
	 * Liefert den XML Feed um den Preis eines Artikels bei Amazon zu aendern
	 *
	 * @param String $sku
	 * @param String $price
	 * @return String
	 */
	public function get_update_price_feed($sku,$price){
		$xml = $this->get_base_xml();
		$feed = new SimpleXMLElement($xml);
		$feed->addChild('MessageType','Price');
		$Message = $feed->addChild('Message');
		$Message->addChild('MessageID',1);
                $Message->addChild('OperationType','Update');
		$Price = $Message->addChild('Price');
		$Price->addChild('SKU',$sku);
		$StandardPrice = $Price->addChild('StandardPrice',$price);
		$StandardPrice->addAttribute('currency','EUR');
		return $feed;
	}


	/**
	 * Liefert das XML fuer einen OrderFulfilment Feed bezogen auf mehrere
	 * Bestellungen/Artikel
	 *
	 * @param Array $orders
	 * @return string
	 */
	public function get_order_fulfillment_feed($orders){
		if(!sizeOf($orders))
			return '';
		$xml = $this->get_base_xml();
		$feed = new SimpleXMLElement($xml);
		$feed->addChild('MessageType', 'OrderFulfillment');
                $message_id = 1;
		foreach($orders as $counter=>$order){
			if(strstr($order['shipper_tracking_number'],'+')){
				$tracking_numbers_array = explode('+',$order['shipper_tracking_number']);
                                $tracking_numbers = array(current($tracking_numbers_array));
			}else{
				$tracking_numbers = array($order['shipper_tracking_number']);
			}

			$items_per_tn = array();
			foreach($tracking_numbers as $lfd => $tn){
				$Message = $feed->addChild('Message');
				$Message->addChild('MessageID', $message_id);
				$OrderFulfillment = $Message->addChild('OrderFulfillment');
				//$OrderFulfillment->addChild('MerchantOrderID',$order['merchant_orders_id']);
				$OrderFulfillment->addChild('AmazonOrderID',$order['amazon_orders_id']);
				$date = new DateTime('now');
				$OrderFulfillment->addChild('FulfillmentDate',$date->format(DATE_ATOM));
				$FulfillmentData = $OrderFulfillment->addChild('FulfillmentData');
				if($order['carrier_code'] != '')
					$FulfillmentData->addChild('CarrierCode',$order['carrier_code']);
				if($order['carrier_name'] != '')
					$FulfillmentData->addChild('CarrierName',$order['carrier_name']);
				$FulfillmentData->addChild('ShippingMethod',$order['shipping_method_service_level']);
				if($tn != '')
					$FulfillmentData->addChild('ShipperTrackingNumber',trim($tn));
				foreach($order['items'] as $item){
					$Item = $OrderFulfillment->addChild('Item');
					$Item->addChild('AmazonOrderItemCode',$item['amazon_order_item_code']);
					$Item->addChild('Quantity',$item['quantity']);
					// BOF - Teillieferungen
					if(sizeOf($tracking_numbers) > 1){
                                            /* ENTFERNT - SOLLTE DAS QUANTITY
                                             * FELD MIT UEBERGEBEN BEI MEHREREN
                                             * SHIPPING TRACKING NUMMERN
                                             * KLAPPTE ABER AUCH NICHT
                                            
                                             
						if(!isset($items_per_tn[$item['amazon_order_item_code']])){
							$items_per_tn_mod = $item['order_quantity'] % sizeOf($tracking_numbers);
							$items_per_tn[ $item['amazon_order_item_code'] ] = ($item['order_quantity'] - $items_per_tn_mod) / sizeOf($tracking_numbers);
							$send_qty = $items_per_tn[$item['amazon_order_item_code']]+$items_per_tn_mod;
						}else{
							$send_qty = $items_per_tn[$item['amazon_order_item_code']];
						}
						$Item->addChild('Quantity',$send_qty);
                                             * 
                                             */
					}
					// EOF - Teillieferungen

//					$Item->addChild('MerchantFulfillmentItemID',$item['merchant_fulfillment_item_id']);
				}
				$message_id++;
			}
			unset($items_per_tn);
		} // eof foreach orders
		return $feed;
	}

	/**
	 * Liefert einen Feed zu einem bestimmten OperationType fuer ein Array von
	 * Artikeln
	 *
	 * @param Array $products_id_array
	 * @param String $OperationType
	 * @return String
	 */
	public function get_product_feed($products_id_array,$OperationType){
		$feed = $this->get_base_xml();
		$feed = new SimpleXMLElement($feed);

		foreach($products_id_array as $counter =>  $pID){
			$product = new product( xtc_db_input($pID));
			$amazon_values = $product->get_amazon_values();
			$feed->addChild('MessageType','Product');
			$Message = $feed->addChild('Message');
			$Message->addChild('MessageID', $counter);
			$Message->addChild('OperationType', $OperationType);
			$Product = $Message->addChild('Product');
			$Product->addChild('SKU', $amazon_values['sku']);
			if(!empty($product->info['products_ean'])){
				$StandardProductID = $Product->addChild('StandardProductID');
				$StandardProductID->addChild('Type', 'EAN');
				$StandardProductID->addChild('Value', $product->info['products_ean']);
			}
		}
		return $feed;
	}

	/**
	 * Submitted den Feed an Amazon und liefert das Resultat.
	 * Bei einem Fehler wird die Meldung ausgegeben.
	 *
	 * @param MarketplaceWebService_Interface $service
	 * @param Object $request
	 * @return Resultinfo
	 */
	public static function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request){
		try {
			$response = $service->submitFeed($request);
			if ($response->isSetSubmitFeedResult()) {
				$submitFeedResult = $response->getSubmitFeedResult();
				return $submitFeedResult->getFeedSubmissionInfo();
			}
		} catch (MarketplaceWebService_Exception $ex) {
			echo amazon_get_request_error_msg($ex);
		}
	}

	public function getOrderAcknowledgementFeed($orders_array){
		$xml = '';
		if(!sizeOf($orders_array))
			return $xml;
		$xml = $this->get_base_xml();
		$feed = new SimpleXMLElement($xml);
		$feed->addChild('MessageType', 'OrderAcknowledgement');

		foreach($orders_array as $counter=>$order){
			$Message = $feed->addChild('Message');
			$Message->addChild('MessageID', ($counter+1));
			$OrderAcknowledgement = $Message->addChild('OrderAcknowledgement');
			$OrderAcknowledgement->addChild('AmazonOrderID',$order['amazon_orders_id']);
			$OrderAcknowledgement->addChild('MerchantOrderID',$order['merchant_orders_id']);
			$OrderAcknowledgement->addChild('StatusCode','Success');
			$Item = $OrderAcknowledgement->addChild('Item');
			foreach($order['items'] as $item){
				$Item->addChild('AmazonOrderItemCode',$item['amazon_order_item_code']);
				$Item->addChild('MerchantOrderItemID',$item['merchant_order_item_id']);
			}
		}
		return $feed;
	}

	/**
	 * Diese Funktion gibt den XML Header fuer alle Feeds als String zurueck.
	 * Diesen XML String laden wir dann als SimpleXMLElement und k�nnen diesen
	 * erweitern
	 *
	 * @return String
	 */
	private static function get_base_xml(){
		$xml =	<<<EOD
<?xml version="1.0"?>
<AmazonEnvelope xsi:noNamespaceSchemaLocation="amzn-envelope.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Header>
		<DocumentVersion>1.0</DocumentVersion>
		<MerchantIdentifier>%s</MerchantIdentifier>
	</Header>
</AmazonEnvelope>
EOD;
                $mID = (defined('MERCHANT_ID') ? MERCHANT_ID : '');
		return sprintf($xml,$mID);
	}
}
