<?php
/**
 * Description of amz_Sync
 *
 * @author mario
 */
class amz_Sync {
	var $items;
	var $Doc;
	var $XML;

	public function getDoc() {
		return $this->Doc;
	}

	public function setDoc($Doc) {
		$this->Doc = $Doc;
	}

    function __construct($items){
		$this->setItems($items);
	}
	
	public function getItems() {
		return $this->items;
	}

	public function setItems($items) {
		$this->items = $items;
	}

	public function getXML() {
		return $this->XML;
	}

	public function setXML($XML) {
		$this->XML = $XML;
	}

	private function add_worklist_item_todo($todo,$action,$value,$counter){
		$todo_item = $this->getDoc()->createElement('Todo');
		$todo_item->setAttribute("id", $counter);
		$todo_item->setAttribute("action", $action);
		$todo_item = $todo->appendChild($todo_item);

		$child = $this->getDoc()->createElement('Value',$value);
		$todo_item->appendChild($child);
	}

	private function add_worklist_item($item,$root){
		$todo_counter = 0;
		$asin = $item['asin'];
		$sku = $item['sku'];
		$qty = $item['qty'];
		$price = $item['price'];
		$pID = yes_get_products_id_from_amazon_sku($sku);

		$occ = $this->getDoc()->createElement('Item');
		$occ = $root->appendChild($occ);

		$child = $this->getDoc()->createElement('SKU',$sku);
		$child = $occ->appendChild($child);
		if($pID < 1){
			$child = $this->getDoc()->createElement('MissingProductsId',true);
			$child = $occ->appendChild($child);
		}else{
			$amazon_values = current(yes_get_products_amazon_values($pID));
			$child = $this->getDoc()->createElement('ProductsId',$pID);
			$child = $occ->appendChild($child);
			$child = $this->getDoc()->createElement('AmazonQuantityDB',$amazon_values['quantity']);
			$child = $occ->appendChild($child);
			$child = $this->getDoc()->createElement('AmazonQuantity',$qty);
			$child = $occ->appendChild($child);
			$child = $this->getDoc()->createElement('AmazonPriceDB',$amazon_values['price']);
			$child = $occ->appendChild($child);
			$child = $this->getDoc()->createElement('AmazonPrice',$price);
			$child = $occ->appendChild($child);

			$todo = $this->getDoc()->createElement('TodoList');
			$todo = $occ->appendChild($todo);
			$todo_counter = 0;
			if($amazon_values['quantity'] <> $qty){
				$this->add_worklist_item_todo($todo,'DBQuantityChange',($amazon_values['quantity']-$qty),$todo_counter);
				$todo_counter++;
			}
			if($amazon_values['price'] <> $price){
				$this->add_worklist_item_todo($todo,'DBPriceChange',$price,$todo_counter);
				$todo_counter++;
			}
			if( empty( $amazon_values['asin'] ) ){
				$this->add_worklist_item_todo($todo,'DBUpdateAmazonASIN',$asin,$todo_counter);
				$todo_counter++;
			}
		}
	}

	public function process_worklist(){
		$this->setDoc(new DomDocument('1.0'));
		// create root node
		$root = $this->getDoc()->createElement('YES4TradeAmazonSync');
		$root = $this->getDoc()->appendChild($root);
		$child = $this->getDoc()->createElement('Status','Generated');
		$child = $root->appendChild($child);
		$child = $this->getDoc()->createElement('NumberOfItems',sizeOf($this->getItems()));
		$child = $root->appendChild($child);
		$child = $this->getDoc()->createElement('Created',date('Y-m-d H:i:s'));
		$child = $root->appendChild($child);
		foreach($this->getItems() as $item){
			$this->add_worklist_item($item,$root);
		}
		$xml_string = $this->getDoc()->saveXML();
		$this->setXML($xml_string);
	}
}

