<?php
use phpFastCache\CacheManager;
class shippings_v2_sql {
    const TABLE_SHIPPING = 'shippings';
    const TABLE_PRODUCTS = 'products';
    const TABLE_STORAGE_NUMBERS = 'storage_numbers stn';
    const TABLE_ORDERS = 'orders o';
    const TABLE_ORDERS_PRODUCTS = 'orders_products op';
    const TABLE_RECLAMATIONS = 'reclamations r';
    const TABLE_RECLAMATIONS_PRODUCTS = 'reclamations_products rp';
    const TABLE_WRAPPING_COUNTER = 'wrapping_counter wc';
    var $scanner_mode,$barcode,$page,
	    $order_source_filter,$payment_method_filter,$shipping_class_filter,
	    $customers_status_filter, $default_products_shipper, $storage_filter,
            $orders_id, $has_part_delivery, $orders_not_de, $sperrgut;
    
    function getOrders_not_de() {
        return $this->orders_not_de;
    }

    function setOrders_not_de($orders_not_de) {
        $this->orders_not_de = $orders_not_de;
    }

    public function getScanner_mode() {
	return $this->scanner_mode;
    }

    public function setScanner_mode($scanner_mode) {
	$this->scanner_mode = $scanner_mode;
    }

    public function getBarcode() {
	return $this->barcode;
    }

    public function setBarcode($barcode) {
	$this->barcode = $barcode;
    }

    public function getPage() {
	return $this->page;
    }

    public function setPage($page) {
	$this->page = $page;
    }

    public function getOrder_source_filter() {
	return $this->order_source_filter;
    }

    public function setOrder_source_filter($order_source_filter) {
	$this->order_source_filter = $order_source_filter;
    }

    public function getPayment_method_filter() {
	return $this->payment_method_filter;
    }

    public function setPayment_method_filter($payment_method_filter) {
	$this->payment_method_filter = $payment_method_filter;
    }

    public function getShipping_class_filter() {
	return $this->shipping_class_filter;
    }

    public function setShipping_class_filter($shipping_class_filter) {
	$this->shipping_class_filter = $shipping_class_filter;
    }

    public function getCustomers_status_filter() {
	return $this->customers_status_filter;
    }

    public function setCustomers_status_filter($customers_status_filter) {
	$this->customers_status_filter = $customers_status_filter;
    }

    function getDefault_products_shipper() {
        return $this->default_products_shipper;
    }

    function setDefault_products_shipper($default_products_shipper) {
        $this->default_products_shipper = $default_products_shipper;
    }
    
    function getStorage_filter() {
        return $this->storage_filter;
    }

    function setStorage_filter($storage_filter): void {
        $this->storage_filter = $storage_filter;
    }
    
    function getOrders_id() {
        return $this->orders_id;
    }

    function setOrders_id($orders_id): void {
        $this->orders_id = $orders_id;
    }
    
    function getHas_part_delivery() {
        return $this->has_part_delivery;
    }

    function setHas_part_delivery($has_part_delivery): void {
        $this->has_part_delivery = $has_part_delivery;
    }
    
    function getSperrgut() {
        return $this->sperrgut;
    }

    function setSperrgut($sperrgut) {
        $this->sperrgut = $sperrgut;
    }

    

    function __construct($page=''){
	$this->setScanner_mode( (isset($_REQUEST['scanner_mode'])) ? $_REQUEST['scanner_mode'] : SHIPPING_BARCODESCAN_DEFAULTMODE);
	$this->setBarcode( (!empty($_POST['barcode'])) ? xtc_db_input($_POST['barcode']) : '');
        if(isset($_GET['default_products_shipper']) and $_GET['default_products_shipper'] != ''){
            $this->setDefault_products_shipper(xtc_db_input($_GET['default_products_shipper']));
        }
	$this->setPage($page);
    }
    
    function getSQL(){
	$BEFORE_PAYMENTS_SQL = self::get_before_payments_sql();
	// CREATE SELECT
	switch($this->getPage()){
	    case 'reclamations':
	    case 'block_reclamations':
		$select_sql = 'reclamations_id,reclamations_status,versender_proposal,block_shipping_comment,block_shipping_end_date';
		break;
	    case 'otc':
		$select_sql = 'wc.*,o.versender,o.orders_id,o.block_shipping';
		break;
	    case 'block_orders':
		$select_sql = 'o.versender,o.orders_id,o.block_shipping_comment,o.block_shipping_end_date';
		break;
	    default:
		$select_sql = 'o.versender,o.orders_id,o.block_shipping_comment';
		break;
	}
	// CREATE FROM
	switch($this->getPage()){
	    case 'block_reclamations':
	    case 'reclamations':
		$from_sql = self::TABLE_RECLAMATIONS;
		if($this->getBarcode() != '' or $this->getDefault_products_shipper() != ''){
		    $from_sql .= sprintf(" LEFT JOIN %s USING(reclamations_id),%s p ",
			    self::TABLE_RECLAMATIONS_PRODUCTS,self::TABLE_PRODUCTS
                    );
                }
                if($this->getBarcode() != ''){
                    $from_sql .= sprintf(" LEFT JOIN %s USING(products_id) ",
			    self::TABLE_STORAGE_NUMBERS
		    );
		}
                if($this->getDefault_products_shipper() != ''){
                    $from_sql .= " LEFT JOIN products_default_shipper pds USING(products_id) ";
                }
		break;
	    default:
		$from_sql = sprintf('%s LEFT JOIN %s USING(orders_id)',self::TABLE_ORDERS,self::TABLE_WRAPPING_COUNTER);
		if( (in_array($this->getScanner_mode(),array('ean','products_model')) and $this->getBarcode() != '') or $this->getDefault_products_shipper() != ''){
		    $from_sql .= sprintf(" LEFT JOIN %s USING(orders_id),%s p ",
			    self::TABLE_ORDERS_PRODUCTS,self::TABLE_PRODUCTS
                    );
                    if($this->getBarcode() != ''){
                        $from_sql .= sprintf(" LEFT JOIN %s USING(products_id) ",
                                self::TABLE_STORAGE_NUMBERS
                        );
                    }
                    if($this->getDefault_products_shipper() != ''){
                        $from_sql .= " LEFT JOIN products_default_shipper pds USING(products_id) ";
                    }
		}
		break;
	}
	// create WHERE
	switch($this->getPage()){
	    case 'block_reclamations':
	    case 'reclamations':
                if($this->getPage() == 'block_reclamations'){
                    $where_sql = " send=1 and send_status=1 and block_shipping='1' and reclamations_status != '3' ";
                }else{
                    $where_sql = " reclamations_status != '3' and send=1 and send_status=1";
                }
		if($this->getBarcode()!=''){
		    if($this->getScanner_mode() == 'orders'){
			$where_sql .= sprintf(" and r.reclamations_id='%s'",
				$this->getBarcode()
			);
		    }else{
                        $sfield = 'products_ean';
                        if(SHIPPING_BARCODESCAN_DEFAULTMODE == 'products_model'){
                            $sfield = 'products_model';
                        }
			$where_sql .= sprintf(" and p.products_id=stn.products_id and p.products_id=rp.products_id and (p.%s='%s' or stn.nummer='%s') ",
                                $sfield,
				$this->getBarcode(),$this->getBarcode()
			);
		    }
		}else{
                    if($this->getPage() != 'block_reclamations'){
                        $where_sql .= " and block_shipping='0'";
                    }
		}
		break;
	    default:
                if($this->getPage() == 'block_orders'){
                    $allowed_orders_status = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_BEZAHLT);
                    $where_sql = sprintf(" (o.orders_status='%s' or ((%s) and (o.orders_status IN(%s) ) and date_shipping='0000-00-00 00:00:00' ) ) and o.goods_despatched='0' and block_shipping=1 and wc.orders_id IS NULL",
                            ORDERS_STATUS_BEZAHLT,$BEFORE_PAYMENTS_SQL,implode(',',$allowed_orders_status)
                    );
                }else{
                    $allowed_orders_status = array(1,2,ORDERS_STATUS_BEZAHLT);
                    $where_sql = sprintf(
                            "(o.orders_status='%s' or ((%s) and (o.orders_status IN(%s)) and date_shipping='0000-00-00 00:00:00' ) ) and o.goods_despatched='0'",
                            ORDERS_STATUS_BEZAHLT,$BEFORE_PAYMENTS_SQL,implode(',',$allowed_orders_status)
                    );
                }
                if($this->getOrder_source_filter() != ''){
                    $where_sql .= sprintf(" and o.source='%s' ",
                        $this->getOrder_source_filter()
                    );
                }
                if($this->getPayment_method_filter() != ''){
                    $where_sql .= sprintf(" and o.payment_method='%s' ",
                        $this->getPayment_method_filter()
                    );
                }
                if($this->getOrders_not_de() === true){
                    $where_sql .= " and o.delivery_country != 'Germany' ";
                }
                if($this->getShipping_class_filter() != ''){
                    $shipping_method_sql = '';
                    if($this->getShipping_class_filter() == 'amazon_express'){
                        $this->setShipping_class_filter('amazon');
                        $shipping_method_sql = " and o.shipping_method='Ship_Expedited' ";
                    }elseif($this->getShipping_class_filter() == 'amazon'){
                        $shipping_method_sql = " and o.shipping_method != 'Ship_Expedited' ";
                    }
                    $where_sql .= sprintf(" and o.shipping_class='%s' %s",
                        $this->getShipping_class_filter(),
                        $shipping_method_sql

                    );
                }
                if(is_array($this->getCustomers_status_filter()) and sizeOf($this->getCustomers_status_filter())){
                    $where_sql .= sprintf(" and o.customers_status IN (%s) ",
                        implode(',',$this->getCustomers_status_filter())
                    );
                }
		switch($this->getPage()){
		    case 'otc':
			$where_sql .= " and wc.orders_id = o.orders_id ";
			break;
		    case 'rueckstand':
			$where_sql .= " and wc.orders_id IS NULL and block_shipping=0 and o.rueckstand=1 ";
			break;
		    default:
			$where_sql .= " and wc.orders_id IS NULL ";
			if($this->getBarcode()!=''){
                            if($this->getScanner_mode() == 'orders'){
                                $where_sql .= sprintf(" and o.orders_id='%s' ",$this->getBarcode());
                            }else{
                                if($this->getScanner_mode() == 'ean'){
                                    $sfield = 'products_ean';
                                }else{
                                    $sfield = 'products_model';
                                }
                                $where_sql .= sprintf(" and op.orders_id=o.orders_id and op.products_id=p.products_id and (p.%s='%s' or stn.nummer='%s') ",$sfield,$this->getBarcode(),$this->getBarcode());
                            }
			}else{
                            if($this->getPage() != 'block_orders'){
                                $where_sql .= ' and block_shipping=0 and o.rueckstand=0 ';
                            }
			}
			break;
		}
		break;
	}
        if($this->getHas_part_delivery() === true){
            $has_part_class_id_key = (strpos($this->getPage(),'reclamation')>-1)?'reclamations_id':'orders_id';
            $has_part_class_table_alias = (strpos($this->getPage(),'reclamation')>-1)?'r':'o';
            $where_sql .= sprintf(
                " AND %s IN( SELECT s.%s FROM shippings s WHERE s.%s=%s.%s) ",
                $has_part_class_id_key,
                $has_part_class_id_key,
                $has_part_class_id_key,
                $has_part_class_table_alias,
                $has_part_class_id_key
            );
        }
        
        if($this->getSperrgut() === true){
            $sql_sperr_tab = (strpos($this->getPage(),'reclamation')>-1)?'r':'o';
            $sql_sperr_key = (strpos($this->getPage(),'reclamation')>-1)?'reclamations_id':'orders_id';
            $sql_sperr_fld = (strpos($this->getPage(),'reclamation')>-1)?'reclamations_products_id':'orders_products_id';
            $sql_sperr_tbl = (strpos($this->getPage(),'reclamation')>-1)?'reclamations_products':TABLE_ORDERS_PRODUCTS;
            $where_sql .= sprintf(
                    " AND %s.%s IN( SELECT sp.%s FROM %s sp LEFT JOIN %s p USING(products_id) WHERE sp.%s=%s.%s AND p.packagings_id='%d' ) ",
                    $sql_sperr_tab,$sql_sperr_key, $sql_sperr_key, $sql_sperr_tbl,
                    TABLE_PRODUCTS,$sql_sperr_key,$sql_sperr_tab,$sql_sperr_key,
                    MODULE_SHIPPING_DHLGKAPI_SPERRGUT_YES_PACKAGINGS_ID
            );
        }
        if($this->getDefault_products_shipper() != ''){
            $shipper_profile_where_array = [];
            $shlist = \YES4Trade\Model\shipper_profiles::get_list();
            foreach($shlist as $shp){
                if($shp['versender'] == $this->getDefault_products_shipper()){
                    $shipper_profile_where_array[] = sprintf("'%s'",$shp['profile_name']);
                }
            }
            $shipping_profiles_where = implode(',',$shipper_profile_where_array);
            if(strstr($this->getPage(),'reclamation')){
                $where_sql .= sprintf(" and rp.reclamations_id=r.reclamations_id and rp.products_id=pds.products_id and pds.shipper_profile IN(%s) ",
                        $shipping_profiles_where
                );
            }else{
                $where_sql .= sprintf(" and op.orders_id=o.orders_id and op.products_id=pds.products_id and pds.shipper IN(%s) ",
                        $shipping_profiles_where
                );
            }
        }
        if( (in_array($this->getScanner_mode(),array('ean','products_model')) and $this->getBarcode() != '') or $this->getDefault_products_shipper() != ''){
            if(strstr($this->getPage(),'reclamation')){
                $where_sql .= 'GROUP BY r.reclamations_id';
            }else{
                $where_sql .= 'GROUP BY o.orders_id';
            }
        }
	return sprintf('select %s from %s where %s',$select_sql,$from_sql,$where_sql);
	
    }
    
    public static function get_before_payments(){
        $payments = array();
        if(defined('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_IS_SHIPPING_BEFORE_PAYMENT') and MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_IS_SHIPPING_BEFORE_PAYMENT == 'True'){
            $payments[] = 'sofortueberweisungredirect';
        }
        if(defined('MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IS_SHIPPING_BEFORE_PAYMENT') and MODULE_PAYMENT_PN_SOFORTUEBERWEISUNG_IS_SHIPPING_BEFORE_PAYMENT == 'True'){
            $payments[] = 'pn_sofortueberweisung';
        }
        if(defined('MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_IS_SHIPPING_BEFORE_PAYMENT') and MODULE_PAYMENT_SOFORTUEBERWEISUNGVORKASSE_IS_SHIPPING_BEFORE_PAYMENT == 'True'){
            $payments[] = 'sofortueberweisungvorkasse';
        }
        if(defined('MODULE_PAYMENT_SOFORTUEBERWEISUNG_IS_SHIPPING_BEFORE_PAYMENT') and MODULE_PAYMENT_SOFORTUEBERWEISUNG_IS_SHIPPING_BEFORE_PAYMENT == 'True'){
            $payments[] = 'sofortueberweisung';
        }
        if(defined('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS') and MODULE_PAYMENT_KLARNA_YES_PAY_LATER_STATUS == 'true'){
            $payments[] = 'klarna_yes_pay_later';
        }   
        return $payments;
    }
    private static function get_before_payments_sql(){
        $additional_allowed_payment_sql = '';
        foreach(self::get_before_payments() as $p){
            $additional_allowed_payment_sql .= sprintf(", '%s'",$p);
        }
        return "o.payment_method IN ('invoice','cod','yes_cod','amazon'".$additional_allowed_payment_sql.") ";
    }
    
    public static function get_different_payment_methods(){
        $payment_methods = array();
        $query_raw = sprintf(
                "select DISTINCT(o.payment_method) from orders o LEFT JOIN wrapping_counter wc USING(orders_id) where (o.orders_status='%d' or ((%s) and (o.orders_status = 1 or o.orders_status=2 or o.orders_status=%d) and date_shipping='0000-00-00 00:00:00' )) and o.goods_despatched='0' and block_shipping=0 and o.rueckstand=0 and wc.orders_id IS NULL",
                ORDERS_STATUS_BEZAHLT,
                self::get_before_payments_sql(),
                ORDERS_STATUS_BEZAHLT
        );
        $query = xtc_db_query($query_raw);
        while($record = xtc_db_fetch_array($query)){
            if(empty($record['payment_method'])) continue;
            $payment_methods[] = array(
                'id'=>$record['payment_method'],
                'text'=>xtc_get_payment_method_title($record['payment_method'])
            );
        }
        return $payment_methods;
    }
    
    private static function get_ebay_shippingmethods(){
        global $InstanceCache;
        if(!defined('EBAY_USER') or empty(constant('EBAY_USER'))){
            return [];
        }
        $EBAYAPI = new ebayAPI();
        $key = 'ebay_shippingmethods';
        $CachedString = $InstanceCache->getItem($key);

        if (!$CachedString->isHit()) {
            $EBAYAPI = new ebayAPI();
            $ARRAY_ebay_shippingmethods = $EBAYAPI->get_ebay_details('ShippingServiceDetails');
            $CachedString->set($ARRAY_ebay_shippingmethods)->expiresAfter(0);//ebay_shippingmethods
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        } else {
            $ARRAY_ebay_shippingmethods = $CachedString->get();// Will print 'First product'
        }
        return $ARRAY_ebay_shippingmethods;
    }
    
    public static function get_different_shipping_classes(){
        $shipping_classes = array();
        $query_raw = sprintf(
                "select DISTINCT(o.shipping_class) from orders o LEFT JOIN wrapping_counter wc USING(orders_id) where (o.orders_status='%d' or ((%s) and (o.orders_status = 1 or o.orders_status=2 or o.orders_status=%d) and date_shipping='0000-00-00 00:00:00' )) and o.goods_despatched='0' and block_shipping=0 and o.rueckstand=0 and wc.orders_id IS NULL",
                ORDERS_STATUS_BEZAHLT,
                self::get_before_payments_sql(),
                ORDERS_STATUS_BEZAHLT
        );
        $query = xtc_db_query($query_raw);
        while($record = xtc_db_fetch_array($query)){
            if(empty($record['shipping_class'])) continue;
            $shipping_class = $record['shipping_class'];
            if($record['shipping_class'] == 'amazon'){
                $shipping_class = $record['shipping_class'].'_express';
            }
            $shipping_classes[] = array(
                'id'=>$shipping_class,
                'text'=>main::get_shipping_class_title($shipping_class, self::get_ebay_shippingmethods())
            );
        }
        return $shipping_classes;
    }
    
    public static function get_different_customers_statuses(){
        $customers_statuses = array();
        $query_raw = sprintf(
                "select DISTINCT(o.customers_status) from orders o LEFT JOIN wrapping_counter wc USING(orders_id) where (o.orders_status='%d' or ((%s) and (o.orders_status = 1 or o.orders_status=2 or o.orders_status=%d) and date_shipping='0000-00-00 00:00:00' )) and o.goods_despatched='0' and block_shipping=0 and o.rueckstand=0 and wc.orders_id IS NULL",
                ORDERS_STATUS_BEZAHLT,
                self::get_before_payments_sql(),
                ORDERS_STATUS_BEZAHLT
        );
        $query = xtc_db_query($query_raw);
        while($record = xtc_db_fetch_array($query)){
            if(empty($record['customers_status'])) continue;
            $customers_statuses[] = array(
                'id'=>$record['customers_status'],
                'text'=> xtc_get_customers_status_name($record['customers_status'])
            );
        }
        return $customers_statuses;
    }
    
    public static function get_barcode_matches(string $barcode = '', string $scanner_mode = 'orders'){
        if($scanner_mode == 'orders'){
            $query_raw = sprintf("select o.versender,o.orders_id from orders o LEFT JOIN wrapping_counter wc USING(orders_id)
                where
                       (
                                o.orders_status='%d' or
                                (
                                        (%s)
                                        and
                                        (o.orders_status IN(1,2,%d) )
                                        and (date_shipping='0000-00-00 00:00:00' or date_shipping=NULL)
                                )
                        )
                        and o.goods_despatched='0' and wc.orders_id IS NULL and o.orders_id='%d'
                        order by o.customers_id",
                ORDERS_STATUS_BEZAHLT,
                self::get_before_payments_sql(),
                ORDERS_STATUS_BEZAHLT,
                $barcode
            );
        }elseif($scanner_mode == 'items'){
        }else{
            switch($scanner_mode){
                case 'products_model':
                    $sfield = 'products_model';
                    break;
                default:
                    $sfield = 'products_ean';
                    break;
            }
            // pID mit beruecksichtigen
            $query_raw = sprintf("select o.versender,o.orders_id from orders o LEFT JOIN wrapping_counter wc USING(orders_id), orders_products op, storage_numbers stn, products p
                where
                (
                         o.orders_status='%d' or
                         (
                                 (%s)
                                 and
                                 (o.orders_status IN(1,2,%d) )
                                 and (date_shipping='0000-00-00 00:00:00' or date_shipping=NULL)
                         )
                 )
                 and o.goods_despatched='0' and wc.orders_id IS NULL and op.orders_id=o.orders_id and
                 op.products_id=p.products_id and
                 stn.products_id=p.products_id and
                 ( p.%s='%s' or stn.nummer='%s')
                 order by o.customers_id",
                ORDERS_STATUS_BEZAHLT,
                self::get_before_payments_sql(),
                ORDERS_STATUS_BEZAHLT,
                $sfield, $barcode, $barcode
            );
        }
	if($scanner_mode == 'items' and substr($barcode,0,1) != 'R'){
	    $query_raw = sprintf(
		    "select s.id,s.date_added,s.versender,o.orders_id,o.shipping_comments,s.packages from shippings s left join orders o using(orders_id) where s.orders_id='%d' and s.status=0",
		    $barcode
	    );
	}
	$orders_array = array();
	$query = xtc_db_query($query_raw);
	while($record = xtc_db_fetch_array($query)){
	    $orders_array[] = $record;
		if(!isset($matches['orders']))
			$matches['orders'] = 0;
		$matches['orders']++;
	}
	
	if($scanner_mode == 'orders'){
	    $reclamations_query_raw = sprintf(
                "select reclamations_id,reclamations_status,versender_proposal from reclamations r where r.reclamations_id='%d' and send=1 and send_status=1 and reclamations_status != '3'",
                 substr($barcode,1,strlen($barcode))
            );
	}elseif($scanner_mode == 'items'){
	    if(substr($barcode,0,1) == 'R'){
		$reclamations_query_raw = sprintf(
			"select s.id,s.date_added,s.versender,r.reclamations_id,r.shipping_comments,s.packages,r.orders_id from shippings s left join reclamations r using(reclamations_id) where s.reclamations_id='%d' and s.status=0",
			substr($barcode,1,strlen($barcode))
		);
	    }
	}else{
	    $reclamations_query_raw = sprintf(
                "select reclamations_id,reclamations_status,versender_proposal from reclamations r LEFT JOIN reclamations_products rp USING(reclamations_id),products p,storage_numbers stn where p.products_id=rp.products_id and stn.products_id=p.products_id and (p.products_ean='%s' or stn.nummer='%s') and send=1 and send_status=1 and reclamations_status != '3'",
                $barcode, $barcode
            );
	}
	$reclamations_array = array();
	if(isset($reclamations_query_raw)){
	    $query = xtc_db_query($reclamations_query_raw);
	    while($record = xtc_db_fetch_array($query)){
		$reclamations_array[] = $record;
		    if(!isset($matches['reclamations']))
			    $matches['reclamations'] = 0;
		    $matches['reclamations']++;
	    }
	}
	
        $shippings_id = Null;
	if($scanner_mode != 'items'){
	    if(sizeOf($orders_array)){
		foreach($orders_array as $order){
		    $squery = xtc_db_query(sprintf(
			    "SELECT id FROM shippings WHERE orders_id='%d' AND reclamations_id=0 AND status=0",
			    $order['orders_id']
		    ));
		    if(!xtc_db_num_rows($squery)){
			continue;
		    }
		    $srecord = xtc_db_fetch_array($squery);
		    $shippings_id = $srecord['id'];
		}
	    }else if(sizeOf($reclamations_array)){
		foreach($reclamations_array as $reclamation){
		    $squery = xtc_db_query(sprintf(
			    "SELECT id FROM shippings WHERE reclamations_id='%d' AND status=0",
			    $reclamation['reclamations_id']
		    ));
		    if(!xtc_db_num_rows($squery)){
			continue;
		    }
		    $srecord = xtc_db_fetch_array($squery);
		    $shippings_id = $srecord['id'];
		}
	    }
	}
        return array(
            'orders'=>$orders_array,
            'reclamations'=>$reclamations_array,
            'matches'=>$matches,
            'shippings_id'=>$shippings_id
        );
    }
}
