<?php
/* --------------------------------------------------------------
   $Id: shopping_cart.php,v 1.23 2017/10/19 07:37:50 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(shopping_cart.php,v 1.7 2002/05/16); www.oscommerce.com 
   (c) 2003	 nextcommerce (shopping_cart.php,v 1.6 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

  class shoppingCart {
    var $contents, $total, $weight;
    var $customers_id;

    
    function __construct( $cID ) {
      if($cID < 1)
      	$cID = $_SESSION['customer_id'];
      $this->customers_id = $cID;
      $this->reset();
    }

    function restore_contents() {

      if (!$this->customers_id) return 0;

      // insert current cart contents in database
      if ($this->contents) {
        reset($this->contents);
        foreach($this->contents as $products_id=>$egal) {
          $qty = $this->contents[$products_id]['qty'];
          $product_query = xtc_db_query("select products_id from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . $this->customers_id . "' and products_id = '" . $products_id . "'");
          if (!xtc_db_num_rows($product_query)) {
            xtc_db_query("insert into " . TABLE_CUSTOMERS_BASKET . " (customers_id, products_id, customers_basket_quantity, customers_basket_date_added) values ('" . $this->customers_id . "', '" . $products_id . "', '" . $qty . "', '" . date('Ymd') . "')");
          } else {
            xtc_db_query("update " . TABLE_CUSTOMERS_BASKET . " set customers_basket_quantity = '" . $qty . "' where customers_id = '" . $this->customers_id . "' and products_id = '" . $products_id . "'");
          }
        }
      }

      // reset per-session cart contents, but not the database contents
      $this->reset(FALSE);

      $products_query = xtc_db_query("select products_id, customers_basket_quantity from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . $this->customers_id . "'");
      while ($products = xtc_db_fetch_array($products_query)) {
        $this->contents[$products['products_id']] = array('qty' => $products['customers_basket_quantity']);
      }

      $this->cleanup();
    }

    function reset($reset_database = FALSE) {

      $this->contents = array();
      $this->total = 0;

      if ($this->customers_id && $reset_database) {
        xtc_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . $this->customers_id . "'");
      }
    }

    function add_cart($products_id, $qty = '', $properties=array()) {
        $products_id = xtc_get_uprid($products_id, $properties);
        if ($this->in_cart($products_id)) {
            $this->update_quantity($products_id, $qty);
        } else {
            if (empty($qty)) {
                $qty = '1'; // if no quantity is supplied, then add '1' to the customers basket
            }
            $this->contents[] = array($products_id);
            $this->contents[$products_id] = array(
                'qty' => $qty
            );
            // insert into database
            if ($this->customers_id) {
                xtc_db_query(sprintf(
                    "insert into %s (customers_id, products_id, customers_basket_quantity, customers_basket_date_added) values ('%d', '%s', '%d', '%s')",
                    TABLE_CUSTOMERS_BASKET,$this->customers_id,$products_id,
                    $qty,date('Ymd')
                ));
            }
            $_SESSION['new_products_id_in_cart'] = $products_id;
        }
        $this->cleanup();
    }

    function update_quantity($products_id, $quantity = '') {
        if (empty($quantity)) {
            return true; // nothing needs to be updated if theres no quantity, so we return true..
        }

        $this->contents[$products_id]['qty'] = (int)$quantity;
        // update database
        if ($this->customers_id) {
            xtc_db_query(sprintf(
                "update %s set customers_basket_quantity = '%d' where customers_id = '%d' and products_id = '%s'",
                 TABLE_CUSTOMERS_BASKET,$quantity,$this->customers_id,$products_id
            ));
        }
    }

    function cleanup() {

      reset($this->contents);
      foreach($this->contents as $key=>$egal) {
        if ($this->contents[$key]['qty'] < 1) {
          unset($this->contents[$key]);
          // remove from database
          if ($this->customers_id) {
            xtc_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . $this->customers_id . "' and products_id = '" . $key . "'");
          }
        }
      }
    }

    function count_contents() {  // get total number of items in cart 
        $total_items = 0;
        if (is_array($this->contents)) {
            reset($this->contents);
            foreach($this->contents as $products_id=>$egal) {
                $total_items += $this->get_quantity($products_id);
            }
        }
        return $total_items;
    }

    function get_quantity($products_id) {
      if ($this->contents[$products_id]) {
        return $this->contents[$products_id]['qty'];
      } else {
        return 0;
      }
    }

    function in_cart($products_id) {
      if ($this->contents[$products_id]) {
        return true;
      } else {
        return false;
      }
    }

    function remove($products_id) {
      unset($this->contents[$products_id]);
      // remove from database
      if ($this->customers_id) {
        xtc_db_query("delete from " . TABLE_CUSTOMERS_BASKET . " where customers_id = '" . $this->customers_id . "' and products_id = '" . $products_id . "'");
      }
    }

    function remove_all() {
      $this->reset();
    }

    function get_product_id_list() {
      $product_id_list = '';
      if (is_array($this->contents)) {
        reset($this->contents);
        foreach($this->contents as $products_id=>$egal) {
          $product_id_list .= ', ' . $products_id;
        }
      }
      return substr($product_id_list, 2);
    }
    
    function calculate($customers_group) {
		global $order,$_GET;
		if(!$customers_group and $_GET['edit_action'] == 'shipping'){
			$customers_group = $order->info['status'];
		}
                if(is_object($order)){
                    $xtPrice = $order->get_price_instance();
                }else{
                    if(!is_object($xtPrice)){
                        $xtPrice = new xtcPrice(DEFAULT_CURRENCY,$customers_group);
                    }
                }
		$this->total = 0;
		$this->weight = 0;
		if (!is_array($this->contents)) return 0;
		reset($this->contents);
		foreach($this->contents as $products_id => $egal) {
			$qty = $this->contents[$products_id]['qty'];
			$prid = xtc_get_prid($products_id);
                        $product_query = xtc_db_query("select products_id, products_price, products_weight from " . TABLE_PRODUCTS . " where products_id='" . $prid . "'");
                        $product = xtc_db_fetch_array($product_query);
                        // EU-OSS 2021/07
                        $country_id = ($xtPrice->getCountry_id() > 0) ? $xtPrice->getCountry_id() : STORE_COUNTRY;
                        $zone_id = ($xtPrice->getCountry_id() > 0) ? $xtPrice->getZone_id() : 0;
                        
                        $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($prid, $country_id, $zone_id);
                        
			if(!isset($this->contents[$products_id]['price'])){
				// products price
                                if(!isset($this->contents[$products_id]['price'])){
                                        $products_price=$xtPrice->xtcGetPrice($prid,
                                                $format=false,
                                                $qty,
                                                $products_tax_class_id,
                                                $product['products_price']
                                        );
                                }else{
                                        $products_price = $this->contents[$products_id]['price'];
                                }

                                $this->total += $products_price*$qty;

                                //$this->total += xtc_add_tax($products_price, $products_tax) * $qty;
                                $products_weight = (isset($products_weight)) ? $products_weight : 0;
                                $this->weight += ($qty * $products_weight);
				$properties_price_brutto = $xtPrice->xtcFormat($this->get_product_properties_price_netto($products_id),false,$products_tax_class_id);
				$this->total += $properties_price_brutto*$qty;
				$products_price += $properties_price_brutto;
			}else{
                                // Ticket 2522 - Im Cart sind bei geaenderten Preisen immer 
                                // Nettopreise
                                if ($xtPrice->cStatus['customers_status_show_price_tax'] =='0'){
                                    $products_price = $this->contents[$products_id]['price'];
                                }else{
                                    $products_tax = xtc_get_tax_rate( $products_tax_class_id, $country_id, $zone_id );
                                    $products_price = $xtPrice->xtcAddTax($this->contents[$products_id]['price'],$products_tax);
                                }

				$this->total += $products_price*$qty;
			}

		} // end while products
    }

    // EU-OSS 2021/07
    function get_products($customers_group, $xtPrice=null) {
        if($xtPrice === null){
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }else if($xtPrice->getCountry_id() > 0){
            $country_id = $xtPrice->getCountry_id();
            $zone_id = $xtPrice->getZone_id();
        }else{
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }
	if (!is_array($this->contents)) return 0;
        $products_array = array();
        reset($this->contents);
        foreach($this->contents as $products_id => $egal ) {
			$products_query = xtc_db_query("select p.products_id, pd.products_name, p.products_model, p.products_price, p.products_weight from " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_DESCRIPTION . " pd where p.products_id='" . xtc_get_prid($products_id) . "' and pd.products_id = p.products_id and pd.language_id = '" . $_SESSION['languages_id'] . "'");
			if(xtc_db_num_rows($products_query)) {
				$products = xtc_db_fetch_array($products_query);
				$prid = $products['products_id'];
                                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($prid, $country_id, $zone_id);
				if(!isset($this->contents[$products_id]['price'])){
					$products_price = $products['products_price'];
					$specials_query = xtc_db_query("select specials_new_products_price from " . TABLE_SPECIALS . " where products_id = '" . $prid . "' and status = '1'");
					if (xtc_db_num_rows($specials_query)) {
                                            $specials = xtc_db_fetch_array($specials_query);
                                            $products_price = $specials['specials_new_products_price'];
					}
				}else{
                                    $products_price = $this->contents[$products_id]['price'];
				}
				if(isset($this->contents[$products_id]['properties'])){
                                    $properties = $this->contents[$products_id]['properties'];
				}else{
					$properties = array();
					if(strstr($products_id,'{')){
						$parts_tmp = explode('{',$products_id);
						array_shift($parts_tmp);
						$prop_parts = explode(',',substr($parts_tmp[0],0,strlen($parts_tmp[0])-1));
						foreach($prop_parts as $ppvID){
	                                            $user_input_span = '';
                                                    if(strpos($ppvID,':')>0){
                                                        $_ppvID_parts = explode(':',$ppvID);
                                                        $ppvID = $_ppvID_parts[0];
                                                        $user_input_span = $_ppvID_parts[1];
                                                    }
                                                    
						    if($ppvID < 1) continue;
							$ppvID = xtc_db_input($ppvID);
							$ppv = new product_properties_values($ppvID);
							$pp = new product_properties($ppv->getProducts_properties_id());
							$properties[] = array(
								'value'=>$ppv->getDescription($_SESSION['languages_id'])->getTitle(),
								'price_netto'=>$ppv->getPrice(),
								'property'=>$pp->getDescription($_SESSION['languages_id'])->getTitle(),
                                                            'input_span'=>$user_input_span,
							);
						}
					}
				}
                                
				$products_array[] = array(
          'id' => $products_id,
          'name' => $products['products_name'],
          'model' => $products['products_model'],
          'price' => $products_price,
          'quantity' => $this->contents[$products_id]['qty'],
          'weight' => $products['products_weight'],
          'final_price' => ($products_price) * $this->contents[$products_id]['qty'],
          'tax_class_id' => $products_tax_class_id,
          'properties' => $properties,
				);
			}
		}// end while products
		return $products_array;
	}

    function show_total($customers_group = false) {
      $this->calculate($customers_group);
      return $this->total;
    }

    function show_weight() {
      $this->calculate();

      return $this->weight;
    }

    function unserialize($broken) {
      foreach($broken as $k=>$v) {
        $kv = [$k,$v];
        $key=$kv['key'];
        if (gettype($this->$key)!="user function")
        $this->$key=$kv['value'];
      }
    }
	
	public static function get_product_properties_price_netto($products_id){
		$price_netto = 0;
		$ppvID_parts = explode('{',$products_id);
		if(sizeOf($ppvID_parts) < 2){
			return $price_netto;
		}
		$ppvID_parts = explode(',',substr($ppvID_parts[1],0,strlen($ppvID_parts[1])-1));
		foreach($ppvID_parts as $ppvID){
			if(strpos($ppvID,':')>0){
				$_ppvID_parts = explode(':',$ppvID);
				$ppvID = $_ppvID_parts[0];
			}else{
				$ppvID = xtc_db_input($ppvID);
			}
			$ppv = new product_properties_values($ppvID);
			$price_netto += $ppv->getPrice();
		}
		return $price_netto;
	}

	public function get_properties_array($products_id){
		$properties = array();
		$ppvID_parts = explode('{',$products_id);
		if(sizeOf($ppvID_parts) < 2){
			return $properties;
		}
		$ppvID_parts = explode(',',substr($ppvID_parts[1],0,strlen($ppvID_parts[1])-1));
		foreach($ppvID_parts as $ppvID){
			$ppvID = xtc_db_input($ppvID);
			$ppv = new product_properties_values($ppvID);
			$pp = new product_properties($ppv->getProducts_properties_id());
			$properties[] = array(
				'value'=>$ppv->getDescription($_SESSION['languages_id'])->getTitle(),
				'price_netto'=>$ppv->getPrice(),
				'property'=>$pp->getDescription($_SESSION['languages_id'])->getTitle(),
                            'input_span'=>$ppv->getInput_span(),
			);
		}
		return $properties;
	}
	
	// GIBT EIN ARRAY ALLER ENTHALTENEN pID DES WARENKORBS ZURUECK
	// INKL DER COLLIES
	// DA EIN ARTIKEL AUFGRUND VON PROPERTIES MEHRFACH VORHANDEN SEIN KANN
	// UND AUCH COLLIES INSGESAMT MEHRFACH IN VERSCHIEDENEN SETS SEIN KOENNEN
	// BRAUCHEN WIR DIESE PRUEFUNG UM BESTAENDE ABZUSICHERN
	public function get_products_total_quantity_array(){
	    if (!is_array($this->contents)) return 0;
	    $products_array = array();
	    reset($this->contents);
	    foreach($this->contents as $products_id => $egal ) {
		$pID = xtc_get_prid($products_id);
		if(!isset($products_array[$pID])){
		    $products_array[$pID] = 0;
		}
		$products_array[$pID] += $this->contents[$products_id]['qty'];
		$collies_query = xtc_db_query(sprintf(
			"SELECT collie_products_id, quantity FROM products_collies WHERE products_id='%s'",
			$pID
		));
		while($collies = xtc_db_fetch_array($collies_query)){
		    if(!isset($products_array[$collies['collie_products_id']]))
			$products_array[$collies['collie_products_id']] = 0;
		    $products_array[$collies['collie_products_id']] += $this->contents[$products_id]['qty']*$collies['quantity'];
		}
	    }
	    return $products_array;
	}
        
}
