<?php
/* --------------------------------------------------------------
   $Id: customer_memo.php,v 1.5 2017/08/23 16:23:46 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce

   (c) programmed by Zanier Mario for neXTCommerce

   Released under the GNU General Public License 
   --------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (customer_memo.php,v 1.6 2003/08/18); www.nextcommerce.org
   
   --------------------------------------------------------------*/
$cID = (int)xtc_db_input($_GET['cID']);
if($cID < 1){
    die('Invalid Customer');
}
$cm_smarty = new yesSmarty;
$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;" id="memo_table"';
$contents = [[
    ['text'=>TEXT_DATE,'th'=>true],
    ['text'=>TEXT_TITLE,'th'=>true],
    ['text'=>'Text','th'=>true],
    ['text'=>TEXT_POSTER,'th'=>true],
    ['text'=>'&nbsp;','th'=>true],
]];

$items = \YES4Trade\Model\customers_memo::get_by_customers_id($cID);
foreach($items as $it){
    $links = [
        sprintf('<a href="javascript:;" onclick="memo_delete(this,%d)" title="%s">%s</a>',
            $it->memo_id, 
            IMAGE_DELETE,
            smarty_function_icon(['type'=>'delete'], $cm_smarty),
        )
    ];
    $memo_text_cutted = (strlen($it->memo_text)>50) ? substr($it->memo_text,0,50).' ...' : $it->memo_text;
    $memo_text = sprintf(
            '<span title="%s">%s</span>',
            str_replace(["\n","\t",'"'],'', strip_tags($it->memo_text)),
            $memo_text_cutted
    );
    $contents[] = [
        ['text'=>$it->memo_date->format('d.m.Y')],
        ['text'=>$it->memo_title],
        ['text'=>$memo_text],
        ['text'=> xtc_get_editor_name($it->poster_id)],
        ['text'=> implode('&nbsp;',$links)],
    ];
}

$cm_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$cm_smarty->assign(array(
    'ENTRY_MEMO'=>ENTRY_MEMO,
    'MEMOS'=>$table->tableBlock_draw($contents),
    'TEXT_DATE'=>TEXT_DATE,
    'TEXT_TITLE'=>TEXT_TITLE,
    'TEXT_POSTER'=>TEXT_POSTER,
    'FORM'=>xtc_draw_form('memo_add',FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action')).'action=insert_memo'),
    'INPUT_TITLE'=>xtc_draw_input_field('memo_title','','id="memo_title"'),
    'INPUT_TEXT'=>xtc_draw_textarea_field('memo_text', 'soft', '60', '5','','id="memo_text"',false),
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'REALLY_DELETE'=>REALLY_DELETE_MEMO
));
header('Content-Type: text/html; charset='.CHARSET);
$cm_smarty->display('customers_memo.html');
exit;

