<?php
/* -----------------------------------------------------------------------------------------
   $Id: billiger.php,v 1.14 2018/06/25 06:37:31 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2005 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_products_shippingtime.inc.php');
define('MODULE_BILLIGER_TEXT_DESCRIPTION', 'Export - Billiger.de (Tab getrennt)');
define('MODULE_BILLIGER_TEXT_TITLE', 'Billiger.de - CSV');
define('MODULE_BILLIGER_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_BILLIGER_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportadatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_BILLIGER_STATUS_DESC','Modulstatus');
define('MODULE_BILLIGER_STATUS_TITLE','Status');
define('MODULE_BILLIGER_CURRENCY_TITLE','W&auml;hrung');
define('MODULE_BILLIGER_CURRENCY_DESC','Welche W&auml;hrung soll exportiert werden?');
define('MODULE_BILLIGER_PROMO_TEXT_TITLE','Promo Text');
define('MODULE_BILLIGER_PROMO_TEXT_DESC','Geben Sie einen Text ein der bei jedem Datensatz mit erzeugt wird.');

@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
define('CURRENCY','<hr noshade><b>W&auml;hrung:</b>');
define('CURRENCY_DESC','W&auml;hrung in der Exportdatei');
define('EXPORT_STATUS_TYPE','<hr noshade><b>Kundengruppe:</b>');
define('EXPORT_STATUS','Bitte w&auml;hlen Sie die Kundengruppe, die Basis f&uuml;r den Exportierten Preis bildet. (Falls Sie keine Kundengruppenpreise haben, w&auml;hlen Sie <i>Gast</i>):</b>');
@define('EXPORT_LINKED_PRODUCTS','Verlinkte Produkte mit exportieren');
@define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
// include needed functions


  class billiger extends products_export{
    var $code, $title, $description, $enabled,$categories_string,$selected_categories;
    var $from_cron, $delimiter;


    function __construct() {
      global $order;

      $this->code = 'billiger';
      $this->title = MODULE_BILLIGER_TEXT_TITLE;
      $this->description = MODULE_BILLIGER_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_BILLIGER_SORT_ORDER')) ? MODULE_BILLIGER_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_BILLIGER_STATUS') and MODULE_BILLIGER_STATUS == 'True') ? true : false);
      $this->only_active_products = true;
      $this->only_active_categories = true;
      //$this->from_cron = (php_sapi_name() === 'cli' or php_sapi_name() === 'cgi') ? true : false;
      // wird beim instantiieren gesetzt
      $this->delimiter = ';';
    }


    function process($file) {
	$basics = new basics;
	$max_items = 5000;
        @xtc_set_time_limit(0);
        require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
	$export_params = array(
	    'customers_status'=>((isset($_REQUEST['status']))?$_REQUEST['status']:CRON_BILLIGER_CONFIG_CUSTOMERS_STATUS),
	    'export_linked_products'=>((isset($_REQUEST['export_linked_products']) and $_REQUEST['export_linked_products'] == 1)?1:0),
	    'particle_path'=>\main::get_exportdata_path().'BILLIGER_EXPORT/',
	    'start'=>0,
	    'cat'=>((isset($_REQUEST['cat']) and (is_array($_POST['cat']) and sizeOf($_POST['cat'])>0)) ? $_REQUEST['cat']:''),
	    'allcat'=>((isset($_REQUEST['allCat']) and $_REQUEST['allCat'] == 1)?1:0),
	    'curr'=>(!isset($_POST['currencies'])) ? DEFAULT_CURRENCY : $_POST['currencies'],
	    'export'=>(isset($_REQUEST['export']) and $_REQUEST['export'] == 'yes') ? 'yes' : 'no',
	    'promo_text'=>(isset($_REQUEST['promo_text']) and $_REQUEST['promo_text'] != '') ? $_REQUEST['promo_text'] : 'no',
	);
	if($this->from_cron){
	    if(is_file(DIR_FS_CATALOG.'ebaymich/'.$file.'.zip')){
			die("Die Datei ebaymich/$file.zip ist bereits vorhanden. Diese muss entweder manuell oder durch den cronjob cron_billiger_delete_file.php geloescht werden.\r\n");
	    }
	    if(is_dir($export_params['particle_path'])){
		$files = $basics->get_directory_content($export_params['particle_path']);
		foreach($files as $f){
		    if(!strstr($f,'PART_')){
			continue;
		    }
		    $strpos1 = strpos($f,'_')+1;
		    $str1 = substr($f,$strpos1);
		    $strpos2 = strpos($str1,'.');
		    $_start = (int)substr($str1,0,$strpos2);
		    if($_start >= $export_params['start']){
			$export_params['start'] = $_start+$max_items;
		    }
		}
	    }
	    $export_params['allcat'] = CRON_BILLIGER_CONFIG_ALL_CAT;
	    $export_params['default_category'] = CRON_BILLIGER_CONFIG_DEFAULT_CATEGORY;
	    $export_params['title'] = CRON_BILLIGER_CONFIG_TITLE;
	    $export_params['export'] = 'no';
	}else{
	    if(isset($_REQUEST['start'])){
		$export_params['start'] = (int)$_REQUEST['start'];
	    }
	    $export_params['allcat'] = (isset($_REQUEST['allCat']))?$_REQUEST['allCat']:'';
	    $export_params['default_category'] = (isset($_REQUEST['default_category']) and $_REQUEST['default_category'] == 1) ? 1 : 0;
	    $export_params['title'] = $_REQUEST['title'];
	    global $messageStack;
	}
	
	$schema = 'artikelid;hersteller;bezeichnung;kategorie;beschreibung_kurz;bild_klein;bild_gross;deeplink;lieferzeit;lieferkosten;preis;product_ean;promo_text'."\n";
	$header = $schema;
	$schema = '';
        $xtPrice = new xtcPrice($export_params['curr'],$export_params['customers_status']);
	if($export_params['cat'] or $export_params['allcat'] == '1'){

		if($export_params['export_linked_products'] == 1){
			$linked_sql = "";
		}else{
			$linked_sql = " GROUP BY products_id ";
		}
		$start = $export_params['start'];
		if($start == 0){
		    if(is_dir($export_params['particle_path'])){
			    $files = $basics->get_directory_content($export_params['particle_path']);
			    foreach($files as $f){
				    unlink($export_params['particle_path'].$f);
			    }
			    rmdir($export_params['particle_path']);
		    }
		    mkdir($export_params['particle_path']);
		}
		$allCat = $export_params['allcat'];
		$cat = $export_params['cat'];
		if($export_params['default_category'] == 1){
		    $default_category_sql = ' AND p2c.categories_id=p.default_category ';
		    $allCat = 1;
		}
		$count_query = xtc_db_query(sprintf(
			"SELECT p.products_id FROM products_to_categories p2c LEFT JOIN %s p USING (products_id) WHERE p.products_id>0 %s %s %s",
			TABLE_PRODUCTS,$this->getP2CWhereSQLString($allCat,$cat),$default_category_sql,$linked_sql
		));
		$num_total = xtc_db_num_rows($count_query);
		
		
		$export_query_raw = "SELECT
				p.products_id,
				p2c.categories_id,
				pd.products_name,
				pd.products_description,pd.products_short_description,
				p.products_model,p.products_ean,
				p.products_image,
				p.products_price,
				p.products_status,
				p.products_date_available,
				p.products_discount_allowed,
				pd.products_meta_keywords,
				p.products_date_added,
				m.manufacturers_name
				FROM
				products_to_categories p2c LEFT JOIN
				" . TABLE_PRODUCTS . " p USING (products_id) LEFT JOIN
				" . TABLE_MANUFACTURERS . " m
				ON p.manufacturers_id = m.manufacturers_id LEFT JOIN
				" . TABLE_PRODUCTS_DESCRIPTION . " pd
				ON p.products_id = pd.products_id AND
				pd.language_id = '".$_SESSION['languages_id']."' LEFT JOIN
				" . TABLE_SPECIALS . " s
				ON p.products_id = s.products_id
				WHERE
				p.products_id > 0 ".$this->getP2CWhereSQLString($export_params['allcat'],$export_params['cat'])."
				".$linked_sql."
				ORDER BY
				p.products_date_added DESC,
				pd.products_name LIMIT $start, $max_items";
		$export_query = xtc_db_query($export_query_raw);
		$counter = 0;
		while ($products = xtc_db_fetch_array($export_query)) {
                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                        $products['products_id'], STORE_COUNTRY
                    );
                            
		    $products_price = $xtPrice->xtcGetPrice($products['products_id'],
						    $format=false,
						    1,
						    $products_tax_class_id,
						    '');
				    // get product categorie
		    $categorie_query=xtc_db_query("SELECT
						    categories_id
						    FROM ".TABLE_PRODUCTS_TO_CATEGORIES."
						    WHERE products_id='".$products['products_id']."' and categories_id='".$products['categories_id']."'");
		    while ($categorie_data=xtc_db_fetch_array($categorie_query)) {
			    $categories=$categorie_data['categories_id'];
		    }
		    // remove trash

		    $products_description = strip_tags($products['products_description']);         
		    $products_description = str_replace("<br>"," ",$products_description);
		    $products_description = str_replace("<br />"," ",$products_description);
	//		$products_description = str_replace(";",", ",$products_description);
		    $products_description = str_replace("'",", ",$products_description);
		    $products_description = str_replace("\n"," ",$products_description);
		    $products_description = str_replace("\r"," ",$products_description);
		    $products_description = str_replace("\t"," ",$products_description);
		    $products_description = str_replace("\v"," ",$products_description);
		    $products_description = str_replace("&quot,"," \"",$products_description);
		    $products_description = str_replace("&qout,"," \"",$products_description);
		    $products_description = str_replace(chr(13)," ",$products_description);

		    $products_short_description = strip_tags($products['products_short_description']);         
		    $products_short_description = str_replace("<br>"," ",$products_short_description);
		    $products_short_description = str_replace("<br />"," ",$products_short_description);
	//		$products_short_description = str_replace(";",", ",$products_short_description);
		    $products_short_description = str_replace("'",", ",$products_short_description);
		    $products_short_description = str_replace("\n"," ",$products_short_description);
		    $products_short_description = str_replace("\r"," ",$products_short_description);
		    $products_short_description = str_replace("\t"," ",$products_short_description);
		    $products_short_description = str_replace("\v"," ",$products_short_description);
		    $products_short_description = str_replace("&quot,"," \"",$products_short_description);
		    $products_short_description = str_replace("&qout,"," \"",$products_short_description);
		    $products_short_description = str_replace(chr(13)," ",$products_short_description);
		    $products_short_description = substr($products_short_description, 0, 255);
		    $products_description = substr($products_description, 0, 65536);
		    $cat = $this->buildCAT($categories);
				
		    if ($products['products_image'] != ''){
			$image_small = HTTP_CATALOG_SERVER . 'images/product_images/thumbnail_images/'.$products['products_image'];
			$image_big = HTTP_CATALOG_SERVER . 'images/product_images/popup_images/' .$products['products_image'];
			}else{
			$image_small = '';
			$image_big = '';
		    }
	
		    //create content
		    $link = HTTP_CATALOG_SERVER.'product_info.php?products_id=' . $products['products_id'];
		    $pID = $products['products_id'];
		    // versandkosten DE

		    $group_id_germany = main::get_shipping_graduation_groups_id_by_countries_id(STORE_COUNTRY);
		    $pweight = xtc_get_ext_products_weight($pID);
		    if(MODULE_SHIPPING_YES_STATUS == 'True'){
			    if(main::get_ext_shipping_costs_status($pID)){

				    $ext_additionalcosts = main::get_product_shipping_extra_charges($pID, $group_id_germany);

				    $costs = main::get_ext_shipping_costs($pID);
				    foreach($costs as $group_id => $qty_array){
					    if($group_id_germany == $group_id){
						    $brutto = true;
						    $shipping_price = main::calc_yes_modul($ext_additionalcosts+$qty_array[1],$group_id,$pweight,$pID,$brutto);
					    }
				    }
			    }else{
				    $qty = 1;
				    $grad_query = xtc_db_query("select * from shipping_graduation WHERE value=1");
				    $grad = xtc_db_fetch_array($grad_query);
				    $gID = $grad['shipping_graduation_id'];
				    $groups_query = xtc_db_query("select * from shipping_graduation_groups ORDER BY shipping_graduation_groups_id");

				    $extra_charge = main::get_product_shipping_extra_charges($pID,$group_id_germany);
                                    $tmp_groups = array();
				    while($groups = xtc_db_fetch_array($groups_query)){
                                        $tmp_groups[] = $groups;
                                    }
                                    foreach($tmp_groups as $groups){
					    $group_id = $groups['shipping_graduation_groups_id'];
					    if($group_id_germany == $group_id){
						    // pweight nehmen wir fuer die kalkulation des Preises
						    $weight_query = xtc_db_query("select * from shipping_graduation_weights order by weight DESC");
						    while ($weight = xtc_db_fetch_array($weight_query)) {
							    if((float)$pweight <= (float)$weight['weight']){
								    $wID = $weight['shipping_graduation_weights_id'];
							    }
						    }
						    $grad_query_raw = sprintf("SELECT grad_value FROM shipping_graduation_values WHERE shipping_graduation_weights_id='%s' and shipping_graduation_groups_id='%s' and shipping_graduation_id='%s'",$wID,$group_id,$gID);
						    $grad_query = xtc_db_query($grad_query_raw);
						    $grad = xtc_db_fetch_array($grad_query);

						    $product_shipping = $grad['grad_value']+$extra_charge;

						    $price = main::calc_yes_modul($product_shipping,$group_id,$pweight,$pID);
						    $tax_class = constant('MODULE_SHIPPING_YES_TAX_CLASS');
						    $tax_value = xtc_get_tax_rate($tax_class);

						    $tax_price = $price*(($tax_value+100)/100);
						    $c_array = main::get_group_countries($group_id);
						    if(sizeOf($c_array)>0){
							    $shipping_price = number_format($tax_price,2,'.','');
						    }
					    }
				    }
			    }
		    }

		    // BOF - Free Shipping TICKET 1890
		    if(defined('MODULE_SHIPPING_FREECOUNT_STATUS') and MODULE_SHIPPING_FREECOUNT_STATUS == 'True'){
			if(round($products_price,2) >= MODULE_SHIPPING_FREECOUNT_AMOUNT){
			    $shipping_price = number_format(0,2,'.','');
			}
		    }
		    // EOF - Free Shipping TICKET 1890
		    
		    $shippingtime = yes_get_products_shippingtime($products['products_id'],$_SESSION['languages_id']);
                    $schema_array = array(
                        $products['products_id'],
			$products['manufacturers_name'],
			$products['products_name'],
			substr($cat,0,strlen($cat)-2),
			substr($products_short_description,0,2000),
			$image_small,
			$image_big,
			HTTP_CATALOG_SERVER . 'product_info.php?products_id='.$products['products_id'],
			$shippingtime,
			$shipping_price,
			number_format($products_price,2,'.',''),
			$products['products_ean'],
			str_replace('"',"'",MODULE_BILLIGER_PROMO_TEXT)
                    );
                    foreach($schema_array as $k=>$v){
                        $schema_array[$k] = sprintf('"%s"',$v);
                    }
                    $schema = implode($this->delimiter,$schema_array)."\r\n";
                    /*
		    $schema .=  $products['products_id'] .";".
					$products['manufacturers_name'].";".
					$products['products_name'].";".
					substr($cat,0,strlen($cat)-2).";".
					substr($products_short_description,0,2000).";".
					$image_small.";".
					$image_big.";".
			HTTP_CATALOG_SERVER . 'product_info.php?products_id='.$products['products_id'].';'.
			$shippingtime.';'.
			$shipping_price.';'.
			number_format($products_price,2,'.',''). ';' .
			$products['products_ean'] . ';'.
			MODULE_BILLIGER_PROMO_TEXT. "\n";
                     * 
                     */
		    $counter++;
		}
		$filename = sprintf('PART_%s.csv',$start);
		$basics->create_file($export_params['particle_path'].$filename, $schema);
		if( $start+$max_items >= $num_total ){
			// KOMPLETT ERZEUGEN
			$schema = $header;
			$files = $basics->get_directory_content($export_params['particle_path']);
			foreach($files as $f){
				$fp = fopen($export_params['particle_path'].$f,"rb");
				$schema .= fread($fp, filesize($export_params['particle_path']. $f));
				fclose($fp);
				unlink($export_params['particle_path'].$f);
			}
			// create File
			if(!isset($file) or $file==''){
				$file = $_REQUEST['configuration'][0];
			}
			$directory_without_slash = substr($export_params['particle_path'],0,strlen($export_params['particle_path'])-1);
			$basics->create_file($export_params['particle_path'] . $file, $schema);
			$basics->zip_file($directory_without_slash, $file, $file.'.zip', true);

			switch ($export_params['export']) {
				case 'yes':
//						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);

					header($_SERVER['SERVER_PROTOCOL'].' 200 OK');
					header("Content-Type: application/zip");
					header("Content-Transfer-Encoding: Binary");
					header("Content-Length: ".filesize($export_params['particle_path']. $file.'.zip'));
					header("Content-Disposition: attachment; filename=\"".$file.".zip\"");
					readfile($export_params['particle_path']. $file.'.zip');
					unlink($export_params['particle_path']. $file.'.zip');
					exit;
					break;
				case 'no':
//						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
				    copy($export_params['particle_path']. $file.'.zip',DIR_FS_CATALOG.'ebaymich/'.$file.'.zip');
				    unlink($export_params['particle_path']. $file.'.zip');
				    if($this->from_cron){
					die('ebaymich/'.$file.".zip wurde erzeugt\r\n");
				    }else{
					$messageStack->add_session(sprintf(MSG_SUCCESS_FILE_EXPORTED,$file.'.zip'),'success');
				    }
				    break;
			}
		}else{
		    if($this->from_cron){
			die("\r\nGENERATED FILE: $filename\r\n".'Start: '.$start.' / Generated: '.($counter-1).' / Total: '.$num_total." / MAX: $max_items\r\n");
		    }else{
			// redirect
			if(isset($_POST['status'])){
				$_GET["configuration[\"MODULE_BILLIGER_FILE\"]"] = $file;
				$_GET["configuration[\"MODULE_BILLIGER_PROMO_TEXT\"]"] = urldecode($_REQUEST['configuration']['promo_text']);
				$_GET['status'] = $_REQUEST['status'];
				$_GET['export'] = $_REQUEST['export'];
				$_GET['allCat'] = $_REQUEST['allCat'];
				$_GET['export_linked_products'] = ((isset($_REQUEST['export_linked_products']))?$_REQUEST['export_linked_products']:'');
			}
			$next_link = xtc_href_link('module_export.php',xtc_get_all_get_params(array('start')).'start='.($start+$max_items));
			xtc_redirect($next_link);
		    }
		}
	} // end if categories_array
    }

    
    function display() {
	return array('text' =>  $this->getCategoryJSString().EXPORT_STATUS_TYPE.'<br />'.
                          	EXPORT_STATUS.'<br />'.
				xtc_draw_pull_down_menu('status',xtc_get_customers_statuses(),1).'<br /><br />'.
                            EXPORT_TYPE.'<br />'.
                            EXPORT.'<br />'.
                          	xtc_draw_radio_field('export', 'no',false).EXPORT_NO.'<br />'.
                            xtc_draw_radio_field('export', 'yes',true).EXPORT_YES.'<br /><br />'.
			    '<b>Exportiere Produkte aus Kategorie:</b><br />'.
			    '<input type="checkbox" name="allCat" value="1" CHECKED onClick="allCatFunc();"> Alle Kategorien<br />'.
			    $this->getCategoriesString().
			    '<input type="checkbox" name="export_linked_products" value="1" />'.EXPORT_LINKED_PRODUCTS.'<br />'.
                            '<br />' . xtc_image_submit('button_export.gif','Exportieren') .
                            '<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=yes').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>');


    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_BILLIGER_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_BILLIGER_FILE', 'billiger.csv',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_BILLIGER_PROMO_TEXT', '',  '6', '2', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_BILLIGER_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_BILLIGER_STATUS','MODULE_BILLIGER_FILE','MODULE_BILLIGER_PROMO_TEXT');
    }

  }
?>
