<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'reclamation.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
define('MODULE_RECLAMATIONS_TEXT_DESCRIPTION', 'Export - Reklamationen (Tab getrennt)');
define('MODULE_RECLAMATIONS_TEXT_TITLE', 'Reklamationen Export - CSV');
define('MODULE_RECLAMATIONS_FILE_TITLE' , '<hr noshade>Dateiname');
define('MODULE_RECLAMATIONS_STATUS_DESC','Modulstatus');
define('MODULE_RECLAMATIONS_STATUS_TITLE','Status');
define('MODULE_RECLAMATIONS_STARTDATE','Exportzeitraum (von)');
define('MODULE_RECLAMATIONS_ENDDATE','Exportzeitraum (bis)');
class reclamations extends products_export{
    var $TextSign, $code, $title, $description, $enabled, $_check, $sort_order;


    function __construct() {
      $this->TextSign = '';
      $this->code = 'reclamations';
      $this->title = MODULE_RECLAMATIONS_TEXT_TITLE;
      $this->description = MODULE_RECLAMATIONS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_RECLAMATIONS_SORT_ORDER')) ? MODULE_RECLAMATIONS_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_RECLAMATIONS_STATUS') and MODULE_RECLAMATIONS_STATUS == 'True') ? true : false);
    }



    function process($file) {
		global $messageStack;
		$basics = new basics;
        @xtc_set_time_limit(0);
		$header = array('Nr','Re-Nr','Typ','Status','Artikel','Grund');
		$schema = implode("\t",$header)."\r\n";
		$date_from = xtc_db_input($_REQUEST['date_from']);
		$date_to = xtc_db_input($_REQUEST['date_to']);
		$query_raw = sprintf(
				"SELECT reclamations_id FROM reclamations WHERE date_created > '%s' AND date_created < '%s' ORDER BY date_created",
				$date_from,$date_to
		);
		$query = xtc_db_query($query_raw);
		$data = array();
		while($record = xtc_db_fetch_array($query)){
			$reclamation = new reclamation($record['reclamations_id']);
			$products_array = array();
			foreach($reclamation->products as $rp){
				$ean_query = xtc_db_query(sprintf(
					"SELECT products_ean FROM %s WHERE products_id='%s'",
					TABLE_PRODUCTS,$rp['id']
				));
				$ean = xtc_db_fetch_array($ean_query);
				$products_array[] = sprintf("pID: %s;EAN: %s; Art-Nr: %s;%s",$rp['id'],str_replace(';','---',$ean['products_ean']),str_replace(';','---',$rp['products_model']),str_replace(';','---',$rp['name']));
			}
			$reasons = array();
			foreach($reclamation->reasons as $rsn){
				$reasons[] = str_replace(';','---',$rsn);
			}
			$data[] = array(
				$record['reclamations_id'],
				$reclamation->info['orders_id'],
				xtc_get_reclamations_types_name($reclamation->info['reclamations_type']),
				xtc_get_reclamations_status_name($reclamation->info['reclamations_status']),
				implode(' | ',$products_array),
				implode(';',$reasons)
			);
		}
		if(sizeOf($data)){
			foreach($data as $line){
				$schema .= implode("\t",$line);
				$schema .= "\r\n";
			}
		}else{
			$messageStack->add_session('Export failed. No reclamations found','error');
			xtc_redirect(xtc_href_link(FILENAME_MODULE_EXPORT,'module=reclamations'));
		}
		// create File
		/*
		die(DIR_FS_CATALOG.'/ebaymich/' . $file);
		$fp = fopen(DIR_FS_CATALOG.'/ebaymich/' . $file, "w+");
		fputs($fp, $schema);
		fclose($fp);
		*/
		$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
		$filename = sprintf('reclamations_%s.csv',$crypt_file);
		$filepath = \main::get_exportdata_path();
		$basics->create_file($filepath.$filename,$schema);
		$basics->zip_file($filepath,$filename,$filename.'.zip',true);

		$file_contents = $basics->read_file_content($filepath.$filename.'.zip',$mode='rb');
		unlink($filepath.$filename.'.zip');
		// send File to Browser
		$file = 'reclamations_'.date('Y-m-d_H_i_s').'.zip';
		header('Content-Type: application/octet-stream');
		header('Content-Transfer-Encoding: binary');
		header('Content-disposition: attachment; filename=' . $file);
		echo $file_contents;
		exit;
	} // end if categories_array

    function display() {
		$from = new \DateTime('-1 Month');
		$from_max = new \DateTime('-1 Day');
		$to = new \DateTime();
		$array = array('text' =>  EXPORT_TYPE.'<br />'.
			MODULE_RECLAMATIONS_STARTDATE.'<br /><input type="date" name="date_from" max="'.$from_max->format('Y-m-d').'" value="'.$from->format('Y-m-d').'"/><br />'.
			MODULE_RECLAMATIONS_ENDDATE.'<br /><input type="date" name="date_to" value="'.$to->format('Y-m-d').'" max="'.$to->format('Y-m-d').'"/><br />'.
			'<br />' . xtc_image_submit('button_export.gif',IMAGE_EXPORT) .
			'<a href="'.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=reclamations').'">'.xtc_image_button('button_cancel.gif',IMAGE_CANCEL).'</a>'
		);
		return $array;
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_RECLAMATIONS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_RECLAMATIONS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_RECLAMATIONS_STATUS');
    }
}
