<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
function paketliste_csv_grouped_filesanitize($string = '', $is_filename = FALSE){
	// Replace all weird characters with dashes
	$string = preg_replace('/[^\w\-'. ($is_filename ? '~_\.' : ''). ']+/u', '-', $string);
	// Only allow one dash separator at a time (and make string lowercase)
	return mb_strtolower(preg_replace('/--+/u', '-', $string), 'UTF-8');
}

function paketliste_csv_grouped_write_file($storage_name,$data){
	$basics = new basics;
	$filename = paketliste_csv_grouped_filesanitize($storage_name.'.csv', true);
	$str = '';
	foreach($data as $line){
		$str .= implode("\t",$line)."\r\n";
	}
	$path = \main::get_exportdata_path().'TMP_GREIFLISTE/';
	if(!is_dir($path)){
		mkdir($path);
		//chmod($path,0777);
	}
	if(is_file($path.$filename)){
		unlink($path.$filename);
	}
	if(strlen($str)){
		$basics->create_file($path.$filename, $str);
		return $path.$filename;
	}
	return '';
}
function paketliste_csv_grouped($process_shipping_id_array=array()){
	$daily_path = \main::get_exportdata_path().yes_get_sha1_from_string( date('Y-m-d') );
	if(!is_dir($daily_path)){
		mkdir($daily_path);
		//chmod($daily_path,0777);
	}
	$ZIP_name = 'GREIFLISTEN_'.date('d_m_Y_H_i_s').'.zip';
	$ZIP_dirname = 'TMP_GREIFLISTE';
	$created_files = array();
	if(sizeOf($process_shipping_id_array)){
		$query = xtc_db_query("SELECT * FROM shippings WHERE status='1' and pdf_status=0 and id IN(".implode(',',$process_shipping_id_array).")");
	}else{
		$query = xtc_db_query("SELECT * FROM shippings WHERE status='1' and pdf_status=0");
	}
	$data = array(
		'Menge',
		'pID',
		'Artikelname',
		'Art-Nr',
		'EAN',
		'Lager',
		'Lagernummer',
		'Lagerort / Platz',
	);
	$greifliste_stammlager = array();
	$greifliste = array();
	$order_products = array();
	while($shipping = xtc_db_fetch_array($query)){
		// enth Produkte der bestellung auslesen
		if($shipping['orders_id'] > 0){
			$order = new order($shipping['orders_id']);
			if(yes_count_shippable_order_products($shipping['orders_id'])){
				$order_products = $order->get_shipped_products_with_collis($order_products);
			}
		}else if($shipping['reclamations_id'] > 0) {
			$reclamation = new reclamation($shipping['reclamations_id']);
			$order_products = $reclamation->get_shipped_products_with_collis($order_products);
		}
	}
	
	if(sizeOf($order_products)){
		foreach($order_products as $pID => $qty){
			
			// HIER DIE QTY ANPASSEN
			
			$spt_query = xtc_db_query(sprintf(
				"SELECT source_storage_products_id,spt.quantity,storage_id,products_id FROM storage_products_transfer spt LEFT JOIN storage_products sp ON spt.source_storage_products_id=sp.id WHERE reason_class='order' AND reason_id='%s' AND reason_subclass='Versand' AND sp.products_id='%s'",
				$order->info['id'],$pID
			));
			if(!xtc_db_num_rows($spt_query)){
				if(!isset($greifliste_stammlager[$pID]))
					$greifliste_stammlager[$pID] = 0;
				$greifliste_stammlager[$pID] += $qty;
				continue;
			}
			$rest_qty = $qty;
			while($spt = xtc_db_fetch_array($spt_query)){
				if( !isset($greifliste[ $spt['storage_id'] ]) )
					$greifliste[ $spt['storage_id'] ] = array();
				if( !isset($greifliste[ $spt['storage_id'] ][ $spt['source_storage_products_id'] ]) )
					$greifliste[ $spt['storage_id'] ][ $spt['source_storage_products_id'] ] = array();
				if( !isset($greifliste[ $spt['storage_id'] ][ $spt['source_storage_products_id'] ][ $pID ] ) )
					$greifliste[ $spt['storage_id'] ][ $spt['source_storage_products_id'] ][ $pID ] = 0;
				$greifliste[ $spt['storage_id'] ][ $spt['source_storage_products_id'] ][ $pID ] += -$spt['quantity'];

				$rest_qty -= -$spt['quantity'];
				//$order_products[$pID] += $spt['quantity'];
			}
			if($rest_qty > 0){
				if(!isset($greifliste_stammlager[$pID]))
					$greifliste_stammlager[$pID] = 0;
				$greifliste_stammlager[$pID] += $rest_qty;
			}
		}
	}
	if(sizeOf($greifliste)){
		foreach($greifliste as $storage_id => $storage_place_array){
			$csv_data = array(0=>$data);
			$storage_name = xtc_get_storage_name($storage_id);
			foreach($storage_place_array as $storage_place_id=>$products_array){
				$query = xtc_db_query(sprintf(
					"SELECT storage_place FROM storage_products WHERE id='%s'",
					$storage_place_id
				));
				$record = xtc_db_fetch_array($query);
				foreach($products_array as $pID => $qty){
					$product_query = xtc_db_query(sprintf(
						"SELECT products_model,products_ean FROM products WHERE products_id='%s'",
						$pID
					));
					$product_record = xtc_db_fetch_array($product_query);
					$csv_data[] = array(
						$qty,
						$pID,
						xtc_get_products_name($pID),
						$product_record['products_model'],
						$product_record['products_ean'],
						$storage_name,
						xtc_get_storage_number($storage_id,$pID),
						$record['storage_place']
					);
				}
			}
			$file = paketliste_csv_grouped_write_file($storage_name,$csv_data);
			if($file != ''){
				$created_files[] = $file;
			}
		}
	}
	if(sizeOf($greifliste_stammlager)){
		foreach($greifliste_stammlager as $pID=>$qty){
			$csv_data = array(0=>$data);
			$storage_name = 'UNZUGEWIESEN_STAMMLAGER';
			$product_query = xtc_db_query(sprintf(
				"SELECT products_model,products_ean FROM products WHERE products_id='%s'",
				$pID
			));
			$product_record = xtc_db_fetch_array($product_query);
			$csv_data[] = array(
				$qty,
				$pID,
				xtc_get_products_name($pID),
				$product_record['products_model'],
				$product_record['products_ean'],
				$storage_name,
				'-',
				'-'
			);
			$file = paketliste_csv_grouped_write_file($storage_name,$csv_data);
			if($file != ''){
				$created_files[] = $file;
			}
		}
	}
	if(!sizeOf($created_files)){
		return false;
	}
	$basics = new basics;
	$basics->zip_files($ZIP_dirname, $ZIP_name, \main::get_exportdata_path(), true);
	copy(\main::get_exportdata_path().$ZIP_name, $daily_path.'/'.$ZIP_name);
	unlink(\main::get_exportdata_path().$ZIP_name);
}
