<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'xtc_recalculate_price.inc.php');
require(DIR_FS_INC.'xtc_get_serial_number.inc.php');
require_once(DIR_FS_INC . 'xtc_remove_non_numeric.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_is_shipping_before_payment.inc.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_FS_INC . 'yes_end_auction_add.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ebay_seller_data.inc.php');

require_once(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
require_once(DIR_WS_CLASSES . 'order.php');
require_once(DIR_WS_CLASSES . 'product.php');
require_once(DIR_WS_CLASSES . 'class.branch_quantity.php');
if(defined('MODULE_OTHER_CASHIER_STATUS') and MODULE_OTHER_CASHIER_STATUS == 'True'){
	if(!isset($_SESSION['module_cashier_cashier_id'])){
		$_SESSION['module_cashier_cashier_id'] = $_SESSION['customer_id'];
	}
	if(!isset($_SESSION['module_cashier_seller_id'])){
		$_SESSION['module_cashier_seller_id'] = 0;
	}
	if(isset($_REQUEST['sellers_id']))
		$_SESSION['module_cashier_seller_id'] = (int)xtc_db_input($_REQUEST['sellers_id']);
	if(isset($_REQUEST['cashier_id']))
		$_SESSION['module_cashier_cashier_id'] = (int)xtc_db_input($_REQUEST['cashier_id']);
	include(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/cashier.php');
}

if(  defined('YES_BRANCHES_COUNT') and YES_BRANCHES_COUNT > 0 and !isset($_SESSION['allocated_branches_id'])){
    if(!has_concergio_special_auth()){
	$messageStack->add_session(MSG_ERROR_NO_BRANCH_ALLOCATED,'error');
	xtc_redirect(xtc_href_link('start.php'));
    }
}

// yes accounting
$admin_access = main::get_admin_access();
if(!defined('KASSE_DEFAULT_CUSTOMER')){
    define('KASSE_DEFAULT_CUSTOMER',KASSE_USER);
}
if(isset($defaultuser['customers_status'])){
    define('KASSE_GROUP_ID',$defaultuser['customers_status']);
}
define('KASSE_DEFAULT_CURRENCY',DEFAULT_CURRENCY);

$currency = KASSE_DEFAULT_CURRENCY;
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

// KUNDE ERMITTELN
if(!isset($_SESSION['kasse_customers_id'])){
    if(!customer::exists(KASSE_DEFAULT_CUSTOMER)){
        $messageStack->add_session('Es wurde ein ungültiger Kasse User definiert (KASSE_DEFAULT_CUSTOMER)','error');
        xtc_redirect(xtc_href_link('start.php'));
    }
    $_SESSION['kasse_customers_id'] = KASSE_DEFAULT_CUSTOMER;
}
$cID = $_SESSION['kasse_customers_id'];
if( isset($_REQUEST['cID']) and  $_REQUEST['cID'] != ''){
	$cID = xtc_db_prepare_input($_REQUEST['cID']);
	$_SESSION['kasse_customers_id'] = $cID;
}
if(!isset($_SESSION['mycart'])){
	$_SESSION['mycart'] = new shoppingCart($cID);
	$_SESSION['cart'] = $_SESSION['mycart'];
}
if($cID != KASSE_DEFAULT_CUSTOMER){
	$customers_status = xtc_oe_get_customers_status($cID);
}else{
	$customers_status = xtc_oe_get_customers_status(KASSE_USER);
}
$xtPrice = new xtcPrice($currency,$customers_status);

// FILIALE ERMITTELN
$customers_branches_id_query = xtc_db_query("SELECT branches_id FROM customers WHERE customers_id='".$_SESSION['customer_id']."'");
$customers_branches_id = xtc_db_fetch_array($customers_branches_id_query);
$cbID = $customers_branches_id['branches_id'];
$kasse_filiale =  ($cbID > 0) ? xtc_get_branch_title($cbID) : CASHPOINT_STAMMLAGER;
$kasse_filiale_change_link = xtc_href_link('start.php');

$stammlager = 1; // von wo wird der bestand der artikel geholt
if($cbID > 0){
	$branch_stammlager_query = xtc_db_query("SELECT stammlager FROM branches WHERE branches_id='".$cbID."'");
	$branch_stammlager = xtc_db_fetch_array($branch_stammlager_query);
	$stammlager = $branch_stammlager['stammlager'];
}

function _getMaxKey($array) {
    if (is_array($array)) {
        $max = false;
	$max_key = false;
        foreach($array as $key=>$val) {
            if (is_array($val)) $val = _getMax($val);
            if (($max===false || $val>$max) && is_numeric($val)) {
		$max = $val;
		$max_key = $key;
	    }
        }
    } else return is_numeric($array)?$array:false;
    return $max_key;
}
if(!$_SESSION['cart']->count_contents()){
    unset($_SESSION['discount_price_counter'][$cID]);
}

$action = (isset($_REQUEST['action']) ? $_REQUEST['action'] : '');
switch($action){
    case 'json_order_details_update':
        if(!isset($_GET['pID']) or !is_array($_GET['pID']) or !sizeOf($_GET['pID'])){
            die(json_encode(array(
                'ERROR'=>'Missing Parameter'
            )));
        }
        foreach($_GET['pID'] as $pID => $qty){
            if(!isset($_SESSION['cart']->contents[$pID])){
                die(json_encode(array(
                    'ERROR'=>'Product '.$pID.' is not in shopping cart'
                )));
            }
        }
        foreach($_GET['pID'] as $pID => $qty){
            if($qty < 1){
                $_SESSION['cart']->remove($pID);
            }else{
                $_SESSION['cart']->update_quantity($pID, $qty);
            }
        }
        $contents = $_SESSION['cart']->get_products($customers_status, $xtPrice);
        $product_final_prices = [];
        foreach($_GET['pID'] as $pID => $qty){
            foreach($contents as $content){
                if($content['id'] == $pID){
                    $products_price=$xtPrice->xtcGetPrice(xtc_get_prid($pID),
                            false,
                            $qty,
                            $content['tax_class_id'],
                            $content['price']
                    );
                    // ES KANN NATUERLICH UNTER IRGENDWELCHEN UMSTAENDEN SEIN
                    // DAS AN DER KASSE NICHT DER MWST SATZ BASIEREND AUF 
                    // STORE_COUNTRY UND STORE_ZONE_ID GILT, ABER DAS MUSS DANN
                    // NEU PROGRAMMIERT WERDEN, WEIL DANN EINE RE-ADRESSE FEST-
                    // STEHEN MUSS - 03/2020
                    $country_id = STORE_COUNTRY;
                    $zone_id = STORE_ZONE;
                    $products_price_netto = $xtPrice->xtcRemoveTax($products_price, xtc_get_tax_rate($content['tax_class_id'],
                            $country_id,$zone_id
                    ));
                    $properties_add_netto = shoppingCart::get_product_properties_price_netto($pID);
                    
                    
                    $product_final_prices[ $pID ] = array(
                        'price'=>$xtPrice->xtcFormat($products_price_netto+$properties_add_netto, true, $content['tax_class_id'], DEFAULT_CURRENCY),
                        'final_price'=>$xtPrice->xtcFormat(($products_price_netto+$properties_add_netto)*$qty, true, $content['tax_class_id'], DEFAULT_CURRENCY)
                    );
                }
            }
        }
        $error = '';
        die(json_encode(array(
            'ERROR'=>$error,
            'MSG'=>array(
                'total_raw'=>$_SESSION['cart']->show_total($customers_status),
                'total'=>'Summe: '.$xtPrice->xtcFormat($_SESSION['cart']->show_total($customers_status),true),
                'product_final_prices'=>$product_final_prices
            )
        )));
        break;
    case 'toggle_wechselgeld_calculator':
        $update_sql_array = array(
            'wechselgeld_calculator'=>($_GET['active'] == 1) ? 1 : 0
        );
        xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$_SESSION['customer_id']."'");
        die(json_encode(array(
            'ACTIVE'=>$update_sql_array['wechselgeld_calculator']
        )));
        break;
    case 'rueckerstattungen':
	include('kasse.rueckerstattungen.php');
	break;
    case 'remove_discount':
	$_SESSION['discount_price_counter'] = array();
	xtc_redirect(xtc_href_link('kasse.php'));
	break;
    case 'add_discount_process':
	$tax_rates = array();
	$products_price_total = 0;
	$cs = xtc_get_customer_status($cID);
	foreach($_SESSION['cart']->get_products($cs['customers_status']) as $item){
	    $tax_rate = number_format( xtc_get_tax_rate($item['tax_class_id']),2,'.','' );
            if(PRICE_IS_BRUTTO == 'true'){
                $price_brutto = $item['final_price'];
                $price_netto = xtc_oe_get_price_o_tax($price_brutto, $tax_rate, false);
                $tax_rates[ $tax_rate ] += $price_brutto-$price_netto;
            }else{
                $price_brutto = $xtPrice->xtcGetPrice($item['id'], false,1,$item['tax_class_id'],$item['price'])*$item['quantity'];
                $tax_rates[ $tax_rate ] += $price_brutto-($item['price']*$item['quantity']);
            }
	    $products_price_total += $price_brutto;
	}
	$tax_rate = _getMaxKey($tax_rates);
	$discount = str_replace(',','.',xtc_db_input($_REQUEST['discount']));
	$discount_percent = 0;
	if(strpos($discount,'%')){
	    $discount_percent = (float)substr($discount,0,strpos($discount,'%'));
	}else{
	    $discount = (float)$discount;
	    if(PRICE_IS_BRUTTO != 'true'){
		$discount = xtc_oe_get_price_i_tax($discount, $tax_rate);
                // 2021/07: Da die tax_rate als parameter verwendet wird, 
                // darf nicht true uebergeben werden
                //$discount = xtc_oe_get_price_i_tax($discount, $tax_rate, true);
	    }
	}
	if($discount <= 0){
	    $messageStack->add_session(MSG_ERROR_ADD_DISCOUNT_NULL,'error');
	    xtc_redirect(xtc_href_link('kasse.php'));
	}
	if($discount_percent > 0){
	    $discount_price = $xtPrice->xtcFormat($products_price_total, false) / 100 * $discount_percent *-1;
	}else{
	    $discount_price = -$discount;
	}
	$_SESSION['discount_price_counter'][$cID] = array(
	    'DISCOUNT'=>$discount,
	    'TITLE'=>xtc_db_input(yes_decode_string($_REQUEST['discount_title']))
	);
	xtc_redirect(xtc_href_link('kasse.php'));
	break;
    case 'add_discount':
	
	echo xtc_draw_form('add_discount_form','kasse.php',xtc_get_all_get_params(array('action')).'action=add_discount_process');
	echo '<fieldset>';
	echo '<label for="discount_title">'.TEXT_ADD_DISCOUNT_TITLE.'</label><br />';
	$cs = xtc_get_customer_status($cID);
	$title = TEXT_ADD_DISCOUNT_TITLE_DEFAULT;
	echo xtc_draw_input_field('discount_title',$title,'id="discount_title" size="40" maxlength="64"').'<br />';
	echo '<label for="discount">'.TEXT_ADD_DISCOUNT.'</label><br />';
	echo xtc_draw_input_field('discount','0,00','id="discount" size="10" maxlength="10"');
	echo (PRICE_IS_BRUTTO=='false') ? ' <i>Netto</i>': ' <i>Brutto</i>';
/*	echo '<br />';
	echo '<label for="discount_at">'.TEXT_ADD_DISCOUNT_AT.'</label><br />';
	echo xtc_draw_pull_down_menu('discount_at',array(array('id'=>'order','text'=>TEXT_ADD_DISCOUNT_AT_ORDER),array('id'=>'products','text'=>TEXT_ADD_DISCOUNT_AT_PRODUCTS)),'id="discount_at"');
 *
 */
	echo '<br /><input type="submit" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
	echo '</fieldset>';
	echo '</form>';
	exit;
	break;
    case 'check_gift':
	$gv_redeem_code = trim(xtc_db_input($_REQUEST['gv_redeem_code']??''));
        if(empty($gv_redeem_code)){
            throw new Exception('Missing gv_redeem_code to check gift');
        }
	$REMOTE_ADDR = ''; // keine remote addr da kasse
	$target_url_filename = 'kasse.php';
        $gv = \YES4Trade\Model\coupons::get_by_coupon_code($gv_redeem_code);
        if ($gv !== null and $gv->coupon_active=='Y') {
            $redeems = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($gv_result['coupon_id']));
            if ( sizeOf($redeems) > 0 and $gv->coupon_type == 'G' ) {
                $messageStack->add_session(sprintf(ERROR_NO_INVALID_REDEEM_GV,$gv_redeem_code),'error');
                xtc_redirect(xtc_href_link('kasse.php'));
            }
        }  else {
            $messageStack->add_session(sprintf(ERROR_NO_INVALID_REDEEM_GV,$gv_redeem_code),'error');
            xtc_redirect(xtc_href_link('kasse.php'));
        }
        $gv_result = $gv->toArray();
        if ($gv->coupon_type == 'G') {
            $gv_amount = $gv_result['coupon_amount'];
            $gvc = \YES4Trade\Model\coupon_gv_customer::get_by_customer_id(intval($cID));
            $customer_gv = false;
            $total_gv_amount = $gv_amount;
            if ($gvc !== null) {
                $total_gv_amount = (float)$gvc->amount + (float)$gv_amount;
                $customer_gv = true;
            }
            $upd = new \YES4Trade\Model\coupons([
                'coupon_active' => 'N',
                'coupon_id'=>$gv->coupon_id
            ]);
            $upd->update();
            $new = new \YES4Trade\Model\coupon_redeem_track([
                'coupon_id'=> intval($gv_result['coupon_id']), 
                'customer_id'=>intval($cID), 
                'redeem_date'=>date('Y-m-d H:i:s'), 
                'redeem_ip' => $REMOTE_ADDR
            ]);
            $new->create();
            if ($customer_gv) {
                // already has gv_amount so update
                $upd = new \YES4Trade\Model\coupon_gv_customer([
                    'amount' => (float)$total_gv_amount,
                    'customer_id' => intval($cID)
                ]);
                $upd->update();
            } else {
                // no gv_amount so insert
                $new = new \YES4Trade\Model\coupon_gv_customer([
                    'customer_id'=>intval($cID), 
                    'amount'=>(float)$total_gv_amount
                ]);
                $new->create();
            }
            $cc_id = $gv_result['coupon_id']; //Fred ADDED, set the global and session variable
            $_SESSION['cc_id_counter'][$cID] = $cc_id;
            $messageStack->add_session(REDEEMED_AMOUNT. $xtPrice->xtcFormat($gv_amount,true),'success');
            xtc_redirect(xtc_href_link('kasse.php'));
	}
	

        if ($gv === null) {
            $messageStack->add_session(ERROR_NO_INVALID_REDEEM_COUPON,'error');
            xtc_redirect(xtc_href_link($target_url_filename));
        }
        if(DateTime::createFromFormat('Y-m-d H:i:s', $gv->coupon_start_date) > new DateTime()){
            $messageStack->add_session(ERROR_INVALID_STARTDATE_COUPON,'error');
            xtc_redirect(xtc_href_link($target_url_filename));
        }
        if(DateTime::createFromFormat('Y-m-d H:i:s', $gv->coupon_expire_date) < new DateTime()){
            $messageStack->add_session(ERROR_INVALID_FINISDATE_COUPON,'error');
            xtc_redirect(xtc_href_link($target_url_filename));
        }

        $coupon_count = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id(intval($coupon_result['coupon_id']),[
            'coupon_id'
        ]);
        $coupon_count_customer = \YES4Trade\Model\coupon_redeem_track::get_by_coupon_id_and_customers_id(
            intval($coupon_result['coupon_id']),
            intval($cID),[
                'coupon_id'
            ]
        );
        if (sizeOf($coupon_count) >= intval($coupon_result['uses_per_coupon']) and intval($coupon_result['uses_per_coupon']) > 0) {
            $messageStack->add_session(sprintf(ERROR_INVALID_USES_COUPON,$coupon_result['uses_per_coupon']),'error');
            xtc_redirect(xtc_href_link($target_url_filename));
        }

        if (sizeOf($coupon_count_customer) >= intval($coupon_result['uses_per_user']) and intval($coupon_result['uses_per_user']) > 0) {
            $messageStack->add_session(sprintf(ERROR_INVALID_USES_USER_COUPON,$coupon_result['uses_per_user']),'error');
            xtc_redirect(xtc_href_link($target_url_filename));
        }
        if ($coupon_result['coupon_type']=='S') {
            $messageStack->add_session(ERROR_COUPON_TYPE_S_NOT_IN_ADMIN,'error');
            xtc_redirect(xtc_href_link($target_url_filename));
        } else {
            $coupon_amount = $coupon_result['coupon_amount'] . ' ';
        }
        if ($coupon_result['coupon_type']=='P'){
            $coupon_amount = $coupon_result['coupon_amount'] . '% ';
        }
        if ($coupon_result['coupon_minimum_order']>0){
            $coupon_amount .= 'on orders greater than ' . $coupon_result['coupon_minimum_order'];
        }
        // DEPRECATED (mario)
        //if (!xtc_session_is_registered('cc_id')) xtc_session_register('cc_id'); //Fred - this was commented out before
        $cc_id = $coupon_result['coupon_id']; //Fred ADDED, set the global and session variable
        $_SESSION['cc_id_counter'][$cID] = $cc_id;
        $messageStack->add_session(REDEEMED_COUPON,'success');
        xtc_redirect(xtc_href_link($target_url_filename));
	break;
    case 'cart_product_title_update':
	if($admin_access['f_orders_edit_products'] == 1){
	    $cart_products_id = $_REQUEST['cart_products_id'];
	    $_SESSION['mycart']->contents[$cart_products_id]['title'] = yes_decode_string($_REQUEST['title']);
	}
	exit;
	break;
    case 'history':
		// HISTORY
		$smarty->assign(array(
			'TEXT_ORDERS_ID'=>TEXT_ORDERS_ID,
			'TEXT_BUYER'=>TEXT_BUYER,
			'TEXT_BUY_FROM_STORAGE'=>TEXT_BUY_FROM_STORAGE,
			'TEXT_PAYMENT_METHOD'=>TEXT_PAYMENT_METHOD,
			'TEXT_DATE_PURCHASED'=>TEXT_DATE_PURCHASED,
			'CASHPOINT_BRANCH'=>CASHPOINT_BRANCH,
			'CASHPOINT_TITLE'=>CASHPOINT_TITLE
		));
			
		$history = array();
		$query = xtc_db_query(sprintf(
			"SELECT paymode,customers_id,orders_id,date_purchased,branches_id FROM kasse WHERE date_purchased > '%s 00:00:00' ORDER BY date_purchased DESC",
			date('Y-m-d')
		));
		while($record = xtc_db_fetch_array($query)){
			$record['customers_name'] = xtc_get_editor_name($record['customers_id']);
			$record['branch'] = ($record['branches_id'] > 0) ? xtc_get_branch_title($record['branches_id']) : CASHPOINT_STAMMLAGER;
			$record['order_link'] = xtc_href_link(FILENAME_ORDERS,'oID='.$record['orders_id'].'&action=edit');
			$history[] = $record;
		}
		if(sizeOf($history)){
			$smarty->assign('HISTORY',$history);
		}
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('kasse_history.html');
		exit;
		break;
	case 'change_price_process':
		$pID = xtc_db_input($_REQUEST['products_id']);
		$price = (float)str_replace(',','.',xtc_db_input($_REQUEST['price']));
		if($price == 0)
			die(TEXT_ERROR_PRICE_NOT_VALID);
		if($admin_access['f_kasse_change_prices'] != 1){
			$user = xtc_db_input($_REQUEST['user']);
			$pass = xtc_db_input($_REQUEST['password']);
			$query = xtc_db_query(sprintf(
				"SELECT customers_id FROM customers WHERE customers_id=%s AND customers_password='%s'",
					$user,md5($pass)
			));
			if(!xtc_db_num_rows($query)){
				die(TEXT_ERROR_LOGINDATA);
			}
		}
		foreach($_SESSION['cart']->contents as $item_pID => $product){
			if($pID == $item_pID){
                                if(PRICE_IS_BRUTTO === 'true'){
                                    $tax_class_id = yes_eu_oss_get_products_tax_class_id($item_pID, STORE_COUNTRY);
                                    $tax_rate = xtc_get_tax_rate($tax_class_id);
                                    $price = xtc_oe_get_price_o_tax($price, $tax_rate);
                                }
                                // hier war vorher noch ein calculate() angehaengt
                                // ist aber ueberfluessig da nach preisaenderung
                                // sowieso nochmal redirected wird
				$_SESSION['cart']->contents[$item_pID]['price'] = $price;
				die('OK');
			}
		}
		
		exit;
		break;
	case 'edit_price':
		$pID = xtc_db_input($_REQUEST['products_id']);
		$prID = xtc_get_prid($pID);
		$smarty->assign(array(
			'TEXT_CHANGE_PRICE_INTRO'=>sprintf(TEXT_CHANGE_PRICE_INTRO,xtc_get_products_name($prID)),
			'TEXT_CHOOSE_AUTHORIZED_USER'=>TEXT_CHOOSE_AUTHORIZED_USER,
			'IMAGE_SAVE'=>IMAGE_SAVE,
			'PRODUCTS_ID'=>$pID,
			'BASE_LINK'=>xtc_href_link('kasse.php'),
		));
		if($admin_access['f_kasse_change_prices'] != 1){
                    $user = array();
                    $user_array = main::get_notice_recipients('f_kasse_change_prices');
                    foreach($user_array as $row){
                        $user[] = array(
                                'id'=>$row['customers_id'],
                                'text'=>  xtc_get_editor_name($row['customers_id'])
                        );
                    }
                    if(sizeOf($user)){
                        $smarty->assign('INPUT_USER',xtc_draw_pull_down_menu('user',$user,'','id="cp_user"'));
                        $smarty->assign('INPUT_PASSWORD',  '<input type="password" id="cp_password" name="password" />');
                    }else{
                        $smarty->assign('ERROR',TEXT_ERROR_NO_ADMIN_ACCESS);
                    }
		}else{
                    $smarty->assign('ALLOW_EDIT',1);
		}
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($prID, STORE_COUNTRY);
		$properties_add_price_netto = 0;
		if(strstr($pID,'{')){
                    $properties = array();
                    $parts = explode('{',$pID);
                    $ppvID_parts = explode(',',substr($parts[1],0,strlen($parts[1])-1));
                    foreach($ppvID_parts as $ppvID){
                    	if(strpos($ppvID,':')>0){
                    		$_ppvID_parts = explode(':',$ppvID);
                    		$ppvID = $_ppvID_parts[0];
                    	}
                    
                        $ppvID = xtc_db_input($ppvID);
                        $ppv = new product_properties_values($ppvID);
                        $pp = new product_properties($ppv->getProducts_properties_id());
                        $properties[] = array(
                            'value'=>$ppv->getDescription($_SESSION['languages_id'])->getTitle(),
                            'price_netto'=>$ppv->getPrice(),
                            'price_brutto'=>$xtPrice->xtcFormat($ppv->getPrice(), false, $products_tax_class_id),
                            'property'=>$pp->getDescription($_SESSION['languages_id'])->getTitle()
                        );
                        $properties_add_price_netto += $ppv->getPrice();
                    }
                    $smarty->assign('PROPERTIES',$properties);
		}
		if(!isset($_SESSION['cart']->contents[$pID]['price'])){
                    $query = xtc_db_query(sprintf(
                        "SELECT products_price FROM products WHERE products_id=%s",
                        $prID
                    ));
                    $row = xtc_db_fetch_array($query);
                    $price = $xtPrice->xtcGetPrice($pID,false,1,$products_tax_class_id);
                    if($properties_add_price_netto > 0){
                        $price += $xtPrice->xtcFormat($properties_add_price_netto,false,$products_tax_class_id);
                    }
		}else{
                    if(PRICE_IS_BRUTTO == 'true'){
                        $tax_class_id = yes_eu_oss_get_products_tax_class_id($prID, STORE_COUNTRY);
                        $tax_rate = xtc_get_tax_rate($tax_class_id);
			$price = xtc_oe_get_price_i_tax($_SESSION['cart']->contents[$pID]['price'], $tax_rate);
                    }else{
			$price = $_SESSION['cart']->contents[$pID]['price'];
                    }
		}
		$price = number_format($price,2,',','');
		$smarty->assign('INPUT_PRICE',xtc_draw_input_field('price',$price,'id="cp_price"'));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('kasse_change_price.html');
		exit;
		break;
	case 'process':
		include('includes/process_kasse.inc.php');
		// $insert_id = orders_id
		// $paymode_code = bar,ec oder cc
		xtc_redirect(xtc_href_link('kasse.php','action=print_order&oID='.$insert_id.'&kasse_payment_code='.$paymode_code));
		break;
	case 'update_product':
                for ($i = 0, $n = sizeof($_POST['products_id']); $i < $n; $i++) {
                    if ($_POST['cart_quantity'][$i]>MAX_PRODUCTS_QTY) {
                        $_POST['cart_quantity'][$i]=MAX_PRODUCTS_QTY;
                    }
                    $properties = array();
                    $_SESSION['cart']->add_cart($_POST['products_id'][$i], 
                        xtc_remove_non_numeric($_POST['cart_quantity'][$i]), 
                        $properties
                    );
                }
		$_SESSION['cart']->calculate($customers_status);
		$messageStack->add_session(MSG_SUCCESS_CART_UPDATED,'success');
		xtc_redirect(xtc_href_link('kasse.php'));
		break;
	case 'delete':
		$prID = (int)xtc_db_input($_REQUEST['products_id']);
		if($prID > 0){
			$_SESSION['cart']->remove(xtc_db_input($_REQUEST['products_id']));
			$messageStack->add_session(MSG_SUCCESS_ITEM_REMOVED,'success');
		}
		xtc_redirect(xtc_href_link('kasse.php'));
		break;
	case 'show_cart':
			/**************************************************************************************************
			 WARENKORB IM ADMINBEREICH
			 - includes/modules/order_details_cart.php
			 - templates/CURRENT_TEMPLATE/module/shopping_cart_admin.html
			 - templates/CURRENT_TEMPLATE/module/order_details_admin.html
			**************************************************************************************************/
			$cart_smarty = new yesSmarty;
	    
			error_reporting(E_ERROR);
	    
			if(defined('MODULE_OTHER_CASHIER_STATUS') and MODULE_OTHER_CASHIER_STATUS == 'True'){
				include('cashier_kasse.inc.php');
			}
			$cart_empty = false;
			if ($_SESSION['cart']->count_contents() > 0) {
				$cart_smarty->assign('FORM_ACTION',xtc_href_link('kasse.php', 'action=update_product'));
				$hidden_options='';
				$_SESSION['any_out_of_stock']=0;
				$products = $_SESSION['cart']->get_products($customers_status,$xtPrice);
				
				$cart_smarty->assign('HIDDEN_OPTIONS',$hidden_options);
				// $cc_value aus gift_cart_admin hat den Gutscheinwert
				require('includes/modules/gift_cart_admin.php');
				// $counter_discount aus order_details_cart.php hat den Kassenrabatt
				require('includes/modules/order_details_cart.php');

									
				if (STOCK_CHECK == 'true') {
					if ($_SESSION['any_out_of_stock']== 1) {
						if (STOCK_ALLOW_CHECKOUT == 'true') {
							// write permission in session
								$_SESSION['allow_checkout'] = 'true';
								$cart_smarty->assign('info_message','F&#252;r diesen Artikel ist kein Bestand verf&#252;gbar. Der Vorgang kann trotzdem abgeschlossen werden.');
				
						} else {
							$_SESSION['allow_checkout'] = 'false';
							$cart_smarty->assign('info_message','F&#252;r diesen Artikel ist kein Bestand verf&#252;gbar. Der Vorgang kann nicht abgeschlossen werden.');
						}
					} else {
						$_SESSION['allow_checkout'] = 'true';
					}
				}
				
				if (isset($_GET['info_message'])) 
					$cart_smarty->assign('info_message',$_GET['info_message']);
				
				$payments = yes_get_kasse_payments();
				foreach($payments as $k=>$pay){
					switch($pay['text']){
						case 'Kreditkarte':
							$payments[$k]['img'] = 'images/kasse_cc.png';
							break;
						case 'EC-Karte':
							$payments[$k]['img'] = 'images/kasse_ec.png';
							break;
						case 'Barzahlung':
							$payments[$k]['img'] = 'images/kasse_bar.png';
							break;
						case 'Rechnung':
							$payments[$k]['img'] = 'images/kasse_invoice.png';
							break;
						default:
						    if($payments[$k]['image'] != ''){
							$payments[$k]['img'] = \main::get_importdata_path().$payments[$k]['image'];
						    }
						    break;
					}
				}
				$cart_smarty->assign('PAYMENT_METHODS',$payments);
				$cart_smarty->assign('BASE_LINK',xtc_href_link('kasse.php'));
				$cart_smarty->assign('JS_CONFIRM_PAYMENT_METHOD',JS_CONFIRM_PAYMENT_METHOD);
				
				$cart_smarty->assign('JS_CONFIRM_MONEY_GIVEN_INTRO',JS_CONFIRM_MONEY_GIVEN_INTRO);
				$cart_smarty->assign('JS_CONFIRM_MONEY_GIVEN',JS_CONFIRM_MONEY_GIVEN);
				$cart_smarty->assign('JS_ALERT_MONEY_BACK',JS_ALERT_MONEY_BACK);
				$cart_smarty->assign(array(
				    'JS_ALERT_MONEY_BACK'=>JS_ALERT_MONEY_BACK,
				    'CC_VALUE'=>$cc_value,
				    'TEXT_ADD_DISCOUNT'=>TEXT_ADD_DISCOUNT,
				    'TEXT_ADD_DISCOUNT_BUTTON'=>TEXT_ADD_DISCOUNT_BUTTON,
				    'TEXT_REMOVE_DISCOUNT'=>TEXT_REMOVE_DISCOUNT,
				    'TEXT_REMOVE_DISCOUNT_BUTTON'=>TEXT_REMOVE_DISCOUNT_BUTTON,
				));

				// discount wird in der order_details_cart.php bereits ermittelt
				$cart_smarty->assign('TOTAL_SUM_CLEAN',number_format($xtPrice->xtcFormat($_SESSION['cart']->show_total($customer_group)-$discount-$cc_value+$counter_discount,false),2,'.',''));
				
				$cart_smarty->assign('BUTTON_RELOAD_TEXT',IMAGE_UPDATE);
				$cart_smarty->assign('BUTTON_CHECKOUT','<a href="'.xtc_href_link('kasse.php').'">'.xtc_image(DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/buttons/'.$_SESSION['language'].'/button_checkout.gif', IMAGE_BUTTON_CHECKOUT).'</a>');
				
			} else {
				// empty cart
				$cart_empty=true;
				if (isset($_GET['info_message'])) 
					$cart_smarty->assign('info_message',$_GET['info_message']); 
				$cart_smarty->assign('BUTTON_CONTINUE','&nbsp;');
				
			}
                        $query = xtc_db_query(sprintf(
                                "SELECT wechselgeld_calculator FROM %s WHERE customers_id='%s'",
                                TABLE_CUSTOMERS, $_SESSION['customer_id']
                        ));
                        $record = xtc_db_fetch_array($query);
                        $wgc = ($record['wechselgeld_calculator'] == 1) ? true : false;
			$cart_smarty->assign(array(
			    'language' => $_SESSION['language'],
			    'JS_ALERT_MONEY_GIVEN_ERROR'=>JS_ALERT_MONEY_GIVEN_ERROR,
			    'cart_empty'=>$cart_empty,
                            'WECHSELGELD_KALKULATOR_TEXT'=>(($wgc)?TEXT_WECHSELGELD_CALCULATOR_ACTIVE:TEXT_WECHSELGELD_CALCULATOR_INACTIVE),
                            'WECHSELGELD_KALKULATOR_CSS_CLASS'=>(($wgc)?'ui-state-default':'ui-state-error'),
                            'TEXT_WECHSELGELD_CALCULATOR_INTRO'=>TEXT_WECHSELGELD_CALCULATOR_INTRO,
                            'TEXT_WECHSELGELD_CALCULATOR'=>TEXT_WECHSELGELD_CALCULATOR,
                            'TEXT_WECHSELGELD_CALCULATOR_ACTIVE'=>TEXT_WECHSELGELD_CALCULATOR_ACTIVE,
                            'TEXT_WECHSELGELD_CALCULATOR_INACTIVE'=>TEXT_WECHSELGELD_CALCULATOR_INACTIVE,
			));
			$cart_smarty->caching = 0;
		header('Content-Type: text/html; charset='.CHARSET);
		$cart_smarty->display(DIR_FS_ADMIN.'templates/shopping_cart_admin.html');
		exit;
		break;
	case 'addtocart':
            $qty = 1;
	    $params = explode('{',$_REQUEST['pID']);
	    $pID = $params[0];
	    $properties = array();
	    if(isset($params[1])){
		$par = str_replace('}','',$params[1]);
		$properties = explode(',',$par);
	    }
	    if($pID > 0){
			foreach($_SESSION['cart']->contents as $cart_pid=>$cart_item){
				$compare = $cart_pid;
				$compare = xtc_get_prid($compare);
				if($compare == $_GET['pID']){
				$_SESSION['cart']->update_quantity($cart_pid, $cart_item['qty']+$qty);
					xtc_redirect(xtc_href_link('kasse.php','action=show_cart'));
				}
			}
			$_SESSION['cart']->add_cart(xtc_db_input($_REQUEST['pID']), 
				$qty,$properties
			);
	    }
	    xtc_redirect(xtc_href_link('kasse.php','action=show_cart'));
	    break;
	case 'search':
		$products_title = xtc_db_prepare_input($_REQUEST['search']);
		$products_description = (isset($_REQUEST['products_description']) and xtc_db_prepare_input($_REQUEST['products_description']) == 1 ) ? true : false;
		$res = array();
		$results = array();

		$saved = ''; // wird gefuellt mit den category-excludes des users
		$saved_query = xtc_db_query("SELECT categories_id FROM categories_exclude WHERE customers_id='".$_SESSION['customer_id']."'");
		while( $saved_res = xtc_db_fetch_array($saved_query) ){
			$saved .= " p2c.categories_id != '".$saved_res['categories_id']."' and";
		}
		if(strlen($saved)>0){
			$saved = substr($saved,0,(strlen($saved)-4));
			$saved = ' and ( '.$saved.' )';
		}

		if(strlen($products_title)>0){
			$query_raw  = "SELECT p2c.categories_id,p.products_price,pd.products_name,p.products_model,p.products_ean,p.products_image,p.products_id,pd.products_description FROM products p,products_description pd,products_to_categories p2c WHERE p2c.products_id=p.products_id and (pd.products_name LIKE '%".$products_title."%' or p.products_id='".(int)$products_title."' or p.products_model LIKE '%".$products_title."%' or p.products_ean LIKE '%".$products_title."%' ";
			if($products_description)
				$query_raw .= " OR pd.products_description LIKE '%".$products_title."%' ";
			$query_raw .= ") && pd.products_id=p.products_id && pd.language_id='".$_SESSION['languages_id']."'";
			$query_raw .= $saved;
			$query = xtc_db_query($query_raw);
			$double_pID = array(); // verhindern das doppelte Produkte gelistet werden

			while($search_result = xtc_db_fetch_array($query)){
				if(!in_array($search_result['products_id'],$double_pID)){
                                    $collies = xtc_get_product_collies( $search_result['products_id'] );
                                    if( sizeOf($collies)>0 ){
                                        $search_result['collies'] = $collies;
                                    }
                                    if($stammlager == 1){
                                        $SQ = new products_quantity( $search_result['products_id'] );
                                        $qty_total = $SQ->get_products_total_qty();
                                        $search_result['AV1'] = $SQ->get_available1_qty();
                                        $av1_check_value = $search_result['AV1'];
                                    }else{
                                        $BQ = new branch_quantity($search_result['products_id'],$cbID);
                                        $qty_total = $BQ->get_quantity();
                                        //$search_result['AV1'] = $qty_total;
                                        $av1_check_value = $qty_total;
                                        $branch_allocation_exists = $BQ->allocation_exists();
                                    }
                                    $search_result['products_tax_class_id'] = yes_eu_oss_get_products_tax_class_id($search_result['products_id'], STORE_COUNTRY);
                                    // KONFIGURIERBAR OB SUCHERGEBNISSE MIT V1 > 0
                                    if( (!defined('SCANNERKASSE_ONLY_SEARCHRESULTS_WITH_V1_QUANTITY') or SCANNERKASSE_ONLY_SEARCHRESULTS_WITH_V1_QUANTITY == 'False') or $av1_check_value > 0){
                                        if($stammlager != 1){
                                            if($branch_allocation_exists){
                                                $search_result['qty_total'] = $qty_total;
                                                $res[] = xtc_db_prepare_input($search_result);
                                            }
                                        }else{
                                            $search_result['qty_total'] = $qty_total;
                                            $res[] = xtc_db_prepare_input($search_result);
                                        }
                                    }
                                    $double_pID[] = $search_result['products_id'];
				}
			}
		}
		if(sizeOf($res)){
			$results = array();
			foreach($res as $k=>$result){
				$result = xtc_db_prepare_input($result);
				$class = (is_int($k/2)) ? 'dataTableRow' : 'dataTableRowOver';
                                $special_price_string = '';
                                if($xtPrice->xtcCheckSpecial($result['products_id']) > 0){
                                    $special_price_string = $xtPrice->xtcGetPrice($result['products_id'],
                                            $format=true,
                                            1,
                                            $result['products_tax_class_id'], // eu-oss safe
                                            $pPrice = '', $cID
                                    );
                                }
				$price = $xtPrice->xtcGetPrice($result['products_id'],
					$format=false,
					1,
					$result['products_tax_class_id'], // eu-oss safe
					$pPrice = '', $cID
				);
				$smarty->assign('SEARCHRESULT_FORM', xtc_draw_form('choose_product','kasse.php','action=choose_product'));
				$collies = (isset($result['collies']))?$result['collies']:array();
				$collies_array = array();
				$qty_link = "<a href='#' onClick='window.open(\"".xtc_href_link('products.php','action=bestand&pID='.$result['products_id'])."\",\"popup\",\"width=350px,height=400px,resizable=yes,scrollbars=yes\");'><u>[Details]</u></a>";
				$result['class'] = $class;
				$result['input_pid'] = xtc_draw_radio_field('pID',$result['products_id']);
				$result['products_name'] = $result['products_name'];
				$result['products_id'] = $result['products_id'];
				$result['collies'] = $collies_array;
				$result['model'] = $result['products_model'];
				$result['ean'] = $result['products_ean'];
				$result['category'] = xtc_output_generated_category_path($result['categories_id']);
				$result['qty'] = $result['qty_total'];
				$result['qty_link'] = $qty_link;
				$result['img_src'] = ($result['products_image'] != '') ? HTTP_CATALOG_SERVER . 'images/product_images/thumbnail_images/'.$result['products_image'] :  false;
				$result['price'] = number_format($price,2,',','.').DEFAULT_CURRENCY;
                                $result['special_price_string'] = $special_price_string;
				$product = new product($result['products_id']);
				$property_array = array();
				$properties = yes_get_products_properties_id_array($result['products_id']);
				if(sizeOf($properties)){
					foreach($properties as $properties_id){
						$property = new product_properties($properties_id);
						$property_desc = $property->getDescription($_SESSION['languages_id']);
						$property_values = $property->getValues($_SESSION['languages_id']);
						if(sizeOf($property_values)){
							$pv_array = array();
							foreach($property_values as $pv){
								$pvd = $pv['description'];
								$pv_array[] = array(
									'price_netto'=>$pv['price'],
									'price_brutto'=>$xtPrice->xtcFormat($pv['price'], true, $result['products_tax_class_id']), // eu-oss safe
									'title'=>$pvd->getTitle(),
                                                                    'input_span'=>$pv['input_span'],
									'id'=>$pvd->getProducts_properties_values_id()
								);
							}
							$property_array[] = array(
								'title'=>$property_desc->getTitle(),
                                                            'text'=>$property_desc->getText(),
								'values'=>$pv_array,
								'id'=>$property->getProducts_properties_id()
							);
						}
					}
					if(sizeOf($property_array)){
						$result['properties'] = $property_array;
					}
				}
				$results[] = $result;
			}
		}
		$smarty->assign(array(
			'results'=>$results,
			'TABLE_HEADING_PRODUCT'=>TABLE_HEADING_PRODUCT,
			'TABLE_HEADING_CATEGORY'=>TABLE_HEADING_CATEGORY,
			'TABLE_HEADING_PICTURE'=>TABLE_HEADING_PICTURE,
			'TABLE_HEADING_PRICE'=>TABLE_HEADING_PRICE,
			'TABLE_HEADING_QUANTITY'=>TABLE_HEADING_QUANTITY,
			'TEXT_PRODUCTS_MODEL'=>TEXT_PRODUCTS_MODEL,
			'TEXT_PRODUCTS_EAN'=>TEXT_PRODUCTS_EAN,
			'ADD_CART_URL'=>xtc_href_link('kasse.php','action=addtocart&pID='),
			'TEXT_BUTTON_SEARCH_CUSTOMER'=>TEXT_BUTTON_SEARCH_CUSTOMER,
			'TEXT_ADD_TO_CART'=>TEXT_ADD_TO_CART,
		    'TEXT_SN_QTY_ERROR'=>TEXT_SN_QTY_ERROR,
		));
		$html = $smarty->fetch(DIR_FS_ADMIN.'templates/kasse_search_results.html');
		header('Content-Type: text/html; charset='.CHARSET);
		echo $html;
		exit;
		break;
	case 'help_get_customer_name':
		$cID = (int)xtc_db_input($_REQUEST['cID']);
		die(xtc_get_editor_name($cID));
		break;
	case 'help_get_customer_status_name':
		$cID = (int)xtc_db_input($_REQUEST['cID']);
		$csID = xtc_get_customer_status($cID);
		die(xtc_get_customers_status_name($csID));
		break;
	case 'change_customer':
		$smarty->assign(array(
			'GET_CUSTOMER_URL'=>xtc_href_link('kasse.php','action=help_get_customer_name&cID='),
			'GET_CUSTOMER_STATUS_URL'=>xtc_href_link('kasse.php','action=help_get_customer_status_name&cID='),
			'TEXT_BUTTON_SEARCH_CUSTOMER'=>TEXT_BUTTON_SEARCH_CUSTOMER,
			'RELOAD_URL'=>xtc_href_link('kasse.php')
		));
		$html = $smarty->fetch(DIR_FS_ADMIN.'templates/kasse_select_customer.html');
		header('Content-Type: text/html; charset='.CHARSET);
		echo $html;
		exit;
		break;
	case 'order_payment_process':
		include('includes/process_kasse_orders.inc.php');
                if(isset($_GET['shop'])){
                    xtc_redirect(HTTPS_CATALOG_SERVER.'account_history.php?orders_id_processed='.$_REQUEST['orders_id']);
                }else{
                    $messageStack->add_session(MSG_SUCCESS_ORDER_PAYMENT,'success');
                    xtc_redirect(xtc_href_link('kasse.php','action=print_order&oID='.$_REQUEST['orders_id'].'&kasse_payment_code='.$paymode_code));
                }
		exit;
		break;
	case 'order_payment_delete_shipping':
		$oID = (int)xtc_db_input($_REQUEST['orders_id']);
		$order = new order($oID);
		xtc_db_query(sprintf(
			"DELETE FROM orders_total WHERE orders_id=%s AND class='ot_shipping'",
			$oID
		));
		$order->recalc();
		$order->add_history($order->info['orders_status'], false, MSG_SHIPPING_COSTS_DELETED);
		$messageStack->add_session(MSG_SHIPPING_COSTS_DELETED,'success');
		xtc_redirect(xtc_href_link('kasse.php','action=order_payment&orders_id='.$oID));
		exit;
		break;
	case 'order_payment':
		$oID = (int)xtc_db_input($_REQUEST['orders_id']);
		$order = new order($oID);
                $shipper_array = \YES4Trade\Model\shipper_profiles::get_selection_list();
		$allow_add_coupon = true;
		foreach($order->totals as $total){
			switch($total['class']){
				case 'ot_shipping':
					$smarty->assign('INPUT_SHIPPER',xtc_draw_pull_down_menu('shipper',$shipper_array,$order->info['versender'],'id="shipper"'));
					break;
				case 'ot_total':
					$total_sum = $total['text'];
					$total_sum_clean = $total['value'];
					break;
				case 'ot_subtotal':
					$total_sum_products = $total['text'];
					break;
				case 'ot_coupon':
					$allow_add_coupon = false;
					break;
			}
		}
		if(ACTIVATE_GIFT_SYSTEM!='true'){
		    $allow_add_coupon = false;
		}
		$payments = yes_get_kasse_payments();
		foreach($payments as $k=>$pay){
			switch($pay['text']){
				case 'Kreditkarte':
					$payments[$k]['img'] = 'images/kasse_cc.png';
					break;
				case 'EC-Karte':
					$payments[$k]['img'] = 'images/kasse_ec.png';
					break;
				case 'Barzahlung':
					$payments[$k]['img'] = 'images/kasse_bar.png';
					break;
				case 'Rechnung':
					$payments[$k]['img'] = 'images/kasse_invoice.png';
					break;
				default:
					if($pay['image'] != ''){
					    $payments[$k]['img'] = \main::get_importdata_path().$pay['image'];
					}
					break;
			}
		}
		$cart_smarty = $smarty;
		require_once(DIR_WS_MODULES.'gift_cart_admin.php');
                $process_link = xtc_href_link('kasse.php','action=order_payment_process&orders_id='.$oID);
                if(isset($_GET['shop'])){
                    $process_link .= '&shop=1';
                }
		$cart_smarty->assign(array(
			'CASHPOINT_TITLE'=>CASHPOINT_TITLE,
			'TEXT_ORDER_SHIPPING_INTRO'=>sprintf(TEXT_ORDER_SHIPPING_INTRO,$oID),
			'TEXT_PREFERRED_SHIPPING'=>TEXT_PREFERRED_SHIPPING,
			'TEXT_SHIPPING_DELETE'=>TEXT_SHIPPING_DELETE,
			'TEXT_BUYER'=>TEXT_BUYER,
			'TEXT_ORDERS_ID'=>TEXT_ORDER,
			'TEXT_PRODUCTS_IN_ORDER'=>TEXT_PRODUCTS_IN_ORDER,
			'ORDERS_ID'=>$oID,
		    'CUSTOMERS_ID'=>$order->customer['ID'],
			'BILLING_ADDRESS'=>$order->billing,
			'PRODUCTS'=>$order->products,
			'TOTAL_SUM'=>$total_sum,
			'TOTAL_SUM_PRODUCTS'=>$total_sum_products,
			'PAYMENT_METHODS'=>$payments,
			'JS_CONFIRM_PAYMENT_METHOD'=>JS_CONFIRM_PAYMENT_METHOD,
			'JS_CONFIRM_MONEY_GIVEN_INTRO'=>JS_CONFIRM_MONEY_GIVEN_INTRO,
			'JS_CONFIRM_MONEY_GIVEN'=>JS_CONFIRM_MONEY_GIVEN,
			'JS_ALERT_MONEY_BACK'=>JS_ALERT_MONEY_BACK,
			'TOTAL_SUM_CLEAN'=>number_format($total_sum_clean,2,'.',''),
			'BASE_LINK'=>xtc_href_link('kasse.php','action=order_payment&orders_id='.$oID),
			'REMOVE_SHIPPING_LINK'=>xtc_href_link('kasse.php','action=order_payment_delete_shipping&orders_id='.$oID),
			'JS_CONFIRM_REALLY_DELETE_SHIPPING'=>JS_CONFIRM_REALLY_DELETE_SHIPPING,
			'PROCESS_LINK'=>$process_link,
			'TEXT_SUM_TOTAL'=>TEXT_SUM_TOTAL,
			'JS_ALERT_MONEY_GIVEN_ERROR'=>JS_ALERT_MONEY_GIVEN_ERROR,
			'totals'=>$order->totals,
		    'ALLOW_ADD_COUPON'=>$allow_add_coupon,
			'INPUT_OTC_REDIRECT'=>xtc_draw_checkbox_field('otc_redirect',1),
		    'TEXT_OTC_REDIRECT'=>TEXT_OTC_REDIRECT,
		    'TEXT_OTC_REDIRECT_INPUT'=>TEXT_OTC_REDIRECT_INPUT
		));
                yes_draw_pre_header();
                yes_draw_header(TITLE);
		?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
<!--
//-->
</script>
<div id="content" style="margin:5px;">
<?php
	echo $cart_smarty->display(DIR_FS_ADMIN.'templates/kasse_order_payment.html');
?>
</div>
<?php
		break;
	default:

		$query = xtc_db_query(sprintf(
			"SELECT paymode,customers_id,orders_id,date_purchased,branches_id FROM kasse WHERE date_purchased > '%s 00:00:00' ORDER BY date_purchased DESC",
			date('Y-m-d')
		));
		$history_size = xtc_db_num_rows($query);
		$branches_query = xtc_db_query("SELECT SUM(branches_id) as anz FROM branches");
		$branches_res = xtc_db_fetch_array($branches_query);
		$branches = $branches_res['anz'];	
		$smarty->assign(array(
			'CASHPOINT_BRANCH'=>CASHPOINT_BRANCH,
			'CASHPOINT_TITLE'=>CASHPOINT_TITLE,
			'KASSE_FILIALE'=>$kasse_filiale,
			'KASSE_FILIALE_CHANGE_LINK'=>(($branches > 1) ? $kasse_filiale_change_link : ''),
			'CURRENCY'=>$currency,
			'CASHPOINT_CURRENCY'=>CASHPOINT_CURRENCY,
			'TEXT_CHOOSEN_CUSTOMER'=>TEXT_CHOOSEN_CUSTOMER,
			'CUSTOMER'=>xtc_get_editor_name($cID),
			'CUSTOMER_CHANGE_LINK'=>xtc_href_link('kasse.php','action=change_customer'),
			'CART_LINK'=>xtc_href_link('kasse.php','action=show_cart'),
			'TEXT_CUSTOMERS_GROUP'=>TEXT_CUSTOMERS_GROUP,
			'GROUP'=>  xtc_get_customers_status_name($customers_status),
			'TEXT_BUTTON_CHOOSE_CUSTOMER'=>TEXT_BUTTON_CHOOSE_CUSTOMER,
			'TEXT_INTRO_SEARCH_PRODUCTS'=>TEXT_INTRO_SEARCH_PRODUCTS,
			'TEXT_SEARCH_PRODUCTNAME'=>TEXT_SEARCH_PRODUCTNAME,
			'TEXT_SEARCH_IN_DESCRIPTION'=>TEXT_SEARCH_IN_DESCRIPTION,
			'SEARCHPRODUCT_INPUT_PRODUCTSNAME'=>xtc_draw_input_field('products_title',((isset($_POST['products_title']))?$_POST['products_title']:''),'size="18" id="products_title"'),
			'SEARCHPRODUCT_INPUT_DESCRIPTION'=>xtc_draw_checkbox_field('products_description',1,false,'','id="products_description"'),
			'IMAGE_SEARCH'=>IMAGE_SEARCH,
			'SEARCH_LINK'=>xtc_href_link('kasse.php','action=search'),
			'BUTTON_HISTORY'=>sprintf(BUTTON_HISTORY,date('d.m.Y')),
			'HISTORY_SIZE'=>$history_size,
		    'TEXT_RUECKERSTATTUNGEN_PAYOUT'=>TEXT_RUECKERSTATTUNGEN_PAYOUT
		));
		yes_draw_pre_header();
		yes_draw_header(TITLE);
		?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
<!--
<?php if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'print_order'){ ?>
	window.open('<?php echo xtc_href_link('print_order.php','oID='.$_REQUEST['oID'].'&kasse_payment_code='.$_REQUEST['kasse_payment_code']); ?>');
<?php } ?>
//-->
</script>
<?php
	$html = $smarty->fetch(DIR_FS_ADMIN.'templates/kasse2.html');
	echo $html;
}
require('includes/application_bottom.php');

