<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once(DIR_FS_INC.'xtc_serials.inc.php');
require_once(DIR_FS_INC . 'xtc_retoure_copy_product.inc.php');
require_once(DIR_WS_CLASSES . 'order.php');
require_once(DIR_WS_CLASSES . 'class.ebay.php');
require_once(DIR_WS_CLASSES . 'customer.php');
require_once(DIR_WS_CLASSES . 'class.storagequantity.php');

$RETOURE_CAT = \YES4Trade\Model\categories_description::get_retoure_categories_id();
if($RETOURE_CAT < 1){
    $messageStack->add_session('Es ist keine RETOURE Kategorie vorhanden.','error');
    xtc_redirect(xtc_href_link('start.php'));
}
  // needs ebayapi-class
function xtc_orders_storno( $oID,$order,$comments='Rechnung wurde storniert' ){
	global $_SESSION,$messageStack,$EBAYAPI;
	
	if( $order->info['parent_orders_id'] != 0){
		// rechnung ist kombiniert
		
		// produktbestand
		if(is_array($order->products)){
			foreach($order->products as $k=>$product){
                            $collies = xtc_get_product_collies($product['id']);
                            if( sizeOf($collies)>0 ){
                                foreach($collies as $ck=>$collie){
                                    $new_qty = $product['qty']*$collie['quantity'];
                                    if($order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
                                        $SQ = new products_quantity($collie['collie_products_id']);
                                        $SQ->update_qty(
                                            $new_qty, 
                                            $SQ->get_default_storage_id(), 
                                            $SQ->get_products_total_qty(), 
                                            'Stornierung der Re-Nr '.$oID.': Rueckbuchung (Colli aus '.$product['id'].') '.$new_qty.' Stk.'
                                        );
                                    }else{
                                        product::add_history_static(intval($collie['collie_products_id']),
                                            'Stornierung der Re-Nr '.$oID.': Rueckbuchung (Colli aus '.$product['id'].') '.$new_qty.' Stk.'
                                        );
                                    }

                                }
                                product::add_history_static(intval($product['id']),
                                    'Stornierung der Re-Nr '.$oID.': Rueckbuchung '.$product['qty'].' Stk.'
                                );
                            }else{
                                $new_qty = $product['qty'];
                                if($order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
                                    $SQ = new products_quantity($product['id']);
                                    $SQ->update_qty($new_qty, 
                                        $SQ->get_default_storage_id(), 
                                        $SQ->get_products_total_qty(), 
                                        'Stornierung der Re-Nr '.$oID.': Rueckbuchung '.$new_qty.' Stk.'
                                    );
                                }else{
                                    product::add_history_static(intval($product['id']),
                                        'Stornierung der Re-Nr '.$oID.': Rueckbuchung '.$new_qty.' Stk.'
                                    );
                                }
                            }
                            xtc_db_query("UPDATE products SET products_ordered=products_ordered-".$product['qty']." where products_id='".$product['id']."'");
			}
		}
                $order->add_history(ORDERS_STATUS_STORNIERT, false, $comments);
		
		// status storno UND keine parent_orders_id setzen
		xtc_db_query(sprintf(
                    "UPDATE orders SET orders_status='%d',last_modified=now(),parent_orders_id=0,orders_date_storno=now() WHERE orders_id='%d'",
                    ORDERS_STATUS_STORNIERT,$oID
                ));
		
		// die verbleibenden rechnungen der hauptrechnung ermitteln
		$combineds_query = xtc_db_query("SELECT orders_id FROM orders WHERE parent_orders_id='".$order->info['parent_orders_id']."' and orders_id!='".$oID."'");
		$combineds_count = xtc_db_num_rows($combineds_query);
		
		// in kombinierter vermerken
		$status_query = xtc_db_query("SELECT orders_status FROM orders WHERE orders_id='".$order->info['parent_orders_id']."'");
		$status = xtc_db_fetch_array($status_query);
                order::add_history_static(intval($order->info['parent_orders_id']), 
                    intval($status['orders_status']), 0, 
                    "Enthaltene Rechnung ".$oID." storniert und aus Kombination entfernt."
                );
		if($combineds_count < 1){ // keine kombinierten mehr uebrig -> auf null setzen
                    order::add_history_static(intval($order->info['parent_orders_id']), 
                        intval(ORDERS_STATUS_STORNIERT), 0, 
                        'Letzte kombinierte Rechnung entfernt. [Automatisches Storno]'
                    );
                    xtc_db_query("UPDATE orders SET orders_status='".ORDERS_STATUS_STORNIERT."',last_modified=now(),orders_date_storno=now() WHERE orders_id='".$order->info['parent_orders_id']."'");
                    xtc_db_query("UPDATE orders_total SET text='0,00 ".$order->info['currency']."',value='0' WHERE orders_id='".$order->info['parent_orders_id']."'");
		}else{ // gesamtbetrag der parent rechnung neu schreiben
                    $EBAYAPI->remove_combined_order($oID,$order->info['parent_orders_id']);
		}
		$messageStack->add_session('Die Rechnung Nr. '.$oID.' und alle enthaltenen Rechnungen wurden storniert.','success');
		
	}else if( $order->info['is_parent'] == 'y'){
		// Rechnung Enthaelt kombi
		$messageStack->add_session('Die Rechnung Nr. '.$oID.' enth&auml;lt kombinierte Rechnungen, wurde nicht storniert.','error');
	}else{
		// normale Rechnung
		// quantity gutschreiben
		if(is_array($order->products)){
			foreach($order->products as $k=>$product){
                            $collies = xtc_get_product_collies( $product['id'] );
                            if(is_countable($collies) and sizeOf($collies)>0){
                                foreach($collies as $ck=>$collie){
                                    $new_qty = $product['qty']*$collie['quantity'];
                                    if($order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
                                        $SQ = new products_quantity($collie['collie_products_id']);
                                        $SQ->update_qty($new_qty, 
                                            $SQ->get_default_storage_id(), 
                                            $SQ->get_products_total_qty(), 
                                            'Stornierung der Re-Nr '.$oID.': Rueckbuchung (Colli aus '.$product['id'].') '.$new_qty.' Stk.'
                                        );
                                    }else{
                                        product::add_history_static(
                                            intval($collie['collie_products_id']),
                                            'Stornierung der Re-Nr '.$oID.': Rueckbuchung (Colli aus '.$product['id'].') '.$new_qty.' Stk.'
                                        );
                                    }
                                }
                                product::add_history_static(intval($product['id']),
                                    'Stornierung der Re-Nr '.$oID.': Rueckbuchung '.$product['qty'].' Stk.'
                                );
                            }else{ // keine collis
                                $new_qty = $product['qty'];
                                if($order->info['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN or $order->info['orders_status'] == ORDERS_STATUS_VERSENDET){
                                    $SQ = new products_quantity($product['id']);
                                    $SQ->update_qty($new_qty, 
                                        $SQ->get_default_storage_id(), 
                                        $SQ->get_products_total_qty(), 
                                        'Stornierung der Re-Nr '.$oID.': Rueckbuchung '.$new_qty.' Stk.'
                                    );
                                }else{
                                    product::add_history_static(
                                        intval($product['id']),
                                        'Stornierung der Re-Nr '.$oID.': Rueckbuchung '.$new_qty.' Stk.'
                                    );
                                }
                            }
                            xtc_db_query(sprintf(
                                "UPDATE products SET products_ordered=products_ordered-%d where products_id='%d'",
                                $product['qty'],$product['id']
                            ));
			}
		}
		// status + history updaten
                $order->add_history(intval(ORDERS_STATUS_STORNIERT),0,$comments);
		xtc_db_query("UPDATE orders SET orders_status='".ORDERS_STATUS_STORNIERT."',last_modified=now(),orders_date_storno=now() WHERE orders_id='".$oID."'");
		$messageStack->add_session('Die Rechnung Nr. '.$oID.' wurde storniert.','success');
	}
}
  
  $oid_array = array();
  if(!is_array($_GET['oID'])){
  	$oid_array[] = $_GET['oID'];
  }else{
  	$oid_array = $_GET['oID'];
  }
  
$oIDs = array();
for($i=0;$i<sizeOf($oid_array); $i++){
      if( $oid_array[$i] < 1 ){
              // nix
      }else{
              $oIDs[] = (int)xtc_db_input($oid_array[$i]);
      }
}
if(sizeOf($oIDs)<1){
      print_r($_GET);
      die('keine rechnung uebergeben.');
}
$vers_array = array();
foreach($VERSENDER as $k=>$v){
      $vers_array[] = array('id'=>$v,'text'=>$v);
}
switch ($_GET['action']) {
    case 'storno':
	$EBAYAPI = new ebayAPI;
	foreach($oIDs as $k=>$oID){
            $order = new order($oID);
            if($_GET['ext_storno'] != '1'){
                if($_POST['comments'] and strlen(trim($_POST['comments']))>3){
                    xtc_orders_storno($oID,$order,xtc_db_input($_POST['comments']));
                }else{
                    $messageStack->add_session(ERROR_NO_COMMENTS_FOR_STORNO,'error');
                    if(!is_countable($_GET['oID'])){
                        xtc_redirect( xtc_href_link('orders_storno.php',xtc_get_all_get_params(array('action')) ) );
                    }else{
                        $s = '';
                        foreach($_GET['oID'] as $k=>$_oID){
                            $s .= '&oID[]='.$_oID;
                        }
                        xtc_redirect( xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','oID','a')).'a=0'.$s ) );
                    }
                }
            }else{ // erweitertes storno
                $storno_grund = xtc_db_input($_POST['storno_grund_'.$oID]);
                $abholung = xtc_db_input($_POST['abholung_'.$oID]);
                $bearbeitungsgebuehr = (float)xtc_db_input(str_replace(',','.',$_POST['bearbeitungsgebuehr_'.$oID]));
                $transportkosten = (float)xtc_db_input(str_replace(',','.',$_POST['transportkosten_'.$oID]));
                $rueckerstatten = xtc_db_input($_POST['rueckerstatten_'.$oID]);
                $rueckerstatten_kto = xtc_db_input($_POST['rueckerstatten_kto_'.$oID]);
                $rueckerstatten_inhaber = xtc_db_input($_POST['rueckerstatten_inhaber_'.$oID]);
                $rueckerstatten_blz = xtc_db_input($_POST['rueckerstatten_blz_'.$oID]);
                $rueckerstatten_bank = xtc_db_input($_POST['rueckerstatten_bank_'.$oID]);
                $rueckerstatten_iban = xtc_db_input($_POST['rueckerstatten_iban_'.$oID]);
                $rueckerstatten_swift = xtc_db_input($_POST['rueckerstatten_swift_'.$oID]);
                $rueckerstatten_betrag = (float)xtc_db_input(str_replace(',','.',$_POST['rueckerstatten_betrag_'.$oID]));
                $rueckerstatten_grund = xtc_db_input($_POST['rueckerstattung_grund_'.$oID]);
                $shipping_company = xtc_db_input($_POST['shipping_company_'.$oID]);
                $shipping_name = xtc_db_input($_POST['shipping_name_'.$oID]);
                $shipping_name2 = xtc_db_input($_POST['shipping_name2_'.$oID]);
                $shipping_street = xtc_db_input($_POST['shipping_street_'.$oID]);
                $shipping_street2 = xtc_db_input($_POST['shipping_street2_'.$oID]);
                $shipping_city = xtc_db_input($_POST['shipping_city_'.$oID]);
                $shipping_postcode = xtc_db_input($_POST['shipping_postcode_'.$oID]);
                $shipping_country = xtc_get_country_name(xtc_db_input($_POST['shipping_country_id_'.$oID]));
                $save_kto = xtc_db_input($_POST['save_kto_'.$oID]);
                $versender = xtc_db_input($_POST['versender_'.$oID]);
                $bestandsbuchung = xtc_db_input($_POST['bestandsbuchung_'.$oID]);
				
                if(strlen($storno_grund)<2){
                    $messageStack->add_session(ERROR_NO_REASON_FOR_STORNO,'error');
                    xtc_redirect( xtc_href_link('orders_storno.php',xtc_get_all_get_params(array('action'))) );
                }
				
                // RETOURE GENERIEREN
                if($abholung == '1' and $bestandsbuchung != '1'){
                    $retouren_sql = array(
                        'orders_id'=>(int)$oID,
                        'customers_id'=>$order->customer['ID'],
                        'shipping_company'=>$shipping_company,
                        'shipping_name'=>$shipping_name,
                        'shipping_name2'=>$shipping_name2,
                        'shipping_street'=>$shipping_street,
                        'shipping_street2'=>$shipping_street2,
                        'shipping_city'=>$shipping_city,
                        'shipping_postcode'=>$shipping_postcode,
                        'shipping_country'=>$shipping_country,
                        'date_created'=>date('Y-m-d H:i:s'),
                        'retoure_status'=>1,
                        'versender'=>$versender,
                        'costs'=>$transportkosten
                    );
                    xtc_db_perform('retouren',$retouren_sql);
                    $insert_id = xtc_db_insert_id();
					
                    $new = new \YES4Trade\Model\retoure_status_history([
                        'retoure_id'=>(int)$insert_id,
                        'retoure_status_id'=>1,
                        'date_added'=>date('Y-m-d H:i:s'),
                        'customer_notified'=>0,
                        'comments'=>sprintf(COMMENTS_RETOURE_FOR_STORNO,$oID),
                        'editor_id'=>(int)$_SESSION['customer_id']
                    ]);
                    $new->create();
					
                    $products = array();
                    foreach($order->products as $k=>$product){
                        $collies = xtc_get_product_collies( $product['id'] );
                        if(is_countable($collies) and sizeOf($collies)>0){
                            foreach($collies as $ck=>$collie){
                                // brauchen das products model des collis
                                $products_model_query = xtc_db_query(sprintf(
                                    "SELECT products_model,products_price FROM products WHERE products_id='%d'",
                                    (int)$collie['collie_products_id']
                                ));
                                $products_model = xtc_db_fetch_array($products_model_query);
                                $retouren_products_sql = array(
                                    'retoure_id'=>$insert_id,
                                    'products_id'=>$collie['collie_products_id'],
                                    'products_model'=>$products_model['products_model'],
                                    'products_name'=>xtc_get_products_name($collie['collie_products_id']),
                                    'products_quantity'=>($product['qty']*$collie['quantity'])
                                );
                                xtc_db_perform('retoure_products',$retouren_products_sql);
                            }
                        }else{
                            $retouren_products_sql = array(
                                'retoure_id'=>$insert_id,
                                'products_id'=>$product['id'],
                                'products_model'=>$product['model'],
                                'products_name'=>$product['name'],
                                'products_quantity'=>$product['qty']
                            );
                            xtc_db_perform('retoure_products',$retouren_products_sql);
                        }
                        // kommt noch: $products[$product['id']]['defekt'] += xtc_db_input($_POST['qty_defekt_'.$oID.'_'.$product['id'] ]);
                    } // end foreach order products
                    $order->add_history(ORDERS_STATUS_STORNIERT, false, sprintf(
                        COMMENTS_RETOURE_CREATED_FROM_EXT_STORNO,$insert_id)
                    );
		} // end retoure
                if($bearbeitungsgebuehr > 0){
                    $sql_array = array(
                        'class'=>'storno_bearbeitungsgebuehr',
                        'orders_id'=>$oID,
                        'customers_id'=>$order->customer['ID'],
                        'comments'=>COMMENTS_BEARBEITUNGSGEBUEHR_EXT_STORNO,
                        'date_created'=>date('Y-m-d H:i:s'),
                        'value'=>$bearbeitungsgebuehr,
                        'editor_id'=>$_SESSION['customer_id']
                    );
                    xtc_db_perform('costs',$sql_array);
                }
	
				
		if($bestandsbuchung == '1'){ // sofortige rueckbuchung
                    $error_defect_comment = false;
                    for($i=0;$i<count($order->products);$i++){
                        $collies = xtc_get_product_collies( $order->products[$i]['id'] );
			if( !is_countable($collies) or sizeOf($collies) == 0 ){
                            $keyid = $oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'];
                            if(isset($_POST['qty_defekt_'.$keyid ]) and $_POST['qty_defekt_'.$keyid ]>0){
                                if(isset($_POST['comments_defekt_'.$keyid ]) and $_POST['comments_defekt_'.$keyid ] != ''){
				}else{
                                    $error_defect_comment = true;
				}
                            }
			}else{
                            foreach($collies as $ck=>$collie){
                                $keyid = $oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'].'_'.$collie['collie_products_id'];
                                if(isset($_POST['qty_defekt_collie_'.$keyid]) and $_POST['qty_defekt_collie_'.$keyid]>0){
                                    if(isset($_POST['comments_defekt_collie_'.$keyid]) and $_POST['comments_defekt_collie_'.$keyid] != ''){
                                    }else{
                                        $error_defect_comment = true;
                                    }
				}
                            }
			}
                    }
                    if($error_defect_comment){
                        $messageStack->add_session(ERROR_MISSING_DEFECT_COMMENT,'error');
			xtc_redirect( xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','oID')).'oID='.$oID ) );
                    }
					
                    for($i=0;$i<count($order->products);$i++){
                        $collies = xtc_get_product_collies( $order->products[$i]['id'] );
			if(is_countable($collies) and sizeOf($collies)>0){
                            foreach($collies as $ck=>$collie){
                                $keyid = $oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'].'_'.$collie['collie_products_id'];
                                $defect_anz = (isset($_POST['qty_defekt_collie_'.$keyid]))?(int)$_POST['qty_defekt_collie_'.$keyid]:0;
                                $order_collie_anz = $order->products[$i]['qty']*$collie['quantity'];
                                $rueckb_anz = $order_collie_anz-$defect_anz;
                                if($rueckb_anz > 0 ){ // bestand rueckbuchen
                                    $new_qty = $rueckb_anz;
                                    // BOF - Auftragshistorie - Ticket 3013
                                    $hist_comment = 'Storno Re-Nr.: '.$oID.' Rueckbuchung (Colli pID '.$collie['collie_products_id'].' aus Set pID '.$order->products[$i]['id'].')  '.$new_qty.' Stk.';
                                    $order->add_history(ORDERS_STATUS_STORNIERT, false, $hist_comment);
                                    if(in_array($order->info['orders_status'],[ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET])){
                                        $SQ = new products_quantity($collie['collie_products_id']);
                                        $SQ->update_qty($new_qty, $SQ->get_default_storage_id(), $SQ->get_products_total_qty(), $hist_comment);
                                    }else{
                                        yes_add_products_history($collie['collie_products_id'], $hist_comment);
                                    }
                                    // EOF - Auftragshistorie - Ticket 3013
                                }
				if($defect_anz > 0){ // defekt erzeugen
                                    $def_com = xtc_db_prepare_input($_POST['comments_defekt_collie_'.$keyid]);
                                    $categories_id = $RETOURE_CAT;
                                    $cat_ids = array('0'=>$categories_id);
                                    $comments = sprintf(COMMENTS_RETOURE_DEFECT_COLLI, $insert_id, $oID,$collie['collie_products_id'],$defect_anz,$def_com);
                                    // BOF - Auftragshistorie - Ticket 3013
                                    $order_history_string = sprintf(' - Collie pID %d aus Set pID %d',$collie['collie_products_id'],$order->products[$i]['id']);
                                    $order->add_history(ORDERS_STATUS_STORNIERT, false, $comments.$order_history_string);
                                    // EOF - Auftragshistorie - Ticket 3013
                                    xtc_retoure_copy_product((int)$collie['collie_products_id'],$cat_ids,$defect_anz,$comments,$def_com);
				} // end defekt copy
                            } // end foreach collies
			}else{ // end if collies
                            $keyid = $oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'];
                            $defect_anz = (isset($_POST['qty_defekt_'.$keyid]))?(int)$_POST['qty_defekt_'.$keyid]:0;
                            $rueckb_anz = $order->products[$i]['qty']-$defect_anz;
                            if($rueckb_anz > 0){ // bestand rueckbuchen
                                $new_qty = $rueckb_anz;
                                // BOF - Auftragshistorie - Ticket 3013
                                $hist_comment = 'Storno Re-Nr.: '.$oID.': Rueckbuchung pID '.$order->products[$i]['id'].' ohne Retoureauftrag  '.$new_qty.' Stk.';
                                $order->add_history(ORDERS_STATUS_STORNIERT, false, $hist_comment);
				if(in_array($order->info['orders_status'],[ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET])){
                                    $SQ = new products_quantity($order->products[$i]['id']);
                                    $SQ->update_qty($new_qty, $SQ->get_default_storage_id(), $SQ->get_products_total_qty(), $hist_comment);
                                }else{
                                    yes_add_products_history($order->products[$i]['id'],$hist_comment);
				}
                                // EOF - Auftragshistorie - Ticket 3013
                            }
                            if($defect_anz > 0){ // defekt erzeugen
                                $def_com = xtc_db_prepare_input($_POST['comments_defekt_'.$keyid]);
				$categories_id = $RETOURE_CAT;
				$cat_ids = array('0'=>$categories_id);
				$comments = sprintf(COMMENTS_RETOURE_DEFECT,$insert_id, $oID, $defect_anz, $def_com);
                                // BOF - Auftragshistorie - Ticket 3013
                                $order_history_string = sprintf(' - pID %d',$order->products[$i]['id']);
                                $order->add_history(ORDERS_STATUS_STORNIERT, false, $comments.$order_history_string);
                                // EOF - Auftragshistorie - Ticket 3013
				xtc_retoure_copy_product($order->products[$i]['id'],$cat_ids,$defect_anz,$comments,$def_com);
                            } // end defekt copy
			} // end if colli
                    } // end foreach order products
		} // end bestandsbuchung == 1
				
                $rueck_add_history = true;
                if($rueckerstatten == '2') { // bank
                    $sql_array = array(
                        'orders_id'=>$oID,
                        'customers_id'=>$order->customer['ID'],
                        'betrag'=>$rueckerstatten_betrag,
                        'paymode'=>'Bank',
                        'date_created'=>date('Y-m-d H:i:s'),
                        'date_payment'=>'0',
                        'kto_nummer'=>$rueckerstatten_kto,
                        'kto_blz'=>$rueckerstatten_blz,
                        'kto_inhaber'=>$rueckerstatten_inhaber,
                        'kto_bank'=>$rueckerstatten_bank,
                        'kto_iban'=>$rueckerstatten_iban,
                        'kto_swift'=>$rueckerstatten_swift,
                        'kto_grund'=>$rueckerstatten_grund,
                        'comments'=>'Rueckerstattung nach Storno',
                        'editor_id'=>$_SESSION['customer_id'],
                        'type'=>$rueckerstatten,
                        'status'=>'1'
                    );
                    xtc_db_perform('rueckerstattungen',$sql_array);
                    $rueck_id = xtc_db_insert_id();
                    $order->add_history(ORDERS_STATUS_STORNIERT,false,sprintf(COMMENTS_RUECKERSTATTUNG_UEBERWEISUNG_CREATED,$rueckerstatten_betrag));
		}else if($rueckerstatten == '3'){
                    $sql_array = array(
                        'orders_id'=>$oID,
                        'customers_id'=>$order->customer['ID'],
                        'kto_inhaber'=>$order->customer['name'],
                        'betrag'=>$rueckerstatten_betrag,
                        'paymode'=>'Bar',
                        'date_created'=>date('Y-m-d H:i:s'),
                        'date_payment'=>date('Y-m-d H:i:s'),
                        'comments'=>'Rueckerstattung nach Storno / Bar',
                        'editor_id'=>(int)$_SESSION['customer_id'],
                        'type'=>$rueckerstatten,
                        'status'=>2
                    );
                    xtc_db_perform('rueckerstattungen',$sql_array);
                    $rueck_id = xtc_db_insert_id();
                    $order->add_history(ORDERS_STATUS_STORNIERT,false,
                        sprintf(COMMENTS_RUECKERSTATTUNG_BAR, $rueckerstatten_betrag)
                    );
		}else if($rueckerstatten == '1'){
                    $rueck_add_history = false;
					// NIX
		}else{ // EIGENE RUECKERSTATTEN TYPES
                    $sql_array = array(
                        'orders_id'=>$oID,
                        'customers_id'=>$order->customer['ID'],
                        'kto_inhaber'=>$order->customer['name'],
                        'betrag'=>$rueckerstatten_betrag,
                        'paymode'=>xtc_get_rueckerstattungen_types_name($rueckerstatten),
                        'date_created'=>date('Y-m-d H:i:s'),
                        'date_payment'=>date('Y-m-d H:i:s'),
                        'comments'=>'Rueckerstattung nach Storno / '.xtc_get_rueckerstattungen_types_name($rueckerstatten),
                        'editor_id'=>(int)$_SESSION['customer_id'],
                        'type'=>$rueckerstatten,
                        'status'=>1
                    );
                    xtc_db_perform('rueckerstattungen',$sql_array);
                    $rueck_id = xtc_db_insert_id();
                    $order->add_history(ORDERS_STATUS_STORNIERT,false,sprintf(COMMENTS_RUECKERSTATTUNG_CREATED_VIA, $rueckerstatten_betrag, xtc_get_rueckerstattungen_types_name($rueckerstatten)));
                }
                if($rueck_add_history){
                    $insert_sql_array = [
                        'rueckerstattungen_id'=>(int)$rueck_id,
                        'rueckerstattungen_status_id'=>1,
                        'date_added'=>date('Y-m-d H:i:s'),
                        'customer_notified'=>0,
                        'comments'=>sprintf(COMMENTS_RUECKERSTATTUNG_FROM_STORNO,$oID,$rueckerstatten_grund),
                        'editor_id'=>(int)$_SESSION['customer_id'],
                    ];
                    xtc_db_perform('rueckerstattungen_status_history',$insert_sql_array);
                }
		if( $save_kto == '1' ){
                    $sql_array = array(
                        'kto_nummer'=>$rueckerstatten_kto,
                        'kto_inhaber'=>$rueckerstatten_inhaber,
                        'kto_iban'=>$rueckerstatten_iban,
                        'kto_swift'=>$rueckerstatten_swift,
                        'kto_blz'=>$rueckerstatten_blz,
                        'kto_bank'=>$rueckerstatten_bank);
                    xtc_db_perform('customers',$sql_array,'update','customers_id='.$order->customer['ID']);
                }
				
                // status + history updaten
                $order->add_history(ORDERS_STATUS_STORNIERT,false,sprintf(COMMENTS_STORNO_SUCCESS_WITH_REASON, $storno_grund));
                xtc_db_query("UPDATE orders SET orders_status='".ORDERS_STATUS_STORNIERT."',last_modified=now(),orders_date_storno=now() WHERE orders_id='".$oID."'");
                $messageStack->add_session(sprintf(COMMENTS_ORDER_STORNO_SUCCESS_MESSAGE,$oID),'success');
            } // end ext storno
            $customer = new customer($order->customer['ID']);
            $customer->update_current_account_value();
	} // end foreach orders
        if(isset($rueck_id) and $rueck_id > 0){
            xtc_redirect( xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rueck_id) );
        }
        xtc_redirect( xtc_href_link('orders.php') );
        break;
}
$orders_get = '';
foreach($oIDs as $k=>$oID){
    $order = new order($oID);
    if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT){
	    $orders_get .= 'oID[]='.$oID.'&';
    }
}
$orders_get = substr($orders_get,0,(strlen($orders_get)-1) );
if(sizeOf($oIDs) == 1){
    $orders_get = 'oID='.$oIDs[0];
}

$buttons = array();
$buttons[] = array('text'=>IMAGE_BACK,
    'link'=>xtc_href_link(FILENAME_ORDERS, 'action=edit&oID='.$oIDs[0]),
    'lbOn'=>false,
    'auth'=>true
);


yes_draw_pre_header();
yes_draw_header(TITLE);
$ext_storno = (isset($_GET['ext_storno']))?$_GET['ext_storno']:'';
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$storno_count = 0;
$orders_data = [];
$error = '';
$inputs = []; // EXT STORNO INPUTS
foreach($oIDs as $k=>$oID){
    $order = new order($oID);
    $orders_data[$oID] = [
        'colli_qty'=>[],
        'order_status_name'=>$order->info['orders_status_name'],
    ];
    if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT) {
        $reclamations_query = xtc_db_query("SELECT reclamations_id FROM reclamations WHERE orders_id='".$oID."' and (reclamations_status='1' or reclamations_status='2') ");
        $recl = xtc_db_num_rows($reclamations_query);
        $retoure_query = xtc_db_query("SELECT retoure_id FROM retouren WHERE orders_id='".$oID."' and (retoure_status='1' or retoure_status='2') ");
        $retoure = xtc_db_num_rows($retoure_query);
        $in_shipping_query = xtc_db_query(sprintf(
            "SELECT id FROM shippings WHERE orders_id='%d' AND status='0'",
            $oID
        ));
        $in_shipping = xtc_db_num_rows($in_shipping_query);
        if(!$in_shipping and $recl == 0 and $retoure == 0){
            $combineds_count = 0;
            $orders_data[$oID]['title'] = sprintf(TEXT_ORDER_TO_STORNO, $oID);
            $orders_data[$oID]['addresses'] = [
                'delivery'=>xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />'),
                'customer'=>xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br />'),
                'billing'=>xtc_address_format($order->billing['format_id'], $order->billing, 1, '', '<br />'),
            ];
            
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal" style="width: 100%;"';
            $th_array = [
                ['text'=>TEXT_QUANTITY,'th'=>true],
                ['text'=>TEXT_PRODUCT,'th'=>true],
                ['text'=>TEXT_PRODUCTS_MODEL,'th'=>true],
                ['text'=>TEXT_YES_EXPORT_MODULES_TYPE_PRICE.' (Excl.)','th'=>true],
            ];
            if ($order->products[0]['allow_tax'] == 1) {
                $th_array[] = ['text'=>'MwSt','th'=>true];
                $th_array[] = ['text'=>TEXT_YES_EXPORT_MODULES_TYPE_PRICE.' (incl.)','th'=>true];
            }
            $th_array[] = ['text'=>'Total'.($order->products[$i]['allow_tax'] == 1)?' (excl.)':'','th'=>true];
            $contents = [$th_array];
            $products_rueckbuch = [];
            for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
                $collies = xtc_get_product_collies($order->products[$i]['id']);
                $tr = [
                    ['text'=>$order->products[$i]['qty'].'&nbsp;x','params'=>'align="right"'],
                    ['text'=>$order->products[$i]['name']],
                    ['text'=>$order->products[$i]['model'].'&nbsp;[ID&nbsp;'.$order->products[$i]['id'].']'],
                    ['text'=>format_price($order->products[$i]['final_price']/$order->products[$i]['qty'], 1, $order->info['currency'], $order->products[$i]['allow_tax'], $order->products[$i]['tax']),'params'=>'align="right"'],
                ];
                if ($order->products[$i]['allow_tax'] == 1) {
                    $tr[] = ['text'=>xtc_display_tax_value($order->products[$i]['tax']).'%','params'=>'align="right"'];
                    $tr[] = ['text'=>format_price($order->products[$i]['final_price']/$order->products[$i]['qty'], 1, $order->info['currency'], 0, 0),'params'=>'align="right"'];
                }
                $tr[] = ['text'=>format_price(($order->products[$i]['final_price']),1,$order->info['currency'],0,0),'params'=>'align="right"'];
                $contents[] = $tr;
                
                if(sizeOf($collies)>0){
                    $products_rueckbuch[ $order->products[$i]['opID']] = [
                        'name'=>TEXT_STUECKLISTENARTIKEL.'&nbsp;'.$order->products[$i]['name'].'&nbsp;&nbsp;<font color="green">'.$order->products[$i]['qty'].' '.TEXT_STK.'</font>',
                        'inputs'=>[],
                        'collies'=>[],
                    ];
                    foreach($collies as $ck=>$collie){
                        $def_array = array(0=>array('id'=>0,'text'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_LAGERBESTAND_OPTION_NO_DEFECTS));
                        for($rf=0;$rf<($order->products[$i]['qty']*$collie['quantity']);$rf++){
                            $def_array[] = array('id'=>($rf+1),'text'=>($rf+1).' '.TEXT_STK);
                        }
                        
                        $products_rueckbuch[ $order->products[$i]['opID'] ]['collies'][$ck]['colli_name'] = '<b>[C]</b>&nbsp;'.xtc_get_products_name($collie['collie_products_id']);
                        $products_rueckbuch[ $order->products[$i]['opID'] ]['collies'][$ck]['inputs'] = [
                            [
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_HOW_MUCH,
                                'input'=>sprintf('<span class="rueckbuch_qty_container_collie_%s" data-orig="%d">%d</span>',
                                    $oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'].'_'.$collie['collie_products_id'],
                                    $order->products[$i]['qty']*$collie['quantity'],
                                    $order->products[$i]['qty']*$collie['quantity']
                                 )
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_DEFECT_QUANTITY,
                                'input'=>xtc_draw_pull_down_menu('qty_defekt_collie_'.$oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'].'_'.$collie['collie_products_id'],
                                    $def_array,
                                    $_POST['qty_defekt_collie_'.$oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'].'_'.$collie['collie_products_id']],
                                    'onChange="change_rueckbuch(this);"'
                                )
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_DEFECT_DESCRIPTION,
				'input'=>xtc_draw_textarea_field('comments_defekt_collie_'.$oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'].'_'.$collie['collie_products_id'],
                                    'virtual','45','2','Defekter Colli Artikel (Set pID '.$order->products[$i]['id'].' ...'
                                ),
                            ]
                        ];
			// brauchen das products model des collis
			$products_model_query = xtc_db_query("SELECT products_model,products_price FROM products WHERE products_id='".$collie['collie_products_id']."'");
			$products_model = xtc_db_fetch_array($products_model_query);
                        $tr = [
                            ['text'=>'Colli enth. '.$order->products[$i]['qty']*$collie['quantity'].'&nbsp;x','params'=>'align="right" class="ui-state-default"'],
                            ['text'=>xtc_get_products_name($collie['collie_products_id'])],
                            ['text'=>$products_model['products_model'].'&nbsp;[ID '.$collie['collie_products_id'].']'],
                            ['text'=>'-','params'=>'align="right"'],
                        ];
                        if ($order->products[$i]['allow_tax'] == 1) {
                            $tr[] = ['text'=>'-','params'=>'align="right"'];
                            $tr[] = ['text'=>'-','params'=>'align="right"'];
                        }
                        $tr[] = ['text'=>'-','params'=>'align="right"'];
                        $contents[] = $tr;
                    }
                }else{
                    $rueckbuch_array = array(0=>array('id'=>0,'text'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_LAGERBESTAND_OPTION_NO));
                    $def_array = array(0=>array('id'=>0,'text'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_LAGERBESTAND_OPTION_NO_DEFECTS));
                    for($rf=0;$rf<$order->products[$i]['qty'];$rf++){
                        $def_array[] = array('id'=>($rf+1),'text'=>($rf+1).' '.TEXT_STK);
                    }
                    $products_rueckbuch[ $order->products[$i]['opID'] ] = [
                        'name'=>$order->products[$i]['name'],
                        'inputs'=>[
                            [
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_HOW_MUCH,
                                'input'=>sprintf('<span class="rueckbuch_qty_container_%s" data-orig="%d">%d</span>',
                                    $oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'],
                                    $order->products[$i]['qty'],
                                    $order->products[$i]['qty']
                                 )
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_DEFECT_QUANTITY,
				'input'=>xtc_draw_pull_down_menu('qty_defekt_'.$oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'],
                                    $def_array,$_POST['qty_defekt_'.$oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id']],'onChange="change_rueckbuch(this);"'
                                )
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_DEFECT_DESCRIPTION,
				'input'=>xtc_draw_textarea_field('comments_defekt_'.$oID.'_'.$order->products[$i]['opID'].'_'.$order->products[$i]['id'],
                                    'virtual','45','2','Defekter Artikel ...'
                                )
                            ]
                        ]
                    ];
                    
                }
            } // end foreach products
            $orders_data[$oID]['PRODUCTS'] = $table->tableBlock_draw($contents);
            
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
            $contents = [];
            foreach($order->totals as $ot) {
                if($ot['class'] == 'ot_subtotal'){
                    $zwsumme = number_format($ot['value'],2,'.','');
                }
                if($ot['class'] == 'ot_total'){
                    $summe = number_format($ot['value'],2,'.','');
                }
                $contents[] = [
                    ['text'=>$ot['title'],'params'=>'align="right"'],
                    ['text'=>$ot['text']]
                ];
            }
            $orders_data[$oID]['TOTALS'] = $table->tableBlock_draw($contents);
            
            $customers_query = xtc_db_query("select c.kto_iban,c.kto_swift,c.kto_nummer,c.kto_inhaber,c.kto_blz,c.kto_bank from " . TABLE_CUSTOMERS . " c where c.customers_id = '" . $order->customer['ID'] . "'");
            $customers = xtc_db_fetch_array($customers_query);
            $cInfo = new objectInfo($customers);
            $_kto = ($_POST) ? $_POST['rueckerstatten_kto_'.$oID]:$cInfo->kto_nummer;
            $_inhaber = ($_POST) ? $_POST['rueckerstatten_inhaber_'.$oID] : $cInfo->kto_inhaber;
            $_blz = ($_POST) ? $_POST['rueckerstatten_blz_'.$oID] : $cInfo->kto_blz;
            $_bank = ($_POST) ? $_POST['rueckerstatten_bank_'.$oID] : $cInfo->kto_bank;
            $_iban = ($_POST) ? $_POST['rueckerstatten_iban_'.$oID] : $cInfo->kto_iban;
            $_swift = ($_POST) ? $_POST['rueckerstatten_swift_'.$oID] : $cInfo->kto_swift;
            $_betrag = ($_POST) ? $_POST['rueckerstatten_betrag_'.$oID] : $summe;
            
            if(isset($_GET['ext_storno']) and $_GET['ext_storno'] == 1){
                $rueck_grund = (isset($_POST['rueckerstattung_grund_'.$oID]))?$_POST['rueckerstattung_grund_'.$oID]:'Rückerstattung erweitertes Storno Auftrag '.$oID;
                $storno_grund = (isset($_POST['storno_grund_'.$oID]))?$_POST['storno_grund_'.$oID]:'Stornierung ...';
                $inputs = [
                    'main'=>[
                        [
                            'label'=>TEXT_EXT_STORNO_REASON,
                            'input'=>xtc_draw_textarea_field('storno_grund_'.$oID,'virtual',45,2,$storno_grund)
                        ]
                    ],
                    'retoure'=>[
                        'title'=>TEXT_RETOURE,
                        'inputs'=>[
                            [
                                'label'=>TEXT_ORDER_EXT_STORNO_ABHOLUNG,
                                'input'=>xtc_draw_radio_field('abholung_'.$oID,'1',
                                        (($_POST['abholung_'.$oID] == '1') ? true : false)
                                ).' '.YES.' '.xtc_draw_radio_field('abholung_'.$oID,'0',
                                        (($_POST['abholung_'.$oID] == '0' or !$_POST) ? true : false)
                                ).' '.NO
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_TRANSPORTKOSTEN,
                                'input'=>xtc_draw_input_field('transportkosten_'.$oID,number_format($_POST['transportkosten_'.$oID],2,'.','') ),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_TRANSPORTKOSTEN_SHIPPER,
                                'input'=>xtc_draw_pull_down_menu('versender_'.$oID,$vers_array,(($_POST) ? $_POST['versender_'.$oID] : 0)),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_COMPANY,
                                'input'=>xtc_draw_input_field('shipping_company_'.$oID,(($_POST) ? $_POST['shipping_company_'.$oID] : $order->delivery['company'])),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_NAME,
                                'input'=>xtc_draw_input_field('shipping_name_'.$oID,(($_POST) ? $_POST['shipping_name_'.$oID] : $order->delivery['name'])),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_NAME2,
                                'input'=>xtc_draw_input_field('shipping_name2_'.$oID,(($_POST) ? $_POST['shipping_name2_'.$oID] : '')),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_STREET_ADDRESS,
                                'input'=>xtc_draw_input_field('shipping_street_'.$oID,(($_POST) ? $_POST['shipping_street_'.$oID] : $order->delivery['street_address'])),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_SUBURB,
                                'input'=>xtc_draw_input_field('shipping_street2_'.$oID,(($_POST) ? $_POST['shipping_street2_'.$oID] : $order->delivery['suburb'])),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_POSTCODE,
                                'input'=>xtc_draw_input_field('shipping_postcode_'.$oID,(($_POST) ? $_POST['shipping_postcode_'.$oID] : $order->delivery['postcode'])),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_CITY,
                                'input'=>xtc_draw_input_field('shipping_city_'.$oID,(($_POST) ? $_POST['shipping_city_'.$oID] : $order->delivery['city'])),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_COUNTRY,
                                'input'=>xtc_draw_pull_down_menu('shipping_country_id_'.$oID,xtc_get_countries(),(($_POST) ? $_POST['shipping_country_id_'.$oID] : $order->delivery['country_id'] )),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RETOURE_COUNTRY,
                                'input'=>xtc_draw_pull_down_menu('shipping_country_id_'.$oID,xtc_get_countries(),(($_POST) ? $_POST['shipping_country_id_'.$oID] : $order->delivery['country_id'] )),
                            ]
                        ]
                    ],
                    'costs'=>[
                        'title'=>TEXT_ORDER_EXT_STORNO_COSTS,
                        'inputs'=>[
                            [
                                'label'=>TEXT_ORDER_EXT_STORNO_BEARBEITUNGSGEBUEHR,
                                'input'=>xtc_draw_input_field('bearbeitungsgebuehr_'.$oID,number_format($_POST['bearbeitungsgebuehr_'.$oID],2,'.','') ),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN_AMOUNT,
                                'input'=>xtc_draw_input_field('rueckerstatten_betrag_'.$oID,(($_POST)?number_format($_POST['rueckerstatten_betrag_'.$oID],2,'.',''):$zwsumme)),
                            ]
                        ]
                    ],
                    'rueckerstattung'=>[
                        'title'=>TEXT_RUECKERSTATTUNG,
                        'inputs'=>[
                            [
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN,
                                'input'=>xtc_draw_pull_down_menu('rueckerstatten_'.$oID,array_merge(array(array('id'=>'','text'=>TEXT_SELECT)),xtc_get_rueckerstattungen_types()), (($_POST)?$_POST['rueckerstatten_'.$oID]:'') ),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN_AMOUNT,
                                'input'=>xtc_draw_input_field('rueckerstatten_betrag_'.$oID,$_betrag),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN_KTO_NUMMER,
                                'input'=>xtc_draw_input_field('rueckerstatten_kto_'.$oID,$_kto),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN_KTO_INHABER,
                                'input'=>xtc_draw_input_field('rueckerstatten_inhaber_'.$oID,$_inhaber),
                            ],[
                                'label'=>'BLZ',
                                'input'=>xtc_draw_input_field('rueckerstatten_blz_'.$oID,$_blz),
                            ],[
                                'label'=>'Bank',
                                'input'=>xtc_draw_input_field('rueckerstatten_bank_'.$oID,$_bank),
                            ],[
                                'label'=>'IBAN',
                                'input'=>xtc_draw_input_field('rueckerstatten_iban_'.$oID,$_iban),
                            ],[
                                'label'=>'BIC/SWIFT',
                                'input'=>xtc_draw_input_field('rueckerstatten_swift_'.$oID,$_swift),
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN_REASON,
                                'input'=>xtc_draw_textarea_field('rueckerstattung_grund_'.$oID,'virtual',45,2,$rueck_grund)
                            ],[
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKERSTATTEN_SAVE_STAMMDATEN,
                                'input'=>xtc_draw_checkbox_field('save_kto_'.$oID,1,(($_POST['save_kto_'.$oID] == '1')?true:false))
                            ]
                        ]
                    ],
                    'rueckbuchen'=>[
                        'title'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN,
                        'subtitle'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_INTRO.'<br />'
                            .'(<b>'.TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_INTRO2.'</b>)',
                        'inputs'=>[
                            [
                                'label'=>TEXT_ORDER_EXT_STORNO_RUECKBUCHEN_LAGERBESTAND,
                                'input'=>xtc_draw_radio_field('bestandsbuchung_'.$oID,'1',
                                        (($_POST['bestandsbuchung_'.$oID] == '1') ? true : false)
                                    ).'&nbsp;'.YES.'&nbsp;'.xtc_draw_radio_field('bestandsbuchung_'.$oID,'0',
                                        (($_POST['bestandsbuchung_'.$oID] == '0' or !$_POST) ? true : false)
                                    ).'&nbsp;'.NO
                            ]
                        ],
                        'products'=>$products_rueckbuch
                    ]
                ];
            } // end if ext storno
        }else{
            if($in_shipping){
                $error = sprintf(TEXT_ORDER_HAS_SHIPPING_ERROR, $oID);
            }else{
                $error = sprintf(TEXT_ORDER_HAS_RECLAMATION_ERROR, $oID);
            }
        }
    }
}
$smarty->assign([
    'JS_ERROR_SELECT_RUECKERSTATTUNG_TYPE'=>JS_ERROR_SELECT_RUECKERSTATTUNG_TYPE,
    'HEADING_TITLE'=>sprintf(PAGE_HEADING_STORNO, implode(',',$oIDs)),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TEXT_STORNO_PRE_INTRO'=>TEXT_STORNO_PRE_INTRO,
    'FORM'=>xtc_draw_form('storno','orders_storno.php',$orders_get.'&action=storno&ext_storno='.$ext_storno,'POST','onsubmit="return check_storno_form()"'),
    'TEXT_ADDRESS_CUSTOMER'=>TEXT_ADDRESS_CUSTOMER,
    'TEXT_ADDRESS_SHIPPING'=>TEXT_ADDRESS_SHIPPING,
    'TEXT_ADDRESS_BILLING'=>TEXT_ADDRESS_BILLING,
    'ORDERS_DATA'=>$orders_data,
    'TEXT_CURRENT_ORDER_STATUS'=>TEXT_CURRENT_ORDER_STATUS,
    'EXT_STORNO'=>(isset($_GET['ext_storno']) and $_GET['ext_storno'] == '1')?'1':'0',
    'TEXT_ORDER_EXT_STORNO'=>TEXT_ORDER_EXT_STORNO,
    'EXT_STORNO_INPUTS'=>$inputs,
    'ERROR'=>$error,
    'BUTTON_ORDERS_MULTIPLE_STORNO_SUBMIT'=>BUTTON_ORDERS_MULTIPLE_STORNO_SUBMIT,
    'TEXT_COMMENT_FOR_STORNO'=>TEXT_COMMENT_FOR_STORNO,
    'INPUT_COMMENTS'=>xtc_draw_textarea_field('comments','virtual','45','2','Stornierung ...'),
]);
$smarty->display('orders_storno.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
