<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require('includes/classes/distributor_invoice.php');
require(DIR_FS_INC.'xtc_get_distributor_invoice_status_name.inc.php');

$admin_access = main::get_admin_access();

$smarty = new yesSmarty;
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'ajax_edit_reason':
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $query = xtc_db_query(sprintf(
            "SELECT reclamations_reasons_id FROM reclamations_to_reclamations_reasons WHERE reclamations_id='%s'",
            $rID
        ));
        $record = xtc_db_fetch_array($query);
        $reason_id = $record['reclamations_reasons_id'];
        header('Content-Type: text/html; charset=iso-8859-1');
        echo '<div class="main">';
        echo xtc_draw_form('edit_reclamation_reason','reclamations_reasons.php',xtc_get_all_get_params(array('action')).'action=ajax_edit_reason_process');
        $reasons = array();
        $items = \YES4Trade\Model\reclamations_reasons::get_all();
        foreach($items as $it){
            $reasons[] = array(
                'id'=>$it->reclamations_reasons_id,
                'text'=>$it->reason
            );
        }
        printf(TEXT_RECLAMATION_REASON_EDIT,$rID);
        echo '<br />'.xtc_draw_pull_down_menu('reclamations_reasons_id',$reasons,$reason_id);
        echo '<input type="submit" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
        echo '</form>';
        echo '</div>';
        exit;
        break;
    case 'ajax_edit_reason_process':
        $item = \YES4Trade\Model\reclamations_reasons::get_by_reclamations_reasons_id((int)xtc_db_input($_REQUEST['reclamations_reasons_id']));
        if($item == null){
            $messageStack->add_session(MSG_ERROR_INVALID_RECLAMATIONS_REASONS_ID,'error');
            xtc_redirect(xtc_href_link('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit'));
        }
        $update_sql_array = array(
                'reclamations_reasons_id'=>(int)xtc_db_input($_REQUEST['reclamations_reasons_id'])
        );
        xtc_db_perform('reclamations_to_reclamations_reasons',$update_sql_array,'update','reclamations_id='.(int)xtc_db_input($_REQUEST['rID']));
        
        $reclamation = new reclamation((int)xtc_db_input($_REQUEST['rID']));
        $reclamation->add_history($reclamation->info['reclamations_status'], false, sprintf(MSG_RECLAMATION_REASON_UPDATED, $item->reason));
        $messageStack->add_session(sprintf(MSG_RECLAMATION_REASON_UPDATED, $item->reason),'success');
        xtc_redirect(xtc_href_link('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit'));
        break;
    case 'new':
    case 'edit':
        echo '<div class="main">';
        if($action == 'edit'){
            $rrID = (int)xtc_db_input($_GET['rrID']);
            $item = \YES4Trade\Model\reclamations_reasons::get_by_reclamations_reasons_id($rrID);
            printf('<b>ID: %d</b><br />',$rrID);
        }else{
            $item = null;
        }
        if($item !== null){
            $reason = $item->reason;
            $date_added = $item->date_added->format('Y-m-d');
        }else{
            $reason = '';
            $date_added = date('Y-m-d');
        }
        if($action == 'edit'){
            echo xtc_draw_form('rr_edit_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=save','POST');
        }else{
            echo xtc_draw_form('rr_insert_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=insert','POST');
        }
        printf('<label for="reason">%s<br /></label>%s<br />',
                TEXT_FIELD_REASON,
                xtc_draw_input_field('reason',$reason,'id="reason"')
        );
        printf('<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" /></form></div>', IMAGE_SAVE);
        exit;
        break;
    case 'insert':
    case 'save':
        if(isset($_GET['rrID'])){
            $rrID = (int)xtc_db_prepare_input( $_GET['rrID'] );
        }else{
            $rrID = null;
        }
        if ($_GET['action'] == 'insert') {
            $new = new \YES4Trade\Model\reclamations_reasons([
                'reason'=>xtc_db_input($_POST['reason']),
                'date_added'=>date('Y-m-d')
            ]);
            $new->create();
            $msg_text = MSG_SUCCESS_SAVE;
        } elseif ($_GET['action'] == 'save') {
            $update = new \YES4Trade\Model\reclamations_reasons([
                'reclamations_reasons_id'=>$rrID,
                'reason'=>xtc_db_input($_POST['reason']),
            ]);
            $update->update();
            $msg_text = MSG_SUCCESS_UPDATE;
        }
        $messageStack->add_session($msg_text,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'delete':
        $rrID = (int)xtc_db_prepare_input($_GET['rrID']);
        $item = \YES4Trade\Model\reclamations_reasons::get_by_reclamations_reasons_id($rrID);
        \YES4Trade\Model\reclamations_reasons::delete($rrID);
        yes_add_history(sprintf(MSG_SUCCESS_DELETE,$item->reason));
        $messageStack->add_session(sprintf(MSG_SUCCESS_DELETE,$item->reason),'success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();
$buttons[] = array('text'=>IMAGE_INSERT,
    'link'=>xtc_href_link(basename(__FILE__), 'action=new'),
    'lbOn'=>true,
    'auth'=>true
);

$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
$contents = [[
    ['text'=>'ID','th'=>true],
    ['text'=>TEXT_FIELD_REASON,'th'=>true],
    ['text'=>TEXT_DATE_ADDED,'th'=>true],
    ['text'=>'&nbsp;','th'=>true],
]];
$items = \YES4Trade\Model\reclamations_reasons::get_all();
foreach($items as $it){
    $links = [
        sprintf('<a title="%s" class="rr_edit" href="javascript:;" data-reclamationsreasonsid="%d">%s</a>',
            IMAGE_EDIT,
            $it->reclamations_reasons_id,
            smarty_function_icon(['type'=>'edit','title'=>IMAGE_EDIT], $smarty)
        ),
        sprintf('<a title="%s" class="rr_delete" href="javascript:;" data-reclamationsreasonsid="%d">%s</a>',
            IMAGE_DELETE,
            $it->reclamations_reasons_id,
            smarty_function_icon(['type'=>'delete','title'=>IMAGE_DELETE], $smarty)
        ),
    ];
    $contents[] = [
        ['text'=>$it->reclamations_reasons_id],
        ['text'=>$it->reason],
        ['text'=>xtc_date_short($it->date_added->format('Y-m-d'))],
        ['text'=>implode('&nbsp;',$links)],
    ];
}
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TABLE'=>$table->tableBlock_draw($contents),
    'REALLY_DELETE_RR'=>REALLY_DELETE_RR,
    
));
$smarty->display('reclamations_reasons.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
