<?php
if(ini_get('register_globals')){
    die('please turn off register_globals - for more information contact <a href="http://www.yes4trade.de" target="_blank">yes4trade</a>');
}
$subscription = json_decode(file_get_contents('php://input'), true);
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'customer.php');
/** BOF - KANN RAUS **/
if(isset($_GET['action']) and $_GET['action'] == 'save_theme'){
	$theme = \YES4Trade\Enums\JQUERY_UI_THEMES::fromName($_POST['theme']);
	if($theme !== null){
		$upd = new \YES4Trade\Model\customers([
			'theme'=>$_POST['theme'],
			'customers_id'=>intval($_SESSION['customer_id'])
		]);
		$upd->update();
		$_SESSION['theme'] = $_POST['theme'];
		$messageStack->add_session('User Default Theme updated to: '.$_POST['theme'],'success');
	}else{
		$messageStack->add_session('Invalid User Default Theme: '.$_POST['theme'],'error');
	}
	xtc_redirect(xtc_href_link('start.php','action=user_profile'));
	exit;
}
if(isset($_GET['action']) and $_GET['action'] == 'un_info'){
	$Bk_array = \YES4Trade\Enums\Bk::cases();
	echo '<div style="display: grid;grid-template-columns: 1fr 1fr;" class="main">';
	foreach($Bk_array as $bk){
		printf('<div><b>%s %s</b></div><div>Faktor %s</div>',
			constant('Bk_TITLE'),
			$bk->value,
			$bk->multiplikator()
		);
	}
	echo '</div>';

	printf('<div style="margin-top:20px;" class="main">'.
		'<p>%s</p><br /><code>%s</code>'
		.'<br /><code>%s</code>'
		.'<br /><code>%s<br />%s</code><br /><br />'
		.'<span style="color: #666;">%s</span></div>',
		UN_SCORE_INFO_1,
		UN_SCORE_INFO_2,
		UN_SCORE_INFO_3,
		UN_SCORE_INFO_4,
		UN_SCORE_INFO_5,
		UN_SCORE_INFO_6
	);
	exit;
}
if(isset($_GET['action']) and $_GET['action'] == 'endpoint_delete_file'){
	rename(main::get_secure_path().'deleted_ebay_users.txt',main::get_secure_path().'deleted_ebay_users.txt-BACKUP');
	$messageStack->add_session('eBay gel&ouml;schte User Daten wurden von Ihnen als verarbeitet gemeldet','success');
	if(!main::isDev(true)){
		yes_mail_debug(HTTPS_SERVER.' endpoint delete closed');
	}
	xtc_redirect(xtc_href_link('start.php'));
}
if(isset($_GET['action']) and $_GET['action'] == 'endpoint_download_file'){
	header('Content-Type: application/csv');
	header('Content-Disposition: attachment; filename=DELETED_EBAY_USER.csv');
	header('Pragma: no-cache');
	readfile(main::get_secure_path().'deleted_ebay_users.txt');
	exit;
}
/** EOF - KANN RAUS **/

$last_manual_cache_delete = false;
$last_manual_cache_delete_file = \main::get_importdata_path().'last_manual_cache_delete.file';
$last_manual_cache_delete_time_check = true;
if(is_file($last_manual_cache_delete_file)){
	$last_manual_cache_delete_time_check = false;
	$last_manual_cache_delete_time = filectime($last_manual_cache_delete_file);
	if( ($last_manual_cache_delete_time+(60*30))>time()){
		$last_manual_cache_delete_time_check = false;
	}else{
		unlink($last_manual_cache_delete_file);
		$last_manual_cache_delete_time_check = true;
	}
}
if(isset($_GET['manual_cache_delete']) and $last_manual_cache_delete_time_check === true){
	$cache_path  = DIR_FS_CATALOG . 'cache';
	$tplc_path   = DIR_FS_CATALOG . 'templates_c';
	$secure_path = \main::get_secure_path() . 'fastcache';
	$basics = new basics;
	if(!$basics->rmdir_rec($cache_path)){
		$messageStack->add_session('cache/ not cleared successful','error');
	}
	if(!$basics->rmdir_rec($tplc_path)){
		$messageStack->add_session('templates_c/ not cleared successful','error');
	}
	if(!$basics->rmdir_rec($secure_path)){
		$messageStack->add_session('fastcache/ not cleared successful','error');
	}
	if(is_file($last_manual_cache_delete_file)){
		unlink($last_manual_cache_delete_file);
	}

	touch($last_manual_cache_delete_file);
	$last_manual_cache_delete_time_check = false;
	$last_manual_cache_delete_time = time();
	$messageStack->add_session(MANUAL_DELETE_CACHE_SUCCESS,'success');
	xtc_redirect(xtc_href_link(basename(__FILE__)));
}
if($last_manual_cache_delete_time_check === true){
	$manual_delete_cache_link = sprintf(
		'<a title="%s" href="?manual_cache_delete=1"><button type="button" class="ui-button ui-corner-all ui-state-default">%s</button></a>',
		MANUAL_DELETE_CACHE,MANUAL_DELETE_CACHE
	);
}else{
	$manual_delete_cache_link = sprintf(
		'<button onclick="alert(\'%s\')" type="button" class="ui-button ui-corner-all ui-state-disabled">%s</button><div style="font-size: 0.8em; padding: 4px;"class="ui-state-error">%s</div>',
		sprintf(MANUAL_DELETE_CACHE_WAIT, 
			ceil((($last_manual_cache_delete_time+(60*30))-time())/60)
		),
		MANUAL_DELETE_CACHE,
		sprintf(MANUAL_DELETE_CACHE_WAIT, 
			ceil((($last_manual_cache_delete_time+(60*30))-time())/60)
		)
	);
}
$table_exists_query = xtc_db_query(sprintf(
	"SHOW TABLES LIKE '%s'",'products_content_description'
));
if(!xtc_db_num_rows($table_exists_query)){
	echo 'system.php?action=convert_products_content <b>muss ausgef&uuml;hrt werden.</b>';
	exit;
}


if(isset($_GET['action']) and $_GET['action'] == 'ebay_orders_oos'){
    require_once(DIR_WS_CLASSES.'class.ebay.php');
    require_once(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
    define('CONFIRM_DELETE_EBAY_ORDERS_OOS_ITEM','Diese eBay Order Stock Warnung wirklich löschen?');
    define('EBAY_ORDERS_OOS_DATE_ADDED','Erzeugt am');
    define('EBAY_ORDERS_OOS_INTRO','Diese eBay Orders können nicht eingelesen werden, da die enthaltenen Artikel keinen Bestand zugewiesen haben. Passen Sie umgehend die Mengen an, damit die Aufträge erzeugt werden können.');
    if(isset($_GET['delete_id']) and $_GET['delete_id'] > 0){
        $id = (int)xtc_db_input($_GET['delete_id']);
        \YES4Trade\Model\ebay_orders_oos::delete( $id );
        die(json_encode([
            'MSG'=>''
        ]));
    }
    $oos_items = \YES4Trade\Model\ebay_orders_oos::get_items();
    $EBAYAPI = new ebayAPI();
    $contents = [];
    $contents[] = [
        ['text'=>'eBay OrderID','params'=>'','align'=>'left','form'=>'','th'=>true],
        ['text'=>'Seller','params'=>'','align'=>'left','form'=>'','th'=>true],
        ['text'=>EBAY_ORDERS_OOS_DATE_ADDED,'params'=>'','align'=>'left','form'=>'','th'=>true],
    ];
    $params = 'class="yesListTable_minimal" id="ebay_orders_oos_table"';
    $table = new tableBlock();
    $table->table_parameters = $params;
    foreach($oos_items as $oi){
        $delete_icon = '&nbsp;<a class="fi-trash" onclick="delete_ebay_orders_oos_item(\''.$oi['ebay_orders_oos_id'].'\',\''.CONFIRM_DELETE_EBAY_ORDERS_OOS_ITEM.'\')" style="color: red;font-size:1.5em;cursor: pointer;" title="'.IMAGE_DELETE.'"></a>';
        $content = ['params'=>'data-ebayordersoosid="'.$oi['ebay_orders_oos_id'].'"'];
        $content[] = ['text'=>'<span style="font-size: 1.5em; color: green;">'.$oi['OrderID'].'</span>','params'=>'','align'=>'left','form'=>''];
        $content[] = ['text'=>$oi['seller'],'params'=>'','align'=>'left','form'=>''];
        $content[] = ['text'=>xtc_date_short($oi['date_created']).$delete_icon,'params'=>'','align'=>'left','form'=>''];
        $contents[] = $content;
        
        $ebay_debug = false;
        $sandbox = (main::isDev(true) or (defined('EBAY_TESTMODE') and EBAY_TESTMODE == '1')) ? true : false;
        $site_id = $EBAYAPI->get_site_id_from_name(EBAY_SITE);
		$ebaycalls = new \YES4Trade\Model\ebaycalls();
		$failed = false;
		if(ebayApi::oauth2_refreshtoken_exists($oi['seller'])){
				if(!ebayApi::oauth2_usertoken_exists($oi['seller']) or ebayApi::get_oauth2_usertoken_lifetime($oi['seller']) < 1){
					try{
						ebayApi::refresh_oauth2_usertoken($oi['seller']);
					}catch(Exception $e){
						$api_error = 'refresh_oauth2_usertoken() for seller '.$oi['seller'].'  '.$e->getMessage();
					}
				}
		}
		try{
			$res = $ebaycalls->tradingQuery($oi['seller'], 
				'GetOrders',
				$site_id,
				[
					'OrderIDArray'=>[
						['OrderID'=>$oi['OrderID']]
					]
				]
			);
		}catch(Exception $e){
			$failed = true;
			$content = [];
			$content[] = ['text'=>$e->getMessage(),'params'=>'colspan="3"','align'=>'left','form'=>''];
			$contents[] = $content;
			$displayed_errorcodes[] = $err->ErrorCode;
		}
        if(!$failed and $res->Ack == 'Failure'){
            $displayed_errorcodes = [];
            foreach($res->Errors as $err){
                if(!in_array($err->ErrorCode,$displayed_errorcodes)){
                    $msg = sprintf('<span style="color: #666;">[%s #%s] %s<br /><i>%s</i></span>',
                        $err->ErrorClassification,
                        $err->ErrorCode,
                        $err->ShortMessage,
                        $err->LongMessage
                    );
                    $content = [];
                    $content[] = ['text'=>$msg,'params'=>'colspan="3"','align'=>'left','form'=>''];
                    $contents[] = $content;
    //                yes_debug($err);
                    $displayed_errorcodes[] = $err->ErrorCode;
                }
            }
        }elseif(!$failed and $res->Ack != 'Failure'){
            if(is_countable(current($res->OrderArray)) and !sizeOf(current($res->OrderArray))){
                $content = [['text'=>'Keine Informationen bei eBay verf&uuml;gbar.','params'=>'colspan="3" style="color: red;"','align'=>'left','form'=>'']];
                $contents[] = $content;
            }
            foreach($res->OrderArray->Order as $Order){
                $status = sprintf('Status %s (CheckoutStatus %s, %s)<br />',$Order->OrderStatus, 
                        $Order->CheckoutStatus->Status, 
                        ((!empty($Order->CheckoutStatus->PaymentInstrument))?$Order->CheckoutStatus->PaymentInstrument.'/'.$Order->CheckoutStatus->PaymentMethod:$Order->CheckoutStatus->PaymentMethod),
                );
                foreach($Order->TransactionArray->Transaction as $Transaction){
                    $check_pID = $EBAYAPI->get_products_id_from_transaction( $Transaction );
                    $SQ = new products_quantity($check_pID);
                    $products_stock = $SQ->get_available1_qty();
                    $ebay_auctions_id = $EBAYAPI->get_ebay_auctions_id_from_ebay_id($Transaction->Item->ItemID);
                    $auction = new ebay_auction($ebay_auctions_id);
					if($auction === false){
						$siteID = constant('EBAY_SITE_ID');
					}else{
                    	$siteID = ebayApi::get_site_id_from_name($auction->getSite());
					}
                    $smarty = new yesSmarty;
                    $msg = sprintf('<a href="javascript:void(window.open(\'products.php?action=bestand&edit=1&pID=%d\',\'popup\',\'width=1400,height=800,scrollbars=yes,resizable=yes\'));" style="font-size: 1.2em;">%dx pID %s [AV1: %d]</a><br />%s<br />%seBay ID: %s',
                        $check_pID,
                        $Transaction->QuantityPurchased,
                        $check_pID,
                        $products_stock,
                        $Transaction->Item->Title,
                        $status,
                        sprintf('<a href="%s">%s</a>',
                        	xtc_href_link('ebayapi_cart.php?page_type=runnings&searchword='.$Transaction->Item->ItemID),
                        	$Transaction->Item->ItemID
                        )
                    );
                    $content = [];
                    $content[] = ['text'=>$msg,'params'=>'colspan="3"','align'=>'left','form'=>''];
                    $contents[] = $content;
                }
            }
        }
    }
    printf('<div class="main" style="width: 600px;"><p>%s</p>%s</div>',
        EBAY_ORDERS_OOS_INTRO,
        $table->tableBlock_draw($contents)
    );
    exit;
}

if(!function_exists('yes_get_sha1_from_string')){
    require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
}
require_once(DIR_WS_CLASSES.'userprofile_emailfilter_addresses_allocation.php');

//$_SESSION['language_id'] = '2';
//$_SESSION['language'] = 'german';

$admin_access = main::get_admin_access();

$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

if(isset($_REQUEST['action'])){
    switch($_REQUEST['action']){
        case 'user_profile':
            $up = new userprofile_emailfilter_addresses_allocation( $_SESSION['customer_id'] );
            $upef_action = (isset($_GET['upef_action']))?$_GET['upef_action']:'';
            switch($upef_action){
                case 'del':
                    $address = xtc_db_input($_GET['address']);
                    if($up->exists($address)){
                        $up->delete($address);
                    }
                    die(json_encode([
                        'MSG'=>'',
                        'ERROR'=>false,
                    ]));
                    break;
                case 'add':
                    $address = xtc_db_input($_GET['address']);
                    if(!xtc_validate_email($address)){
                        die(json_encode([
                            'MSG'=>sprintf(ERROR_EMAILFILTER_ADD_INVALID_EMAIL,$address),
                            'ERROR'=>true,
                        ]));
                    }
                    if($up->exists($address)){
                        die(json_encode([
                            'MSG'=>ERROR_EMAILFILTER_ADD_EMAIL_EXISTS,
                            'ERROR'=>true,
                        ]));
                    }
                    $up->add($address);
                    die(json_encode([
                        'MSG'=>'',
                        'ERROR'=>false,
                    ]));
                    break;
            }
            break;
		case 'update_yes_push_user_allocation':
			$status = xtc_db_input($_GET['status']);
			$allocation = xtc_db_input($_GET['allocation']);
					main::yes_debug_log($status.':'.$allocation);
			$query = xtc_db_query(sprintf(
				"SELECT COUNT(push_customer_allocations_id) AS anz FROM push_customer_allocations WHERE customers_id='%s' AND allocation='%s'",
				$_SESSION['customer_id'],$allocation
			));
			$record = xtc_db_fetch_array($query);
			switch($status){
				case '1':
					if($record['anz'] == 0){
						$insert_sql_array = array(
							'customers_id'=>$_SESSION['customer_id'],
							'allocation'=>$allocation
						);
						xtc_db_perform('push_customer_allocations',$insert_sql_array);
					}
					break;
				case '0':
					if($record['anz'] > 0){
						xtc_db_query(sprintf(
							"DELETE FROM push_customer_allocations WHERE customers_id='%s' AND allocation='%s' LIMIT 1",
							$_SESSION['customer_id'],$allocation
						));
					}
					break;
			}
			exit;
			break;
		case 'reactivate_notizen_termine':
				unset($_SESSION['display_notizen_termine']);
				xtc_redirect(xtc_href_link(basename(__FILE__)));
				break;
		case 'reactivate_systemmessages':
				unset($_SESSION['display_system_alerts']);
				xtc_redirect(xtc_href_link(basename(__FILE__)));
				break;
		case 'save_user_categories':
			xtc_db_query("DELETE FROM categories_exclude WHERE customers_id='".$_SESSION['customer_id']."'");
			foreach($_REQUEST as $k=>$v){
				if( strstr($k,'cat_') ){
					$split = explode('cat_',$k);
					if($split[1] and $v == '1'){
						xtc_db_query("INSERT INTO categories_exclude SET categories_id='".xtc_db_input($split[1])."',customers_id='".$_SESSION['customer_id']."'");
					}
				}
			}
			die(json_encode(array(
				'ERROR'=>'',
				'SUCCESS'=>true
			)));
			break;
		case 'save_email_signature':
			$update_sql_array = array(
				'email_signature'=>$_REQUEST['email_signature']
			);
			xtc_db_perform('customers',$update_sql_array,'update','customers_id="'.$_SESSION['customer_id'].'"');
			die(json_encode(array(
				'ERROR'=>'',
				'SUCCESS'=>true
			)));
			break;
		case 'update_easylog':
			$update_sql_array = array(
				'easylog_tn_national'=>$_REQUEST['easylog_tn_national'],
				'easylog_tn_international'=>$_REQUEST['easylog_tn_international']
			);
			xtc_db_perform('customers',$update_sql_array,'update','customers_id="'.$_SESSION['customer_id'].'"');
			xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action'))));
			break;
		case 'save_use_own_mailaddress':
			$use_own_mailaddress = 0;
			if(isset($_REQUEST['use_own_mailaddress']) and $_REQUEST['use_own_mailaddress'] == 1){
				$use_own_mailaddress = 1;
			}
			$update_sql_array = array(
				'use_own_mailaddress'=>$use_own_mailaddress
			);
			xtc_db_perform('customers',$update_sql_array,'update','customers_id="'.$_SESSION['customer_id'].'"');
			die(json_encode(array(
				'ERROR'=>'',
				'SUCCESS'=>true
			)));
			break;
		case 'set_orders_default_search_type':
			$orders_default_search_type = xtc_db_input($_REQUEST['orders_default_search_type']);
			xtc_db_query("UPDATE customers SET orders_default_search_type='".$orders_default_search_type."' WHERE customers_id='".xtc_db_input($_SESSION['customer_id'])."' LIMIT 1");
			die(json_encode(array(
				'ERROR'=>'',
				'SUCCESS'=>true
			)));
			break;
		case 'save_ti':
			$error = '';
			if(is_array($_REQUEST['ebay_textitems_id'])){
				xtc_db_query("DELETE FROM ebay_textitems_user WHERE customers_id='".$_SESSION['customer_id']."'");
				foreach($_REQUEST['ebay_textitems_id'] as $k=>$ti_id){
					xtc_db_query("INSERT INTO ebay_textitems_user SET customers_id='".intval($_SESSION['customer_id'])."',ebay_textitems_id='".intval($ti_id)."'");
				}

				$ti_query_raw = "select ti.* from ebay_textitems ti LEFT JOIN ebay_textitems_user tiu ON ti.id=tiu.ebay_textitems_id WHERE tiu.customers_id='".$_SESSION['customer_id']."' and module='mail' order by class";
				$ti_query = xtc_db_query($ti_query_raw);

				$doc = new DOMDocument('1.0', 'UTF-8');
				$doc->formatOutput = true;

				$templates = $doc->createElement('Templates');
				$templates->setAttribute('imagesBasePath', 'fck_template/images/');
				$doc->appendChild($templates);

				$counter = 0;
				while ($ti = xtc_db_fetch_array($ti_query)) {
					$ti = xtc_db_prepare_input($ti);
					$template = $doc->createElement('Template');
					$template->setAttribute('title', 'Template ' . $counter);
					$template->setAttribute('image', 'template2.gif');

					$description = $doc->createElement('Description');
					$description->appendChild($doc->createCDATASection($ti['class']));
					$template->appendChild($description);

					$html = $doc->createElement('Html');
					$html->appendChild($doc->createCDATASection(nl2br($ti['text']) . chr(160)));
					$template->appendChild($html);

					$templates->appendChild($template);
					$counter++;
				}
				$xml_str = $doc->saveXML();
				$filename = \main::get_exportdata_path().'textitems_'.$_SESSION['customer_id'].'.xml';

				// Wir �ffnen $filename im "Anh�nge" - Modus.
				// Der Dateizeiger befindet sich am Ende der Datei, und
				// dort wird $somecontent sp�ter mit fwrite() geschrieben.
				if (!$handle = fopen($filename, "w")) {
					$error = "cant open $filename";
				}

				// Schreibe $somecontent in die ge�ffnete Datei.
				if (!fwrite($handle, $xml_str)) {
					$error = "cant write into $filename";
				}
				fclose($handle);
			}
			xtc_db_query("UPDATE customers SET subject_from_textitem='".xtc_db_input($_REQUEST['subject_from_textitem'])."' WHERE customers_id='".xtc_db_input($_SESSION['customer_id'])."' LIMIT 1");
			die(json_encode(array(
				'ERROR'=>$error,
				'SUCCESS'=>($error == '') ? true : false
			)));
		break;
		case 'ebay_import_csv':
			require('ebay_import_csv.php');
			exit;
			break;
		case 'module_attachments':
			require('module_attachments.php');
			exit;
			break;
		case 'tpl_chk':
			if(substr($_REQUEST['tpl'],strlen($_REQUEST['tpl'])-5,strlen($_REQUEST['tpl'])) == '.html'){
			$file = str_replace('..','',$_REQUEST['tpl']);
				$smarty = new yesSmarty;
				$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
				$smarty->display($file);
				exit;
			}
			break;
		case 'ajax_update':
			include('ajax_updater.php');
			break;
		case 'messages':
			include('messages.php');
			break;
		case 'header_quicksearch':
			include('header_quicksearch.php');
			break;
	}
}

if(isset($_REQUEST['context_menu']) and $_REQUEST['context_menu'] == 1){
	if(isset($_REQUEST['context_group']) and isset($_REQUEST['group_item_id'])){
		header('Content-Type: text/html; charset='.CHARSET);
		$group_item_id = (int)xtc_db_input($_REQUEST['group_item_id']);
		$context_group = xtc_db_input($_REQUEST['context_group']);
		if(is_file(DIR_WS_CLASSES.'context_menu.php')) require_once(DIR_WS_CLASSES.'context_menu.php');
		$context_menu = new context_menu($context_group,$group_item_id,$_SESSION['customer_id'],$admin_access);
		echo $context_menu->get_menu_html();
	}
	exit;
}

require_once 'includes/classes/carp.php';
if(isset($_REQUEST['action'])){
	switch($_REQUEST['action']){
            case 'convert_default_shipper':
                if(isset($_POST['profile_name'])){
                    $doubles = [];
                    foreach($_POST['profile_name'] as $shipper_conf=>$profile){
                        $profile_name = main::filesanitize($profile,true,false);
                        if(in_array($profile_name, $doubles)){
                            $messageStack->add_session('Profilname '.$profile_name.' wurde mehrfach &uuml;bergeben','error');
                            xtc_redirect(xtc_href_link('start.php',xtc_get_all_get_params()));
                        }
                        if(strlen($profile_name) < 3){
                            $messageStack->add_session('Profilname '.$profile_name.' muss mind. 3 Zeichen und keine Sonderzeichen enthalten','error');
                            xtc_redirect(xtc_href_link('start.php',xtc_get_all_get_params()));
                        }
                        if(\YES4Trade\Model\shipper_profiles::profile_name_exists( $profile_name )){
                            $messageStack->add_session('Profilname '.$profile_name.' ist bereits gespeichert als Profilname.','error');
                            xtc_redirect(xtc_href_link('start.php',xtc_get_all_get_params()));
                        }
                        $doubles[] = $profile_name;
                    }
                    
                    foreach($_POST['profile_name'] as $shipper_conf=>$profile){
                        $profile_name = main::filesanitize($profile,true,false);
                        $shipper_parts = explode('::',urldecode($shipper_conf));
                        $new_sp = new \YES4Trade\Model\shipper_profiles([
                            'versender'=>$shipper_parts[0],
                            'versender_params'=>$shipper_parts[1],
                            'profile_name'=>$profile_name,
                        ]);
                        $spID = $new_sp->create();
                        
                        $allocateds = [];
                        $all_query = xtc_db_query(sprintf(
                                "SELECT products_id FROM products_default_shipper WHERE shipper='%s' AND shipper_params='%s'",
                                $shipper_parts[0],$shipper_parts[1]
                        ));
                        while($all = xtc_db_fetch_array($all_query)){
                            $allocateds[] = $all['products_id'];
                        }
                        foreach($allocateds as $pID){
                            xtc_db_query(sprintf(
                                    "DELETE FROM products_default_shipper WHERE products_id='%d'",
                                    $pID
                            ));
                            $insert_sql_array = [
                                'products_id'=>$pID,
                                'shipper_profile'=>$profile_name,
                            ];
                            xtc_db_perform('products_default_shipper', $insert_sql_array);
                        }
                    }
                    touch(main::get_secure_path().'shipper_profiles_converted.txt');
                    $messageStack->add_session('Versender Profile Konvertierung abgeschlossen.','success');
                    xtc_redirect(xtc_href_link('start.php'));
                }
                xtc_db_query("DELETE FROM products_default_shipper WHERE shipper='' AND shipper_profile = ''");
                $distinct = [];
                $q = xtc_db_query(
                    "SELECT DISTINCT( CONCAT(shipper,'::',shipper_params) ) as dist FROM products_default_shipper"
                );
                while($record = xtc_db_fetch_array($q)){
                    $distinct[] = $record;
                }
                $sh_data = [];
                $dist_shipper_nr = [];
                foreach($distinct as $data){
                    $d = $data['dist'];
                    if($d === '::'){
                        continue;
                    }

                    $parts = explode('::',$d);

                    $count_query = xtc_db_query(sprintf(
                            "SELECT COUNT(products_id) AS anz FROM products_default_shipper WHERE shipper='%s' AND shipper_params='%s'",
                            $parts[0],$parts[1]
                    ));
                    $count = xtc_db_fetch_array($count_query);

                    if(!isset($dist_shipper_nr[ $parts[0] ])){
                        $dist_shipper_nr[ $parts[0] ] = 1;
                    }
                    $params = explode(',',$parts[1]);
                    $sh_data[] = [
                        'shipper'=>$parts[0],
                        'allocated'=>$count['anz'],
                        'shipper_params'=>(!empty($parts[1]))?implode(', ',$params):'',
                        'input'=>xtc_draw_input_field('profile_name['.urlencode($d).']',$parts[0].'_'.$dist_shipper_nr[ $parts[0] ],'size="32" maxlength="32"'),
                    ];
                    $dist_shipper_nr[ $parts[0] ]++;
                }
                $smarty->assign([
                    'SHIPPER_PROFILES'=>$sh_data,
                ]);
                yes_draw_pre_header();
                yes_draw_header(TITLE);
                $smarty->display('default_shipper_convert.html');
                require(DIR_WS_INCLUDES . 'footer.php');
                require(DIR_WS_INCLUDES . 'application_bottom.php');
                exit;
                break;
		case 'set_branch':
			$allocated_branches = yes_get_customer_branches($_SESSION['customer_id']);
			if(in_array($_POST['selected_branch'],$allocated_branches)){
				$_SESSION['allocated_branches_id'] = (int)xtc_db_input($_POST['selected_branch']);
				xtc_db_query("UPDATE customers SET branches_id='".(int)$_SESSION['allocated_branches_id']."' WHERE customers_id='".$_SESSION['customer_id']."'");
				$messageStack->add_session(sprintf(
					MSG_SUCCES_SELECTED_BRANCH,
					xtc_get_branch_title($_SESSION['allocated_branches_id'])
					),
					'success'
				);
			}
			xtc_redirect(xtc_href_link('start.php'));
			break;
		case 'select_branch':
			$smarty = new yesSmarty;
			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$allocated_branches_array = array();
			$allocated_branches = yes_get_customer_branches($_SESSION['customer_id']);
			for($a = 0;$a < sizeOf($allocated_branches); $a++){
				$allocated_branches_array[] = array('id'=>$allocated_branches[$a],'text'=>xtc_get_branch_title($allocated_branches[$a]));
			}
			$smarty->assign('allocated_branches',$allocated_branches_array );
			$smarty->assign('HEADING_TITLE',HEADING_TITLE_SELECT_BRANCH);
			$smarty->assign('TEXT_SELECT_BRANCH',TEXT_SELECT_BRANCH);
			$smarty->assign('TEXT_BRANCH',TEXT_BRANCH);
			$smarty->assign('FORM',xtc_draw_form('select_branch','start.php','action=set_branch'));
			$smarty->assign('FORM_END','</form>');
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('ajax_select_branch.html');
			exit;
			break;
	}
}

// FILIAL AUSWAHL
$select_branch = false;
if(YES_BRANCHES_COUNT > 0 && !isset($_SESSION['allocated_branches_id'])){
	$saved_branches_id_query = xtc_db_query("SELECT branches_id FROM customers  WHERE customers_id='".$_SESSION['customer_id']."'");
	$saved_branches_id = xtc_db_fetch_array($saved_branches_id_query);

	$allocated_branches = yes_get_customer_branches($_SESSION['customer_id']);
	if(sizeOf($allocated_branches)==1){
		$_SESSION['allocated_branches_id'] = current($allocated_branches);
	}else if(sizeOf($allocated_branches) > 1){
		if(in_array($saved_branches_id['branches_id'],$allocated_branches)){
			$_SESSION['allocated_branches_id'] = $saved_branches_id['branches_id'];
		}else{
			$_SESSION['allocated_branches_id'] = current($allocated_branches);
		}
	}
}

if(isset($_REQUEST['message'])){
	if(empty($_REQUEST['message'])){
		$messageStack->add_session(ERROR_SUPPORT_REQUEST_MESSAGE_EMPTY,'error');
	}else{
		$mail = sprintf("Supportanfrage von %s / %s\r\n\r\nAnfragetyp: %s\r\nAuftragsart: %s (%s)\r\n\r\nNachricht\r\n\r\n%s",
			$_REQUEST['domain'],$_REQUEST['user'],$_REQUEST['msg_nature'],
			$_REQUEST['order_nature'],$_REQUEST['order_release'],
			$_REQUEST['message']
		);
		mail('support@yes4trade.de','Supportanfrage',$mail);
		$messageStack->add_session(SUCCESS_SUPPORT_REQUEST_MESSAGE_SENT,'success');
	}
	xtc_redirect(xtc_href_link('start.php'));
}
yes_draw_pre_header();
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'user_profile'){
    echo '<script src="js/tinymce-'.TINYMCE_VERSION.'/js/tinymce/tinymce.min.js"></script>';
}
echo '<script type="text/javascript" src="https://www.google.com/jsapi"></script>';
yes_draw_header(TITLE);
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'user_profile'){
    include(DIR_WS_INCLUDES.'user_profile.php');
    exit;
}
include(DIR_WS_MODULES.FILENAME_SECURITY_CHECK);
$key = 'DIRECTORIES_SIZES';
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
	$dir_sizes = \basics::getDirectoryUsages([
		DIR_FS_CATALOG.'images/',
		DIR_FS_CATALOG.'templates/',
		DIR_FS_CATALOG.'files/',
		DIR_FS_CATALOG.'cache/',
		DIR_FS_CATALOG.'templates_c/',
		DIR_FS_CATALOG.'media/',
		\main::get_exportdata_path(),
		\main::get_importdata_path(),
	]);
	$directories_sizes = ['payload'=>$dir_sizes,'date_created'=>time()];
	$CachedString->set($directories_sizes)->expiresAfter(3600*24*2);//in seconds, also accepts Datetime
	$InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
	$directories_sizes = $CachedString->get();
}
$total_size = 0;
foreach($directories_sizes['payload'] as $ds){
	$total_size += floatval($ds['total_size']);
}
$smarty->assign([
	'directories_sizes'=>$directories_sizes,
	'directories_sizes_info'=>sprintf(
		'%s: %s (%s)',
		TEXT_LAST_UPDATE,
		date('d.m.Y H:i:s',$directories_sizes['date_created']),
		'2 '.TEXT_DAYS
	),
	'directories_sizes_total'=>\basics::formatBytes($total_size,2),
]);

$key = 'MAILSTATS';
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
	$mail_stats = [
		TEXT_EMAIL_UNREAD=>0,
		'total'=>0,
		TEXT_EMAIL_UNALLOCATED=>0,
		TEXT_EMAIL_CLOSED=>0,
		TEXT_EMAIL_OWNMAIL=>0
	];
	$query = xtc_db_query(sprintf("SELECT count(id) AS anz FROM ebay_emails WHERE read_status=0"));
	$record = xtc_db_fetch_array($query);
	$mail_stats[TEXT_EMAIL_UNREAD] += intval($record['anz']);
	$query = xtc_db_query(sprintf("SELECT count(id) AS anz FROM ebay_emails"));
	$record = xtc_db_fetch_array($query);
	$mail_stats['total'] += intval($record['anz']);
	$query = xtc_db_query(sprintf("SELECT count(id) AS anz FROM ebay_emails WHERE allocation_status=0"));
	$record = xtc_db_fetch_array($query);
	$mail_stats[TEXT_EMAIL_UNALLOCATED] += intval($record['anz']);
	$query = xtc_db_query(sprintf("SELECT count(id) AS anz FROM ebay_emails WHERE saved=0"));
	$record = xtc_db_fetch_array($query);
	$mail_stats[TEXT_EMAIL_CLOSED] += intval($record['anz']);
	$query = xtc_db_query(sprintf("SELECT count(id) AS anz FROM ebay_emails WHERE ownmail=1"));
	$record = xtc_db_fetch_array($query);
	$mail_stats[TEXT_EMAIL_OWNMAIL] += intval($record['anz']);
	$mail_stats_array = ['payload'=>$mail_stats,'date_created'=>time()];
	$CachedString->set($mail_stats_array)->expiresAfter(3600);//in seconds, also accepts Datetime
	$InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
	$mail_stats_array = $CachedString->get();
}
$smarty->assign([
	'mail_stats'=>$mail_stats_array['payload'],
	'mail_stats_info'=>sprintf(
		'%s: %s (%s)',
		TEXT_LAST_UPDATE,
		date('d.m.Y H:i:s',$mail_stats['date_created']),
		TEXT_HOURLY
	)
]);

$order_stats_date_default = $_GET['order_stats_date_default']??'2 Weeks';
$order_stats_date_spans = [
	['id'=>'1 Week','text'=>'1 '.TEXT_WEEK],
	['id'=>'2 Weeks','text'=>'2 '.TEXT_WEEKS],
	['id'=>'1 Month','text'=>'1 '.TEXT_MONTH],
	['id'=>'3 Months','text'=>'3 '.TEXT_MONTHS],
	['id'=>'6 Months','text'=>'6 '.TEXT_MONTHS],
	['id'=>'1 Year','text'=>'1 '.TEXT_YEAR],
	['id'=>'3 Years','text'=>'3 '.TEXT_YEARS],
];
$osds_valid = false;
foreach($order_stats_date_spans as $osds){
	if($osds['id'] == $order_stats_date_default){
		$osds_valid = true;
		break;
	}
}
if($osds_valid === false){
	$order_stats_date_default = '2 Weeks';
}
$order_stats_date = new DateTime('-'.$order_stats_date_default);
$order_stats_date_param = " WHERE date_purchased > '".$order_stats_date->format('Y-m-d H:i:s')."'";

function short_sales_stats(DateTime $date_purchased_from):array{
	$sales_stats = [];
	$sales_stats_query = xtc_db_query(sprintf(
		"SELECT o.date_purchased,o.orders_id, o.orders_status,o.source,ot.value,ot.text, ot.title FROM %s o INNER JOIN %s ot ON o.orders_id=ot.orders_id WHERE o.date_purchased > '%s' AND o.orders_status NOT IN(%s) AND ot.class IN('ot_total') ",
		TABLE_ORDERS,TABLE_ORDERS_TOTAL,
		$date_purchased_from->format('Y-m-d H:i:s'),
		implode(',',[constant('ORDERS_STATUS_STORNIERT')])
	));
	while($record = xtc_db_fetch_array($sales_stats_query)){
		$sales_stats[] = $record;
	}
	return $sales_stats;
}

$key = 'SHORT_SALES_STATS';
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
	$sales_stats = [
		'1day'=>['data'=>short_sales_stats(new DateTime('-1 Day')),'text'=>TEXT_YESTERDAY],
		'2days'=>['data'=>short_sales_stats(new DateTime('-2 Days')),'text'=>TEXT_EREYESTERDAY],
		'today'=>['data'=>short_sales_stats(new DateTime()),'text'=>TEXT_TODAY]
	];
	$sales_stats_array = ['payload'=>$sales_stats,'date_created'=>time()];
	$CachedString->set($sales_stats_array)->expiresAfter(3600);//in seconds, also accepts Datetime
	$InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
	$sales_stats_array = $CachedString->get();
}
$sales_stats_charts = [];
foreach($sales_stats_array['payload'] as $stats_key=>$values){
	$total = 0;
	foreach($values['data'] as $sal){
		$total += floatval($sal['value']);
	}
	$sales_stats_charts[] = [
		'total'=>xtc_round($total,2),
		'total_formatted'=>number_format(xtc_round($total,2),2,',','.').' '.DEFAULT_CURRENCY,
		'number_of_orders'=>sizeOf($values['data']),
		'title'=>$values['text']
	];
}

$valid = 0;
foreach($sales_stats_charts as $k=>$v){
	if($v['total'] > 0){
		$valid++;
	}
}
if($valid > 1){
	$smarty->assign([
		'short_sales_stats'=>$sales_stats_charts,
		'short_sales_info'=>sprintf('%s: %s (%s)',
			TEXT_LAST_UPDATE, 
			date('d.m.Y H:i:s',$sales_stats_array['date_created']),
			TEXT_HOURLY
		)
	]);
}

$key = 'ORDERS_STATS_START_'.$order_stats_date_default;
$CachedString = $InstanceCache->getItem($key);
$order_stats = [
	'status_stats'=>[],
	'source_stats'=>[],
	'total'=>0,
];
if (!$CachedString->isHit()) {
	$query = xtc_db_query("SELECT orders_status, COUNT(*) AS total_orders FROM `orders` $order_stats_date_param GROUP BY orders_status");
	while($record = xtc_db_fetch_array($query)){
		$order_stats['status_stats'][ \main::get_orders_status_name( intval($record['orders_status']), $_SESSION['languages_id'] ) ] = $record['total_orders'];
		$order_stats['total'] += intval($record['total_orders']);
	}

	$query = xtc_db_query("SELECT source, COUNT(*) AS total_orders FROM `orders` $order_stats_date_param GROUP BY source");
	while($record = xtc_db_fetch_array($query)){
		$order_stats['source_stats'][ yes_get_order_source_title( $record['source'] )] = $record['total_orders'];
	}
	$order_stats_start = ['payload'=>$order_stats,'date_created'=>time()];
	$CachedString->set($order_stats_start)->expiresAfter(3600);//in seconds, also accepts Datetime
	$InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
	$order_stats_start = $CachedString->get();
}
$smarty->assign([
	'order_stats'=>$order_stats_start['payload']['status_stats'],
	'order_stats_total'=>$order_stats_start['payload']['total'],
	'source_stats'=>$order_stats_start['payload']['source_stats'],
	'order_stats_input_start'=>xtc_draw_pull_down_menu('order_stats_date_default',$order_stats_date_spans,$order_stats_date_default),
	'order_stats_info'=>sprintf(
		'%s: %s (%s)',
		TEXT_LAST_UPDATE, 
		date('d.m.Y H:i:s',$order_stats_start['date_created']),
		TEXT_HOURLY
	),
]);


$key = 'NEWCUSTOMERSTATS';
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
	$customers_new = [];
	$query = xtc_db_query(
		"SELECT c.customers_id,c.customers_date_added, customers_firstname, customers_lastname, customers_status FROM customers c  ORDER BY customers_date_added DESC LIMIT 10"
	);
	while($record = xtc_db_fetch_array($query)){
		$cs = \YES4Trade\Model\customers_status::get_by_customers_status_id_and_language_id(intval($record['customers_status']),intval($_SESSION['languages_id']),['customers_status_name']);
		$record['date_added_formatted'] = xtc_date_long($record['customers_date_added']);
		$record['status_name'] = current($cs)->customers_status_name;
		$customers_new[] = $record;
	}
	
	$customers_new_stats = ['payload'=>$customers_new,'date_created'=>time()];
	$CachedString->set($customers_new_stats)->expiresAfter(3600);//in seconds, also accepts Datetime
	$InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
	$customers_new_stats = $CachedString->get();
}
$smarty->assign([
	'customers_new_stats'=>$customers_new_stats['payload'],
	'customers_new_stats_info'=>sprintf(
		'%s: %s (%s)',
		TEXT_LAST_UPDATE,
		date('d.m.Y H:i:s',$customers_new_stats['date_created']),
		TEXT_HOURLY
	),
]);


/*
$curl = curl_init();
curl_setopt($curl, CURLOPT_URL, "http://yes4trade.de/yes4trade-backend/");
curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
$html = curl_exec($curl);
curl_close($curl);
*/
$html = '';
$smarty->assign('marketing_box',yes_decode_string($html));
if($admin_access['token'] == 1 and defined('EBAY_USER') and !empty(constant('EBAY_USER'))){
    $smarty->assign('EBAY_USER',xtc_get_ebay_users());
}
$html = '';
$smarty->assign('kurznews_box',yes_decode_string($html));
$smarty->assign(array(
	'HTTP_SERVER'=>HTTP_SERVER,
	'CUSTOMERS_ID'=>$_SESSION['customer_id'],
	'CUSTOMERS_NAME'=>$_SESSION['customer_first_name'].' '.$_SESSION['customer_last_name'],
    'TEXT_USER_PROFILE'=>TEXT_USER_PROFILE,
));

if(isset($_SESSION['display_notizen_termine'])){
    $smarty->assign(array(
        'display_notizen_termine'=>true,
        'TEXT_NOTIZEN_TERMINE'=>TEXT_NOTIZEN_TERMINE,
        'TEXT_NOTIZEN_TERMINE_REACTIVATE'=>TEXT_NOTIZEN_TERMINE_REACTIVATE,
        'RECATIVATE_NOTIZEN_TERMINE_LINK'=>xtc_href_link(basename(__FILE__),'action=reactivate_notizen_termine'),
        'TEXT_SYSTEMMESSAGES_SHOW'=>TEXT_SYSTEMMESSAGES_SHOW,
    ));
}
if(isset($_SESSION['display_system_alerts'])){
    $smarty->assign(array(
        'display_system_alerts'=>true,
        'TEXT_SYSTEMMESSAGES'=>TEXT_SYSTEMMESSAGES,
        'TEXT_SYSTEMMESSAGES_REACTIVATE'=>TEXT_SYSTEMMESSAGES_REACTIVATE,
        'RECATIVATE_SYSTEMMESSAGES_LINK'=>xtc_href_link(basename(__FILE__),'action=reactivate_systemmessages'),
        'TEXT_SYSTEMMESSAGES_SHOW'=>TEXT_SYSTEMMESSAGES_SHOW,
    ));
}

$smarty->assign('SUPPORT_TICKET_ORDER_ACCESS',$admin_access['support_ticket_order']);
$smarty->assign('TEXT_SAVED_BRANCH',TEXT_SAVED_BRANCH);

$applicationServerKey = '';
define('YES_PUSH_VAPID_KEYS_FILE',$secure_path.'/yes_push_vapid_keys.vapid');
if(is_file(YES_PUSH_VAPID_KEYS_FILE)){
	$yes_push_auth = json_decode(file_get_contents(YES_PUSH_VAPID_KEYS_FILE));
	$applicationServerKey = $yes_push_auth->publicKey;
}

$ypua = array();
$query = xtc_db_query(sprintf(
	"SELECT allocation FROM push_customer_allocations WHERE customers_id='%s'",
	$_SESSION['customer_id']
));
while($record = xtc_db_fetch_array($query)){
	$ypua[$record['allocation']] = true;
}

$smarty->assign(array(
	'saved_branch'=>xtc_get_branch_title(@$_SESSION['allocated_branches_id']),
	'YES_PUSH_SERVERKEY_FOR_APP_JS'=>$applicationServerKey,
	'YES_PUSH_USER_ALLOCATIONS'=>$ypua,
));
// MESSAGESTACK START
if ($messageStack->size > 0) {

	$smarty->assign('MESSAGE_STACK',sprintf('<span id="yesmessagestack" class="smallText">%s</span>',
		$messageStack->output()
	));
}
// MESSAGESTACK END
// BOF - eBay Post Order Handling
$secure_path = main::get_secure_path();

if(defined('MODULE_PAYMENT_YES_AMAZON_PAY_STATUS') and MODULE_PAYMENT_YES_AMAZON_PAY_STATUS == 'True'){
	$smarty->assign('AMAZON_PAYMENT_ACTIVE',1);
}
/** BOF - KANN RAUS **/
if(is_file(main::get_secure_path().'deleted_ebay_users.txt')){
	$content = file_get_contents(main::get_secure_path().'deleted_ebay_users.txt');
	$lines_raw = explode("\n",$content);
	$lines = [];
	$liste = [];
	foreach($lines_raw as $line){
		if(!empty(trim($line))){
			$parts = explode("\t",trim($line));
			$lines[] = sprintf('<tr><td><a style="text-decoration: underline;" href="customers.php?action=edit&cID=%d">%d</a></td><td>%s</td><td>%s</td></tr>',
				$parts[0],
				$parts[0],
				$parts[2],
				$parts[1],
			);
		}
	}
	$liste = sprintf('<table class="yesListTable_minimal"><thead><tr><th>Kunden ID</th><th>Name</th><th>eBay User</th></tr></thead><tbody>%s</tbody></table>',
		implode("\n",$lines)
	);
	$html = <<<DELETED_USER_HTML
	<script>
	function confirm_endpoint_delete(){
		yes = confirm('Haben Sie alle Daten der aufgelisteten eBay User anonymisiert bzw gelöscht? Wenn Sie jetzt bestätigen wird die Auflistung der gemeldeten User unwiderbringlich gelöscht.');
		if(yes){
			window.location.href = 'start.php?action=endpoint_delete_file';
		}
	}
	function download_endpoint_delete(){
			window.location.href = 'start.php?action=endpoint_download_file';
	}
	</script>
	<div class="ui-widget" style="padding: px; display: block; width: 800px;">
		<div style="padding: 10px;" class="ui-widget-header ui-state-error">eBay: {ANZAHL} gelöschte User</div>
		<div style="padding: 10px;" class="ui-widget-content">
			<img style="margin: 10px;" src="images/icons/big_warning.gif" align="left" alt="Bitte handeln." />
			Durch einen Fehler in der API Anbindung wurden mehrere Monate lang die von eBay gemeldeten Userlöschungen nicht mit dem Datenbestand des YES Systems abgeglichen.
			Da Händler mit API Anbindung von <a title="Info" style="text-decoration: underline;" href="https://developer.ebay.com/marketplace-account-deletion" target="_blank">eBay vertraglich verpflichtet</a> sind, die Daten der bei eBay gelöschten User ebenfalls zu löschen oder zu anonymisieren, m&uuml;ssen Sie hierauf reagieren.
			<br /><br />
			Sie sehen hier eine Auflistung der User die bei eBay in den letzten Monaten gelöscht wurden. Wenn Sie die Daten abgearbeitet haben, können Sie <a style="text-decoration: underline;" href="javascript: confirm_endpoint_delete()">hier</a> klicken, dann verschwindet diese Meldung (inkl. der Datendatei).
			<br /><br />
			Sie können sich die Auflistung auch <a style="text-decoration: underline;" href="javascript: download_endpoint_delete()">als Datei herunterladen</a> um diese abzuarbeiten. (Trennzeichen: TABULATOR)
			<div style="margin-bottom: 10px;margin-top: 10px;font-size: 0.9em; font-family: system, system-ui, monospace,Courier New,Lucida Console,Monaco; color: #444;">
				{LISTE}
			</div>
			<p>Die Benachrichtigung für gelöschte User erhalten Sie ab jetzt wieder täglich als Notiz, sofern es Ihren Kundenstamm betrifft.</p>
		</div>
	</div>
DELETED_USER_HTML;
	$smarty->assign('DELETED_USER', str_replace(['{ANZAHL}','{LISTE}'],[sizeOf($lines),$liste],$html));
}
/** EOF - KANN RAUS **/

$epo_string = '';
if(is_file($secure_path.'cron_ebay_post_order.php/summary.xml')){
    // XML Datei wird von admin/cron_ebay_post_order.php erzeugt
    $display_epo = false;
    $file_xml = simplexml_load_file($secure_path.'cron_ebay_post_order.php/summary.xml');
    $xsl = new DOMDocument;
    $xsl->substituteEntities = true;
    $xsl->load('templates/ebay_post_order_notifications.xsl');

    $proc = new XSLTProcessor();
    $proc->importStyleSheet($xsl);
    $epo_string = $proc->transformToXML($file_xml);
    $smarty->assign(array(
	'EPO'=>$epo_string,
	'TEXT_EPO_MESSAGES'=>TEXT_EPO_MESSAGES,
	'TEXT_EPO_MESSAGES_INTRO'=>TEXT_EPO_MESSAGES_INTRO,
	'FILE_DATE'=>date('d.m.y H:i',filemtime($secure_path.'cron_ebay_post_order.php/summary.xml'))
    ));
}
// EOF - eBay Post Order Handling
$cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id'],['customers_email_address']);
$customer = new \customer($_SESSION['customer_id']);
$cinfo = $customer->get_customers_info();
$smarty->assign([
	'CI_LANG'=>$_SESSION['language'],
	'CI_NAME'=>$_SESSION['customer_first_name'].' '.$_SESSION['customer_last_name'],
	'CI_ID'=>$_SESSION['customer_id'],
	'CI_IP'=>$_SESSION['user_info']['user_ip'],
	'CI_HOST'=>$_SESSION['user_info']['user_host'],
	'CI_EMAIL'=>$cust->customers_email_address,
	'CI_LAST_LOGON'=>$customer->get_last_login_date()->format('d.m.y H:i:s'),
	'CI_BROWSER'=>$_SERVER['HTTP_USER_AGENT'],
	'MANUAL_CACHE_DELETE'=>$manual_delete_cache_link,
	'MANUAL_DELETE_CACHE_INTRO'=>MANUAL_DELETE_CACHE_INTRO
]);
$html = $smarty->fetch('start.html');
echo '<div class="start_body">'.$html.'</div>';
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
