<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require('includes/classes/reclamation.php');
require('includes/classes/class.csv.php');
$startDate = $_REQUEST['start_date']??(new DateTime('-4 Weeks'))->format('Y-m-d');
$endDate = $_REQUEST['end_date'] ?? date('Y-m-d');
$endDate_sql = $endDate.' 23:59:59'; // BUGFIX UM DEN GANZEN TAG ZU KRIEGEN
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$rstatus = $_REQUEST['rstatus'] ?? 3;

$order_by = $_REQUEST['order_by']??'';
if(!empty($order_by)){
    $order_by_parts = explode(' ',$order_by);
    $field = $order_by_parts[0];
    $direction = $order_by_parts[1];
    $sort = ($direction == 'ASC') ? 'DESC' : 'ASC';
    $th_type = sprintf(
        '<a href="javascript:;" id="reclamations_type%%20%s" class="sort">%s</a>',
        $sort,TABLE_HEADING_TYPE
    );
    $order_by = sprintf(" ORDER BY %s",$order_by);
}else{
    $th_type = sprintf(
        '<a href="javascript:;" id="reclamations_type%%20ASC" class="sort">%s</a>',
        TABLE_HEADING_TYPE
    );
}

$reason = '';
$pID = $_REQUEST['products_id'] ?? null;
if($pID !== null and intval($pID) > 0 ){
    $pID = (int)xtc_db_input($pID);
    $recla_query_raw = sprintf(
        "select r.reclamations_id from reclamations r LEFT JOIN reclamations_products rp USING(reclamations_id) where reclamations_status='%d' and UNIX_TIMESTAMP(date_created)>'%s' and UNIX_TIMESTAMP(date_created)<'%s' and products_id='%d' %s",
        $rstatus,strtotime($startDate),strtotime($endDate_sql),$pID,$order_by
    );
}else{
    $reason_sql_from = '';
    $reason_sql_where = '';
    $reclamations_reasons_id = $_REQUEST['reclamations_reasons_id']??null;
    if($reclamations_reasons_id !== null and intval($reclamations_reasons_id) > 0){
        $reason = intval($reclamations_reasons_id);
        $reason_sql_from = ' LEFT JOIN reclamations_to_reclamations_reasons rtrr USING (reclamations_id) ';
        $reason_sql_where = sprintf(" AND rtrr.reclamations_reasons_id='%d'",$reason);
    }
    $recla_query_raw = sprintf(
        "select r.reclamations_id from reclamations r $reason_sql_from WHERE reclamations_status=%s and UNIX_TIMESTAMP(date_created)>'%s' and UNIX_TIMESTAMP(date_created)<'%s' %s %s",
        $rstatus,strtotime($startDate),strtotime($endDate_sql),
        $reason_sql_where,
        $order_by
    );
}
$items = \YES4Trade\Model\reclamations_reasons::get_all('reason');
$reasons_array = array(
    array('id'=>'','text'=>TEXT_SELECT)
);
foreach($items as $it){
    $reasons_array[] = array(
        'id'=>$it->reclamations_reasons_id,
        'text'=>$it->reason
    );
}

// ANZAHL DER reclamation_type ERMITTELN
$total_types_query = yes_db_query(sprintf(
	"select reclamations_type,COUNT(reclamations_id) as anz from reclamations where reclamations_status='%d' and UNIX_TIMESTAMP(date_created)>'%s' and UNIX_TIMESTAMP(date_created)<'%s' GROUP BY reclamations_type",
	$rstatus,$startDate,$endDate_sql
));
$_types_array = array();
$types_array = array();
if(yes_db_num_rows($total_types_query)){
    foreach($total_types_query as $record){
        $_types_array[ $record['reclamations_type'] ] = $record['anz'];
    }
    foreach($_types_array as $type=>$anz){
        $types_array[ xtc_get_reclamations_types_name( $type ) ] = $anz;
    }
}
$page = intval($_GET['page'] ?? 0);
$split_limit = (!isset($_REQUEST['csv'])) ? MAX_DISPLAY_SEARCH_RESULTS_ADMIN : 1000000;
$split_start = (!isset($_REQUEST['csv'])) ? intval($page) : 0;
$recla_split = new splitPageResults($page,$split_limit , $recla_query_raw, $recla_query_numrows);
$reclas_query = xtc_db_query($recla_query_raw);
$final_costs = 0;
$final_rueck = 0;
$final_retou = 0;
$data_array = array();
$_recla_tmp = [];
while($recla = xtc_db_fetch_array($reclas_query)){
    $_recla_tmp[] = $recla;
}
foreach($_recla_tmp as $recla){
    $r = new reclamation($recla['reclamations_id']);
    $products = (!isset($_REQUEST['csv'])) ? '' : [];
    if(is_array($r->products)){
        foreach($r->products as $k=>$product){
            if(!isset($_REQUEST['csv'])){
                $products .= sprintf(
                    '<a href="products.php?action=ajax_view&pID=%d" rel="products.php?action=ajax_view&pID=%d" title="Info pID %d" class="yes_dynamic_tooltip">%d x %s [pID: %d]</a><br />',
                    $product['id'],$product['id'],$product['id'],$product['qty'],$product['name'],$product['id']
                );
            }else{
                $products[] = sprintf(
                    '%d x %s [pID: %d]',
                    $product['qty'],$product['name'],$product['id']
                );
            }
        }
    }
    if(!isset($_REQUEST['csv']) and $products == ''){
        $products = '&nbsp;';
    }

    if(!isset($_REQUEST['csv'])){
        $rueck_str = '';
    }else{
        $rueck_str = array();
    }
    if(is_array($r->rueckerstattungen) and sizeOf($r->rueckerstattungen)>0){
        foreach($r->rueckerstattungen as $k=>$rueck){
            if(!isset($_REQUEST['csv'])){
                $rueck_str .= sprintf(
                    '<a href="%s">%s</a> [%s] %s<br />',
                    xtc_href_link('rueckerstattungen.php','rID='.$rueck['id'].'&action=edit'),$rueck['id'],
                    xtc_get_rueckerstattungen_status_name($rueck['status']),
                    number_format($rueck['betrag'],2,',','')
                );
            }else{
                $rueck_str[] = sprintf(
                    '%d [%s] %s',
                    $rueck['id'],
                    xtc_get_rueckerstattungen_status_name($rueck['status']),
                    number_format($rueck['betrag'],2,',','')
                );
            }
            $final_rueck += $rueck['betrag'];
        }
    }
    if(empty($rueck_str) and !isset($_REQUEST['csv'])){
        $rueck_str = '&nbsp;';
    }

    $costs = (!isset($_REQUEST['csv'])) ? '' : [];
    if(is_array($r->costs)){
        foreach($r->costs as $k=>$cost){
            if(!isset($_REQUEST['csv'])){
                $costs .= number_format($cost['value'],2,',','').'<br />';
            }else{
                $costs[] = number_format($cost['value'],2,',','');
            }
            $final_costs += $cost['value'];
        }
    }
    if(empty($costs) and !isset($_REQUEST['csv'])){
        $costs = '&nbsp;';
    }

    $retoure_str = (!isset($_REQUEST['csv'])) ? '' : [];

    if(!isset($_REQUEST['csv'])){
        $orders_id = sprintf(
            '<a href="%s"><u>%d</u></a>',
            xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$r->info['orders_id']),
            $r->info['orders_id']
        );
        $reclamations_id = sprintf(
            '<a href="%s"><u>%d</u></a>',
            xtc_href_link('reclamations.php','action=edit&rID='.$recla['reclamations_id']),
            $recla['reclamations_id']
        );
    }else{
        $orders_id = $r->info['orders_id'];
        $reclamations_id = $recla['reclamations_id'];
    }
    $retoure_query = xtc_db_query(sprintf(
        "SELECT retoure_id,costs,retoure_status FROM retouren WHERE reclamations_id='%d' and retoure_status != '4'",
        $recla['reclamations_id']
    ));
    if(xtc_db_num_rows($retoure_query)){
        if(!isset($_REQUEST['csv'])){
            $retoure_str .= '<table border="0" cellspacing="0" cellpadding="1">';
            while( $retoure = xtc_db_fetch_array($retoure_query) ){
                $retoure_str .= sprintf(
                    '<tr><td>[Nr: <a href="%s">%d</a>]</td><td>%s</td><td align="right">%s</td></tr>',
                    xtc_href_link('retoure.php','rID='.$retoure['retoure_id'].'&action=edit'),	
                    $retoure['retoure_id'],	
                    xtc_get_retoure_status_name($retoure['retoure_status']),
                    number_format($retoure['costs'],2,',','')
                );
                $final_retou += $retoure['costs'];
            }
            $retoure_str .= '</table>';
        }else{
            while( $retoure = xtc_db_fetch_array($retoure_query) ){
                $retoure_str[] = sprintf(
                    'Nr: %d / Status: %s / Kosten: %s',
                    $retoure['retoure_id'],	
                    xtc_get_retoure_status_name($retoure['retoure_status']),
                    number_format($retoure['costs'],2,',','')
                );
                $final_retou += $retoure['costs'];
            }
        }
    }
    if(empty($retoure_str) and !isset($_REQUEST['csv'])){
        $retoure_str = '&nbsp;';
    }
    $data = array(
        'id'=>$reclamations_id,
        'orders_id'=>$orders_id,
        'type'=>xtc_get_reclamations_types_name($r->info['reclamations_type']),
        'products'=>$products,
        'rueckerstattungen'=>$rueck_str,
        'retoure'=>$retoure_str,
        'reason'=>$r->reasons,
        'costs'=>$costs
    );
    $data_array[] = $data;
}

if(isset($_REQUEST['csv']) and $_REQUEST['csv'] == 1){
    if(!sizeOf($data_array)){
        $messageStack->add_session('Keine Daten zum exportieren','error');
        xtc_redirect(xtc_href_link('stats_reclamations.php',xtc_get_all_get_params(array('csv')) ));
    }
    $filename = \main::get_exportdata_path().'stats_reclamations_'.date('Y-m-d_H_i_s').'.csv';
    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
    fclose($fh);
    $CSV = new CSVfile($filename);
    $CSV->delimiter = "\t";
    $CSV->open('w');
    $CSV->addRow(array(
        TABLE_HEADING_RID,
        TABLE_HEADING_OID,
        TABLE_HEADING_TYPE,
        TABLE_HEADING_REASON,
        TABLE_HEADING_PRODUCTS,
        TABLE_HEADING_COSTS,
        TABLE_HEADING_REIMBURSEMENTS_CSV,
        TABLE_HEADING_RETOURE
    ));
    foreach($data_array as $data){
        $CSV->addRow(array(
            $data['id'],
            $data['orders_id'],
            $data['type'],
            implode(';',$data['reason']),
            implode(';',$data['products']),
            implode(';',$data['costs']),
            implode(';',$data['rueckerstattungen']),
            implode(';',$data['retoure'])
        ));
    }
    $CSV->close();
    $content = file_get_contents($filename);
    unlink($filename);
    header("Content-type: application/octet-stream;charset=".CHARSET);
    header("Content-Disposition: attachment; filename=\"reclamations_".date('Y-m-d_H-i-s').".csv\"");
    echo $content;
    exit;
}
$smarty->assign(array(
    'start_date'=>$startDate,
    'end_date'=>$endDate,
    'products_id'=>($pID !== null)?$pID:'',
    'PAGE_HEADING'=>PAGE_HEADING,
    'FORM_ACTION'=>xtc_href_link('stats_reclamations.php',xtc_get_all_get_params(array('order_by'))),
    'FORM_LEGEND'=>FORM_LEGEND,
    'FORM_LABEL_START_DATE'=>FORM_LABEL_START_DATE,
    'FORM_LABEL_END_DATE'=>FORM_LABEL_END_DATE,
    'FORM_LABEL_STATUS'=>FORM_LABEL_STATUS,
    'FORM_LABEL_PRODUCTS_ID'=>FORM_LABEL_PRODUCTS_ID,
    'FORM_BUTTON_SUBMIT'=>FORM_BUTTON_SUBMIT,
    'INPUT_STATUS'=>xtc_draw_pull_down_menu('rstatus',xtc_get_reclamations_status(),$rstatus),
    'INPUT_REASON'=>xtc_draw_pull_down_menu('reclamations_reasons_id',$reasons_array,$reason),
    'TABLE_HEADING_RID'=>TABLE_HEADING_RID,
    'TABLE_HEADING_OID'=>TABLE_HEADING_OID,
    'TABLE_HEADING_TYPE'=>$th_type,
    'TABLE_HEADING_REASON'=>TABLE_HEADING_REASON,
    'TABLE_HEADING_PRODUCTS'=>TABLE_HEADING_PRODUCTS,
    'TABLE_HEADING_COSTS'=>TABLE_HEADING_COSTS,
    'TABLE_HEADING_REIMBURSEMENTS'=>TABLE_HEADING_REIMBURSEMENTS,
    'TABLE_HEADING_RETOURE'=>TABLE_HEADING_RETOURE,
    'TEXT_TOTAL'=>TEXT_TOTAL,
    'TEXT_TYPES'=>TEXT_TYPES,
    'DATA'=>$data_array,
    'FINAL_COSTS'=>number_format($final_costs,2,',',''),
    'FINAL_RUECK'=>number_format($final_rueck,2,',',''),
    'FINAL_RETOURE'=>number_format($final_retou,2,',',''),
    'TYPES'=>$types_array,
    'SPLIT_COUNT'=>$recla_split->display_count($recla_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, $page, TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page','action'))),
    'SPLIT_LINKS'=>$recla_split->display_links($recla_query_numrows, MAX_DISPLAY_SEARCH_RESULTS_ADMIN, MAX_DISPLAY_PAGE_LINKS, $page, xtc_get_all_get_params(array('page', 'action'))),
    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER
));
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('stats_reclamations.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
