<?php
// check if customer is allowed to send this order!
if(!function_exists('xtc_get_short_description'))
    require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
if(!function_exists('xtc_address_format'))
    require_once(DIR_FS_INC.'xtc_address_format.inc.php');
if(!function_exists('yes_get_shop_content'))
    require_once(DIR_FS_INC.'yes_get_shop_content.inc.php');
if(!function_exists('xtc_php_mail'))
    require_once(DIR_FS_INC.'xtc_php_mail.inc.php');
if(!isset($insert_id)){
    die('Missing Params');
}
$order_query_check = xtc_db_query("SELECT
					customers_id,customers_email_address,customers_name
					FROM ".TABLE_ORDERS."
					WHERE orders_id='".intval($insert_id)."'");

if(xtc_db_num_rows($order_query_check)){
    $order_check = xtc_db_fetch_array($order_query_check);
	$order = new order($insert_id);
	$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);

	  // send mail to customer
	$send_to_email = $order_check['customers_email_address'];

	$lang_query = xtc_db_query(sprintf(
		"SELECT directory FROM languages WHERE code='%s'",
		DEFAULT_LANGUAGE
	));
	$lang = xtc_db_fetch_array($lang_query);
	$lang_path = $lang['directory'];

	// assign language to template for caching
	$smarty->assign('language', $lang_path);
	$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
	$smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
	$smarty->assign('oID',$insert_id);

	// dont allow cache
	$smarty->caching = false;

	$smarty->assign('AMAZON_ORDERS_ID',$amazon_orders_id);

	$smarty->assign('SHOP_URL',HTTP_SERVER.DIR_WS_CATALOG.'login.php');
	$smarty->assign('NAME',$order_check['customers_name']);
        
        $amz_query = xtc_db_query(sprintf(
                "SELECT buyer_telephone_number FROM amazon_orders WHERE orders_id='%s' AND buyer_telephone_number != ''",
                $insert_id
        ));
        if(xtc_db_num_rows($amz_query)){
            $amz_record = xtc_db_fetch_array($amz_query);
            $smarty->assign('AMAZON_TELEPHONE_NUMBER',$amz_record['buyer_telephone_number']);
        }
        
	// NEUE VARIABLEN
	$smarty->assign('BANK_WRAP',BANK_WRAP);
	$smarty->assign('STORE_NAME_ADDRESS',STORE_NAME);

	$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
	$smarty->assign('address_label_shipping',xtc_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br>'));
	$order_query=xtc_db_query("SELECT
					products_id,
					orders_products_id,
					products_model,
					products_name,
					products_price,
					final_price,
					products_quantity
					FROM ".TABLE_ORDERS_PRODUCTS."
					WHERE orders_id='".$insert_id."'"
	);
	$order_data=array();
    while ($order_data_values = xtc_db_fetch_array($order_query)) {
	$order_data[]=array(
			'PRODUCTS_MODEL' => $order_data_values['products_model'],
			'PRODUCTS_NAME' => $order_data_values['products_name'],
			'PRODUCTS_WEIGHT'=>  xtc_get_ext_products_weight($order_data_values['products_id'])*$order_data_values['products_quantity'],
			'PRODUCTS_PRICE' => $xtPrice->xtcFormat($order_data_values['final_price'],true),
			'PRODUCTS_SINGLE_PRICE' => $xtPrice->xtcFormat($order_data_values['products_price'],true),
			'PRODUCTS_QTY' => $order_data_values['products_quantity'],
			'PRODUCTS_SHORT_DESCRIPTION'=>  xtc_get_short_description($order_data_values['products_id'], $languages_id)
		);
	}
	// get order_total data
	$oder_total_query=xtc_db_query("SELECT
		title,
		text,
		sort_order
		FROM ".TABLE_ORDERS_TOTAL."
		WHERE orders_id='".$insert_id."'
		ORDER BY sort_order ASC"
	);
	$order_total=array();
	while ($oder_total_values = xtc_db_fetch_array($oder_total_query)) {
		$order_total[] = array(
			'TITLE' => $oder_total_values['title'],
			'TEXT' => $oder_total_values['text']
		);
	}

	$smarty->assign('order_data', $order_data);
	$smarty->assign('order_total', $order_total);
	$smarty->assign('NAME',$order->customer['name']);

	$conditions = '';
	$conditions_txt = '';
	$shop_content_data = yes_get_shop_content(3, $languages_id,false);
	if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
		$conditions = $shop_content_data['content_text'];
		$conditions_txt = yes_get_shop_content_html_stripped($conditions);
	}

	// WIDERRUF
	$widerruf = '';
	$widerruf_txt = '';
	$shop_content_data = yes_get_shop_content(9, $languages_id,false);
	if (isset($shop_content_data['content_text']) and $shop_content_data['content_text']!=''){
		$widerruf = $shop_content_data['content_text'];
		$widerruf_txt = yes_get_shop_content_html_stripped($widerruf);
	}
	$smarty->assign(array(
		'conditions'=>$conditions,
		'widerruf'=>$widerruf,
		'conditions_txt'=>$conditions_txt,
		'widerruf_txt'=>$widerruf_txt
	));


	$html_mail=$smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/mail/'.$lang_path.'/order_amazon_mail.html');
	$txt_mail=$smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/mail/'.$lang_path.'/order_amazon_mail.txt');




    if(defined('MODULE_OTHER_AMAZON_EMAIL_SUBJECT') and MODULE_OTHER_AMAZON_EMAIL_SUBJECT != ''){
        $order_subject=str_replace('{$orders_id}',$insert_id,MODULE_OTHER_AMAZON_EMAIL_SUBJECT);
        $order_subject=str_replace('{$amazon_order_id}',$amazon_orders_id,$order_subject);
    }else{
        // create subject
        $order_subject=str_replace('{$nr}',$insert_id,EMAIL_BILLING_SUBJECT_ORDER);
        $order_subject=str_replace('{$date}',yes_strftime(DATE_FORMAT_LONG),$order_subject);
        $order_subject=str_replace('{$lastname}',$order->customer['name'],$order_subject);
        $order_subject=str_replace('{$firstname}',$order->customer['name'],$order_subject);
    }



  $path_to_attachement = '';
  if(is_file(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/mail/'.$lang['directory'].'/widerruf.pdf')){
      $path_to_attachement = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/mail/'.$lang['directory'].'/widerruf.pdf';
  }
  xtc_php_mail(EMAIL_BILLING_ADDRESS,
	       STORE_NAME,
	       $send_to_email ,
	       $order->customer['name'],
	       '',
	       EMAIL_BILLING_ADDRESS,
	       STORE_NAME,
	       $path_to_attachement,
	       '',
	       $order_subject,
	       $html_mail ,
	       $txt_mail 
	);
	\YES4Trade\Model\ebay_emails::create_ebay_emails([
		'subject'=>$order_subject,
		'mailto'=>$order->customer['email_address'],
		'from_name'=>STORE_NAME,
		'from_email'=>EMAIL_BILLING_ADDRESS,
		'date'=>date('Y-m-d H:i:s'),
		'customers_id'=>intval($order->customer['ID']),
		'orders_id'=>intval($insert_id),
		'allocation_status'=>'1',
		'saved'=>1,
		'ownmail'=>'1',
		'format'=>'text/html'
	],$html_mail);
}
