<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_customers_statuses.inc.php,v 1.1 2006/05/03 07:11:49 web2 Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_get_customers_statuses.inc.php,v 1.4 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// Return all customers statuses for a specified language_id and return an array(array())
// Use it to make pull_down_menu, checkbox....
function xtc_get_customers_statuses() {
    global $InstanceCache;
    $lang_id = (!isset($_SESSION['languages_id']) or empty($_SESSION['languages_id']) or (int)$_SESSION['languages_id'] < 1) ? 2 : $_SESSION['languages_id'];
    $key = 'customers_statuses_'.$lang_id;
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $customers_statuses_array = array(array());
        $customers_statuses_list = \YES4Trade\Model\customers_status::get_by_language_id(intval($lang_id));
        foreach($customers_statuses_list as $customers_status) {
            $customers_statuses = $customers_status->toArray();
            $i=$customers_statuses['customers_status_id'];
            $customers_statuses_array[] = array(
                'id' => $customers_statuses['customers_status_id'],
                'text' => $customers_statuses['customers_status_name'],
                'csa_public' => $customers_statuses['customers_status_public'],
                'csa_show_price' => $customers_statuses['customers_status_show_price'],
                'csa_show_price_tax' => $customers_statuses['customers_status_show_price_tax'],
                'csa_image' => (string)$customers_status->customers_status_image,
                'csa_discount' => $customers_statuses['customers_status_discount'],
                'csa_ot_discount_flag' => $customers_statuses['customers_status_ot_discount_flag'],
                'csa_ot_discount' => $customers_statuses['customers_status_ot_discount'],
                'csa_graduated_prices' => $customers_statuses['customers_status_graduated_prices'],
                'csa_cod_permission' => (isset($customers_statuses['customers_status_cod_permission']))?$customers_statuses['customers_status_cod_permission']:false,
                // die fehlte (2024/02)
                'csa_add_tax_ot' => $customers_statuses['customers_status_add_tax_ot'],
                
                'csa_payment_unallowed'=>$customers_statuses['customers_status_payment_unallowed'],
                'csa_payment_unallowed'=>$customers_statuses['customers_status_payment_unallowed'],
                'csa_shipping_unallowed'=>$customers_statuses['customers_status_shipping_unallowed'],
                'csa_discount_attributes'=>$customers_statuses['customers_status_discount_attributes'],
                'customers_fsk18'=>$customers_statuses['customers_fsk18'],
                'customers_fsk18_display'=>$customers_statuses['customers_fsk18_display'],
                'customers_status_description'=>$customers_statuses['customers_status_description'],
            );
        }
        $CachedString->set($customers_statuses_array)->expiresAfter(0)->addTag('shop');//customers_statuses_
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
    }else{
        $customers_statuses_array = $CachedString->get();
    }
    return $customers_statuses_array;
}
