<?php
function yes_check_amazon_products_status($products_id){
    $query = yes_query(
        "SELECT amazon_products_id FROM amazon_products WHERE products_id=:products_id",
        ['products_id'=>(int)$products_id]
    );
    return sizeOf($query);
}


/**
 * Gibt true zurueck wenn ein Eintrag in 'amazon_feeds_product_listing' vorhanden ist
 * Das heisst, der Datensatz befindet sich im Upload Vorgang zu Amazon, wurde
 * aber noch nicht ausgewertet.
 * 
 * @param type $products_id
 * @return boolean
 */
function yes_check_products_amazon_export($products_id){
    $query = yes_query(
        "SELECT afp.amazon_feeds_product_listing_id FROM amazon_feeds af LEFT JOIN amazon_feeds_product_listing afp USING(amazon_feeds_id) WHERE af.feed_type='_POST_FLAT_FILE_LISTINGS_DATA_' AND af.processed=0 AND afp.products_id=:products_id",
        ['products_id'=>(int)$products_id]
    );
    return sizeOf($query);
}