<?php
/**
 * Ermittelt alle verfuegbaren Bilder zu einem Artikel
 * Return Array enthaelt jeweils nr und image name
 * die nr 0 ist der Eintrag aus products
 * 
 * @param INT $products_id
 * @return array
 */
function yes_get_products_images($products_id){
    $images = array();
    $parameters = ['products_id'=>(int)$products_id];
    $query = yes_query(
        "SELECT products_image FROM products WHERE products_id=:products_id",
        $parameters
    );
    if(!sizeOf($query)){
	return $images;
    }
    $record = current($query);
    if(xtc_not_null($record['products_image'])){
	$images[] = array(
	    'id'=>$record['products_image'],
	    'text'=>$record['products_image']
	);
    }
    $query = yes_query(
        "SELECT image_nr,image_name FROM products_images WHERE products_id=:products_id",
        $parameters
    );
    foreach($query as $record){
	$images[] = array(
	    'id'=>$record['image_name'],
	    'text'=>$record['image_name']
	);
    }
    return $images;
}