<?php
function yes_set_products_distributors_stock( int $distributor_id, int $products_id, int $stock ){
    $parameters = [
        'products_id'=>$products_id,
        'dist_id'=>$distributor_id
    ];
    $query = yes_query(
        "SELECT products_id FROM products_distributors WHERE distributor_id=:dist_id AND products_id=:products_id",
        $parameters
    );
    if(!sizeOf($query)){
        // es existiert keine Zuweisung Artikel/Lieferant
        return false;
    }
    $query = yes_query(
        "SELECT products_distributors_stock_id FROM products_distributors_stock WHERE distributor_id=:dist_id AND products_id=:products_id",
        $parameters
    );
    if(!sizeOf($query)){
        // es existiert noch kein Eintrag in products_distributors_stock
        $insert_sql_array = array(
            'products_id'=>$products_id,
            'distributor_id'=>$distributor_id,
        );
        yes_db_perform('products_distributors_stock', $insert_sql_array);
        $pdsID = xtc_db_insert_id();
    }else{
        $record = current($query);
        $pdsID = $record['products_distributors_stock_id'];
    }
    $update_sql_array = array(
        'quantity'=>$stock,
        'last_quantity_update'=>'now()'
    );
    yes_db_perform('products_distributors_stock',$update_sql_array, 'update',[
        "products_distributors_stock_id"=>$pdsID
    ]);
}