<?php
/**
 * needed classes and functions
 * - initiated ebayApi as $EBAYAPI
 * - xtc_get_tax_rate(
 * - xtc_get_product_collies(
 * - xtc_get_product_collies_tax_value(
 * - xtc_get_tax_class_id(
 * - xtc_get_tax_rate(
 * - includes/ebay_transaction_functions
 * - xtc_get_products_name(
 * - xtc_encrypt_password(
 * - xtc_get_lang_path_from_ebay_site(
 * - xtc_get_serial_number(
 * - yes_update_products_in_auction_quantity(
 * - class products_quantity
 * - class order
 * - class yesSmarty
 * - yes_write_notice(
 * - xtc_quicklogin_uuid(
 * - xtc_quicklogin_save(
 * - xtc_address_format(
 * - xtc_get_attributes_model(
 * - xtc_get_ext_products_weight(
 * - xtc_get_short_description(
 * - yes_get_shop_content(
 * - yes_get_shop_content_html_stripped(
 * - xtc_php_mail(
 * - yes_customers_email_alias_functions
 * 
 * Description of ebay_transaction
 *
 * @author mario
 */
$er = error_reporting();
require_once(DIR_FS_INC.'yes_get_country_id_from_iso2.inc.php');

class ebay_transaction {
	var $source = 'SOAP';
	var $debug = false;
	var $ebay_id;
	var $transaction_id;
	var $seller;
	var $language_id;
	var $send_mail = false;
	var $orders_id;
	var $customer_id;
	var $password;
	var $is_registered = false;
	var $addresses;
	var $ebay_no_shippingaddress = 0;
	var $ebay_different_address = 0;
	var $ebay_no_registrationaddress = false;
	var $ebay_user;
	var $email;
	var $combined_order = array();
	var $transaction_data;
	var $item_title;
	var $item_quantity_sold;
	var $item_quantity;
	var $item_current_price;
	var $listing_type;
	var $transaction_data_copy; // for ebay_send_email
	var $auction_data_copy; // for ebay_send_email
        var $ebay_plus;
	
	//put your code here
	function __construct($seller,$ebay_id,$transaction_id,$item_title,$item_quantity_sold,$item_quantity,$item_current_price,$listing_type,$ebay_plus=false,$site=''){

//		yes_mail_debug(sprintf("seller %s, ebay_id %s, transaction_id %s<br />item_title %s<br />item_quantity_sold: %d, item_quantity %d, item_current_price: %s, listing_type %s, ebay_plus: %s",
//			$seller,$ebay_id,$transaction_id,$item_title,$item_quantity_sold,$item_quantity,$item_current_price,$listing_type,$ebay_plus
//		));

		$this->seller = $seller;
		$this->ebay_id = $ebay_id;
		$this->transaction_id = $transaction_id;
		$this->item_title = $item_title;
		$this->item_quantity_sold = $item_quantity_sold;
		$this->item_quantity = $item_quantity;
		$this->item_current_price = $item_current_price;
		$this->listing_type = $listing_type;
                $this->ebay_plus = $ebay_plus;
                $this->site = $site;
	}
	
	function process( $language_id ){
		global $EBAYAPI;
		$this->language_id = $language_id;
		
		$transaction = $this->transaction_data;
		$transaction['ebay_id'] = $this->ebay_id ;
		$transaction['transaction_id'] = $this->transaction_id;
		$transaction['ebay_user'] = $this->ebay_user;
		$transaction['email'] = $this->email;
		// BOF - WENN KEIN CHINESE DANN PRUEFEN OB TRANSAKTIONSNUMMER 
		//       VORHANDEN IST - Ticket 2289
		if($this->listing_type != 'Chinese' and (empty($this->transaction_id) or $this->transaction_id == '')){
		    $this->debug( 'Keine Transaktionsnummer enthalten' );
		    $rec_array = $this->get_recipients_array('orders_edit');
		    $text = sprintf('Zum eBay Angebot #%s konnte keine Transaktionsnummer ermittelt werden. Um das Anlegen doppelter Auftr&auml;ge zu vermeiden, konnte die Meldung nicht verarbeitet werden. Bitte pr&uuml;fen Sie den Vorgang manuell. eBay User: "%s", Email: "%s"',
				    $this->ebay_id, $this->ebay_user,$this->email
		    );
		    yes_write_notice($this->source.': Fehlende Transaktionsnummer #'.$this->ebay_id,$text,0,$rec_array);
		    ob_start();
		    print_r($transaction);
		    $debugmail_text = ob_get_contents();
		    ob_end_clean();
		    mail('m.aspeleiter@yes-websolutions.de, agri@yes-websolutions.de',$this->source.': Fehlende Transaktionsnummer #'.$this->ebay_id,$text.' Das Transactionresult sieht so aus:'."\r\n\r\n".$debugmail_text);
		    return false;
		}
                
		// EOF - WENN KEIN CHINESE DANN PRUEFEN OB TRANSAKTIONSNUMMER 
		//       VORHANDEN IST - Ticket 2289
		
		if($this->is_transaction_saved()){
			$transaction_order_data = $this->getTransactionOrderData();
			if(strtoupper($this->source) == 'CRON' && $transaction_order_data['ebay_plus'] != $this->ebay_plus){
                            $update_sql_array = array(
                                'ebay_plus'=>$this->ebay_plus
                            );
                            xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$transaction_order_data['orders_id']."'");
                            $order_history_sql_array = array(
                                    'orders_id' => $transaction_order_data['orders_id'],
                                    'orders_status_id' => $transaction_order_data['orders_status'],
                                    'date_added' => 'now()',
                                    'customer_notified' => false,
                                    'comments' => $this->source.": eBay Plus (".$this->ebay_plus.")"
                            );
                            yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
                            
                        }
			if($transaction_order_data['checkoutstatus'] == 'CheckoutComplete'){
				$this->debug( 'Transaktion hat bereits Status CheckoutComplete' );
				return false;
			}
			$this->debug( 'Transaktion existiert aber hat noch nicht den Status CheckoutComplete' );
			if($transaction['checkoutstatus'] == 'CheckoutComplete' and $transaction['eBayPaymentStatus'] == 'NoPaymentFailure' and ($transaction_order_data['orders_status'] == ORDERS_STATUS_UPSELLING or $transaction_order_data['orders_status'] == ORDERS_STATUS_BEZAHLT )){
				$this->debug( 'Transaktion existiert und eBay meldet CheckoutComplete' );
				// TRANSAKTION NOCH NICHT ABGESCHLOSSEN - EVTL KOMBINIEREN/BUYERCHECKOUTMESSAGE
				if( $transaction_order_data['checkoutmessage_saved'] == 0 and isset($transaction['BuyerCheckoutMessage']) and $transaction['BuyerCheckoutMessage'] != '' and $transaction['BuyerCheckoutMessage'] != 'null'){
					$this->saveBuyerCheckoutMessage($transaction['BuyerCheckoutMessage'],
							$transaction_order_data['email'],
							$transaction_order_data['orders_id'] 
					);
					xtc_db_query(sprintf(
						"UPDATE ebay_transactions SET checkoutmessage_saved=1 WHERE ebayid='%s' AND transactionid='%s'",
						$this->ebay_id,$this->transaction_id
					));
				}	
				if( $transaction_order_data['checkoutmessage_saved'] == 0 and isset($transaction['BuyerMessage']) and $transaction['BuyerMessage'] != '' and $transaction['BuyerMessage'] != 'null'){
					$this->saveBuyerCheckoutMessage($transaction['BuyerMessage'],
							$transaction_order_data['email'],
							$transaction_order_data['orders_id'] 
					);
					xtc_db_query(sprintf(
						"UPDATE ebay_transactions SET checkoutmessage_saved=1 WHERE ebayid='%s' AND transactionid='%s'",
						$this->ebay_id,$this->transaction_id
					));
				}	
				$this->process_containing_order();
				$this->update_address_data($transaction_order_data['orders_id']);
				$order = new order($transaction_order_data['orders_id']);
			    	$order->save_real_shipping_cost();

				xtc_db_query(sprintf(
					"UPDATE ebay_transactions SET checkoutstatus='%s' WHERE ebayid='%s' AND transactionid='%s'",
					$transaction['checkoutstatus'],$this->ebay_id,$this->transaction_id
				));
			}
			return false;
		}
		
		if(!$this->is_valid_seller_transaction()){
			$this->debug( 'Transaktion ist nicht vom Seller '.$this->seller );
			return false;
		}
		/// TESTMODUS - ebay_orders
		$this->process_containing_order();
		/// TESTMODUS - ebay_orders --- ENDE
		$this->debug( 'Neue Transaktion anlegen' );
		
		$auction_data = $this->get_auction_data();
		if($auction_data === False){
			$auction_data = array();
		}
		
		$use_dummy_pid = false;
		if((!isset($this->transaction_data['variation_sku']) and !isset($this->transaction_data['sku']) )and $auction_data['products_id'] < 1 and defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0 and (!defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') or EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU != 'true')){
			$use_dummy_pid = true;
			$transaction_pID = EBAY_DEFAULT_DUMMY_PRODUCTS_ID;
		}else{
		    if($auction_data['products_id'] < 1 and defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') and EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU == 'true'){
			if(isset($this->transaction_data['variation_sku'])){
			    $transaction_pID = $this->transaction_data['variation_sku'];
			}else{
			    $transaction_pID = $this->transaction_data['sku'];
			}

			$check_pid_query = xtc_db_query(sprintf(
				"SELECT products_id FROM products WHERE products_id='%s'",
				intval($transaction_pID)
			));
			if(!xtc_db_num_rows($check_pid_query)){
				$use_dummy_pid = true;
				$transaction_pID = EBAY_DEFAULT_DUMMY_PRODUCTS_ID;
			}
			
		    }else{
			$transaction_pID = $auction_data['products_id'];
		    }
		}
		 if($transaction_pID < 1){
		    $this->debug( 'Transaktion hat keine SKU' );
		    return false;
		}

		if($auction_data['vat'] == 1){
                    // EU-OSS 2021/07
                    $tax = xtc_get_tax_rate($auction_data['products_tax_class_id'],$auction_data['country_id']);
                    $collies = xtc_get_product_collies($transaction_pID);
                    // calculate brutto price for display
                    // EU-OSS 2021/07
                    if(COLLI_ACTIVE){
                        if(sizeOf($collies)>0){
                            $tax = xtc_get_product_collies_tax_value($collies, $auction_data['country_id']);
                        }
                    }
		}else{
                        // EU-OSS 2021/07
			if(defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0){
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id(EBAY_DEFAULT_DUMMY_PRODUCTS_ID, $auction_data['country_id']);
                            $tax = xtc_get_tax_rate($tax_class_id, $auction_data['country_id']);
			}elseif(defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') and EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU == 'true'){
                            $tax_class_id = yes_eu_oss_get_products_tax_class_id($transaction_pID, $auction_data['country_id']);
                            $tax = xtc_get_tax_rate($tax_class_id, $auction_data['country_id']);
			}else{
                            $tax = 0;
			}
		}
		$transaction['order']['vat'] = $tax;

		// ***************************************************************
		// ********** START VARIABLEN AUFBEREITEN ************************
		// ***************************************************************

		// APIBUG - MANCHMAL KEIN OBJECT REGISTRATIONADDRESS
		
		$transaction['password'] = $EBAYAPI->generatePassword();
		$this->password = $transaction['password'];
		$transaction['order']['shipping_title'] = EBAY_TOTAL_SHIPPING_TITLE;

		$transaction['order']['shipping_method'] = $transaction['ShippingService'];
		$transaction['order']['shipping_class'] = $EBAYAPI->get_shipping_class($transaction['ShippingService']);
		
		
		
		$transaction['order']['date'] = date('Y-m-d H:i:s');
		
		//$pm = _get_payment_method($trans,$item,$transaction['order']['shipping_class']);
		// gibt immer moneyorder zurueck - warum? weiss ich nicht mehr
		if($transaction['checkoutstatus'] == 'CheckoutComplete' and $transaction['PaymentMethodUsed'] == 'PayPal' and $transaction['eBayPaymentStatus'] == 'NoPaymentFailure'){
			$transaction['order']['payment_method'] = 'Paypal';
			$transaction['order']['payment_class'] = 'Paypal';
			if(defined('EBAY_SET_ORDERS_STATUS_BEZAHLT_BY_PAYPAL_PAYMENT') and EBAY_SET_ORDERS_STATUS_BEZAHLT_BY_PAYPAL_PAYMENT == 'True'){
				$orders_status = ORDERS_STATUS_BEZAHLT;
			}else{
				$orders_status = ORDERS_STATUS_UPSELLING;
			}
		}else if(strtolower($transaction['PaymentMethodUsed']) == 'none'){
			$pm = 'moneyorder';
			$transaction['order']['payment_method'] = $pm;
			$transaction['order']['payment_class'] = $EBAYAPI->get_converted_payment_string( $pm );
			$orders_status = ORDERS_STATUS_UPSELLING;
		}else{
			$pm = $transaction['PaymentMethodUsed'];
			$transaction['order']['payment_method'] = $pm;
			$transaction['order']['payment_class'] = $EBAYAPI->get_converted_payment_string( $pm );
			$orders_status = ORDERS_STATUS_UPSELLING;
		}
		if(strtolower($transaction['order']['payment_class']) == 'cashondelivery' or strtolower($transaction['order']['payment_class']) == 'cod'){
			$transaction['order']['shipping_method'] = 'cod_cod';
			$transaction['order']['shipping_class'] = 'cod_cod';
			$orders_status = '1';
		}
		if( $transaction['ShippingService'] != 'CustomCode' and (stristr($transaction['ShippingService'],'cashondelivery') or stristr($transaction['ShippingService'],'nachname') ) and stristr($transaction['PaymentMethodUsed'],'moneyxfer')){
			$transaction['order']['payment_method'] = 'COD';
			$transaction['order']['payment_class'] = 'COD';
			$orders_status = '1';
		}
		
		// WENN EBAY PAYMENT. DANN PAUSCHAL DAS HIER
                if($this->is_ebay_payment($this->seller) and !strstr($pm,'CashOnPickup')){
                    $transaction['order']['payment_method'] = 'ebay_payment';
                    $transaction['order']['payment_class'] = 'eBay Payment';
                    $orders_status = ORDERS_STATUS_BEZAHLT;
                }
		
		
		// den Versandkostenwert kriegen wir bei auslaendischer Waehrung nicht in EUR wieder
		// also rechnen wir um (*$umrechnungskurs)
		$transaction['order']['shipping'] = ($transaction['ShippingInsuranceCost'] + (float)$transaction['ShippingServiceCost'])*$transaction['umrechnungskurs'];

		$transaction['order']['total'] = ( $transaction['itemprice'] * $transaction['QuantityPurchased'] ) + $transaction['order']['shipping'];
		$transaction['order']['qty'] = xtc_db_input($transaction['QuantityPurchased']);
		$transaction['order']['itemtotal'] = $transaction['itemprice'];

		if($use_dummy_pid){
			$transaction['order']['products_name'] = $this->item_title;
		}else{
			$transaction['order']['products_name'] = xtc_get_products_name($transaction_pID,$this->language_id);
		}

		// **************************************************************
		// ********** ENDE VARIABLEN AUFBEREITEN ************************
		// **************************************************************
		$customers_saved = $this->is_customer_saved($transaction['email']);
		if(!$customers_saved){
			$this->debug( "\tNeuen Kunden anlegen" );
			// -------------------------------------------
			// EINTRAG IN customers
			// -------------------------------------------
			if(!defined('EBAY_CUSTOMERS_STATUS') or constant('EBAY_CUSTOMERS_STATUS') == 0){
				require_once('admin/includes/config.ebayapi.inc.php');
			}
			$customers_sql_array = array(
				'customers_status'=>EBAY_CUSTOMERS_STATUS,
				'customers_gender'=>EBAY_DEFAULT_GENDER,
				'customers_firstname'=>$this->addresses['reg']['firstname'],
				'customers_lastname'=>$this->addresses['reg']['lastname'],
				'customers_dob'=>'1970-01-01 00:00:00',
				'customers_email_address'=>$transaction['email'],
				'customers_password'=>xtc_encrypt_password($transaction['password']),
				'account_type'=>0,
				'customers_ebay_userid'=>$transaction['ebay_user'],
				'customers_telephone'=>$this->addresses['reg']['phone']
			);
			xtc_db_perform('customers',$customers_sql_array);
			$new_customers_id = xtc_db_insert_id();
			// BOF - customers_email_alias
			yes_remove_customers_email_alias($transaction['email'], $new_customers_id);
			// EOF - customers_email_alias
			

			// -------------------------------------------
			// FUER WEITERE VERARBEITUNG ALS SESSION
			// -------------------------------------------
			$transaction['customer_default_address_id'] = EBAY_ADDRESS_FORMAT_ID;
			$transaction['customer_cid'] = '';
			$transaction['customer_id'] = $new_customers_id;
			$transaction['customers_vat_id'] = '';

			// -------------------------------------------
			// EINTRAG IN address_book
			// -------------------------------------------
			$new = new \YES4Trade\Model\address_book([
                            'customers_id'=>(int)$new_customers_id,
                            'entry_gender'=>EBAY_DEFAULT_GENDER,
                            'entry_firstname'=>$this->addresses['reg']['firstname'],
                            'entry_lastname'=>$this->addresses['reg']['lastname'],
                            'entry_street_address'=>$this->addresses['reg']['street'],
                            'entry_postcode'=>$this->addresses['reg']['zip'],
                            'entry_city'=>$this->addresses['reg']['city'],
                            'entry_country_id'=>(int)$this->addresses['reg']['country_id'],
                            'entry_zone_id'=>(int)$this->addresses['reg']['zone_id'],
                            'address_date_added'=>date('Y-m-d H:i:s'),
			]);
			$address_book_id = $new->create();

			// -------------------------------------------
			// ADDRESSBUCH-ID IN customers SPEICHERN
			// -------------------------------------------
			$update_customers_sql_array = array(
				'customers_default_address_id'=>$address_book_id
			);
			xtc_db_perform('customers',$update_customers_sql_array,'update','customers_id='.$new_customers_id);

			// ------------------------------------------------------------
			// KUNDENHISTORIEN EINTRAG IN customers_info UND customers_memo
			// ------------------------------------------------------------
			$customers_info_sql_array = array(
				'customers_info_id' => $new_customers_id,
				'customers_info_date_account_created'=>'now()'
			);
			xtc_db_perform('customers_info',$customers_info_sql_array);

			$new = new \YES4Trade\Model\customers_memo([
                            'customers_id'=>(int)$new_customers_id,
                            'memo_date'=>date('Y-m-d H:i:s'),
                            'memo_title'=>'User angelegt',
                            'memo_text'=>'Durch Ebayauktion '.$this->ebay_id.' vom System angelegt.',
                            'poster_id'=>0
			]);
			$new->create();

		}else{ // end if registered user
			$this->debug( "\tZu existierendem Kunden speichern" );
			$this->is_registered = true;
			$customer = $customers_saved;
			// -------------------------------------------
			// FUER WEITERE VERARBEITUNG ALS SESSION
			// -------------------------------------------
			$transaction['customer_default_address_id'] = EBAY_ADDRESS_FORMAT_ID;
			$transaction['customer_id'] = $customer['customers_id'];
			$transaction['customer_cid'] = $customer['customers_cid'];
			$transaction['customers_vat_id'] = $customer['customers_vat_id'];
                        $this->update_customers_ebay_userid($transaction['customer_id'],$transaction['ebay_user']);

		}

		// BOF - DEFAULT VERSENDER
		$default_shipper = $this->get_default_shipper_from_products_id($transaction_pID,$transaction['order']['qty']);
		// EOF - DEFAULT VERSENDER
                $this->transaction_data = $transaction;

		$site = xtc_get_lang_path_from_ebay_site($this->site);
                $orders_id = $this->create_order($orders_status,$site,$default_shipper);
		// is it a yes products?
		if($transaction_pID > 0){
			// -------------------------------------------
			// NEUEN EINTRAG IN orders_products ANLEGEN
			// -------------------------------------------
			$order_products_id = $this->create_order_product($orders_id, $transaction_pID, $auction_data);


			// -------------------------------------------
			// VERKAUFTE-PRODUKTE-COUNTER IN products HOCHSETZEN
			// -------------------------------------------
			if($transaction_pID > 0){
				xtc_db_query("update " . TABLE_PRODUCTS . " set products_ordered = products_ordered + " . sprintf('%d', $transaction['order']['qty'] ). " where products_id = '" . $transaction_pID . "'");
			}


			if($transaction_pID > 0 and defined('EBAY_END_AUCTION_AT_SHOPORDER') and EBAY_END_AUCTION_AT_SHOPORDER == 'True'){
				yes_end_auction_add($transaction_pID,$transaction['order']['qty']);
			}
			$this->create_order_totals($orders_id);
			$this->create_order_history($orders_id,$orders_status);
			$site = (($auction_data['site'] != '') ? $auction_data['site'] : $this->site);
			$this->create_ebay_transaction_entry($transaction_pID, $orders_id, $site);


			// NEW EMAIL configuration !
			$insert_id = $orders_id;
                        
                        if( isset($transaction['BuyerCheckoutMessage']) and $transaction['BuyerCheckoutMessage'] != '' and $transaction['BuyerCheckoutMessage'] != 'null'){
                            $this->saveBuyerCheckoutMessage($transaction['BuyerCheckoutMessage'],
                                $transaction['email'],
                                $insert_id
                            );
                            xtc_db_query(sprintf(
                                "UPDATE ebay_transactions SET checkoutmessage_saved=1 WHERE ebayid='%s' AND transactionid='%s'",
                                $this->ebay_id,$this->transaction_id
                            ));
                        }	

			if(!$use_dummy_pid){
                            // KEINE KAUFABWICKLUNG BEI DUMMY PID
                            if(defined('EBAY_CHECKOUT_SEND_EMAIL') and EBAY_CHECKOUT_SEND_EMAIL == 'True'){
                                //include('ebay_send_order.php');
                                $this->customer_id = $transaction['customer_id'];
                                $this->orders_id = $insert_id;
                                $this->transaction_data_copy = $transaction;
                                $this->auction_data_copy = $auction_data;
                                $this->send_mail = 1;
                            }
			}

			if($use_dummy_pid or $transaction_pID == 0){
				return true;
			}
			product::add_history_static(intval($transaction_pID),
                            sprintf('[%s] Auktion %s: %s Verk&auml;ufe',
                                $this->source,$this->ebay_id,
                                $transaction['order']['qty']
                            )
                        );
			
			if(isset($transaction['variation_sku'])){
				xtc_db_query(sprintf(
					"UPDATE ebay_auctions_variations SET quantity=quantity-%d,quantity_sold=quantity_sold+%d WHERE ebay_auctions_id='%d' and sku='%s'",
					$transaction['order']['qty'],$transaction['order']['qty'],
					$auction_data['id'],$transaction['variation_sku']
				));
			}else{
				xtc_db_query(sprintf(
					"UPDATE ebay_auctions SET quantity=quantity-%d,quantity_sold=quantity_sold+%d WHERE id='%d'",
					$transaction['order']['qty'],$transaction['order']['qty'],
					$auction_data['id']
				));
			}
                        
                        $in_auction_qty_update = $transaction['order']['qty'];
                        $has_staffelpreise = false;
                        $staffelpreis_qty = 1;
                        if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                            $ea = new ebay_auction($auction_data['id']);
                            if($ea->has_staffelpreise()){
                                $has_staffelpreise = true;
                                $staffelpreis_qty = $ea->get_staffelpreis_quantity_from_sku($auction_data['sku']);
                                $in_auction_qty_update = $in_auction_qty_update*$staffelpreis_qty;
				$update_sql_array = array(
					'comments'=>'Staffelpreis Auktion - '.$staffelpreis_qty.' Stk. Variante'
				);
				xtc_db_perform(TABLE_ORDERS,$update_sql_array,'update',"orders_id='".$insert_id."'");
                            }
                        }
                        
			yes_update_products_in_auction_quantity($transaction_pID,
				yes_products_calc_in_auction_quantity(intval($transaction_pID)), 
				sprintf($this->source.': Abverkauf Auktion %s: %s Stk',$this->ebay_id,$in_auction_qty_update),
				true // overwrite
			);
			$this->debug("\tin_auction minus $in_auction_qty_update");

			// ************ AUTOMATIC REVISE START *****************************************

			if($auction_data['revise'] == 'to_qty'){
				$sku = (isset($transaction['variation_sku'])) ? $transaction['variation_sku'] : Null;
				$res = $this->revise($auction_data['id'],$transaction_pID, $transaction['order']['qty'], $sku);
				switch($res['code']){
					case -1:
                                                $SQ = new products_quantity($transaction_pID);
                                                $products_stock = $SQ->get_available1_qty();
						$rec_array = $this->get_recipients_array('ebayapi_cart');
						$text = sprintf('Die Auktion &raquo;%s&laquo; [%s] wurde von Ihnen so konfiguriert, dass bei Abverkauf der Bestand nachgeruestet werden soll. Es fand ein Abverkauf statt. Die Bestandspruefung fuer die pID %d ergab, dass ein Bestand von %d verfuegbar ist und somit die Menge der Auktion nicht mehr erhoeht wird.',
								xtc_db_input($transaction['order']['products_name']),
								$this->ebay_id,$transaction_pID,$products_stock);
						yes_write_notice($this->source.': Auktionsbestand nicht automatisch erhoeht',$text,0,$rec_array);
						xtc_db_query("UPDATE ebay_auctions SET revise='',revise_option='' WHERE id='".$auction_data['id']."'");
                                                if(main::isDev()){
                                                    $history_insert_sql = array(
                                                        'products_id'=>$transaction_pID,
                                                        'editor_id'=>0,
                                                        'date_saved'=>'now()',
                                                        'comments'=>'[nur dev history] '.$text,
                                                    );
                                                    xtc_db_perform('products_history',$history_insert_sql);
                                                }
						break;
					case -2:
						$rec_array = $this->get_recipients_array('ebayapi_cart');
						$text = sprintf($this->source.': Die Auktion %s (pID: %s) wurde von Ihnen so konfiguriert, dass bei Abverkauf der Bestand nachgeruestet werden soll.  [Neue Auction Qty: %s] Der Versuch die Menge der Auktion zu erhoehen scheiterte mit folgender Meldung von Ebay: %s',
							$this->ebay_id,
							$transaction_pID,
							$auction_data['quantity'],
							$res['status_message']
						);
						yes_write_notice($this->source.': Fehler in Automatik zum erhoehen der Anzahl in Auktionen',$text,0,$rec_array);
                                                if(main::isDev()){
                                                    $history_insert_sql = array(
                                                        'products_id'=>$transaction_pID,
                                                        'editor_id'=>0,
                                                        'date_saved'=>'now()',
                                                        'comments'=>'[nur dev history] '.$text,
                                                    );
                                                    xtc_db_perform('products_history',$history_insert_sql);
                                                }
						break;
				}
			}
			// ************ AUTOMATIC REVISE ENDE *****************************************
		}else{
			$this->debug( "\tErzeuge Auftrag zu unbekannter Auktion" );
			$this->create_order_totals($orders_id,true);
			$this->create_order_history($orders_id, $orders_status,true);
			$site = (($auction_data['site'] != '') ? $auction_data['site'] : $this->site);
			$this->create_ebay_transaction_entry(0, $orders_id, $site);

			$string = "Die Auktion ".$this->ebay_id." konnte keinem Produkt zugewiesen werden.\r\nEs wurde die Rechnung Nr. ".$orders_id." erzeugt, bitte f\FCgen Sie per Hand die fehlenden Daten hinzu.";

			// comment an auktion berechtigte
                        $rec_array = $this->get_recipients_array('orders');
                        yes_write_notice($this->source.': Unbekannte Auktion',xtc_db_input($string),0,$rec_array);
		}

		// BOF ERSATZ FUER soap_event_fixedpricetransaction.php
		$allow_types = array('StoresFixedPrice','FixedPriceItem');
		if(in_array($this->listing_type,$allow_types)){
			$this->debug( "\tUpdate Metadaten" );

			// META DATEN UPDATEN
			$products_id_query = xtc_db_query(sprintf("SELECT id,ebay_products_id,duration,products_id,title,quantity FROM ebay_auctions WHERE ebay_id='%s'",$this->ebay_id));
			$products_id = xtc_db_fetch_array($products_id_query);
			$current_item = array(
				'ebay_auctions_id'=>$products_id['id'],
				'ebay_products_id'=>$products_id['ebay_products_id'],
				'products_id'=>$products_id['products_id'],
				'db_auction_quantity'=>$products_id['quantity'],
				'title'=>$products_id['title'],
				'ebay_quantity'=>$this->item_quantity,
				'qty_sold'=>$this->item_quantity_sold
			);

			$qty = $this->item_quantity;
			$qty_sold = $this->item_quantity_sold;
			// BOF eBay OutOfStock
			$status = (($qty-$qty_sold) == 0) ? 2 : 0;
			if($status == 2){
			    if($products_id['duration'] == 0 and EBAY_FEATURE_OUTOFSTOCK == 'True'){
				$status = 0;
			    }
			}
			// EOF eBay OutOfStock

			if(isset($transaction['variation_sku'])){
				$this->debug( "\tUpdate Metadaten - VARIANTE" );
				
				// WIR PRUEFEN, OB ALLE VARIANTEN ABVERKAUFT SIND
				$query = xtc_db_query(sprintf(
					"SELECT SUM(quantity) as anz FROM ebay_auctions_variations eav WHERE eav.ebay_auctions_id='%d'",
					$current_item['ebay_auctions_id']
				));
				$record = xtc_db_fetch_array($query);
				if($record['anz'] == 0){
				    $status = 2;
				    // BOF eBay OutOfStock
				    if($products_id['duration'] == 0 and EBAY_FEATURE_OUTOFSTOCK == 'True'){
					$status = 0;
				    }
				    // EOF eBay OutOfStock
				}else{
				    $status = 0;
				}
				$this->debug("Auktion erhaelt status ".$status);
				
				$query = xtc_db_query(sprintf(
					"SELECT quantity,quantity_sold FROM ebay_auctions_variations eav WHERE eav.sku='%s' AND eav.ebay_auctions_id='%d'",
					$transaction['variation_sku'],$current_item['ebay_auctions_id']
				));
				if(xtc_db_num_rows($query)){
					$record = xtc_db_fetch_array($query);
					$current_item = array(
                                            'ebay_auctions_id'=>$current_item['ebay_auctions_id'],
                                            'ebay_products_id'=>$current_item['ebay_products_id'],
                                            'products_id'=>$transaction_pID,
                                            'db_auction_quantity'=>$record['quantity'],
                                            'title'=>$transaction['variation_title'],
                                            'ebay_quantity'=>$current_item['ebay_quantity'],
                                            'qty_sold'=>$this->item_quantity_sold,
                                            'db_quantity_sold'=>$record['quantity_sold']
					);

					$new_qty = 0;
					if($status == 2){
						$this->debug("Auktion beenden Historie schreiben");
						$qty_comment = $this->source.': Festpreis-Varianten-Auktion '.$this->ebay_id.' Alle Artikel abverkauft.';
						// EINTRAEGE IN DEN ANDEREN VARIANTEN
						$vquery = xtc_db_query(sprintf(
                                                    "SELECT products_id FROM ebay_auctions_variations WHERE ebay_auctions_id='%d' and sku!='%s'",
                                                    $auction_data['id'],$transaction['variation_sku']
						));
						while($vrow = xtc_db_fetch_array($vquery)){
                                                    product::add_history_static(intval($vrow['products_id']),
                                                        $this->source.': Festpreis-Varianten-Auktion '.$this->ebay_id.' Ende des Variantensets.'
                                                    );
						}
					}else{
                                            $qty = $current_item['ebay_quantity'];
                                            $qty_comment = $this->source.': Festpreis-Auktion '.$this->ebay_id.' Variante Abverkauf '.$transaction['order']['qty'].'/'.$record['quantity'];
                                            $this->debug($qty_comment);
					}

					product::add_history_static(intval($transaction['variation_sku']),
                                            $qty_comment
                                        );


					if($status == 2){
						$this->debug("Auktion beenden");
						// WENN EINSTELLDAUER BIS AUF WIDERRUF
						// NOTIZ AN ADMIN DAS AUKTION BEENDET
						if($products_id['duration'] == 0){
							$recs = $this->get_recipients_array('ebayapi_cart');
							$comments = sprintf('Die Auktion %s (%s) wurde nach Verkauf aller Artikel beendet. Sammlerprodukt-ID: %s / pID: %s',
								$this->ebay_id,
								$products_id['title'],
								$products_id['ebay_products_id'],
								$products_id['products_id']
							);
							yes_write_notice($this->source.': Auktion bis auf Widerruf nach Verkauf beendet',$comments,$sender=0,$recs);
						}
						$EBAYAPI->set_end_auction($products_id['id']);
						$this->debug('Auktion beendet');
					}
					$sql_update_array = array(
						'current_auctionprice'=>$this->item_current_price,
						'status'=>$status
					);
					xtc_db_perform('ebay_auctions',$sql_update_array,'update',"ebay_id='".$this->ebay_id."'");
					$this->debug("Metadaten (current_auctionprice+status) Variante erfolgreich aktualisiert");
				}

			}else{
				$this->debug( "\tUpdate Metadaten - KEINE VARIANTE" );
				$sql_update_array = array(
					'current_auctionprice'=>$this->item_current_price,
					'status'=>$status
				);
				xtc_db_perform('ebay_auctions',$sql_update_array,'update',"ebay_id='".$this->ebay_id."'");
				$this->debug("Metadaten (current_auctionprice+status) KEINE Variante erfolgreich aktualisiert");
				if($status == 2){
					$qty_comment = 'Festpreis-Auktion '.$this->ebay_id.' Ende mit '.$qty_sold.'/'.$qty.' Verkaeufen.';
				}else{
					$qty_comment = 'Festpreis-Auktion '.$this->ebay_id.' Abverkauf '.$qty_sold.'/'.$qty;
				}
				product::add_history_static(intval($current_item['products_id']),
                                    $this->source.': '.$qty_comment
                                );
				if($status == 2){
					// WENN EINSTELLDAUER BIS AUF WIDERRUF
					// NOTIZ AN ADMIN DAS AUKTION BEENDET
					if($products_id['duration'] == 0){
						$recs = $this->get_recipients_array('ebayapi_cart');
						$comments = sprintf('Die Auktion %s (%s) wurde nach Verkauf aller Artikel beendet. Sammlerprodukt-ID: %s / pID: %s',
							$this->ebay_id,
							$current_item['title'],
							$current_item['ebay_products_id'],
							$current_item['products_id']
						);
						yes_write_notice($this->source.': Auktion bis auf Widerruf nach Verkauf beendet',$comments,$sender=0,$recs);
					}
					$EBAYAPI->set_end_auction($products_id['id']);
					$this->debug('Auktion beendet');
				}
			}
		} // end if fixed price
		return true;
	}
	
	private function process_containing_order(){
		if(!isset($this->combined_order['OrderID']) or $this->combined_order['OrderID'] == ''){
			$this->debug( "\tKeine ContainingOrderID" );
			return false;
		}
		$check_query = yes_db_query(sprintf("SELECT ebay_orders_id FROM ebay_orders WHERE OrderID='%s'",
			$this->combined_order['OrderID']
		));
		if(yes_db_num_rows($check_query)){
			$this->debug( "\tUpdate ebay_orders ContainingOrderID ".$this->combined_order['OrderID'].' zu '.$this->combined_order['OrderStatus'] );
			$check_record = current($check_query);
			$update_sql_array = array(
				'OrderStatus' => $this->combined_order['OrderStatus']
			);
			xtc_db_perform('ebay_orders',$update_sql_array,'update',"ebay_orders_id='".$check_record['ebay_orders_id']."'");
		}else{
			$this->debug( "\tINSERT ebay_orders ContainingOrderID ".$this->combined_order['OrderID'].' zu '.$this->combined_order['OrderStatus'] );
			$insert_sql_array = array(
				'OrderID'=>$this->combined_order['OrderID'],
				'OrderStatus' => $this->combined_order['OrderStatus'],
				'date_added'=>'now()',
				'ebay_id'=>$this->ebay_id,
				'transaction_id'=>$this->transaction_id,
				'user'=>$this->seller
			);
			xtc_db_perform('ebay_orders',$insert_sql_array);
		}
	}
	
	private function is_valid_seller_transaction(){
		// HIER HABEN WIR WAHRSCHEINLICH EINEN KAUF DES POWERSELLER
		// NUR ABFANGEN WENN KEINE DUMMY PID
		if(!defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') and (!defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') or EBAY_DEFAULT_DUMMY_PRODUCTS_ID < 1)){
			$ebay_seller_query = xtc_db_query("SELECT user FROM ebay_auctions WHERE ebay_id='".$this->ebay_id."'");
			$ebay_seller_res = xtc_db_fetch_array($ebay_seller_query);
			if($this->seller != $ebay_seller_res['user']){
				$rec = $this->get_recipients_array('ebayapi_cart');
				$notice_text = sprintf(
					'Transaktionen der Auktion %s wurden nicht eingelesen, da der Selleruser (%s) nicht mit ihrem Powersellernamen uebereinstimmt.',
					$this->ebay_id,$this->seller
				);
				yes_write_notice($this->source.': Auktion nicht vom Sellerkonto',$notice_text,0,$rec);
				return false;
			}
		}
		return true;
	}
	
	private function get_recipients_array($auth){
		return main::get_notice_recipients($auth);
	}
	
	private function is_transaction_saved(){
		$check_query = xtc_db_query("SELECT count(*) as anzahl FROM ".TABLE_EBAY_TRANSACTIONS." WHERE ebayid='".$this->ebay_id."' && transactionid='".$this->transaction_id."'");
		$check_res = xtc_db_fetch_array($check_query);
		if($check_res['anzahl'] == '0')
			return false;
		return true;
	}
	
	private function is_customer_saved($email){
		$query = xtc_db_query("SELECT customers_id,customers_vat_id,customers_cid FROM customers WHERE customers_email_address='".$email."'");
		if(!xtc_db_num_rows($query))
			return false;
		return xtc_db_fetch_array($query);
	}
	
	private function get_auction_data(){
		$auction_data = array();
		if(isset($this->transaction_data['variation_sku'])){
		    $match = false; // afterbuy_import workaround
		    $match_afterbuy = false;
		    if(is_file(DIR_FS_CATALOG.'admin/includes/config.afterbuy.php') or is_file(DIR_FS_CATALOG.'admin/includes/config.ebay_import.php')){
			$auction_data_query = xtc_db_query(sprintf("SELECT ea.id, eav.quantity,ea.revise,ea.revise_option, ea.vat, ea.site, ea.country,p.products_id, p.products_model, eav.ebay_auctions_variations_id
                            FROM products p LEFT JOIN ebay_auctions_variations eav USING(products_id)
                            LEFT JOIN ebay_auctions ea ON ea.id=eav.ebay_auctions_id
                            WHERE ea.ebay_id = '%s' AND eav.sku = '%s'",
                           $this->ebay_id,
                           $this->transaction_data['variation_sku']
			));
			if(xtc_db_num_rows($auction_data_query)){
			    $match = true;
			    $match_afterbuy = true;
			}
		    }
		    if(!$match){
			$auction_data_query = xtc_db_query(sprintf("SELECT ea.id, eav.quantity,ea.revise,ea.revise_option, ea.vat, ea.site, ea.country,p.products_id, p.products_model, eav.ebay_auctions_variations_id
				 FROM products p LEFT JOIN ebay_auctions_variations eav USING(products_id)
				 LEFT JOIN ebay_auctions ea ON ea.id=eav.ebay_auctions_id
				 WHERE ea.ebay_id = '%s' AND eav.sku = '%s'",
				$this->ebay_id,
				$this->transaction_data['variation_sku']
			));
		    }
			// BUGFIX 20.12.13 - unbekannte SKU darf kein Result zurueckgeben
                    if(xtc_db_num_rows($auction_data_query)){
			    $auction_data = xtc_db_fetch_array($auction_data_query);
			    if($match_afterbuy){
				$var_query = xtc_db_query(sprintf(
					"SELECT products_id,quantity,quantity_sold FROM ebay_auctions_variations WHERE ebay_auctions_id='%d' AND sku='%s'",
					$auction_data['id'],$this->transaction_data['variation_sku']
				));
			    }else{
				$var_query = xtc_db_query(sprintf(
					"SELECT products_id,quantity,quantity_sold FROM ebay_auctions_variations WHERE ebay_auctions_id='%s' AND sku='%s'",
					$auction_data['id'],$this->transaction_data['variation_sku']
				));
			    }
			    $var = xtc_db_fetch_array($var_query);
			    $auction_data['quantity'] = $var['quantity'];
			    $auction_data['quantity_sold'] = $var['quantity_sold'];
			    $product_data_query = xtc_db_query("SELECT p.products_model FROM products p WHERE products_id='".$var['products_id']."'");
			    $product_data = xtc_db_fetch_array($product_data_query);
			    $auction_data['products_id'] = $var['products_id'];
			    $auction_data['products_model'] = $product_data['products_model'];
                            $auction_data['sku'] = $this->transaction_data['variation_sku'];
			}
		}else{
                    $auction_data_query = xtc_db_query("SELECT ea.sku,ea.id,ea.quantity,ea.revise,ea.revise_option,ea.vat,ea.site,ea.country,ea.select_set,ea.select_set_multiple,p.products_id,p.products_model FROM ebay_auctions ea LEFT JOIN products p USING(products_id) WHERE ea.ebay_id='".$this->ebay_id."'");
                    $auction_data = xtc_db_fetch_array($auction_data_query);
		}
                $country_id = yes_get_country_id_from_iso2($auction_data['country']);
                $zone_id = 0;
                // EU-OSS 2021/07
//                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($var['products_id'], $country_id,$zone_id);
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($auction_data['products_id'], $country_id,$zone_id);
                $auction_data['products_tax_class_id'] = $products_tax_class_id;
                $auction_data['country_id'] = $country_id;
		return $auction_data;
	}
	
	public function get_addresses_from_object($buyer){
		global $EBAYAPI;
		$array = array();
		$this->ebay_user = $buyer->UserID;
		$this->email = $buyer->Email;
		$buyerInfo = $buyer->BuyerInfo;
		$buyerShip = $buyerInfo->ShippingAddress;
		
                $fullname = split_string($buyerShip->Name);
                $array['reg']['fullname'] = xtc_db_input($buyerShip->Name);
                $array['reg']['firstname'] = xtc_db_input($fullname[0]);
                $array['reg']['lastname'] = xtc_db_input($fullname[1]);
                $array['reg']['street'] = xtc_db_input($buyerShip->Street1);
                if($buyerShip->Street2 != ''){
                        $array['reg']['suburb'] = xtc_db_input($buyerShip->Street2);
                }
                $array['reg']['zip'] = xtc_db_input($buyerShip->PostalCode);
                $array['reg']['city'] = xtc_db_input($buyerShip->CityName);
                $array['reg']['phone'] = $EBAYAPI->get_phone_number_from_transactionrecord( xtc_db_input($buyerShip->Phone) );
			
                if(!$this->is_transaction_saved()){
                    $array['reg']['country'] = _get_country_code( $buyerShip->CountryName, $this->ebay_id);
                }else{
                    $array['reg']['country'] = _get_country_code( $buyerShip->CountryName, $this->ebay_id,false);
                }
			
                $array['reg']['countryname'] = _get_country_name_from_code($array['reg']['country'] );
		$array['reg']['addressid'] = xtc_db_input($buyerShip->AddressID );
		$array['reg']['country_id'] = _ebay_country_code( $array['reg']['country'] );
		$array['reg']['zone_id'] = _ebay_zone_id( $array['reg']['country_id'] );
                
                $array['ship'] = $array['reg'];
		return $array;
	}
	
	public function get_addresses_from_array($buyer){
		global $EBAYAPI;
		$array = array();
		$this->ebay_user = $buyer['UserID']['value'];
		$this->email = $buyer['Email']['value'];
                $buyerShip = $buyer['BuyerInfo']['ShippingAddress'];

                $fullname = split_string($buyerShip['Name']['value']);
                $array['reg']['fullname'] = xtc_db_input($buyerShip['Name']['value']);
                $array['reg']['firstname'] = xtc_db_input($fullname[0]);
                $array['reg']['lastname'] = xtc_db_input($fullname[1]);
                $array['reg']['street'] = xtc_db_input($buyerShip['Street1']['value']);
                if(isset($buyerShip['Street2']) and is_array($buyerShip['Street2'])){
                    $array['reg']['suburb'] = xtc_db_input($buyerShip['Street2']['value']);
                }
                $array['reg']['zip'] = xtc_db_input($buyerShip['PostalCode']['value']);
                $array['reg']['city'] = xtc_db_input($buyerShip['CityName']['value']);
			
                if(!$this->is_transaction_saved()){
                    $array['reg']['country'] = _get_country_code( $buyerShip['CountryName']['value'], $this->ebay_id);
                }else{
                    $array['reg']['country'] = _get_country_code( $buyerShip['CountryName']['value'], $this->ebay_id, false);
                }
			
                $array['reg']['countryname'] = _get_country_name_from_code($array['reg']['country'] );
		$array['reg']['country_id'] = _ebay_country_code( $array['reg']['country'] );
		$array['reg']['zone_id'] = _ebay_zone_id( $array['reg']['country_id'] );
                $array['reg']['phone'] = $EBAYAPI->get_phone_number_from_transactionrecord( xtc_db_input($buyerShip['Phone']['value']) );
                $array['reg']['addressid'] = xtc_db_input($buyerShip['AddressID']['value']);
		$array['ship'] = $array['reg'];
		return $array;
	}
	
	public function get_combined_order_from_array($co){
		if(!isset($co['OrderID']['value']))
			return array();
		
		return array(
			'OrderID' => $co['OrderID']['value'],
			'OrderStatus' => $co['OrderStatus']['value']
		);
	}
	
	public function get_combined_order_from_object( $CO ){
	    if(is_object($CO) and isset($CO->OrderID) and $CO->OrderID != ''){
                return array(
                        'OrderID'=>$CO->OrderID,
                        'OrderStatus'=>$CO->OrderStatus
                );
            }
            return array();
	}
	
	public function get_transactiondata_from_array($trans,$item){
		$transaction = array(
			'currency' => $trans['ConvertedTransactionPrice']['attr']['currencyID'], // BUGFIX immer shop/einstellwaehrung
			'umrechnungskurs' => $trans['ConvertedTransactionPrice']['value'] / $trans['TransactionPrice']['value'],
			'itemprice' => $trans['ConvertedTransactionPrice']['value'],
			'ShippingService'=>$trans['ShippingServiceSelected']['ShippingService']['value'],
			'ShippingInsuranceCost'=>$trans['ShippingServiceSelected']['ShippingInsuranceCost']['value'],
			'ShippingServiceCost'=>$trans['ShippingServiceSelected']['ShippingServiceCost']['value'],
			'QuantityPurchased'=>$trans['QuantityPurchased']['value'],
			'checkoutstatus'=>$trans['Status']['CheckoutStatus']['value'],
			'PaymentMethodUsed'=>$trans['Status']['PaymentMethodUsed']['value'],
			'eBayPaymentStatus'=>$trans['Status']['eBayPaymentStatus']['value']
		);
		if($transaction['PaymentMethodUsed'] == 'PayPal' and $transaction['checkoutstatus'] == 'CheckoutComplete'){
			if(isset($trans['ExternalTransaction']) and is_array($trans['ExternalTransaction'])){
				$et = current($trans['ExternalTransaction']);
				$transaction['ExternalTransactionID'] = $et['ExternalTransactionID']['value'];
			}
		}
		if(isset($trans['BuyerCheckoutMessage']['value'])){
			$transaction['BuyerCheckoutMessage'] = $trans['BuyerCheckoutMessage']['value'];
		}
		if(isset($trans['BuyerMessage']['value'])){
			$transaction['BuyerMessage'] = $trans['BuyerMessage']['value'];
		}
		// API-BUG?!
		if(!isset($trans['QuantityPurchased']['value']) or $trans['QuantityPurchased']['value'] == 0){
			$this->error_report_qty_error($trans, $trans['QuantityPurchased']['value']);
			$transaction['QuantityPurchased'] = 1;
		}
		if(isset($trans['Variation'])){
			$transaction['variation_sku'] = $trans['Variation']['SKU']['value'];
			$transaction['variation_title'] = $trans['Variation']['VariationTitle']['value'];
			$this->item_title = $transaction['variation_title'];
		}else{
			if(isset($trans['SKU']) and $trans['SKU']['value'] != ''){
				$transaction['sku'] = $trans['SKU']['value'];
			}
		}
		return $transaction;
	}
	
	public function get_transactiondata_from_object($trans){
		$ctp = $trans->ConvertedTransactionPrice;
		$tp = $trans->TransactionPrice;
		$shippingService = $trans->ShippingServiceSelected;
                if(strtolower(gettype($shippingService)) != 'null'){
        		$shippingServiceIC = $shippingService->ShippingInsuranceCost;
                	$shippingServiceC = $shippingService->ShippingServiceCost;
                        $shSIC_val = $shippingServiceIC->value;
                        $shSC_val = $shippingServiceC->value;
                        $scService = $shippingService->ShippingService;
                }else{
                    $shippingService = $trans->ShippingDetails;
                    $shSIC_val = 0;
                    $shSC_val = 0;
                    $scService = $shippingService->ShippingServiceUsed;
                }
		$transaction = array(
			'currency' => $ctp->currencyID,
			'umrechnungskurs' => $ctp->value / $tp->value,
			'itemprice' => $ctp->value,
			'ShippingService'=>$scService,
			'ShippingInsuranceCost'=>$shSIC_val,
			'ShippingServiceCost'=>$shSC_val,
			'QuantityPurchased'=>$trans->QuantityPurchased,
			'checkoutstatus'=>$trans->Status->CheckoutStatus,
			'PaymentMethodUsed'=>$trans->Status->PaymentMethodUsed,
			'eBayPaymentStatus'=>$trans->Status->eBayPaymentStatus
		);
		if($transaction['PaymentMethodUsed'] == 'PayPal' and $transaction['checkoutstatus'] == 'CheckoutComplete'){
// testen                    
			$et_array = $trans->ExternalTransaction;
			
			if(is_array($et_array) and sizeOf($et_array)){
				$et = current($et_array);
				$transaction['ExternalTransactionID'] = $et->ExternalTransactionID;
			}
			
		}
		$transaction['BuyerCheckoutMessage'] = '';
		$transaction['BuyerMessage'] = '';
		if(isset($trans->BuyerCheckoutMessage) and $trans->BuyerCheckoutMessage != ''){
			$transaction['BuyerCheckoutMessage'] = $trans->BuyerCheckoutMessage;
		}
		

		
		// API-BUG?!
		if( !isset($trans->QuantityPurchased) or $trans->QuantityPurchased == 0){
			$this->error_report_qty_error($trans,$v->QuantityPurchased);
			$transaction['QuantityPurchased'] = 1;
		}
// testen                
		if(isset($trans->Variation)){
			$Variation = $trans->Variation;
			$transaction['variation_sku'] = $Variation->SKU;
			$transaction['variation_title'] = $Variation->VariationTitle;
			$this->item_title = $Variation->VariationTitle;
			
		}else{
			$Item = $trans->Item;
			if($Item->SKU != ''){
				$transaction['sku'] = (string)$Item->SKU;
			}
		}
		return $transaction;
	}
	
	private function error_report_qty_error($trans,$qty){
		ob_start();
		print_r($trans);
		$debugmail_text = ob_get_contents();
		ob_end_clean();

		mail('m.aspeleiter@yes-websolutions.de, agri@yes-websolutions.de','API gab kein quantitypurchased zurueck','In Auktion Nr. '.$this->ebay_id.' wurde als quantitypurchased '.$qty.' uebergeben. Das Transactionresult sieht so aus:'."\r\n\r\n".$debugmail_text);
	}
	
	private function getTransactionOrderData(){
		$query = xtc_db_query(sprintf(
			"SELECT * FROM ebay_transactions WHERE ebayid='%s' AND transactionid='%s'",
			$this->ebay_id,$this->transaction_id
		));
		$record = xtc_db_fetch_array($query);
		if($record['orders_id'] > 0){
			$query = xtc_db_query(sprintf(
				"SELECT orders_status,ebay_plus FROM orders WHERE orders_id='%s'",
				$record['orders_id']
			));
			$order_record = xtc_db_fetch_array($query);
			$record['orders_status'] = $order_record['orders_status'];
                        $record['ebay_plus'] = $order_record['ebay_plus'];
		}
		return $record;
	}
	
	private function saveBuyerCheckoutMessage( $message,$email,$orders_id ){
		$rec_array = $this->get_recipients_array('ebayapi_cart');
		$text = strip_cdata($message);
		// NUR SPEICHERN WENNS NICHT NUR DIE EMAIL IS
		if(trim(strtolower($text)) != strtolower($email)){
			yes_write_notice($this->source.': eBay K&auml;ufer Nachricht Re-Nr '.$orders_id,$text,0,$rec_array);
			
			$check_cv_query = xtc_db_query(sprintf(
				"SELECT comments_visible FROM %s WHERE orders_id='%s'",
				TABLE_ORDERS,$orders_id
			));
			if(xtc_db_num_rows($check_cv_query)){
			    $check_cv = xtc_db_fetch_array($check_cv_query);
			    $cv = '';
			    if($check_cv['comments_visible'] != ''){
				$cv = $check_cv['comments_visible'].' ';
			    }
			    $update_sql_array = array(
				'comments_visible'=>$cv.$message
			    );
			    yes_db_perform(TABLE_ORDERS,$update_sql_array,'update',
                                ['orders_id'=>$orders_id]
                            );
			}
			$order_history_sql_array = array(
				'orders_id' => $orders_id,
				'orders_status_id' => ORDERS_STATUS_UPSELLING,
				'date_added' => 'now()',
				'customer_notified' => 0,
				'comments' => $this->source.': eBay Kunde Kommentar: '.$text
			);
			yes_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
		}
	}
	
	private function update_address_data($orders_id){
		/**
		FUER HISTORIENEINTRAG DIE "ALTE" BEZAHLART ERMITTELN
		**/
		$query = yes_db_query(sprintf("SELECT orders_status,payment_method,shipping_method,currency,billing_name,billing_company FROM orders WHERE orders_id='%s'",
			$orders_id
		));
		$record = current($query);
		$currency = $record['currency'];
		$billing_str = $record['billing_name'];
		if($record['billing_company'] != ''){
		    $billing_str = $record['billing_company'].' '.$record['billing_name'];
		}

		if( stristr($this->transaction_data['PaymentMethodUsed'],'paypal') and $record['orders_status'] != ORDERS_STATUS_STORNIERT and $this->transaction_data['eBayPaymentStatus'] == 'NoPaymentFailure') {
			if(defined('EBAY_SET_ORDERS_STATUS_BEZAHLT_BY_PAYPAL_PAYMENT') and EBAY_SET_ORDERS_STATUS_BEZAHLT_BY_PAYPAL_PAYMENT == 'True'){
				$new_orders_status = ORDERS_STATUS_BEZAHLT;
			}else{
				$new_orders_status = $record['orders_status'];
			}
		}else{
			$new_orders_status = $record['orders_status'];
		}
		
		
		if(strtolower($this->transaction_data['PaymentMethodUsed']) == 'none'){
			$pm = 'Moneyorder';
		}else{
		    $pm = $this->transaction_data['PaymentMethodUsed'];
		}
		if(stristr($this->transaction_data['PaymentMethodUsed'],'CashOnPickup')){
		    $new_orders_status = '1';
		    $this->transaction_data['ShippingService'] = 'CashOnPickup';
		}
		if( !stristr($this->transaction_data['ShippingService'],'cod') and (stristr($this->transaction_data['ShippingService'],'cod') or stristr($this->transaction_data['ShippingService'],'nachname')) and stristr($this->transaction_data['PaymentMethodUsed'],'moneyxfer')){
			if(strtolower($this->transaction_data['ShippingService']) != 'customcode'){
			    $new_orders_status = '1';
			    $pm = 'COD';
			}
		}
		
		
		
		$update_sql_array = array(
			'delivery_name'=>$this->addresses['ship']['fullname'],
			'delivery_company'=>((isset($this->addresses['ship']['company']))?$this->addresses['ship']['company']:''),
			'delivery_street_address'=>$this->addresses['ship']['street'],
			'delivery_suburb'=>((isset($this->addresses['ship']['suburb']))?$this->addresses['ship']['suburb']:''),
			'delivery_city'=>$this->addresses['ship']['city'],
			'delivery_postcode'=>$this->addresses['ship']['zip'],
			'delivery_state'=>((isset($this->addresses['ship']['state']))?$this->addresses['ship']['state']:''),
			'delivery_country'=>$this->addresses['ship']['countryname'],
			'payment_method'=>$pm,
			'payment_class'=>$pm,
			'last_modified'=>'now()',
			'orders_status'=>$new_orders_status
		);
		
		// UPDATE SHIPPING METHOD
		$order_history_shipping_text = '';
		if($record['shipping_method'] != $this->transaction_data['ShippingService']){
		    
		    if(stristr($this->transaction_data['PaymentMethodUsed'],'CashOnDelivery')){
			$update_sql_array['shipping_method'] = 'cod_cod';
			$update_sql_array['shipping_class'] = 'cod_cod';
		    }else{
			$update_sql_array['shipping_method'] = $this->transaction_data['ShippingService'];
			$update_sql_array['shipping_class'] = $update_sql_array['shipping_method'];
		    }
		    
		    
		    
    		    $new_shipping_costs = ($this->transaction_data['ShippingInsuranceCost'] + (float)$this->transaction_data['ShippingServiceCost'])*$this->transaction_data['umrechnungskurs'];
		    $ot_query = xtc_db_query(sprintf(
			   "SELECT value FROM orders_total WHERE orders_id='%s' AND class='ot_shipping'",
			    $orders_id
		    ));
		    $ot = xtc_db_fetch_array($ot_query);
		    if( (float) $new_shipping_costs != (float) $ot['value'] ){
			
			xtc_db_query(sprintf(
			    "UPDATE orders_total SET value='%s',text='%s' WHERE orders_id='%s' AND class='ot_shipping'",
			    $new_shipping_costs,
			    number_format($new_shipping_costs,2,',','.').' '.$this->transaction_data['currency'],
			    $orders_id
			));
			
			$ot_query = xtc_db_query(sprintf(
				"SELECT SUM(value) as total_value FROM orders_total WHERE orders_id='%s' AND class != 'ot_total' AND class != 'ot_tax'",
				$orders_id
			));
			$ot = xtc_db_fetch_array($ot_query);
			
			// BOF - TAX RATE
			$auction_data = $this->get_auction_data();
			$use_dummy_pid = false;
			if($auction_data['products_id'] < 1 and defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0){
				$use_dummy_pid = true;
				$transaction_pID = EBAY_DEFAULT_DUMMY_PRODUCTS_ID;
			}else{
				if($auction_data['products_id'] < 1 and defined('EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU') and EBAY_UNKNOWN_PRODUCTS_ID_USE_SKU == 'true'){
				    if(isset($this->transaction_data['variation_sku']))
					$transaction_pID = $this->transaction_data['variation_sku'];
				    else
					$transaction_pID = $this->transaction_data['sku'];
				}else{
				    $transaction_pID = $auction_data['products_id'];
				}
			}

			if($auction_data['vat'] == 1){
				$tax = xtc_get_tax_rate($auction_data['products_tax_class_id'], $auction_data['country_id']);

				$collies = xtc_get_product_collies($transaction_pID);
				// calculate brutto price for display
				if(COLLI_ACTIVE){
                                    if(sizeOf($collies)>0){
                                        // EU-OSS 2021/07
                                        $tax = xtc_get_product_collies_tax_value($collies, $auction_data['country_id']);
                                    }
				}
			}else{
				if(defined('EBAY_DEFAULT_DUMMY_PRODUCTS_ID') and EBAY_DEFAULT_DUMMY_PRODUCTS_ID > 0){
                                    // EU-OSS 2021/07
                                    $tax_class_id = yes_eu_oss_get_products_tax_class_id(EBAY_DEFAULT_DUMMY_PRODUCTS_ID, $auction_data['country_id']);
                                    $tax = xtc_get_tax_rate($tax_class_id, $auction_data['country_id']);
				}else{
                                    $tax = 0;
				}
			}
			// EOF - TAX RATE
			$ot_tax_value = $ot['total_value'] - ( $ot['total_value'] / ((100+$tax)/100) );
			
			xtc_db_query(sprintf(
			    "UPDATE orders_total SET value='%s',text='%s' WHERE orders_id='%s' AND class='ot_tax'",
			    $ot_tax_value,
			    number_format($ot_tax_value,2,',','.').' '.$this->transaction_data['currency'],
			    $orders_id
			));
			
			xtc_db_query(sprintf(
			    "UPDATE orders_total SET value='%s',text='%s' WHERE orders_id='%s' AND class='ot_total'",
			    $ot['total_value'],
			    number_format($ot['total_value'],2,',','.').' '.$this->transaction_data['currency'],
			    $orders_id
			));
			$order_history_shipping_text = sprintf(
				"\r\nVersandkosten %s (%s)",
				number_format($ot['total_value'],2,',','.').' '.$this->transaction_data['currency'],
				$update_sql_array['shipping_method']
			);
		    }
		}
		
		
		xtc_db_perform('orders',$update_sql_array,'update',"orders_id='".$orders_id."'");
		
		
		// BOF - PAYPAL ZAHLUNG IN ZEP 10.09.14
		if($this->transaction_data['checkoutstatus'] == 'CheckoutComplete' and strtolower($this->transaction_data['PaymentMethodUsed']) == 'paypal'){
		    $insert_sql_array = array(
			'betrag'=>( $this->transaction_data['itemprice'] * $this->transaction_data['QuantityPurchased'] ) + $this->transaction_data['ShippingServiceCost'],
			'waehrung'=>$this->transaction_data['currency'],
			'buchungstag'=>date('d.m.Y'),
			'bankleitzahl'=>'',
			'kontonummer'=>'',
			'name'=>$billing_str,
			'verwendungszweck1'=>$this->transaction_data['PaymentMethodUsed'].' Transaktion '.$this->transaction_data['ExternalTransactionID'],
			'confirmed'=>1,
			'sorting'=>0,
			'buchungstag_date'=>date('Y-m-d')
		    );
		    xtc_db_perform('incoming_payments',$insert_sql_array);
		    $payment_id = xtc_db_insert_id();
		    $insert_sql_array = array(
			'payment_id'=>$payment_id,
			'orders_id'=>$orders_id,
			'created'=>'now()'
		    );
		    xtc_db_perform('payment_orders',$insert_sql_array);
		    //mail('m.aspeleiter@yes-websolutions.de','ebay paypal zep succ '.$orders_id,$this->transaction_data['FinalValueFee']);
		}else{
		    //mail('m.aspeleiter@yes-websolutions.de','ebay paypal zep fail '.$orders_id,$this->transaction_data['ExternalTransactionStatus'].var_export($this->transaction_data,true));
		}
		// EOF - PAYPAL ZAHLUNG IN ZEP
		
		
		$order_history_text = 'Kunde bezahlte via eBay Payment. Verwendete Bezahlart: '.$this->transaction_data['PaymentMethodUsed'].' / vorh. Bezahlart: '.$record['payment_method'];
		if(isset($this->transaction_data['ExternalTransactionID'])){
			$order_history_text .= " Paypal Transaction ID: ".$this->transaction_data['ExternalTransactionID'];
		}
		if($order_history_shipping_text != ''){
		    $order_history_text .= $order_history_shipping_text;
		}
		
		
		
		$insert_sql_array = array(
			'orders_id'=>$orders_id,
			'orders_status_id'=>$new_orders_status,
			'date_added'=>'now()',
			'customer_notified'=>0,
			'comments'=>$this->source.': '.$order_history_text,
			'editor_id'=>0
		);
		xtc_db_perform('orders_status_history',$insert_sql_array);	
		
		
	}
	
	private function debug($debug_text){
		if(!$this->source == 'SOAP'){
			$msg = sprintf("\tEbayID %s / Transaktion %s: %s\r\n",
					$this->ebay_id,$this->transaction_id,$debug_text
			);
			mail('m.aspeleiter@yes-websolutions.de','DEBUG '.basename(__FILE__),STORE_NAME.' '.$msg);
		}
		if($this->debug){
			printf("\tEbayID %s / Transaktion %s: %s\r\n",
					$this->ebay_id,$this->transaction_id,$debug_text
			);
		}
	}
        
        private function update_customers_ebay_userid($customers_id,$ebay_user){
            $query = xtc_db_query(sprintf(
                    "SELECT customers_ebay_userid FROM customers WHERE customers_id='%s'",
                    $customers_id
            ));
            $record = xtc_db_fetch_array($query);
            if($record['customers_ebay_userid'] != $ebay_user){
                $update_sql_array = array(
                    'customers_ebay_userid'=>$ebay_user
                );
                xtc_db_perform('customers',$update_sql_array,'update',"customers_id='".$customers_id."'");
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id'=>(int)$customers_id,
                    'memo_date'=>date('Y-m-d H:i:s'),
                    'memo_title'=>'eBay User Update',
                    'memo_text'=>'Durch Ebayauktion '.$this->ebay_id.' eBay Username von "'.$record['customers_ebay_userid'].'" in "'.$ebay_user.'" aktualisiert.',
                    'poster_id'=>0,
                ]);
                $new->create();
            }
        }
        
        /**
         * Wenn der Seller das neue (2020) eBay Payment aktiviert hat, gelten
         * alle Transaktionen als bezahlt
         * @param string $seller
         * @return boolean
         */
        public static function is_ebay_payment($seller){
            $query = xtc_db_query(sprintf(
                    "SELECT id FROM ebay_auth WHERE user='%s' AND ebay_payment_active='1'",
                    $seller
            ));
            return xtc_db_num_rows($query);
        }

	public function revise(int $ebay_auctions_id, int $transaction_pID, int $transaction_order_qty, string $sku = Null){
		global $EBAYAPI;
		$this->debug( "\tRevise to_qty" );
		// BESTANDSPRUEFUNG
		$SQ = new products_quantity($transaction_pID);
		$products_stock = $SQ->get_available1_qty();
		$in_auction_add_qty = $transaction_order_qty;
		$revise_qty = $this->item_quantity;
                $stfl_info_text = '';

                if($sku != Null and defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
                    $ea = new ebay_auction($ebay_auctions_id);
                    if($ea->has_staffelpreise()){
                        $staffelpreis_qty = $ea->get_staffelpreis_quantity_from_sku($sku);
                        $in_auction_add_qty = $in_auction_add_qty*$staffelpreis_qty;

			foreach($ea->getVariations() as $variation){
				if($variation->getSKU() == $sku){
					$revise_qty = $variation->getQuantity()+$transaction_order_qty;
                                        $stfl_info_text = 'Staffelpreis Variante '.$sku.' ';
				}
			}
                    }
                }
		//yes_mail_debug(sprintf('revise(ebay_auctions_id %d, transaction_pID %d, transaction_order_qty %d, sku %s) staffelpreis_qty %d, in_auction_add_qty %d, revise_qty %d',
		//	$ebay_auctions_id,$transaction_pID,$transaction_order_qty,$sku,$staffelpreis_qty,$in_auction_add_qty,$revise_qty
		//));
		// $this->item_quantity = Item.Quantity aus der Transaktion
		if( STOCK_CHECK == 'true' ){
		    if( $products_stock < 1 or $products_stock < $revise_qty){
			return array(
				'code'=>-1,
				'status_message'=>''
			);
		    }
		}
	        $new_itemtype = $EBAYAPI->get_sdk_type_class('ItemType');
	        $new_itemtype->ItemID = $this->ebay_id;
	        if($sku != Null){
	            $Variations = $EBAYAPI->get_sdk_type_class('VariationsType');
	            $Variation = $EBAYAPI->get_sdk_type_class('VariationType');
	            $Variation->SKU = $sku;
	            $Variation->Quantity = (int)$revise_qty;
                    $Variations->Variation[] = $Variation;
	            $new_itemtype->Variations = $Variations;
			try{
		            $status_message = $EBAYAPI->revise_variation_auction($ebay_auctions_id,$new_itemtype);
			}catch( Exception $e ){
                            $history_insert_sql = array(
                                'products_id'=>$transaction_pID,
                                'editor_id'=>0,
                                'date_saved'=>'now()',
                                'comments'=>$stfl_info_text.' Revise #'.$this->ebay_id.' '.$revise_qty.' Stk fehlgeschlagen. '.$e->getMessage(),
                            );
                            xtc_db_perform('products_history',$history_insert_sql);
                            print_r($e);
			}
	        }else{
	            $new_itemtype->Quantity = $revise_qty;
	            $status_message = $EBAYAPI->revise_auction($ebay_auctions_id,$new_itemtype,'Item.Quantity');
	        }
		$this->debug("eBay Revise erfolgreich - auf $revise_qty Stk");
	        if($status_message == ''){
			$qty_comment = sprintf($this->source.': %sAutomatisches erhoehen der Anzahl in Auktionen nach Abverkauf von %d Stk in Auktion %s',
                            $stfl_info_text,
                            $transaction_order_qty,
                            $this->ebay_id
			);
			product::add_history_static(intval($transaction_pID),
                            $qty_comment
                        );
			$revise_counter_add = 0; // revise counter wird nicht mehr genutzt
			if($sku != Null){
				xtc_db_query(sprintf(
					"UPDATE ebay_auctions_variations SET quantity=%d,revise_counter=revise_counter+%d WHERE ebay_auctions_id='%d' AND sku='%s'",
					$revise_qty,
					$revise_counter_add,
					$ebay_auctions_id,
					$sku
				));
			}else{
				xtc_db_query(sprintf("UPDATE ebay_auctions SET quantity=%d, revise_counter=revise_counter+%d WHERE id='%d'",
					$revise_qty,
					$revise_counter_add,
					$ebay_auctions_id
				));
			}
			yes_update_products_in_auction_quantity($transaction_pID,
				yes_products_calc_in_auction_quantity(intval($transaction_pID)),
				sprintf($this->source.': %sRevise Auktion %s: %s Stk',
                    $stfl_info_text,$this->ebay_id,$in_auction_add_qty),
				true // overwrite!
			);
			$this->debug("yes_update_products_in_auction_quantity plus $in_auction_add_qty Stk");
		}else{
			return array(
				'code'=>-2,
				'status_message'=>$status_message
			);
			return -2;
	        }
	}
        private function get_order_phone_from_addresses(){
            // Wenn 2 versch. Telefonummern vorliegen, dann beide in einem speichern
            $order_phone = $this->addresses['reg']['phone'];
            if(!empty($this->addresses['ship']['phone']) and $this->addresses['ship']['phone'] != $order_phone){
                if(!empty($order_phone))
                    $order_phone .= ' / '.$this->addresses['ship']['phone'];
                else
                    $order_phone = $this->addresses['ship']['phone'];
            }
            return $order_phone;
        }
        public function create_order(int $orders_status,string $site,string $default_shipper = ''){
            $this->debug("create order");
            $transaction = $this->transaction_data;
            $order_sql_array = array(
                'ebay_id'=>$this->ebay_id,
                'billing_name'=>$this->addresses['reg']['fullname'],
                'billing_street_address'=>$this->addresses['reg']['street'],
                'billing_postcode'=>$this->addresses['reg']['zip'],
                'billing_city'=>$this->addresses['reg']['city'],
                'billing_country'=>$this->addresses['reg']['countryname'],
                'customers_cid'=>$transaction['customer_cid'],
                'customers_id'=>$transaction['customer_id'],
                'customers_vat_id'=>$transaction['customers_vat_id'],
                'customers_status'=>EBAY_CUSTOMERS_STATUS,
                'customers_status_name'=>EBAY_CUSTOMERS_STATUS_NAME,
                'customers_status_image'=>'ebay_status.gif',
                'customers_name'=>$this->addresses['reg']['fullname'],
                'customers_street_address'=>$this->addresses['reg']['street'],
                'customers_postcode'=>$this->addresses['reg']['zip'],
                'customers_city'=>$this->addresses['reg']['city'],
                'customers_country'=>$this->addresses['reg']['countryname'],
                'customers_email_address'=>$transaction['email'],
                'customers_telephone'=>$this->get_order_phone_from_addresses(),

                'delivery_name'=>$this->addresses['ship']['fullname'],
                'delivery_street_address'=>$this->addresses['ship']['street'],
                'delivery_suburb'=>((isset($this->addresses['ship']['suburb']))?$this->addresses['ship']['suburb']:''),
                'delivery_postcode'=>$this->addresses['ship']['zip'],
                'delivery_city'=>$this->addresses['ship']['city'],
                'delivery_country'=>$this->addresses['ship']['countryname'],
                'ebay_shippingcountry'=>_get_country_id_from_code($this->addresses['ship']['country']),
                'delivery_address_format_id'=>EBAY_ADDRESS_FORMAT_ID,
                'customers_address_format_id'=>EBAY_ADDRESS_FORMAT_ID,
                'billing_address_format_id'=>EBAY_ADDRESS_FORMAT_ID,
                'payment_method' => $transaction['order']['payment_method'],
                'payment_class' => $transaction['order']['payment_class'],
                'shipping_method' => $transaction['order']['shipping_method'],
                'shipping_class' => $transaction['order']['shipping_class'],
                'orders_status'=>$orders_status,
                'currency'=>$transaction['currency'],
                'account_type'=>0,
                'language'=>$site,
                'date_purchased'=>$transaction['order']['date'],
                'ebay_no_shippingaddress'=>$this->ebay_no_shippingaddress,
                'ebay_different_address'=>$this->ebay_different_address,
                //'ebay_no_registrationaddress'=>$this->ebay_no_registrationaddress,
                // gibt es nicht mehr
                //'select_set'=>((isset($auction_data['select_set']))?$auction_data['select_set']:''),
                'payment_transaction_id'=>((isset($transaction['ExternalTransactionID']) and $transaction['ExternalTransactionID'] != '')?$transaction['ExternalTransactionID']:''),
                'source'=>'ebay',
                'versender'=>$default_shipper,
                'ebay_plus'=>$this->ebay_plus,
            );
            xtc_db_perform('orders',$order_sql_array);
            $orders_id = xtc_db_insert_id();
            $this->debug( "\tAuftrag $orders_id wurde generiert" );
            return $orders_id;
        }
        
        private static function get_default_shipper_from_products_id($products_id, $qty){
            if($products_id > 0 and $qty == 1){
                return \YES4Trade\Model\shipper_profiles::get_products_id_value($products_id);
            }
            return '';
        }

	private function create_order_product(int $orders_id, int $products_id, array $auction_data){
		$transaction = $this->transaction_data;
		$products_quantity = $transaction['order']['qty'];
		$products_price = $transaction['order']['itemtotal'];
		$final_price = ($transaction['order']['itemtotal']*$transaction['order']['qty']);
		if(isset($transaction['variation_sku']) and $transaction['variation_sku'] != ''){
		        if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
		            $ea = new ebay_auction($auction_data['id']);
		            if($ea->has_staffelpreise()){
		                $staffelpreis_qty = $ea->get_staffelpreis_quantity_from_sku($transaction['variation_sku']);
				$products_price = $final_price / $staffelpreis_qty;
				$products_quantity = $products_quantity * $staffelpreis_qty;
		            }
		        }
		}
		$orders_products_sql_array = array(
			'orders_id'=>$orders_id,
			'products_id' => $products_id,
			'products_model'=>$auction_data['products_model'],
			'products_name'=>xtc_db_input($transaction['order']['products_name']),
			'products_price'=>$products_price,
			'final_price'=>$final_price,
			'products_tax'=>$transaction['order']['vat'],
			'products_quantity'=>$products_quantity,
			'allow_tax'=>(($transaction['order']['vat']>0)?'1':'0'),
			'date_added'=>$transaction['order']['date']
		);
		xtc_db_perform('orders_products',$orders_products_sql_array);
		$order_products_id = xtc_db_insert_id();
		$this->debug("\torder product #$order_products_id saved");
		return $order_products_id;
	}


	private function create_order_totals(int $orders_id, bool $unknown_pID = false){
		$transaction = $this->transaction_data;
		if($unknown_pID){
			$orders_total_subtotal_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_SUBTOTAL_TITLE,
				'text'=>'0,00 '.$transaction['currency'],
				'value'=>0,
				'class'=>'ot_subtotal',
				'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
			);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_subtotal_array);
		}else{
			$orders_total_subtotal_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_SUBTOTAL_TITLE,
				'text'=>number_format(($transaction['order']['itemtotal'] * $transaction['order']['qty']),2,',','.').' '.$transaction['currency'],
				'value'=>($transaction['order']['itemtotal'] * $transaction['order']['qty']),
				'class'=>'ot_subtotal',
				'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
			);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_subtotal_array);
		}

		// -------------------------------------------
		// SHIPPINGTOTAL
		// -------------------------------------------
		$orders_total_shipping_array = array(
			'orders_id'=>$orders_id,
			'title'=>$transaction['order']['shipping_title'],
			'text'=>number_format($transaction['order']['shipping'],2,',','.').' '.$transaction['currency'],
			'value'=>$transaction['order']['shipping'],
			'class'=>'ot_shipping',
			'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER,
			'tax_rate_percent'=>$transaction['order']['vat']
		);
		xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_shipping_array);

		// -------------------------------------------
		// VATTOTAL
		// -------------------------------------------
		if(!$unknown_pID and $transaction['order']['vat'] > 0){
			$orders_total_tax_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_TAX_TITLE . number_format($transaction['order']['vat'],0,',','.').'%',
				'text'=> number_format($transaction['order']['total']-( $transaction['order']['total'] / ((100+$transaction['order']['vat'])/100) ),2,',','.' ).' '.$transaction['currency'],
				'value'=>$transaction['order']['total'] - ( $transaction['order']['total'] / ((100+$transaction['order']['vat'])/100) ),
				'class'=>'ot_tax',
				'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
				'tax_rate_percent'=>$transaction['order']['vat']
			);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_tax_array);
		}
		if($unknown_pID){
			$orders_total_tax_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_TAX_TITLE . number_format($transaction['order']['vat'],0,',','.').'%',
				'text'=> '0,00 '.$transaction['currency'],
				'value'=>0,
				'class'=>'ot_tax',
				'sort_order'=>MODULE_ORDER_TOTAL_TAX_SORT_ORDER,
				'tax_rate_percent'=>$transaction['order']['vat']
			);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_tax_array);
		}
		if($unknown_pID){
			$orders_total_total_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_TOTAL_TITLE,
				'text'=>'0,00 '.$transaction['currency'],
				'value'=>0,
				'class'=>'ot_total',
				'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
			);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_total_array);
		}else{
			$orders_total_total_array = array(
				'orders_id'=>$orders_id,
				'title'=>EBAY_TOTAL_TOTAL_TITLE,
				'text'=>number_format($transaction['order']['total'],2,',','.').' '.$transaction['currency'],
				'value'=>$transaction['order']['total'],
				'class'=>'ot_total',
				'sort_order'=>MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
			);
			xtc_db_perform(TABLE_ORDERS_TOTAL, $orders_total_total_array);
		}
		$this->debug("\torder total datensaetze erzeugt");
	}

	private function create_order_history(int $orders_id, int $orders_status, $unknown_products_id = false){
		$transaction = $this->transaction_data;
		$customer_notification = (SEND_EMAILS == 'true') ? '1' : '0';
		if(!$unknown_products_id){		
			$order_history_text = "Ebay-Auktion ".$this->ebay_id." als Bestellung angelegt.";
		}else{
			$order_history_text = $this->source.": Ebay-Auktion ".$this->ebay_id." als Bestellung ohne Referenz zur Produktdatenbank angelegt.";
		}
		if(isset($transaction['ExternalTransactionID'])){
			$order_history_text .= " Paypal Transaction ID: ".$transaction['ExternalTransactionID'];
		}
		
		
		$order_history_sql_array = array(
			'orders_id' => $orders_id,
			'orders_status_id' => $orders_status,
			'date_added' => $transaction['order']['date'],
			'customer_notified' => $customer_notification,
			'comments' => $this->source.": ".$order_history_text
		);
		xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $order_history_sql_array);
		$this->debug( "\tAuftrag Historie geschrieben" );
	}

	private function create_ebay_transaction_entry(int $products_id, int $orders_id, string $site){
		$transaction = $this->transaction_data;
		// ----------------------------------------------------
		// KOPIE DER DATEN IN ebay_transactions
		// ----------------------------------------------------
		$transaction_sql_array = array(
			'transactionid'=>$this->transaction_id,
			'ebayid'=>$this->ebay_id,
			'products_id'=>$products_id,
			'orders_id'=>$orders_id,
			'email'=>$transaction['email'],
			'fullname'=>$this->addresses['reg']['fullname'],
			'street1'=>$this->addresses['reg']['street'],
			'zip'=>$this->addresses['reg']['zip'],
			'city'=>$this->addresses['reg']['city'],
			'userid'=>$transaction['ebay_user'],
			'paymentmethod'=>$transaction['order']['payment_method'],
			'shippinghandlingcosts'=>$transaction['order']['shipping'],
			'amountpaid'=>$transaction['order']['total'],
			'quantitypurchased'=>$transaction['order']['qty'],
			'transactionprice'=>$transaction['order']['itemtotal'],
			'transactiondate'=>$transaction['order']['date'],
			'currency_value'=>$transaction['umrechnungskurs'],
			'STATUS'=>'1',
			'seller'=>$this->seller,
			'site'=>$site,
			'checkoutstatus'=>$transaction['checkoutstatus'],
			'shipping_addressid'=>$this->addresses['ship']['addressid']
		);
		xtc_db_perform(TABLE_EBAY_TRANSACTIONS,$transaction_sql_array);
		$this->debug( "\tebay_transactions Eintrag gespeichert" );
	}
}
