<?php
/* -----------------------------------------------------------------------------------------
   $Id: order.php,v 1.109 2019/04/05 08:02:18 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(order.php,v 1.32 2003/02/26); www.oscommerce.com 
   (c) 2003	 nextcommerce (order.php,v 1.28 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   credit card encryption functions for the catalog module
   BMC 2003 for the CC CVV Module


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/

  // include needed functions
  require_once(DIR_FS_INC . 'xtc_date_long.inc.php');
  require_once(DIR_FS_INC . 'xtc_address_format.inc.php');
  require_once(DIR_FS_INC . 'xtc_get_country_name.inc.php');
  require_once(DIR_FS_INC . 'xtc_get_countries.inc.php');
  require_once(DIR_FS_INC . 'xtc_get_zone_code.inc.php');
  require_once(DIR_FS_INC . 'xtc_get_tax_description.inc.php');
  require_once(DIR_FS_CATALOG.'includes/classes/order_positions.php');
  require_once(DIR_FS_INC.'yes_get_products_description.inc.php');

  class order {
    var $info, $totals, $products, $customer, $delivery, $content_type,$total,
            $weight,$editor_id,$ebay_id_array,$Price,$tax_discount,$billing;

    public function __construct($order_id = '', xtcPrice $Price = Null) {
      $this->info = array();
      $this->totals = array();
      $this->products = array();
      $this->customer = array();
      $this->delivery = array();
      $this->Price=$Price;
      
      $this->editor_id = $_SESSION['customer_id'];
      $this->tax_discount = array();

      if (xtc_not_null($order_id)) {
        $this->query($order_id);
      } else {
        $this->cart();
      }
    }

	function query($order_id) {
		$order = yes_query(sprintf("select
                    orders_id,
                    ebay_id,
                    select_set_product_status,
                    combined_orders_id,
                    select_set,
                    customers_id,
                    customers_vat_id,
                    customers_status,
                    customers_cid,
                    customers_name,
                    customers_company,
                    customers_street_address,
                    customers_suburb,
                    customers_city,
                    customers_postcode,
                    customers_state,
                    customers_country,
                    customers_telephone,
                    customers_mobile,
                    customers_email_address,
                    customers_address_format_id,
                    delivery_name,
                    delivery_company,
                    delivery_street_address,
                    delivery_suburb,
                    delivery_city,
                    delivery_postcode,
                    delivery_state,
                    delivery_country,
                    delivery_address_format_id,
                    billing_name,
                    billing_company,
                    billing_street_address,
                    billing_suburb,
                    billing_city,
                    billing_postcode,
                    billing_state,
                    billing_country,
                    billing_address_format_id,
                    payment_method,
					payment_class,
                    shipping_class,
                    cc_type,
                    cc_owner,
                    cc_number,
                    cc_expires,
                    cc_cvv,
                    cc_start,
                    cc_issue,
                    currency,
                    comments,
                    currency_value,
                    date_purchased,
                    date_shipping,
                    orders_status,
                    ebay_shippingcountry,
                    language,
                    is_parent,
                    comments_visible,
                    last_modified,
                    source,yes_amazon_pay_reference,
					commission_number
                    from %s where
                    orders_id =:orders_id",
                    TABLE_ORDERS
		),['orders_id'=>intval($order_id)],true);
                if(!sizeOf($order)){
                    return false;
                }
		$ot_tax = 0;
		$order_total = array();
		$pp_order_tax = 0;
		$pp_order_disc = 0;
		$pp_order_gs = 0;
		$pp_order_fee = 0;
		$shipping_method = array();

		$totals_query = xtc_db_query("select title, text,value,class from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $order['orders_id'] . "' order by sort_order");
		while ($totals = xtc_db_fetch_array($totals_query)) {
			$this->totals[] = array('title' => $totals['title'],
				'text' =>$totals['text'],
				'class'=>$totals['class'],
				'value'=>$totals['value']
			);
			switch($totals['class']){
				case 'ot_total':
					$order_total = array(
						'title' => $totals['title'],
						'text' =>$totals['text'],
						'class'=>$totals['class'],
						'value'=>$totals['value']
					);
					break;
				case 'ot_tax':
					$ot_tax += $totals['value'];
					$pp_order_tax += $totals['value'];
					break;
				case 'ot_tax':
					$pp_order_disc += $totals['value'];
					break;
				case 'ot_coupon':
				case 'ot_gv':
					$pp_order_gs -= $totals['value'];
					break;
				case 'ot_payment':
				case 'ot_cod_fee':
				case 'ot_ps_fee':
				case 'ot_loworderfee':
					$pp_order_fee += $totals['value'];
					break;
				case 'ot_shipping':
					$shipping_method = array(
						'title'=>$totals['title'],
						'value'=>$totals['value']
					);
					break;
			}
		}
		$order_status_name = main::get_orders_status_name($order['orders_status'], (int)$_SESSION['languages_id']);

		$this->info = array('currency' => $order['currency'],
			'id'=>$order['orders_id'],
			'is_parent'=>$order['is_parent'],
			'status'=>$order['customers_status'],
			'currency_value' => $order['currency_value'],
			'payment_method' => $order['payment_method'],
            'payment_method_db' => $order['payment_method'],
			'payment_class_raw' => $order['payment_class'],
			'payment_class_db' => $order['payment_class'],
			'shipping_class' => $order['shipping_class'],
			'cc_type' => $order['cc_type'],
			'cc_owner' => $order['cc_owner'],
			'cc_number' => $order['cc_number'],
			'cc_expires' => $order['cc_expires'],
			'ebay_id'=>$order['ebay_id'],
			'select_set_product_status'=>$order['select_set_product_status'],
			'combined_orders_id'=>$order['combined_orders_id'],
			'select_set'=>$order['select_set'],
			// BMC CC Mod Start
			'cc_start' => $order['cc_start'],
			'cc_issue' => $order['cc_issue'],
			'cc_cvv' => $order['cc_cvv'],

// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
			'pp_total' => $order_total['value'],
			'pp_shipping' => $shipping_method['value'],
			'pp_tax' => $pp_order_tax,
			'pp_disc' => $pp_order_disc,
			'pp_gs' => $pp_order_gs,
			'pp_fee' => $pp_order_fee,
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul

			// BMC CC Mod End
			'date_purchased' => $order['date_purchased'],
			'date_shipping' => $order['date_shipping'],
			'orders_status' => $order_status_name,
			'orders_status_id' => $order['orders_status'],
			'last_modified' => $order['last_modified'],
			'total' => strip_tags($order_total['text']),
			'shipping_method' => ((substr($shipping_method['title'], -1) == ':') ? substr(strip_tags($shipping_method['title']), 0, -1) : strip_tags($shipping_method['title'])),
			'ebay_shippingcountry'=>$order['ebay_shippingcountry'],
			'comments' => $order['comments'],
			'language'=>$order['language'],
			'comments_visible' => $order['comments_visible'],
			'vat_id'=>$order['customers_vat_id'],
		    'source'=>$order['source'],
			'yes_amazon_pay_reference'=>$order['yes_amazon_pay_reference']??'',
			'yes_amazon_pay_reference_id'=>$order['yes_amazon_pay_reference_id']??'',
			'tax_groups'=>[],
			'tax_groups_clean'=>[],
			
			'commission_number'=>$order['commission_number'],
		);
		if($order['ebay_id'] != ''){
			$this->ebay_id_array[] = $order['ebay_id'];
		}
		$ebay_ids_query = xtc_db_query(sprintf(
			"SELECT ebay_id FROM orders WHERE combined_orders_id='%s' and ebay_id != ''",
			$order['orders_id']
		));
		while($ebay_ids = xtc_db_fetch_array($ebay_ids_query)){
			$this->ebay_id_array[] = $ebay_ids['ebay_id'];
		}
		$this->customer = array(
			'id' => $order['customers_id'],
			'firstname' => '', // PAYPAL ADDON - HABEN WIR ABER GAR NICHT
			'lastname' => '', // PAYPAL ADDON - HABEN WIR ABER GAR NICHT
			'name' => $order['customers_name'],
			'csID' => $order['customers_cid'],
			'vat_id' => $order['customers_vat_id'],
			'company' => $order['customers_company'],
			'street_address' => $order['customers_street_address'],
			'suburb' => $order['customers_suburb'],
			'city' => $order['customers_city'],
			'postcode' => $order['customers_postcode'],
			'state' => $order['customers_state'],
			'country' => $order['customers_country'],
			'format_id' => $order['customers_address_format_id'],
			'telephone' => $order['customers_telephone'],
			'mobile'=>$order['customers_mobile'],
			'email_address' => $order['customers_email_address']
		);
        $delivery_country_id = main::get_country_values_from_name(xtc_db_input($order['delivery_country']));
		$this->delivery = array(
			'name' => $order['delivery_name'],
			'firstname' => '', // PAYPAL ADDON - HABEN WIR ABER GAR NICHT
			'lastname' => '', // PAYPAL ADDON - HABEN WIR ABER GAR NICHT
			'company' => $order['delivery_company'],
			'street_address' => $order['delivery_street_address'],
			'suburb' => $order['delivery_suburb'],
			'city' => $order['delivery_city'],
			'postcode' => $order['delivery_postcode'],
			'state' => $order['delivery_state'],
			'country' => $order['delivery_country'],
			'country_iso_2' => $delivery_country_id['countries_iso_code_2'],
			'format_id' => $order['delivery_address_format_id'],
			'country_id' => $delivery_country_id['countries_id'],
			'iso_code_2' => $delivery_country_id['countries_iso_code_2'],
                    'zone_id'=>0, // erstmal als dummy
		);

		if (empty($this->delivery['name']) && empty($this->delivery['street_address'])) {
			$this->delivery = false;
		}

		// WE NEED THE COUNTRY ID
		$billing_country_id = main::get_country_values_from_name(xtc_db_prepare_input($order['billing_country']));
		$this->billing = array(
			'name' => $order['billing_name'],
			'firstname' => '', // PAYPAL ADDON - HABEN WIR ABER GAR NICHT
			'lastname' => '', // PAYPAL ADDON - HABEN WIR ABER GAR NICHT
			'company' => $order['billing_company'],
			'street_address' => $order['billing_street_address'],
			'suburb' => $order['billing_suburb'],
			'city' => $order['billing_city'],
			'postcode' => $order['billing_postcode'],
			'state' => $order['billing_state'],
			'country' => $order['billing_country'],
			'format_id' => $order['billing_address_format_id'],
			'country_iso_2' => $billing_country_id['countries_iso_code_2']
		);

		$index = 0;
		$orders_products_query = xtc_db_query(sprintf(
			"select orders_products_id, products_id, products_name, products_model, products_price, products_tax, allow_tax, products_quantity, final_price,weight, volume from %s where orders_id = '%d'",
			TABLE_ORDERS_PRODUCTS, $order['orders_id']
		));
		$own_weight = 0;
		$own_volume = 0;
		while ($orders_products = xtc_db_fetch_array($orders_products_query)) {
			$own_weight += floatval($orders_products['weight']);
			$own_volume += floatval($orders_products['volume']);
			$this->products[$index] = array(
				'qty' => $orders_products['products_quantity'],
				'id' => $orders_products['products_id'],
				'opID' => $orders_products['orders_products_id'],
				'name' => $orders_products['products_name'],
				'model' => $orders_products['products_model'],
				'tax' => $orders_products['products_tax'],
				'allow_tax' => $orders_products['allow_tax'],
				'price'=>$orders_products['products_price'],
				'final_price' => $orders_products['final_price'],
				'weight'=>floatval($orders_products['weight']),
				'volume'=>floatval($orders_products['volume']),
			);
			$this->products[$index]['properties'] = $this->get_properties( $orders_products['orders_products_id']);
			$this->info['tax_groups']["{$this->products[$index]['tax']}"] = '1';
			$this->info['tax_groups_clean']["{$this->products[$index]['tax']}"] = '1';
			$index++;
		}
		$this->info['own_weight'] = $own_weight;
		$this->info['own_volume'] = $own_volume;
	}

	private static function get_country_data($countries_id){
		return main::get_country_values((int)$countries_id);
	}

	private static function getAmazonAddressValue($addresspart, $class='shipping_address'){
		$default_value = '';
		switch($addresspart){
			case 'zone_id':
				$default_value = 0;
				break;
		}
		return (isset($_SESSION['yes_amazon_payment'][$class][$addresspart])) ? $_SESSION['yes_amazon_payment'][$class][$addresspart] : $default_value;
	}

	private function get_address_array(){
		if(!isset($_SESSION['customer_id'])){
			
			$tax_array = array();
			if(isset($_SESSION['payment']) and $_SESSION['payment'] == 'yes_amazon_pay' and isset($_SESSION['yes_amazon_payment']) and isset($_SESSION['yes_amazon_payment']['shipping_address']['countries_id']) and $_SESSION['yes_amazon_payment']['shipping_address']['countries_id'] > 0){
				$tax_array = array(
					'entry_country_id'=>$this->getAmazonAddressValue('countries_id','shipping_address'),
					'entry_zone_id'=>$this->getAmazonAddressValue('zone_id','shipping_address')
				);
			}
			// yes amazon payment
			$billing_country_data = $this->get_country_data($this->getAmazonAddressValue('countries_id','payment_address'));
			$delivery_country_data = $this->get_country_data($this->getAmazonAddressValue('countries_id','shipping_address'));
			return array(
				'customer'=>array(),
				'shipping'=>array(
					'entry_zone_id'=>$this->getAmazonAddressValue('zone_id','shipping_address'),
					'entry_state'=>$this->getAmazonAddressValue('state','shipping_address'),
					'countries_id'=>$this->getAmazonAddressValue('countries_id','shipping_address'),
					'countries_name'=>$delivery_country_data['countries_name'],
					'countries_iso_code_2'=>$delivery_country_data['countries_iso_code_2'],
					'countries_iso_code_3'=>$delivery_country_data['countries_iso_code_3']
				),
				'billing'=>array(
					'entry_zone_id'=>$this->getAmazonAddressValue('zone_id','payment_address'),
					'entry_state'=>$this->getAmazonAddressValue('state','payment_address'),
					'countries_id'=>$this->getAmazonAddressValue('countries_id','payment_address'),
					'countries_name'=>$billing_country_data['countries_name'],
					'countries_iso_code_2'=>$billing_country_data['countries_iso_code_2'],
					'countries_iso_code_3'=>$billing_country_data['countries_iso_code_3']
				),
				'tax'=>$tax_array
			);
		}
		// eingeloggter User aber Amazon pay
		if(isset($_SESSION['payment']) and $_SESSION['payment'] == 'yes_amazon_pay'){
			if(isset($_SESSION['yes_amazon_payment']) and isset($_SESSION['yes_amazon_payment']['shipping_address']) and $_SESSION['yes_amazon_payment']['shipping_address']['countries_id'] > 0){
				$delivery_country_id = $this->getAmazonAddressValue('countries_id','shipping_address');
			}else{
				$delivery_country_id = STORE_COUNTRY;
			}
			if(isset($_SESSION['yes_amazon_payment']) and isset($_SESSION['yes_amazon_payment']['payment_address']) and $_SESSION['yes_amazon_payment']['payment_address']['countries_id'] > 0){
				$billing_country_id = $this->getAmazonAddressValue('countries_id','payment_address');
			}else{
				$billing_country_id = STORE_COUNTRY;
			}
			$tax_array = array(
				'entry_country_id'=>$this->getAmazonAddressValue('countries_id','shipping_address'),
				'entry_zone_id'=>$this->getAmazonAddressValue('zone_id','shipping_address')
			);
			// yes amazon payment
			$billing_country_data = $this->get_country_data($billing_country_id);
			$delivery_country_data = $this->get_country_data($delivery_country_id);
			return array(
				'customer'=>array(),
				'shipping'=>array(
					'entry_zone_id'=>$this->getAmazonAddressValue('zone_id','shipping_address'),
					'entry_state'=>$this->getAmazonAddressValue('state','shipping_address'),
					'countries_id'=>$this->getAmazonAddressValue('countries_id','shipping_address'),
					'countries_name'=>$delivery_country_data['countries_name'],
					'countries_iso_code_2'=>$delivery_country_data['countries_iso_code_2'],
					'countries_iso_code_3'=>$delivery_country_data['countries_iso_code_3']
				),
				'billing'=>array(
					'entry_zone_id'=>$this->getAmazonAddressValue('zone_id','payment_address'),
					'entry_state'=>$this->getAmazonAddressValue('state','payment_address'),
					'countries_id'=>$this->getAmazonAddressValue('countries_id','payment_address'),
					'countries_name'=>$billing_country_data['countries_name'],
					'countries_iso_code_2'=>$billing_country_data['countries_iso_code_2'],
					'countries_iso_code_3'=>$billing_country_data['countries_iso_code_3']
				),
				'tax'=>$tax_array
			);
		}
		$customer_address_query_raw = "select c.customers_firstname,c.customers_cid, c.customers_gender,c.customers_lastname, c.customers_telephone, c.customers_email_address, ab.entry_company, ab.entry_street_address, ab.entry_suburb, ab.entry_postcode, ab.entry_city, ab.entry_zone_id, z.zone_name, co.countries_id, co.countries_name, co.countries_iso_code_2, co.countries_iso_code_3, co.address_format_id, ab.entry_state from " . TABLE_CUSTOMERS . " c, " . TABLE_ADDRESS_BOOK . " ab left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id) left join " . TABLE_COUNTRIES . " co on (ab.entry_country_id = co.countries_id) where c.customers_id = '" . $_SESSION['customer_id'] . "' and ab.customers_id = '" . $_SESSION['customer_id'] . "' and c.customers_default_address_id = ab.address_book_id";
		$customer_address_query = xtc_db_query($customer_address_query_raw);
		$customer_address = xtc_db_fetch_array($customer_address_query);
		if(isset($_SESSION['sendto'])){
			$shipping_address_query = xtc_db_query("select ab.entry_firstname, ab.entry_gender,ab.entry_lastname, ab.entry_company, ab.entry_street_address, ab.entry_suburb, ab.entry_postcode, ab.entry_city, ab.entry_zone_id, z.zone_name, ab.entry_country_id, c.countries_id, c.countries_name, c.countries_iso_code_2, c.countries_iso_code_3, c.address_format_id, ab.entry_state from " . TABLE_ADDRESS_BOOK . " ab left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id) left join " . TABLE_COUNTRIES . " c on (ab.entry_country_id = c.countries_id) where ab.customers_id = '" . $_SESSION['customer_id'] . "' and ab.address_book_id = '" . $_SESSION['sendto'] . "'");
		}else{
		// WENN KEINE VERSANDADRESSE GEWAEHLT WURDE - DEFAULTADRESSE
			$shipping_address_query = xtc_db_query($customer_address_query_raw);
		}
		$shipping_address = xtc_db_fetch_array($shipping_address_query);

		if(isset($_SESSION['billto'])){
			$billing_address_query = xtc_db_query("select ab.entry_firstname, ab.entry_gender,ab.entry_lastname, ab.entry_company, ab.entry_street_address, ab.entry_suburb, ab.entry_postcode, ab.entry_city, ab.entry_zone_id, z.zone_name, ab.entry_country_id, c.countries_id, c.countries_name, c.countries_iso_code_2, c.countries_iso_code_3, c.address_format_id, ab.entry_state from " . TABLE_ADDRESS_BOOK . " ab left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id) left join " . TABLE_COUNTRIES . " c on (ab.entry_country_id = c.countries_id) where ab.customers_id = '" . $_SESSION['customer_id'] . "' and ab.address_book_id = '" . $_SESSION['billto'] . "'");
		}else{
			$billing_address_query = $customer_address_query;
		}
		$billing_address = xtc_db_fetch_array($billing_address_query);
		if (isset($_SESSION['AMZ_COUNTRY_ID']) && isset($_SESSION['AMZ_ZONE_ID'])) {
			// NIE EINGEBAUTES AMAZON PAYMENT HANDLING
			$tax_address = array('entry_country_id' => $_SESSION['AMZ_COUNTRY_ID'],
				'entry_zone_id' => $_SESSION['AMZ_ZONE_ID']
			);
		} else {
			if(isset($_SESSION['billto']) and isset($_SESSION['sendto'])){
				$tax_address_query = xtc_db_query("select ab.entry_country_id, ab.entry_zone_id from " . TABLE_ADDRESS_BOOK . " ab left join " . TABLE_ZONES . " z on (ab.entry_zone_id = z.zone_id) where ab.customers_id = '" . $_SESSION['customer_id'] . "' and ab.address_book_id = '" . ($this->content_type == 'virtual' ? $_SESSION['billto'] : $_SESSION['sendto']) . "'");
			}else{
				$tax_address_query = xtc_db_query($customer_address_query_raw);
			}
			$tax_address = xtc_db_fetch_array($tax_address_query);
		}
		return array(
			'customer'=>$customer_address,
			'shipping'=>$shipping_address,
			'billing'=>$billing_address,
			'tax'=>$tax_address,
		);
	}

	function cart() {
		global $currencies;
		if(gettype($currencies) == 'NULL'){
			if(!class_exists('currencies')){
				require_once(DIR_FS_CATALOG.'includes/classes/currencies.php');
			}
			$currencies = new \currencies;
		}

		$this->tax_discount = array ();
		if (!isset($_SESSION['cart']) or !is_object($_SESSION['cart'])) {
			$_SESSION['cart'] = new shoppingCart();
		}
		$this->content_type = $_SESSION['cart']->get_content_type();

		$address_data = $this->get_address_array();
		$customer_address = $address_data['customer'];
		$shipping_address = $address_data['shipping'];
		$billing_address = $address_data['billing'];
		$tax_address = $address_data['tax'];
      
		$this->info = array(
			'order_status' => DEFAULT_ORDERS_STATUS_ID,
			'status'=>$_SESSION['customers_status']['customers_status_id'],
			'currency' => $_SESSION['currency'],
			'currency_value' => $currencies->currencies[$_SESSION['currency']]['value'],
			'payment_method' => (isset($_SESSION['payment']))?$_SESSION['payment']:'',
			'cc_type' => ((isset($GLOBALS['cc_type']))?$GLOBALS['cc_type']:''),
			'cc_owner' => ((isset($GLOBALS['cc_owner']))?$GLOBALS['cc_owner']:''),
			'cc_number' => ((isset($GLOBALS['cc_number']))?$GLOBALS['cc_number']:''),
			'cc_expires' => ((isset($GLOBALS['cc_expires']))?$GLOBALS['cc_expires']:''),
			'cc_start' => (isset($GLOBALS['cc_start']) ? $GLOBALS['cc_start'] : ''),
			'cc_issue' => (isset($GLOBALS['cc_issue']) ? $GLOBALS['cc_issue'] : ''),
			'cc_cvv' => (isset($GLOBALS['cc_cvv']) ? $GLOBALS['cc_cvv'] : ''),
			'shipping_method' => ((isset($_SESSION['shipping']['title']))?$_SESSION['shipping']['title']:''),
			'shipping_cost' => (isset($_SESSION['shipping']['cost']))?$_SESSION['shipping']['cost']:0,
			'comments' => ((isset($_SESSION['comments']))? $_SESSION['comments'] :''),
			'shipping_class'=>((isset($_SESSION['shipping']['id']))?$_SESSION['shipping']['id']:''),
			'payment_class' => (isset($_SESSION['payment']))?$_SESSION['payment']:'',
			'tax_groups'=>[],
			'tax_groups_clean'=>[],
		);
		if (isset($_SESSION['payment']) && is_object($_SESSION['payment'])) {
			if(isset($_SESSION['payment']->title2) or $_SESSION['payment']->title2 != ''){
				$this->info['payment_method'] = $_SESSION['payment']->title2;
				$this->info['payment_class'] = $_SESSION['payment']->title2;
			}else{
				$this->info['payment_method'] = $_SESSION['payment']->title;
				$this->info['payment_class'] = $_SESSION['payment']->title;
			}
			if ( isset($_SESSION['payment']->order_status) && is_numeric($_SESSION['payment']->order_status) && ($_SESSION['payment']->order_status > 0) ) {
				$this->info['order_status'] = $_SESSION['payment']->order_status;
			}
		}
        $format_id = ($customer_address['address_format_id'] > 0) ? $customer_address['address_format_id'] : 5;
		$this->customer = array('firstname' => $customer_address['customers_firstname'],
			'lastname' => $customer_address['customers_lastname'],
			'csID' => $customer_address['customers_cid'],
			'gender' => $customer_address['customers_gender'],
			'company' => $customer_address['entry_company'],
			'street_address' => $customer_address['entry_street_address'],
			'suburb' => $customer_address['entry_suburb'],
			'city' => $customer_address['entry_city'],
			'postcode' => $customer_address['entry_postcode'],
			'state' => ((xtc_not_null($customer_address['entry_state'])) ? $customer_address['entry_state'] : $customer_address['zone_name']),
			'zone_id' => $customer_address['entry_zone_id'],
			'country' => array('id' => $customer_address['countries_id'], 'title' => $customer_address['countries_name'], 'iso_code_2' => $customer_address['countries_iso_code_2'], 'iso_code_3' => $customer_address['countries_iso_code_3']),
			'format_id' => $format_id,
			'telephone' => $customer_address['customers_telephone'],
			'email_address' => $customer_address['customers_email_address']
		);
		$fn = (isset($shipping_address['entry_firstname']))?$shipping_address['entry_firstname']:$shipping_address['customers_firstname'];
		$ln = (isset($shipping_address['entry_lastname']))?$shipping_address['entry_lastname']:$shipping_address['customers_lastname'];
		$country_id = (isset($shipping_address['entry_country_id']))?$shipping_address['entry_country_id']:$shipping_address['countries_id'];
                if((int)$country_id<1){
                    $country_id = STORE_COUNTRY;
                    $record = main::get_country_values($country_id);
                    $shipping_address['countries_name'] = $record['countries_name'];
                    $shipping_address['countries_iso_code_2'] = $record['countries_iso_code_2'];
                    $shipping_address['countries_iso_code_3'] = $record['countries_iso_code_3'];
                }
        $format_id = ($shipping_address['address_format_id'] > 0) ? $shipping_address['address_format_id'] : 5;
		$this->delivery = array(
			'firstname' => $fn,
			'lastname' => $ln,
			'company' => $shipping_address['entry_company'],
			'street_address' => $shipping_address['entry_street_address'],
			'suburb' => $shipping_address['entry_suburb'],
			'city' => $shipping_address['entry_city'],
			'postcode' => $shipping_address['entry_postcode'],
			'state' => ((xtc_not_null($shipping_address['entry_state'])) ? $shipping_address['entry_state'] : $shipping_address['zone_name']),
			'zone_id' => $shipping_address['entry_zone_id'],
			'country' => array(
				'id' => $country_id, 
				'title' => $shipping_address['countries_name'], 
				'iso_code_2' => $shipping_address['countries_iso_code_2'], 
				'iso_code_3' => $shipping_address['countries_iso_code_3']
			),
			'country_id' => $country_id,
			'format_id' => $format_id,
			'entry_gender' => $shipping_address['entry_gender']??''
		);
        $format_id = ($billing_address !== false and $billing_address['address_format_id']>0)?$billing_address['address_format_id']:5;
		$billing_state = '';
		if($billing_address !== false){
			$billing_state = (xtc_not_null($billing_address['entry_state'])) ? $billing_address['entry_state'] : $billing_address['zone_name'];
		}
		$this->billing = array('firstname' => $billing_address['entry_firstname']??'',
			'lastname' => $billing_address['entry_lastname']??'',
			'company' => $billing_address['entry_company']??'',
			'street_address' => $billing_address['entry_street_address']??'',
			'suburb' => $billing_address['entry_suburb']??'',
			'city' => $billing_address['entry_city']??'',
			'postcode' => $billing_address['entry_postcode']??'',
			'state' => $billing_state,
			'zone_id' => $billing_address['entry_zone_id']??0,
			'country' => array(
				'id' => $billing_address['countries_id']??null, 
				'title' => $billing_address['countries_name']??'', 
				'iso_code_2' => $billing_address['countries_iso_code_2']??'', 
				'iso_code_3' => $billing_address['countries_iso_code_3']??''
			),
			'country_id' => $billing_address['entry_country_id']??0,
			'format_id' => $format_id,
			'entry_gender' => $shipping_address['entry_gender']??''
		);
		$index = 0;
		$products = $_SESSION['cart']->get_products();
        $_tax_rate_country_id = (isset($tax_address['entry_country_id'])) ? $tax_address['entry_country_id'] : $this->delivery['country']['id'];
		$this->Price = 	new xtcPrice($this->info['currency'],$this->info['status']);
		// EU-OSS 2021/07
		$euoss = yes_eu_oss_use_country_handling($_tax_rate_country_id);
		
		// BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
		/*if($euoss){
			$this->Price->setCountryZone($_tax_rate_country_id, $tax_address['entry_zone_id']);
		}*/
		// EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
		
		// BUGF_CH_OSS - IMMER ZONE/COUNTRY
		$this->Price->setCountryZone($_tax_rate_country_id, $tax_address['entry_zone_id']);
                
		for ($i=0, $n=sizeof($products); $i<$n; $i++) {
			if($euoss){
				$products[$i]['tax_class_id'] = yes_eu_oss_get_products_tax_class_id(
					xtc_get_prid($products[$i]['id']), 
					$_tax_rate_country_id, 
					$tax_address['entry_zone_id']
				);
			}
			$format=false;
			$products_price = $this->Price->xtcGetPrice(
				xtc_get_prid($products[$i]['id']),
				$format,
				$products[$i]['quantity'],
				$products[$i]['tax_class_id']
			);
			$products_price = floatval($products_price);
			// BUGF_CH_OSS - IMMER ZONE/COUNTRY
			$_product_tax_rate = xtc_get_tax_rate($products[$i]['tax_class_id'], $_tax_rate_country_id, $tax_address['entry_zone_id']);
			$tax_description = xtc_get_tax_description($products[$i]['tax_class_id'], $_tax_rate_country_id, $tax_address['entry_zone_id']);
			$properties = $_SESSION['cart']->get_properties_array( $products[$i]['id'] );
			$xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)$products[$i]['id']);
                        
			if($xy !== false){
				foreach($properties as $pp_item){
					if($pp_item['products_properties_id'] == $xy->products_properties_id_X){
						$X = $pp_item['value'];
					}
					if($pp_item['products_properties_id'] == $xy->products_properties_id_Y){
						$Y= $pp_item['value'];
					}
				}
				$xy_price = $xy->get_price($X, $Y, xtc_get_tax_rate($products[$i]['tax_class_id']));
				$products_price = floatval($xy_price['PRICE_BRUTTO']);
				if(is_countable($xy_price['ALLOCATED_PROPERTIES_PRICES']) and sizeOf($xy_price['ALLOCATED_PROPERTIES_PRICES'])){							
					$p1 = explode('{',$products[$i]['id']);
					$p2 = explode('}',$p1[1]);
					$p3 = explode(',',$p2[0]);
					// ALLE UEBERGEBENEN ppvID durchlaufen
					foreach($p3 as $products_properties_values_id){
						if(strpos($products_properties_values_id,':')>-1){
							continue;
						}
						$q1 = xtc_db_query(sprintf(
							"SELECT ppv.products_properties_id FROM `products_properties_values` ppv WHERE `products_properties_values_id`='%d'",
							$products_properties_values_id
						));
						$r1 = xtc_db_fetch_array($q1);
						$products_properties_id = $r1['products_properties_id'];
						foreach($xy_price['ALLOCATED_PROPERTIES_PRICES'] as $ap){
							if($ap['products_properties_id'] == $products_properties_id && $ap['products_properties_values_id'] == $products_properties_values_id){
								$products_price += floatval($ap['PRICE_BRUTTO']);
							
							}
						}
					}
				}
				$properties_netto = 0;
			}else{// end is xy
				$properties_netto = $this->get_product_properties_price_netto($products[$i]['id']);
			}
			if ($_SESSION['customers_status']['customers_status_show_price_tax'] == '1') {
				$properties_brutto = xtc_oe_get_price_i_tax($properties_netto, $_product_tax_rate, false);
				$products_price += floatval($properties_brutto);
			}else{
				$products_price += floatval($properties_netto);
			}
			$this->products[$index] = array(
				'qty' => $products[$i]['quantity'],
				'name' => $products[$i]['name'],
				'slave_title'=>$products[$i]['slave_title'],
				'model' => $products[$i]['model'],
				'tax_class_id'=> $products[$i]['tax_class_id'],
				'tax' => $_product_tax_rate,
				'tax_description' => $tax_description,
				'price' =>  $products_price,
				'price_formated' => $this->Price->xtcFormat($products_price,true),
				'final_price' => ($products_price)*$products[$i]['quantity'],
				'final_price_formated' => $this->Price->xtcFormat(($products_price)*$products[$i]['quantity'],true),
				'weight' => $products[$i]['weight'],
				'id' => xtc_get_prid($products[$i]['id']),
				'properties'=>$properties,
				'shipping_time'=>$products[$i]['products_shippingtime'],
			);

			$shown_price = floatval($this->products[$index]['final_price']);
			if(!isset($this->info['subtotal'])) {
				$this->info['subtotal'] = 0;
			}
			$this->info['subtotal'] += $shown_price;
			if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1){
				$shown_price_tax = $shown_price-($shown_price/100 * $_SESSION['customers_status']['customers_status_ot_discount']);
			}
			$products_tax = $this->products[$index]['tax'];
			$products_tax_description = $this->products[$index]['tax_description'];
			if(!isset($this->info['tax'])) {
				$this->info['tax'] = 0;
			}
			if(!isset($this->info['tax_groups'])) {
				$this->info['tax_groups'] = array();
			}
			if ($_SESSION['customers_status']['customers_status_show_price_tax'] == '1') {
				$txprefix = TAX_ADD_TAX;
			}else{
				$txprefix = TAX_NO_TAX;
			}
			if(!isset($this->info['tax_groups'][$txprefix."$products_tax_description"])) {
				$this->info['tax_groups'][$txprefix."$products_tax_description"] = 0;
			}
			// BOF - MWST FUER ot_tax BZW tax_rate_percent 
			if(!isset($this->info['tax_groups_clean'])) {
				$this->info['tax_groups_clean'] = array();
			}
			if(!isset($this->info['tax_groups_clean'][$txprefix."$products_tax_description"])){
				$this->info['tax_groups_clean'][$txprefix."$products_tax_description"] = array(
					'tax_percent'=>$this->products[$index]['tax'],
					'value'=>0
				);
			}
			// EOF - MWST FUER ot_tax BZW tax_rate_percent 

			if ($_SESSION['customers_status']['customers_status_show_price_tax'] == '1') {
				if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1) {
					$current_tax = (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax));
					$this->info['tax'] += $shown_price_tax - ($shown_price_tax / $current_tax);

					// BOF PAYPAL ADDON
					if(!isset($this->tax_discount[ $products[$i]['tax_class_id'] ])){
						$this->tax_discount[ $products[$i]['tax_class_id'] ] = 0;
					}
					$this->tax_discount[ $products[$i]['tax_class_id'] ] += ($shown_price_tax/100) * $products_tax;
					// EOF PAYPAL
					$this->info['tax_groups'][TAX_ADD_TAX."$products_tax_description"] += (($shown_price_tax /(100+$products_tax)) * $products_tax);

					// BOF - MWST FUER ot_tax BZW tax_rate_percent 
					$this->info['tax_groups_clean'][TAX_ADD_TAX."$products_tax_description"]['value'] += (($shown_price_tax /(100+$products_tax)) * $products_tax);
					// EOF - MWST FUER ot_tax BZW tax_rate_percent 
				} else {
					$this->info['tax'] += $shown_price - ($shown_price / (($products_tax < 10) ? "1.0" . str_replace('.', '', $products_tax) : "1." . str_replace('.', '', $products_tax)));
					$this->info['tax_groups'][TAX_ADD_TAX . "$products_tax_description"] += (($shown_price /(100+$products_tax)) * $products_tax);

					// BOF - MWST FUER ot_tax BZW tax_rate_percent 
					$this->info['tax_groups_clean'][TAX_ADD_TAX . "$products_tax_description"]['value'] += (($shown_price /(100+$products_tax)) * $products_tax);
					// EOF - MWST FUER ot_tax BZW tax_rate_percent 
				}
			} else {
				if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == 1) {
					$this->info['tax'] += ($shown_price_tax/100) * ($products_tax);
					$this->info['tax_groups'][TAX_NO_TAX . "$products_tax_description"] += ($shown_price_tax/100) * ($products_tax);

					// BOF - MWST FUER ot_tax BZW tax_rate_percent 
					$this->info['tax_groups_clean'][TAX_NO_TAX . "$products_tax_description"]['value'] += ($shown_price_tax/100) * ($products_tax);
					// EOF - MWST FUER ot_tax BZW tax_rate_percent 

				} else {
					$this->info['tax'] += ($shown_price/100) * ($products_tax);
					$this->info['tax_groups'][TAX_NO_TAX . "$products_tax_description"] += ($shown_price/100) * ($products_tax);

					// BOF - MWST FUER ot_tax BZW tax_rate_percent 
					$this->info['tax_groups_clean'][TAX_NO_TAX . "$products_tax_description"]['value'] += ($shown_price/100) * ($products_tax);
					// EOF - MWST FUER ot_tax BZW tax_rate_percent 
				}
			}

			$index++;
      	}
        // BOF - Tomcraft - 2009-10-03 - Paypal Express Modul
	  
	    /* 
		 * BOF BUGFIX
		 * ALSO MAL EHRLICH - DIE MWST (info['tax']) WIRD BEI DEN ARTIKELN SCHON HOCHGEZAEHLT - DAS HIER IST SCHWACHSINN
		 * MARIO - 27.07.12
		foreach ($this->tax_discount as $value) {
			$this->info['tax']+=round($value, $this->Price->get_decimal_places($order->info['currency']));
		}
		 * EOF BUGFIX
		 * 
		 */	
		
		// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul

		$xtPrice = new xtcPrice($this->info['currency'],$this->info['status']);
        $xtPrice->setCountryZone($_tax_rate_country_id, $tax_address['entry_zone_id']);
		if ($_SESSION['customers_status']['customers_status_show_price_tax'] == '0') {
			$this->info['total'] = $this->info['subtotal']  + $xtPrice->xtcFormat($this->info['shipping_cost'], false);
			if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == '1') {
				$this->info['total'] -= ($this->info['subtotal'] /100 * $_SESSION['customers_status']['customers_status_ot_discount']);
			}
		} else {
			$this->info['total'] = $this->info['subtotal']  + $xtPrice->xtcFormat($this->info['shipping_cost'],false);
			if ($_SESSION['customers_status']['customers_status_ot_discount_flag'] == '1') {
				$this->info['total'] -= ($this->info['subtotal'] /100 * $_SESSION['customers_status']['customers_status_ot_discount']);
			}
		}
	}

    function calculate( ) {
        $this->total = 0;
        $this->weight = 0;
        if (!is_array($this->products)) return 0;

        reset($this->products);
        if(!function_exists('xtc_get_ext_products_weight'))
                require(DIR_FS_INC.'xtc_collis.inc.php');
        // php8 bugfix
        //while (list($id, ) = each($this->products)) {
        foreach($this->products as $id => $egal) {
          $this->weight += ($this->products[$id]['qty'] * xtc_get_ext_products_weight($this->products[$id]['id']));
        }
    }

    function count_contents() {  // get total number of items in cart 
        $total_items = 0;
        if (is_array($this->products)) {
            reset($this->products);
            // php8 bugfix
            //while (list($id, ) = each($this->products)) {
            foreach($this->products as $id => $egal) {
                $total_items += $this->get_quantity($id);
            }
        }
        return $total_items;
    }

    function show_weight() {
        $this->calculate();
        return $this->weight;
    }

    function get_quantity($id) {
        if (isset($this->products[$id])) {
            return $this->products[$id]['qty'];
        }
        return 0;
    }

    function getOrderData($oID) {
    	global $xtPrice;
    	$order_query = yes_query("SELECT
            products_id,
            orders_products_id,
            products_model,
            products_name,
            final_price,
                    products_tax,
                    allow_tax,
            products_quantity
            FROM ".TABLE_ORDERS_PRODUCTS."
            WHERE orders_id=:orders_id",
            ['orders_id'=>(int) $oID]
        );
	$order_data = array ();
	foreach($order_query as $order_data_values) {
		// die get_products_price_netto() funktion erwartet als array die selbe
		// struktur wie ein $this->products array Eintrag
		$orders_product = array(
			'id'=>$order_data_values['products_id'],
			'qty'=>$order_data_values['products_quantity'],
			'tax'=>$order_data_values['products_tax'],
			'final_price'=>$order_data_values['final_price']
		);
		$products_price_netto = $this->get_products_price_netto($orders_product);
		$products_single_price_netto = $products_price_netto / $order_data_values['products_quantity'];

		$product_detail_query = xtc_db_query(sprintf(
			"SELECT products_shippingtime,products_ean FROM products WHERE products_id='%s'",
			$order_data_values['products_id']
		));
		$product_detail = xtc_db_fetch_array($product_detail_query);
		$order_data[] = array (
			'PRODUCTS_ID'=>$order_data_values['products_id'],
			'PRODUCTS_MODEL' => $order_data_values['products_model'],
			'PRODUCTS_NAME' => $order_data_values['products_name'],
			'PRODUCTS_SHIPPING_TIME' =>$product_detail['products_shippingtime'],
			'PRODUCTS_PRICE' => $order_data_values['final_price'],
			'PRODUCTS_SINGLE_PRICE' => $order_data_values['final_price']/$order_data_values['products_quantity'],
			'PRODUCTS_QTY' => $order_data_values['products_quantity'],
			'PRODUCTS_PRICE_NETTO' => $products_price_netto,
			'PRODUCTS_SINGLE_PRICE_NETTO' => $products_single_price_netto,
			'PROPERTIES'=>$this->get_properties($order_data_values['orders_products_id'])
		);

	}

	return $order_data;

    }

    function update_orders_status($status_id){
            $update_sql_array = array(
                    'orders_status'=>$status_id,
                    'last_modified'=>'now()'
            );
            yes_db_perform('orders',$update_sql_array,'update',
                    ['orders_id'=>$this->info['id']]
            );
    }

    public static function add_history_static(int $orders_id, int $status_id,bool $notified,string $comments){
        $insert_sql_array = array(
            'orders_id'=>$orders_id,
            'orders_status_id'=>$status_id,
            'date_added'=>date('Y-m-d H:i:s'),
            'customer_notified'=>$notified,
            'comments'=>$comments,
            'editor_id'=>intval($_SESSION['customer_id']??0)
        );
        yes_db_perform('orders_status_history',$insert_sql_array);
    }
    
    function add_history($status_id,$notified,$comments){
		$insert_sql_array = array(
			'orders_id'=>$this->info['id'],
			'orders_status_id'=>$status_id,
			'date_added'=>'now()',
			'customer_notified'=>$notified,
			'comments'=>$comments,
			'editor_id'=>$this->editor_id??0
		);
		yes_db_perform('orders_status_history',$insert_sql_array);
   }

   function recalc(){
	define('TABLE_ORDERS_RECALCULATE','orders_recalculate');
	$cinfo = xtc_oe_customer_infos($this->customer['ID']);
        $lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        $status = main::get_customers_status($this->info['status'], $lang_id);
	if($this->info['is_parent'] == 'n') {
		$products_query = xtc_db_query("select SUM(final_price) as subtotal_final from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . $this->info['id'] . "' ");
		$products = xtc_db_fetch_array($products_query);
		$subtotal_final = $products['subtotal_final'];
	}else{
		$products_query = xtc_db_query("select SUM(op.final_price) as subtotal_final from " . TABLE_ORDERS_PRODUCTS . " op, ".TABLE_ORDERS." o where o.parent_orders_id = '" . $this->info['id'] . "' && op.orders_id=o.orders_id");
		while( $products = xtc_db_fetch_array($products_query) ) {
			$subtotal_final += $products['subtotal_final'];
		}
	}
	//********************* COMBINED PAYMENT CHANGE

	$xtPrice = new xtcPrice($this->info['currency'],$this->info['status']);
        
        // BUGF_CH_OSS - IMMER ZONE/COUNTRY
        $this->Price->setCountryZone($this->delivery['country_id'], $this->delivery['zone_id']);

	$subtotal_text = $xtPrice->xtcFormat($subtotal_final,true);

	xtc_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . $subtotal_text . "', value = '" . $subtotal_final . "' where orders_id = '" . $this->info['id'] . "' and class = 'ot_subtotal' ");

	// Falls No Tax
	$check_no_tax_value_query = xtc_db_query("select count(*) as count from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class = 'ot_subtotal_no_tax'");
	$check_no_tax_value = xtc_db_fetch_array($check_no_tax_value_query);
	if ($check_no_tax_value_query['count'] != '0') {
		$subtotal_no_tax_value_query = xtc_db_query("select SUM(value) as subtotal_no_tax_value from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class != 'ot_tax' and class != 'ot_total' and class != 'ot_subtotal_no_tax' and class != 'ot_coupon' and class != 'ot_gv'");
		$subtotal_no_tax_value = xtc_db_fetch_array($subtotal_no_tax_value_query);
		$subtotal_no_tax_final = $subtotal_no_tax_value['subtotal_no_tax_value'];
		$subtotal_no_tax_text = $xtPrice->xtcFormat($subtotal_no_tax_final, true);
		xtc_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . $subtotal_no_tax_text . "', value = '" . $subtotal_no_tax_final . "' where orders_id = '" . $this->info['id'] . "' and class = 'ot_subtotal_no_tax' ");
	}
	
	$subtotal_query = xtc_db_query("select SUM(value) as value from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class != 'ot_subtotal_no_tax' and class != 'ot_tax' and class != 'ot_subtotal'");
	$subtotal = xtc_db_fetch_array($subtotal_query);

	$subtotal_final = $subtotal['value'];
	$subtotal_text = $xtPrice->xtcFormat($subtotal_final, true);
	xtc_db_query("update " . TABLE_ORDERS_TOTAL . " set text = '" . $subtotal_text . "', value = '" . $subtotal_final . "' where orders_id = '" . $this->info['id'] . "' and class = 'ot_total'");

	//********************* COMBINED PAYMENT CHANGE
	if($this->info['is_parent'] == 'n') {
		$products_query = xtc_db_query("select final_price, products_tax, allow_tax from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . $this->info['id'] . "' ");
	}else{
		$products_query = xtc_db_query("select op.final_price, op.products_tax, op.allow_tax from " . TABLE_ORDERS_PRODUCTS . " op, ".TABLE_ORDERS." o where o.parent_orders_id = '" . $this->info['id'] . "' && o.orders_id=op.orders_id");
	}
	//********************* COMBINED PAYMENT CHANGE

	while($products = xtc_db_fetch_array($products_query)){
		$tax_rate = $products['products_tax'];
		$multi = (($products['products_tax'] / 100) + 1);

		if ($products['allow_tax'] == '1') {
			$bprice = $products['final_price'];
			$nprice = $xtPrice->xtcRemoveTax($bprice, $tax_rate);
			$tax = $xtPrice->calcTax($nprice, $tax_rate);
		} else {
			$nprice = $products['final_price'];
			$bprice = $xtPrice->xtcAddTax($nprice, $tax_rate);
			$tax = $xtPrice->calcTax($nprice, $tax_rate);
		}

		// KEINE MWST BEI ENTSPRECHENDER KUNDENGRUPPENCONFIG
		if ($status['customers_status_add_tax_ot'] == 1) {
			$sql_data_array = array (
				'orders_id' => $this->info['id'], 
				'n_price' => xtc_db_prepare_input($nprice), 
				'b_price' => xtc_db_prepare_input($bprice), 
				'tax' => xtc_db_prepare_input($tax), 
				'tax_rate' => xtc_db_prepare_input($products['products_tax']),
				'class' => 'products');
			xtc_db_perform(TABLE_ORDERS_RECALCULATE, $sql_data_array);
		}
	}
	// Produkte Ende

	// Module Anfang

	$module_query = xtc_db_query("select value, class from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class!='ot_total' and class!='ot_subtotal_no_tax' and class!='ot_tax' and class!='ot_subtotal'");
	while ($module_value = xtc_db_fetch_array($module_query)) {
		$module_name = str_replace('ot_', '', $module_value['class']);

		if ($module_name != 'discount') {
			if ($module_name != 'shipping') {
				switch( strtoupper($module_name) ){
					case 'COD_FEE':
						// COD FEE Tax heisst COD_TAX
						$mod_key = 'COD';
						break;
					default:
						$mod_key = strtoupper($module_name);
						break;
				}
                                $module_tax_class = $this->get_shipping_tax_class();
                                // EU-OSS 2021/07
				//$module_tax_class = constant(MODULE_ORDER_TOTAL_ . $mod_key . _TAX_CLASS);
			} else {
				$module_tmp_name = explode('_', $this->info['shipping_class']);
				$module_tmp_name = $module_tmp_name[0];
				if ($module_tmp_name != 'selfpickup') {
                                    // EU-OSS 2021/07
//					if (defined(MODULE_SHIPPING_ . strtoupper($module_tmp_name) . _TAX_CLASS)) {
//						$module_tax_class = constant(MODULE_SHIPPING_ . strtoupper($module_tmp_name) . _TAX_CLASS);
//					} else {
//						$module_tax_class = '';
//					}
                                    $module_tax_class = $this->get_shipping_tax_class();
				} else {
					$module_tax_class = '';
				}
			}
		} else {
			$module_tax_class = '0';
		}
                $country_id = $this->delivery['country_id'];
                $zone_id = $this->delivery['zone_id'];
                
                // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                /*if(!yes_eu_oss_use_country_handling($country_id)){
                    $country_id = STORE_COUNTRY;
                    $zone_id = 0;
                }*/
                // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                
		$module_tax_rate = xtc_get_tax_rate($module_tax_class, $country_id, $zone_id);

		if ($status['customers_status_show_price_tax'] == 1) {
			$module_b_price = $module_value['value'];
			if ($module_tax == '0') {
				$module_n_price = $module_value['value'];
			} else {
				$module_n_price = $xtPrice->xtcRemoveTax($module_b_price, $module_tax_rate);
			}
			$module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);
		} else {
			$module_n_price = $module_value['value'];
			$module_b_price = $xtPrice->xtcAddTax($module_n_price, $module_tax_rate);
			$module_tax = $xtPrice->calcTax($module_n_price, $module_tax_rate);
		}
		// KEINE MWST BEI ENTSPRECHENDER KUNDENGRUPPENCONFIG
		if ($status['customers_status_add_tax_ot'] == 1) {
			$sql_data_array = array (
				'orders_id' => $this->info['id'], 
				'n_price' => xtc_db_prepare_input($module_n_price), 
				'b_price' => xtc_db_prepare_input($module_b_price), 
				'tax' => xtc_db_prepare_input($module_tax), 
				'tax_rate' => xtc_db_prepare_input($module_tax_rate),
				'class' => $module_value['class']);

			xtc_db_perform(TABLE_ORDERS_RECALCULATE, $sql_data_array);
		}
	}
	// Module Ende  

	// Alte UST Löschen ANFANG
	xtc_db_query("delete from " . TABLE_ORDERS_TOTAL . " where orders_id = '" . $this->info['id'] . "' and class='ot_tax'");
	// Alte UST Löschen ENDE

	// Neue Mwst. zusammenrechnen Anfang

	$ust_query = xtc_db_query("select tax_rate, SUM(tax) as tax_value_new from " . TABLE_ORDERS_RECALCULATE . " where orders_id = '" . $this->info['id'] . "' and tax !='0' GROUP by tax_rate ");
	while ($ust = xtc_db_fetch_array($ust_query)) {

		$ust_desc_query = xtc_db_query("select tax_description from " . TABLE_TAX_RATES . " where tax_rate = '" . $ust['tax_rate'] . "'");
		$ust_desc = xtc_db_fetch_array($ust_desc_query);

		$title = $ust_desc['tax_description'];

		if ($ust['tax_value_new']) {
			$text = $xtPrice->xtcFormat($ust['tax_value_new'], true);

			$sql_data_array = array (
				'orders_id' => $this->info['id'], 
				'title' => xtc_db_prepare_input($title), 
				'text' => xtc_db_prepare_input($text), 
				'value' => xtc_db_prepare_input($ust['tax_value_new']), 
				'class' => 'ot_tax',
				'sort_order' => MODULE_ORDER_TOTAL_TAX_SORT_ORDER);

			xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
		}

	}


	if ($status['customers_status_show_price_tax'] == 0)
		$total_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$this->info['id']."' and class != 'ot_total'");
	else
		$total_query = xtc_db_query("SELECT SUM(value) as totalsum FROM orders_total WHERE orders_id='".$this->info['id']."' and class != 'ot_total' and class != 'ot_tax'");


	$total = xtc_db_fetch_array($total_query);
	$text = $xtPrice->xtcFormat($total['totalsum'], true);

	$sql_data_array = array (
		'text' => xtc_db_prepare_input($text), 
		'value' => xtc_db_prepare_input($total['totalsum']), 
	);
	xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array,'update',"orders_id='".$this->info['id']."' and class='ot_total'");
	
	// Löschen des Zwischenspeichers Anfang
	xtc_db_query("delete from " . TABLE_ORDERS_RECALCULATE . " where orders_id = '" . $this->info['id'] . "'");
	// Löschen des Zwischenspeichers Ende
  }

  // WIRD IN DER KAUFABWICKLUNG BENOETIGT WENN KEINE PASSENDE EBAYVERSANDART GEFUNDEN WIRD
  function get_shippingcosts($shipping_modules){
	global $order;
	$country = $this->delivery['country'];
	$this->delivery['country'] = array();
	$this->delivery['country']['name'] = $country;
	$this->delivery['country']['id'] = $this->delivery['country_id'];
	$this->delivery['country']['iso_code_2'] = $this->delivery['iso_code_2'];
	

	$total_weight = $this->show_weight();
	$total_count = $this->count_contents();

	$_SESSION['shipping'] = 'yes_yes';
	list ($module, $method) = explode('_', $_SESSION['shipping']);

	// YES Versandmodul braucht eine $order Instanz
	$order = $this;
	$quote = $shipping_modules->quote($method, $module);
	unset($order);

	$newCost = $quote[0]['methods'][0]['cost'];
	if($quote[0]['tax']>0)
		$newCost = xtc_add_tax($newCost,$quote[0]['tax']);
	if(!$quote[0]['error']){
		return $newCost;
	}else{
		return false;
	}
  }

  function get_sofortueberweisung_paycode(){
	$code = '';
	if(MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS == 'True'){
            if(main::isDev(true)){ // sofortueberweisung testdaten
		define('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_HOLDER','Mario Aspeleiter');
		define('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ACCOUNT_NUMBER','688542300');
		define('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_BANK_CODE','25010030');
		define('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_BANK_BIC','PBNKDEFF250');
		define('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_IBAN','DE85250100300688542300');
            }
		$store_iso_code_2 = main::get_country_values(STORE_COUNTRY_ID);
		$data = array(
		       'user_id' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR,
		       'project_id' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT,
		       'amount' => number_format($this->info['total'],2,',',''),
		       'reason_1' => substr('Re-Nr '.$this->info['id'].' '.(($this->info['ebay_id'] != '')?$this->info['ebay_id'].' ':'').$this->billing['name'],0,27),
		       'reason_2' => substr((($this->billing['company'] != '')?$this->billing['company'].' ':'').'vom '.date('d.m.Y',strtotime($this->info['date_purchased'])),0,27),
		       'sender_holder' => '',
		       'sender_account_number' => '',
		       'sender_bank_code' => '',
		       'sender_bank_bic' => '',
		       'sender_iban' => '',
		       'sender_country_id' => '',
		       'user_variable_0' => $this->info['id'],
		       'user_variable_1' => '',
		       'user_variable_2' => '',
		       'user_variable_3' => '',
		       'user_variable_4' => '',
		       'user_variable_5' => '',
		       'expires' => '3',
		       'language_id' => 'DE',
		       'project_password' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT
		);
		$data_implode = implode('|', $data);
		$hash = md5($data_implode);
		$gets = '';
		foreach($data as $k=>$v){
			$gets .= '&'.$k.'='.urlencode($v);
		}
		ob_start();
		$pc = curl_init('https://www.sofortueberweisung.de/payment/paycode/get/?hash='.$hash.$gets);
		curl_setopt($pc, CURLOPT_HEADER, 0);
		//Ausführen der Aktionen
		curl_exec($pc);
		$code.=ob_get_contents();

		//Session beenden
		curl_close($pc);
		ob_end_clean();
	}
	return $code;
  }

  // needs ebayapi-class
  function storno( $comments='Rechnung wurde storniert' ){
	global $_SESSION,$messageStack,$EBAYAPI;
	$oID = $this->info['id'];
	// normale Rechnung
	// quantity gutschreiben
	if(is_array($this->products)){
		foreach($this->products as $k=>$product){
				$collies = xtc_get_product_collies( $product['id'] );
				if(sizeOf($collies)>0){
                                    foreach($collies as $ck=>$collie){
                                        $SQ = new products_quantity( $collie['collie_products_id'] );
                                        $new_qty = $product['qty']*$collie['quantity'];
                                        $qty_total = $SQ->get_products_total_qty();
                                        //$SQ->update_qty( $new_qty, $SQ->get_default_storage_id(),$qty_total,'Stornierung der Re-Nr '.$oID.': Rueckbuchung (Colli aus '.$product['id'].') '.$new_qty.' Stk.');
                                        product::add_history_static(intval($collie['collie_products_id']),
                                            'Stornierung der Re-Nr '.$oID.'. Colli aus '.$product['id'].') '.$new_qty.' Stk.'
                                        );
                                    }
				}else{ // keine collis
                                    $SQ = new products_quantity( $product['id'] );
                                    $new_qty = $product['qty'];
                                    $qty_total = $SQ->get_products_total_qty();
                                    product::add_history_static(intval($product['id']), 
                                        'Stornierung der Re-Nr '.$oID
                                    );
				}
				xtc_db_query("UPDATE products SET products_ordered=products_ordered-".$product['qty']." where products_id='".$product['id']."'");
		}
	}
	// status + history updaten
        $this->add_history(ORDERS_STATUS_STORNIERT, false, $comments);
        $this->update_orders_status(ORDERS_STATUS_STORNIERT);
  }

    /**
     * Ueberarbeitete Version von is_netto
     * prueft sowohl den tax wert als auch die allow_tax einstellung
     *
     * @return bool
     */
    function is_netto2(){
        if(sizeOf($this->products)>0){
                if($this->products[0]['tax']>0 and $this->products[0]['allow_tax'] == 1)
                        return false;
        }else{
            $lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
            $cs = main::get_customers_status($this->info['status'], $lang_id);
            if($s['customers_status_add_tax_ot'] > 0){
                return false;
            }
        }
        return true;
    }

    function is_netto(){
        if(sizeOf($this->products)>0){
                if($this->products[0]['tax']>0 and $this->products[0]['allow_tax'] == 1)
                        return false;
        }else{
            $lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
            $cs = main::get_customers_status($this->info['status'], $lang_id);
            if($cs['customers_status_add_tax_ot'] > 0){
                        return false;
            }
        }
        return true;
    }


  /**
   * Ermittelt den Nettobetrag zu einem Eintrag des $this->products Arrays
   * Achtung - nicht die original Datenbank Array Keys (aus einem SQL Query)
   * uebergeben, sondern immer einen Eintrag des $this->products Arrays
   *
   * @global object $xtPrice
   * @param array $orders_product
   * @return float Netto-Price
   */
  function get_products_price_netto($orders_product){
		global $xtPrice;
	    if(!is_array($orders_product) or !is_object($xtPrice)) return 0;
		$products_price_netto = $orders_product['final_price'];
		if(!$this->is_netto()){
			if($orders_product['tax']>0 and isset($orders_product['allow_tax']) and $orders_product['allow_tax'] == 1){
				$products_price_netto = $xtPrice->xtcRemoveTax($orders_product['final_price'], $orders_product['tax']);
			}else{
				$products_price_netto = $orders_product['final_price'];
			}
		}
		return (float)$products_price_netto;
  }

  function is_kasse(){
		$kasse_query = xtc_db_query("SELECT id FROM kasse WHERE orders_id='".$this->info['id']."'");
		if(xtc_db_num_rows($kasse_query)>0){
			return true;
		}
		return false;
  }
  
  function get_kasse_data(){
		$kasse_query = xtc_db_query("SELECT * FROM kasse WHERE orders_id='".$this->info['id']."'");
		$kasse = xtc_db_fetch_array($kasse_query);
		$data_array = array('id'=>$kasse['id'],
			'paymode'=>$kasse['paymode'],
			'date_purchased'=>$kasse['date_purchased'],
			'quantity_purchased'=>$kasse['quantity_purchased'],
			'tax_rate'=>$kasse['tax_rate'],
			'total'=>$kasse['total'],
			'send'=>$kasse['send'],
			'branches_id'=>$kasse['branches_id']
		);
		return $data_array;
  }

	function get_fibunumber(){
		if(!defined('MODULE_OTHER_FIBUNUMBERS_STATUS') or MODULE_OTHER_FIBUNUMBERS_STATUS != 'True'){
			return 0;
		}
		if($this->is_kasse()){
			$kasse_data = $this->get_kasse_data();
			$branches_id = $kasse_data['branches_id'];

			// BUGFIX - WENN KEINE FILIALE
			$branches_num_query = xtc_db_query("SELECT branches_id FROM branches");
			$branches_num = xtc_db_num_rows($branches_num_query);

			$branches_stammlager_query = xtc_db_query("SELECT stammlager FROM branches WHERE branches_id='".$branches_id."'");
			$branches_stammlager = xtc_db_fetch_array($branches_stammlager_query);
			if($branches_stammlager['stammlager'] == 0 and $branches_num){
				$query = xtc_db_query(sprintf(
					"SELECT fibunumber FROM branches_orders_fibunumbers WHERE orders_id='%s'",
					$this->info['id']
				));
			}else{
				$query = xtc_db_query(sprintf(
					"SELECT fibunumber FROM orders_fibunumbers WHERE orders_id='%s'",
						$this->info['id']
				));
			}
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				return $record['fibunumber'];
			}
		}else{
			$query = xtc_db_query(sprintf(
				"SELECT fibunumber FROM orders_fibunumbers WHERE orders_id='%s'",
					$this->info['id']
			));
			if(xtc_db_num_rows($query)){
				$record = xtc_db_fetch_array($query);
				return $record['fibunumber'];
			}
		}
		return 0;
	}

	function _parse_branch_fibunumber($counter,$prefix,$length){
			$target_string = ''.$counter;
			$counter_length = strlen(''.$counter);
			if($counter_length < $length){
				$target_nulls = $length-$counter_length;
				for($i=0;$i<$target_nulls;$i++){
					$target_string = '0'.$target_string;
				}
			}
			return $prefix.$target_string;
	}
	function add_fibunumber(){
		if($this->is_kasse()){
			$kasse_data = $this->get_kasse_data();
			$branches_id = $kasse_data['branches_id'];

			$branches_num_query = xtc_db_query("SELECT branches_id FROM branches");
			$branches_num = xtc_db_num_rows($branches_num_query);

			if($branches_num){ // BUGFIX - WENN KEINE FILIALE
				$branches_fibu_query = xtc_db_query(sprintf(
					"SELECT fibunumber_prefix,fibunumber_length,fibunumber_start,stammlager FROM
					   branches WHERE branches_id='%s'",
					$branches_id
				));
				$branches_fibu = xtc_db_fetch_array($branches_fibu_query);
				if($branches_fibu['stammlager'] == 0){
					$query = xtc_db_query(sprintf(
						"SELECT MAX(fibunumber_branches_counter) as lastid FROM branches_orders_fibunumbers WHERE branches_id='%s'",
						$branches_id
					));
					$record = xtc_db_fetch_array($query);
					if($record['lastid']>0){
						$number = $record['lastid'] + 1;
					}else{
						$number = (int)$branches_fibu['fibunumber_start'];
						if($number == 0) $number = 1; // BUGFIX
					}
					$fibunumber = $this->_parse_branch_fibunumber($number,$branches_fibu['fibunumber_prefix'],$branches_fibu['fibunumber_length']);
					$insert_sql_array = array(
						'orders_id'=>$this->info['id'],
						'fibunumber'=>$fibunumber,
						'branches_id'=>$branches_id,
						'fibunumber_branches_counter'=>$number,
						'date_added'=>'now()'
					);
					xtc_db_perform('branches_orders_fibunumbers',$insert_sql_array);
					return $fibunumber;
				}
			}
		}

		$query = xtc_db_query("SELECT MAX(fibunumber) as lastid FROM orders_fibunumbers");
		$record = xtc_db_fetch_array($query);
		if($record['lastid']>0){
			$number = $record['lastid'] + 1;
		}else{
			$number = MODULE_OTHER_FIBUNUMBERS_START;
		}
		$insert_sql_array = array(
			'orders_id'=>$this->info['id'],
			'fibunumber'=>$number,
			'date_added'=>'now()'
		);
		xtc_db_perform('orders_fibunumbers',$insert_sql_array);
		return $number;
	}

	/**
	 * UEBERPRUEFT OB DER AUFTRAG MIT DEM UEBERGEBENEM STATUS EINE FIBUNUMMER
	 * ERHALTEN DARF
	 * 
	 * @param int $status
	 * @return bool
	 */
	public static function check_add_fibunumber_by_status($status){
		switch($status){
		/* KOMPLETT RAUS - TICKET 2096
			case ORDERS_STATUS_BEZAHLT:
		 * 
		 */
			case ORDERS_STATUS_ABGESCHLOSSEN:
			case ORDERS_STATUS_VERSENDET:
				return true;
				break;
		}
		return false;
	}
	
  function get_order_positions(){
	global $xtPrice;
	$positions = new order_positions;
	
	$positions->setCommission_number($this->info['commission_number']);
	$positions->setOwn_volume($this->info['own_volume']);
	$positions->setOwn_weight($this->info['own_weight']);

	if(!function_exists('xtc_get_product_collies')){
	    require_once(DIR_FS_INC.'xtc_collis.inc.php');
	}
	
	if(!function_exists('xtc_get_short_description')){
	    require_once(DIR_FS_INC.'xtc_get_short_description.inc.php');
	}
	
        require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
	
	// ALS ERSTES DIE PRODUKTE ALS POSITIONEN ADDEN
	$total_weight_netto = 0;
	$total_weight = 0;
	for($i=0;$i<sizeOf($this->products);$i++){
	    $product_detail_query = xtc_db_query(sprintf(
		"SELECT products_ean,products_image,size_width,size_height,size_depth FROM products WHERE products_id='%s'",
		$this->products[$i]['id']
	    ));
	    $product_detail = xtc_db_fetch_array($product_detail_query);


		$total_netto = $this->get_products_price_netto( $this->products[$i] );
		$total = $this->products[$i]['final_price'];
		$pos = new order_position;
		$pos->setClass('product');

		$pos->setWidth(floatval($product_detail['size_width']));
		$pos->setDepth(floatval($product_detail['size_depth']));
		$pos->setHeight(floatval($product_detail['size_height']));

		$pos->setTotal_price($this->products[$i]['final_price']);
		$pos->setTotal_price_netto($total_netto);
		$pos->setSingle_price($this->products[$i]['price']);
		$pos->setSingle_price_netto( (($this->products[$i]['qty'] != 0) ? $total_netto/$this->products[$i]['qty'] : 0) );
		$pos->setQuantity($this->products[$i]['qty']);
		$pos->setProducts_model($this->products[$i]['model']);
		$pos->setPosition($i+1);
		$pos->setTitle($this->products[$i]['name']);
		if($this->is_netto()){
			$pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price_netto(),true) );
			$pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price_netto(),true) );
		}else{
			$pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price(),true) );
			$pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price(),true) );
		}
		$pos->setProperties($this->products[$i]['properties']);
		
		$collies_data = array();
		$collies = xtc_get_product_collies($this->products[$i]['id']);
		foreach($collies as $colli){
		    $collie_desc_query = xtc_db_query(sprintf(
			    "SELECT pd.slave_title,pd.products_name,p.products_model FROM products p LEFT JOIN products_description pd USING(products_id) WHERE p.products_id='%s' AND language_id='%s'",
			    $colli['collie_products_id'],
			    $_SESSION['languages_id']
		    ));
		    $collie_desc = xtc_db_fetch_array($collie_desc_query);
                    // WAR VORHER IMMER DRIN, DAHER LASSEN WIR ES GESETZT
		    $colli['products_model'] = $collie_desc['products_model'];
                    
                    // VARIABLEN WIE IN ADMIN order - Ticket 3275 - 2021/04/09
		    $colli['SLAVE_TITLE'] = $collie_desc['slave_title'];
		    $colli['TITLE'] = $collie_desc['products_name'];
		    $colli['PRODUCTS_WEIGHT'] = xtc_get_ext_products_weight($colli['collie_products_id']);
		    $colli['PRODUCTS_WEIGHT_NETTO'] = xtc_get_ext_products_weight_netto($colli['collie_products_id']);
		    $colli['PRODUCTS_MODEL'] = $collie_desc['products_model'];
                    
		    $collies_data[] = $colli;
		}
		$pos->setCharacteristics($this->get_characteristics_for_product($this->products[$i]['id'],$collies));
		$pos->setAllow_tax( $this->products[$i]['allow_tax'] );
		if($pos->getAllow_tax() == 1){
		    $pos->setTax_rate( number_format($this->products[$i]['tax'],2,'.',''));
		}
		$pos->setProducts_ean($product_detail['products_ean']);
		$pos->setCollis($collies_data);
		$pos->setStorages($this->get_product_storages($this->products[$i]['id'], $collies));
		$products_description = yes_get_products_description($this->products[$i]['id'], $_SESSION['languages_id']);
 		$pos->setProducts_short_description($products_description['products_short_description']);
		$pos->setSlave_title( $products_description['slave_title'] );
		$pos->setImage($product_detail['products_image']);
        $pos->setProducts_id($this->products[$i]['id']);

        $weight = xtc_get_ext_products_weight($this->products[$i]['id']);
        $weight_netto = xtc_get_ext_products_weight_netto($this->products[$i]['id']);
        $pos->setWeight(floatval($weight));
        $pos->setWeight_netto(floatval($weight_netto));

		$total_weight += $weight * $pos->getQuantity();
		$total_weight_netto += floatval($weight_netto) * $pos->getQuantity();

		$positions->addPosition( $pos );
	}

	$position_counter = $i;
        $country_id = $this->delivery['country_id'];
        $zone_id = $this->delivery['zone_id'];
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(!yes_eu_oss_use_country_handling($country_id)){
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
        $tax_rate = xtc_get_tax_rate($this->get_shipping_tax_class(),$country_id, $zone_id);

	// NUN DIE OT_TOTAL MODULE
	for($i=0;$i<sizeOf($this->totals);$i++){
		$item_countable = false;
		switch($this->totals[$i]['class']){
			case 'ot_discount':
			    $total = $this->totals[$i]['value'];
			    if($tax_rate > 0 and !$this->is_netto2()){ // bugfix 17.02.10
				    $total_netto = $xtPrice->xtcRemoveTax($total, $tax_rate);
			    }else{
				    $total_netto = $total;
			    }

			    $class = 'ot';
			    $item_countable = true;
			    break;
			case 'ot_coupon':
			case 'ot_gv':
			case 'ot_loworderfee':
			case 'ot_payment_fee':
				$total = $this->totals[$i]['value'];
				$total_netto = $total_netto;
				$class = 'ot';
				$item_countable = true;
				break;
			case 'ot_cod_fee':
				$total = $this->totals[$i]['value'];

				if($tax_rate > 0 and !$this->is_netto2()){ // bugfix 17.02.10
					$total_netto = $xtPrice->xtcRemoveTax($total, $tax_rate);
				}else{
					$total_netto = $total;
				}

				$class = 'ot';
				$item_countable = true;
				break;
			case 'ot_shipping':
				$scn = $this->totals[$i]['value'];
				if(xtc_not_null($this->info['shipping_class']) and !$this->is_netto()){
                                    $shipping_class = strtoupper(current(explode('_',$this->info['shipping_class'])));
                                    if(defined('MODULE_SHIPPING_'.$shipping_class.'_TAX_CLASS')){
                                            $scn = $xtPrice->xtcRemoveTax($scn, $tax_rate);
                                    }else{
                                            $scn = $xtPrice->xtcRemoveTax($scn, $tax_rate);
                                    }
				}
				$total = $this->totals[$i]['value'];
				$total_netto = $scn;
				$class = 'shipping';
				$item_countable = true;
				break;
		}
		if(!$item_countable) continue;

		$position_counter++;
		$pos = new order_position;
		$pos->setClass($class);
		$pos->setTotal_price($total);
		$pos->setTotal_price_netto($total_netto);
		$pos->setSingle_price($total);
		$pos->setSingle_price_netto( $total_netto );
		$pos->setQuantity(1);
		$pos->setPosition($position_counter);
		$pos->setTitle($this->totals[$i]['title']);
		if($this->is_netto()){
			$pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price_netto(),true) );
			$pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price_netto(),true) );
		}else{
			$pos->setText1( $xtPrice->xtcFormat( $pos->getSingle_price(),true) );
			$pos->setText2( $xtPrice->xtcFormat( $pos->getTotal_price(),true) );
		}
		$positions->addPosition( $pos );
	}
	$positions->setWeight($total_weight);
    $positions->setWeight_netto($total_weight_netto);

	$positions->setIs_netto( $this->is_netto() );
	$positions->process($this->totals);
	return $positions->getArray($xtPrice);
  }

  function get_title($fibu_number){
	if($this->info['orders_status'] == ORDERS_STATUS_OFFER){
		return TEXT_OFFER;
	}
	$invoice_statuses = array(ORDERS_STATUS_BEZAHLT, ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET);
	if( (!empty($fibu_number) and strlen($fibu_number) > 1 ) ){
		return TEXT_INVOICE;
	}
	if(!defined('MODULE_OTHER_FIBUNUMBERS_STATUS') or MODULE_OTHER_FIBUNUMBERS_STATUS != 'True'){
		if(in_array($this->info['orders_status_id'],$invoice_statuses)){
			return TEXT_INVOICE;
		}
	}
	return TEXT_ORDER;
  }

	function save_order_product_estimated_date_receipt_as_comment($pID){
		if(STOCK_CHECK == 'true'){
			return false;
		}
		$SQ = new products_quantity($pID);
		if($SQ->get_available1_qty() > 0){
			return false;
		}
		$collies = xtc_get_product_collies($pID);
		if( sizeOf($collies)>0 ){
			foreach($collies as $k=>$collie){
				$cpID = $collie['collie_products_id'];
				$query = xtc_db_query(sprintf(
					"SELECT UNIX_TIMESTAMP(products_date_available) as datum FROM products WHERE products_id=%s and products_date_available >= now()",
					$cpID
				));
				if(xtc_db_num_rows($query)){
					$record = xtc_db_fetch_array($query);
					$comments = sprintf('Colli pID %s (aus Set pID %s): Verf. ab %s',
						$cpID,$pID,
						date('d.m.Y',$record['datum'])
					);
					$this->add_history($this->info['orders_status_id'], false, $comments);
				}
			}
		}else{
			$query = yes_query(
				"SELECT UNIX_TIMESTAMP(products_date_available) as datum FROM products WHERE products_id=:products_id and products_date_available >= now()",
				['products_id'=>(int)$pID]
			);
			if(sizeOf($query)){
				$record = current($query);
				$comments = sprintf('pID %s: Verf. ab %s',
					$pID,
					date('d.m.Y',$record['datum'])
				);
				$this->add_history($this->info['orders_status_id'], false, $comments);
			}
		}
		$query = yes_query(
			"SELECT UNIX_TIMESTAMP(do.estimated_date_receipt) as datum,do.distributor_name,do.distributor_orders_id FROM distributor_orders_products dop LEFT JOIN distributor_orders do USING(distributor_orders_id) WHERE dop.products_id=:products_id and do.orders_status=2 and do.estimated_date_receipt>0",
			['products_id'=>(int)$pID]
		);
		foreach($query as $record){
			$comments = sprintf('pID %s: LB %s vom %s (%s)',
				$pID,
				$record['distributor_orders_id'],
				date('d.m.Y',$record['datum']),
				$record['distributor_name']
			);
			$this->add_history($this->info['orders_status_id'], false, $comments);
		}
  }


  /**
   * BEI KOMBINIERTEN AUFTRAEGEN KOENNEN MEHR ALS EINE
   * AUKTIONSNUMMERN ENTHALTEN SEIN
   *
   * WENN $return_orders_id MIT true uebergeben wird, dann wird ein Mehrdimen-
   * sionales Array zurueckgegeben was jeweils die orders_id zur ebay_id ent-
   * haelt
   *
   * @param bool $return_orders_id
   * @return array ebay_id
   */
  //
  function get_auction_array($return_orders_id = false){
	$ebay_id = array();
	$combineds = $this->get_combined_orders();
	if(!sizeOf($combineds)){
		if(empty($this->info['ebay_id']))
			return $ebay_id;
		if(!$return_orders_id){
			return array($this->info['ebay_id']);
		}else{
			return array(
				0=>array(
					'orders_id'=>$this->info['id'],
					'ebay_id'=>$this->info['ebay_id']
				)
			);
		}
	}

	foreach($combineds as $combined){
		$ebay_id_query = xtc_db_query(sprintf(
			"SELECT ebay_id FROM orders WHERE orders_id='%s'",
			$combined['orders_id']
		));
		$ebay_id_result = xtc_db_fetch_array($ebay_id_query);
		if(xtc_not_null($ebay_id_result['ebay_id'])){
			if(!$return_orders_id){
				$ebay_id[] = $ebay_id_result['ebay_id'];
			}else{
				$ebay_id[] = array(
					'orders_id'=>$combined['orders_id'],
					'ebay_id'=>$ebay_id_result['ebay_id']
				);
			}
		}
	}
	return $ebay_id;
  }
  
  // KOMBINIERTE ERMITTELN
  function get_combined_orders(){
  		$child_orders = array();
		$query = xtc_db_query("SELECT orders_id FROM ".TABLE_ORDERS." WHERE combined_orders_id = '".$this->info['id']."'");
	  	while($res = xtc_db_fetch_array($query)) {
  			$link = xtc_href_link(FILENAME_ORDERS,'oID='.$res['orders_id'].'&action=edit');
			$child_orders[] = array('orders_id'=>$res['orders_id'],'link'=>$link);
	  	}
	  	return $child_orders;
  }
  
  function get_shipping_tax_class(){
        $tax_class_id = 0;
        $country_id = $this->delivery['country_id'];
        $zone_id = $this->delivery['zone_id'];
        
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(!yes_eu_oss_use_country_handling($country_id)){
            $country_id = STORE_COUNTRY;
            $zone_id = 0;
        }*/
        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        
	if(is_array($this->products)){
            $taxes = array();
            foreach($this->products as $product){
				$products_tax_class_id = yes_eu_oss_get_products_tax_class_id(xtc_get_prid($product['id']),
					$country_id, $zone_id
				);

                if(!isset($product['tax'])){
                    //$product['tax'] = xtc_get_tax_rate($product['tax_class_id'],$country_id,$zone_id);
					$product['tax'] = xtc_get_tax_rate($products_tax_class_id,$country_id,$zone_id);
                }
                $tax_key = sprintf('%s:%d',
                    number_format($product['tax'],2,'.',''),
                    //$product['tax_class_id']
					$products_tax_class_id
                );
                if(!isset($taxes[ $tax_key ])){
                    $taxes[ $tax_key ] = 0;
                }
                $taxes[ $tax_key ] += $product['final_price'];
            }
            if(sizeOf($taxes)){
                $max = max($taxes);	
            }
            foreach($taxes as $tax=>$val){
                if($val == $max){
                    $tax_parts = explode(':',$tax);
                    $tax_class_id = $tax_parts[1];
                }
            }
	}
	return $tax_class_id;
  }

  public function get_product_properties_price_netto($products_id){
	$price_netto = 0;
	$ppvID_parts = explode('{',$products_id);
	if(sizeOf($ppvID_parts) < 2){
		return $price_netto;
	}
	$ppvID_parts = explode(',',substr($ppvID_parts[1],0,strlen($ppvID_parts[1])-1));
	foreach($ppvID_parts as $ppvID){
                if(strpos($ppvID,':')>-1){
                    $ppvid_parts = explode(':',$ppvID);
                    $ppvID = $ppvid_parts[0];
                }
		$ppvID = (int)xtc_db_input($ppvID);
		$ppv = new product_properties_values($ppvID);
                if((int)$ppv->products_properties_id < 1){
                    continue;
                }
                if( \YES4Trade\Model\product_properties_xy_prices::is_products_properties_id_xy_price($ppv->products_properties_id) ){
                    continue;
                }
		$price_netto += $ppv->getPrice();
	}
	return $price_netto;
  }
  
  function get_properties($opID){
	$properties_array = array();
        // BOF - input_span Addon 2023/06
	$properties_query = yes_query(
		"SELECT property_title,property_value,price_netto,input_span FROM orders_products_properties WHERE orders_products_id=:op_id",
		['op_id'=>(int)$opID]
	);
        // EOF - input_span Addon 2023/06
	if(sizeOf($properties_query)){
		foreach($properties_query as $properties){
			 $properties_array[] = $properties;
		}
	}
	return $properties_array;
  }
  
    private function get_characteristics_for_product($pID,$collies){
        $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
	$collies_array = array();
	if(sizeOf($collies)>0){
	    foreach($collies as $ck=>$collie){
                $collie_title_query = xtc_db_query(sprintf(
                        "SELECT slave_title,products_name FROM products_description WHERE products_id=%s AND language_id=%s",
                        $collie['collie_products_id'],$_SESSION['languages_id']
                ));
                $collie_title = xtc_db_fetch_array($collie_title_query);
                $collies_array[] = array(
                        'products_id'=>$collie['collie_products_id'],
                        'slave_title'=>$collie_title['slave_title'],
                        'products_name'=>$collie_title['products_name'],
                        'PRODUCTS_WEIGHT'=>xtc_get_ext_products_weight($collie['collie_products_id']),
						'PRODUCTS_WEIGHT_NETTO'=>xtc_get_ext_products_weight_netto($collie['collie_products_id']),
                );
                $allocs = $gh->get_allocated_product_group_characteristic_values($collie['collie_products_id']);
                if(is_countable($allocs) and sizeOf($allocs)){
                    foreach($allocs as $alloc){
                        if($alloc['visible'] != 1){
                            continue;
                        }
                        $products_characteristics_data[ $collie['collie_products_id']][] = $alloc;
                    }
                }
	    }
	}else{
            $allocs = $gh->get_allocated_product_group_characteristic_values($pID);
            if(is_countable($allocs) and sizeOf($allocs)){
                foreach($allocs as $alloc){
                    if($alloc['visible'] != 1){
                        continue;
                    }
                    $products_characteristics_data[] = $alloc;
                }
            }
	}
	return $products_characteristics_data;
  }
  
  private function get_product_storages($pID,$collies){
      // NUR IM ADMIN!!
      return '';
		// LAGERPLAETZE
		$storage_str = '';
		$transfer_places = array();
		if(in_array($this->info['orders_status'],array(ORDERS_STATUS_VERSENDET, ORDERS_STATUS_ABGESCHLOSSEN))){
			$transfer_places = $this->get_transferred_places($pID,'Versand');
		}else{
			$transfer_places = array();
		}
		if(sizeOf($transfer_places)){
			foreach($transfer_places as $tp){
				$storage_str .= sprintf('<br />Lager &raquo;%s&laquo; / Lagerplatz &raquo;%s&laquo;: %s Stk.',
					$tp['name'],$tp['storage_place'],$tp['quantity']
				);
			}
		}else{
			$storages = array();
			if(sizeOf($collies)>0){
				foreach($collies as $ck=>$collie){
					$storage_query = xtc_db_query("SELECT s.name,sp.storage_place,sn.nummer FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id='".$collie['collie_products_id']."' and sp.storage_id=s.id");
					while($storage = xtc_db_fetch_array($storage_query)){
						$storage['name'] = '(Colli aus pID '.$collie['collie_products_id'].') '.$storage['name'];
						$storages[] = xtc_db_prepare_input($storage);
					}
				}
			}else{
				$storage_query = yes_query("SELECT s.name,sp.storage_place,sn.nummer FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id=:products_id and sp.storage_id=s.id",
                                    ['products_id'=>(int)$pID]
                                );
				foreach($storage_query as $storage){
                                    $storages[] = xtc_db_prepare_input($storage);
				}
			}
		}
		if(sizeOf($storages)>0){
			$storage_str = '<table border="0" cellpadding="2" cellspacing="2">';
			foreach($storages as $sk=>$storage){
				$storage_str .= '<tr>';
				$storage_str .= '	<td colspan="2" class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif"><b>'.TEXT_STORAGE.' '.$storage['name'].'</b></font></td>';
				$storage_str .= '</tr><tr>';
				$storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['storage_place'].'</font></td>';
				$storage_str .= '	<td class="smallText"><font size="1" face="Verdana, Arial, Helvetica, sans-serif">'.$storage['nummer'].'</font></td>';
				$storage_str .= '</tr>';
			}
			$storage_str .= '</table>';
		}
		return $storage_str;
  }
  
  
  public function get_real_shipping_costs(){
      if(stristr($this->info['shipping_class'],'pickup')){
          return 0;
      }
      $graduation_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_id FROM shipping_graduation WHERE value <= %s ORDER BY value DESC limit 1",
              sizeOf($this->products)
      ));
      $graduation = xtc_db_fetch_array($graduation_query);
      $gID = $graduation['shipping_graduation_id'];
      $group_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_groups_id FROM shipping_graduation_countries WHERE country_id='%s'",
              $this->delivery['country_id']
      ));
      if(xtc_db_num_rows($group_query)){
          $group = xtc_db_fetch_array($group_query);
          $groupID = $group['shipping_graduation_groups_id'];
      }else{
          $groupID = 999999;
      }
      $weight_query = xtc_db_query(sprintf(
              "SELECT shipping_graduation_weights_id FROM shipping_graduation_weights ORDER BY abs(weight - %s) limit 1",
              $this->show_weight()
      ));
      $weight = xtc_db_fetch_array($weight_query);
      $wID = $weight['shipping_graduation_weights_id'];
      $cost_query = xtc_db_query(sprintf(
              "SELECT grad_value_cost FROM shipping_graduation_values WHERE shipping_graduation_id='%s' AND shipping_graduation_weights_id='%s' AND shipping_graduation_groups_id='%s'",
              $gID,$wID,$groupID
      ));
      if(xtc_db_num_rows($cost_query)){
          $cost = xtc_db_fetch_array($cost_query);
          return $cost['grad_value_cost'];
      }
      return 0;
  }
  
  public function save_real_shipping_cost(){
      xtc_db_query(sprintf(
              "DELETE FROM orders_costs WHERE orders_id='%s' AND title='shipping'",
              $this->info['id']
      ));
      $insert_sql_array = array(
          'orders_id'=>$this->info['id'],
          'title'=>'shipping',
          'costs'=>$this->get_real_shipping_costs()
      );
      xtc_db_perform('orders_costs',$insert_sql_array);
  }
  
  function get_paymentinstructions(){
      $instructions = array();
	$query  = xtc_db_query(sprintf(
		"SELECT paymentinstructions FROM orders_paymentinstructions WHERE orders_id='%s' ORDER BY date_saved DESC",
		$this->info['id']
	));
	while($record = xtc_db_fetch_array($query)){
	    $instructions[] = $record['paymentinstructions'];
	}
	return $instructions;
  }
  
  public function get_shipping_tracking_id_array(){
	$array = array();
	$query = xtc_db_query(sprintf(
	    "SELECT id,versender, tracking_id,date_finished FROM shippings WHERE orders_id='%s' ORDER BY date_finished DESC",
	    $this->info['id']
	));
	while($record = xtc_db_fetch_array($query)){
	    /**
	     * DAS IST ALTES HANDLING, BEIM NEUEN HANDLING WERDEN DIE tracking_id
	     * IN shippings_tracking_numbers GESPEICHERT UND PER yes_shipping Klasse
	     * ausgelesen
	     */
	    if($record['tracking_id'] != ''){
		$array[] = $record;
	    }
	    // NEUES HANDLING
	    $YS = new yes_shipping($record['id']);
	    $_array = $YS->getTracking_id_array();
	    if(sizeOf($_array)){
		foreach($_array as $_a){
		    $array[] = array(
			'id'=>$record['id'],
			'versender'=>$record['versender'],
			'tracking_id'=>$_a,
			'date_finished'=>$record['date_finished']
		    );
		}
	    }
	}
	return $array;
  }

	public function get_customers_id(){
		if(isset($_SESSION['customer_id'])){
			if($this->info['payment_class'] == 'yes_amazon_pay'){
				$this->setAmazonAddressDataToOrderObject();
			}
			return $_SESSION['customer_id'];
		}
		if($this->info['payment_class'] == 'yes_amazon_pay'){
			$query = xtc_db_query(sprintf(
				"SELECT * FROM customers WHERE customers_email_address='%s'",
				$_SESSION['yes_amazon_payment']['buyer']['email']
			));
			if(xtc_db_num_rows($query)){
				// email des amazon Kunden ist bekannt
				$record = xtc_db_fetch_array($query);
				return $record['customers_id'];
			}
			return $this->create_customer_from_yes_amazon_pay();
		}
	}
	private static function splitAmazonName($full){
		$parts = explode(' ',$full);
		$last = array_pop($parts);
		$first = implode(' ',$parts);
		return array(
			'first'=>$first,
			'last'=>$last
		);
	}

	/**
	  * ERZEUGT EINEN DATENSATZ IN customers
	  * ERZEUGT DATENSAETZE IN address_book
	  * SETZT this->customer, this->billing UND this->delivery
	  * @return int customers_id
	*/
	private function create_customer_from_yes_amazon_pay(){

		// FALLS EIN ALIAS EXISTIERT: Entfernen!
		xtc_db_query(sprintf(
			"DELETE FROM customers_email_aliased WHERE email_address='%s'",
			$_SESSION['yes_amazon_payment']['buyer']['email']
		));
		$name_parts = $this->splitAmazonName($_SESSION['yes_amazon_payment']['buyer']['name']);
		if(!function_exists('xtc_random_charcode')){
			require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');
		}
		$insert_sql_array = array(
			'customers_status'=>MODULE_PAYMENT_YES_AMAZON_PAY_CUSTOMERS_STATUS,
			'customers_firstname'=>$name_parts['first'],
			'customers_lastname'=>$name_parts['last'],
			'customers_email_address'=>$_SESSION['yes_amazon_payment']['buyer']['email'],
			'customers_telephone'=>$_SESSION['yes_amazon_payment']['buyer']['phone'],
			'customers_password'=>xtc_random_charcode(8),
			'customers_date_added'=>'now()',
		);
		xtc_db_perform(TABLE_CUSTOMERS,$insert_sql_array);
		$customers_id = xtc_db_insert_id();

		// MEHR HABEN WIR HALT NICHT
		$this->customer = array(
			'id' => $customers_id,
			'name' => $_SESSION['yes_amazon_payment']['buyer']['name'],
			'firstname'=>$name_parts['first'],
			'lastname'=>$name_parts['last'],
			'format_id' => 5,
			'telephone' => $_SESSION['yes_amazon_payment']['buyer']['phone'],
			'email_address' => $_SESSION['yes_amazon_payment']['buyer']['email'],
			'company'=>'',
			'street_address'=>'',
			'suburb'=>'',
			'city'=>'',
			'postcode'=>'',
			'state'=>'',
			'country'=>array(
				'title'=>'',
			),
		);

		$new = new \YES4Trade\Model\customers_memo([
                    'customers_id'=>(int)$customers_id,
                    'memo_date'=>date('Y-m-d H:i:s'),
                    'memo_title'=>'YES Amazon Payment Import',
                    'memo_text'=>'Account created by Amazon Payment',
                    'poster_id'=>0
		]);
		$new->create();
		$name_parts = $this->splitAmazonName($_SESSION['yes_amazon_payment']['payment_address']['name']);
		$new = new \YES4Trade\Model\address_book([
                    'customers_id'=>(int)$customers_id,
                    'entry_firstname'=>$name_parts['first'],
                    'entry_lastname'=>$name_parts['last'],
                    'entry_street_address'=>$_SESSION['yes_amazon_payment']['payment_address']['street_address'],
                    'entry_suburb'=>(isset($_SESSION['yes_amazon_payment']['payment_address']['suburb'])) ? $_SESSION['yes_amazon_payment']['payment_address']['suburb'] : '',
                    'entry_postcode'=>$_SESSION['yes_amazon_payment']['payment_address']['postcode'],
                    'entry_city'=>$_SESSION['yes_amazon_payment']['payment_address']['city'],
                    'entry_state'=>(isset($_SESSION['yes_amazon_payment']['payment_address']['state'])) ? $_SESSION['yes_amazon_payment']['payment_address']['state'] : '',
                    'entry_country_id'=>(int)$_SESSION['yes_amazon_payment']['payment_address']['countries_id'],
                    'entry_zone_id'=>(isset($_SESSION['yes_amazon_payment']['payment_address']['zone_id'])) ? (int)$_SESSION['yes_amazon_payment']['payment_address']['zone_id'] : 0,
                    'address_class'=>'billing',
                    'address_date_added'=>date('Y-m-d H:i:s'),
		]);
		$abID = $new->create();

		$update_sql_array = array(
			'customers_default_address_id'=>$abID
		);
		xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$customers_id."'");

		$name_parts = $this->splitAmazonName($_SESSION['yes_amazon_payment']['shipping_address']['name']);
		$new = new \YES4Trade\Model\address_book([
                    'customers_id'=>(int)$customers_id,
                    'entry_firstname'=>$name_parts['first'],
                    'entry_lastname'=>$name_parts['last'],
                    'entry_street_address'=>$_SESSION['yes_amazon_payment']['shipping_address']['street_address'],
                    'entry_suburb'=>(isset($_SESSION['yes_amazon_payment']['shipping_address']['suburb'])) ? $_SESSION['yes_amazon_payment']['shipping_address']['suburb'] : '',
                    'entry_postcode'=>$_SESSION['yes_amazon_payment']['shipping_address']['postcode'],
                    'entry_city'=>$_SESSION['yes_amazon_payment']['shipping_address']['city'],
                    'entry_state'=>(isset($_SESSION['yes_amazon_payment']['shipping_address']['state'])) ? $_SESSION['yes_amazon_payment']['shipping_address']['state'] : '',
                    'entry_country_id'=>(int)$_SESSION['yes_amazon_payment']['shipping_address']['countries_id'],
                    'entry_zone_id'=>(isset($_SESSION['yes_amazon_payment']['shipping_address']['zone_id'])) ? (int)$_SESSION['yes_amazon_payment']['shipping_address']['zone_id'] : 0,
                    'address_class'=>'delivery',
                    'address_date_added'=>date('Y-m-d H:i:s'),
		]);
		$new->create();
		$this->setAmazonAddressDataToOrderObject($customers_id);

		return $customers_id;
	}	

	private function setAmazonAddressDataToOrderObject($customers_id){
		$name_parts = $this->splitAmazonName($_SESSION['yes_amazon_payment']['shipping_address']['name']);
		$this->delivery = array(
			'firstname'=>$name_parts['first'],
			'lastname'=>$name_parts['last'],
			'company'=>'',
			'street_address'=>$_SESSION['yes_amazon_payment']['shipping_address']['street_address'],
			'suburb' => (isset($_SESSION['yes_amazon_payment']['shipping_address']['suburb'])) ? $_SESSION['yes_amazon_payment']['shipping_address']['suburb'] : '',
			'city' => $_SESSION['yes_amazon_payment']['shipping_address']['city'],
			'postcode' => $_SESSION['yes_amazon_payment']['shipping_address']['postcode'],
			'state' => (isset($_SESSION['yes_amazon_payment']['shipping_address']['state'])) ? $_SESSION['yes_amazon_payment']['shipping_address']['state'] : '',
			'country' => array(
				'title'=>xtc_get_country_name($_SESSION['yes_amazon_payment']['shipping_address']['countries_id']),
			),
			'format_id' => 5,
		);

		$name_parts = $this->splitAmazonName($_SESSION['yes_amazon_payment']['payment_address']['name']);
		$this->billing = array(
			'firstname'=>$name_parts['first'],
			'lastname'=>$name_parts['last'],
			'company' => '',
			'street_address' => $_SESSION['yes_amazon_payment']['payment_address']['street_address'],
			'suburb' => (isset($_SESSION['yes_amazon_payment']['payment_address']['suburb'])) ? $_SESSION['yes_amazon_payment']['payment_address']['suburb'] : '',
			'city' => $_SESSION['yes_amazon_payment']['payment_address']['city'],
			'postcode' => $_SESSION['yes_amazon_payment']['payment_address']['postcode'],
			'state' => (isset($_SESSION['yes_amazon_payment']['payment_address']['state'])) ? $_SESSION['yes_amazon_payment']['payment_address']['state'] : '',
			'country' => array(
				'title'=>xtc_get_country_name($_SESSION['yes_amazon_payment']['payment_address']['countries_id'])
			),
			'format_id' => 5
		);

		$name_parts = $this->splitAmazonName($_SESSION['yes_amazon_payment']['buyer']['name']);
		$this->customer = array(
			'id' => $customers_id,
			'name' => $_SESSION['yes_amazon_payment']['buyer']['name'],
			'firstname'=>$name_parts['first'],
			'lastname'=>$name_parts['last'],
			'format_id' => 5,
			'telephone' => $_SESSION['yes_amazon_payment']['buyer']['phone'],
			'email_address' => $_SESSION['yes_amazon_payment']['buyer']['email'],
			'company'=>'',
			'street_address'=>'',
			'suburb'=>'',
			'city'=>'',
			'postcode'=>'',
			'state'=>'',
			'country'=>array(
				'title'=>'',
			),
		);
	}

    public function get_order_language_id(){
        $order_language_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
        $languages = \YES4Trade\Model\languages::get_list();
        foreach($languages as $lang){
            if($lang['directory'] == $this->info['language']){
                $order_language_id = $lang['id'];
            }
        }
        return $order_language_id;
    }
    
    public function get_products_content_files(){
        $order_products_files = array();
        foreach ($this->products as $products) {
            $items = \YES4Trade\Model\products_content::get_by_products_id($products['id']);
            foreach($items as $it){
				$pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id(intval($it->content_id),(int)$this->get_order_language_id());
				$rel_path = '';
				if(!empty($it->content_file)){
					$rel_path = \YES4Trade\Model\products_content::get_file_content_dir($it->content_file);
				}
                $order_products_files[$products['id']][$rel_path] = $pcd->content_name;
            }
        }
        return $order_products_files;
    }

	public static function get_orders_status(int $orders_id):int|null{
		$query = yes_query(sprintf(
			"SELECT orders_status FROM %s WHERE orders_id=:id",
				TABLE_ORDERS
			),[
				'id'=>$orders_id
			],true
		);
		if($query === false){
			return null;
		}
		return intval($query['orders_status']);
	}
}
